/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.analyzer.LineChart;
import elgato.measurement.gsm.GsmAnalyzer;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import java.awt.Color;
import java.awt.Graphics;

public class GsmLineChart
extends LineChart {
    private GsmAnalyzer analyzer;

    public GsmLineChart(GsmAnalyzer gsmAnalyzer) {
        this.analyzer = gsmAnalyzer;
    }

    public void dispose() {
        super.dispose();
        this.analyzer = null;
    }

    protected void drawChart(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (!this.isChartDrawable()) {
            return;
        }
        this.checkInsets();
        int n9 = this.getGridTopMargin();
        int n10 = this.getGridBottomMargin();
        int n11 = this.getGridLeftMargin();
        int n12 = this.getGridRightMargin();
        int n13 = n + n11 + this.insets.left;
        int n14 = n2 + n9 + this.insets.top;
        int n15 = n3 - this.insets.left - this.insets.right - n11 - n12;
        int n16 = n4 - this.insets.top - this.insets.bottom - n9 - n10;
        this.drawGrid(graphics, n13, n14, n15, n16);
        if (this.measurement != null) {
            n8 = n13 + 1;
            n7 = n14 + 1;
            n6 = n15 - 2;
            n5 = n16 - 2;
            this.drawTrace(graphics, n8, n7, n6, n5);
            this.showLimits(graphics, n3, n4);
        }
        if (((GsmMeasurement)this.measurement).getZoomType() == 1 && ((GsmMeasurement)this.measurement).getViewType() == 1) {
            n8 = 20;
            n7 = n16;
            n6 = n13 + n15 / 2 - n8 / 2;
            n5 = n14;
            graphics.setColor(this.gridColor);
            graphics.fillRect(n6, n5, n8, n7);
        }
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4) {
        int[] nArray = new int[((GsmMeasurement)this.measurement).getTraceLength()];
        int[] nArray2 = new int[((GsmMeasurement)this.measurement).getTraceLength()];
        int[] nArray3 = ((GsmMeasurement)this.measurement).getPvtSlotLowerLimitTrace();
        Color color = LineChart.COLOR_TRACE;
        Color color2 = Color.magenta;
        Color color3 = Color.yellow;
        System.arraycopy(((GsmMeasurement)this.measurement).getPvtSlotRFTrace(), 0, nArray, 0, nArray.length);
        System.arraycopy(((GsmMeasurement)this.measurement).getPvtSlotUpperLimitTrace(), 0, nArray2, 0, nArray2.length);
        if (((GsmMeasurement)this.measurement).getViewType() == 1) {
            if (((GsmMeasurement)this.measurement).getZoomType() == 1) {
                this.drawTrace(graphics, n, n2, n3, n4, nArray, color, 0);
                if (GsmMeasurementSettings.instance().getPvtMask().intValue() == 1) {
                    this.drawTrace(graphics, n, n2, n3, n4, nArray2, color2, 1);
                    this.drawTrace(graphics, n, n2, n3, n4, nArray3, color3, 2);
                }
            } else {
                super.drawTrace(graphics, n, n2, n3, n4, nArray, color, 0);
                if (GsmMeasurementSettings.instance().getPvtMask().intValue() == 1) {
                    super.drawTrace(graphics, n, n2, n3, n4, nArray2, color2, 1);
                    super.drawTrace(graphics, n, n2, n3, n4, nArray3, color3, 2);
                }
            }
        } else if (((GsmMeasurement)this.measurement).getViewType() == 2) {
            if (((GsmMeasurement)this.measurement).getAverageType() != 0) {
                super.drawTrace(graphics, n, n2, n3, n4, nArray, color, 0);
                super.drawTrace(graphics, n, n2, n3, n4, nArray2, color2, 1);
            } else {
                super.drawTrace(graphics, n, n2, n3, n4, nArray, color, 0);
            }
        }
    }

    protected void drawTrace(Graphics graphics, int n, int n2, int n3, int n4, int[] nArray, Color color, int n5) {
        this.yTop = this.getYTop();
        this.yBottom = this.getYBottom();
        this.yRange = this.yBottom - this.yTop + 1L;
        graphics.setClip(n, n2, n3, n4);
        int n6 = this.getXStartTraceIndex();
        int n7 = this.getXStopTraceIndex();
        int n8 = n7 + 1;
        int n9 = n8 - n6;
        int n10 = n9 + 1;
        if (n6 > n7 || n10 > 8192) {
            return;
        }
        this.allocateArrays(n10);
        int n11 = n6;
        int n12 = 0;
        while (n11 <= n8) {
            long l = this.measurement.getXValueForIndex(n11);
            this.traceXpts[n12] = n + (int)((l - this.measurement.getTraceStartValue(l)) * (long)n3 / (this.measurement.getTraceStopValue(l) - this.measurement.getTraceStartValue(l)));
            int n13 = n11 >= nArray.length ? nArray[nArray.length - 1] : (n11 < 0 ? nArray[0] : nArray[n11]);
            int n14 = (int)(((long)n13 - this.yTop) * (long)n4 / this.yRange);
            this.traceYpts[n12] = n2 + n14;
            ++n11;
            ++n12;
        }
        graphics.setColor(color);
        graphics.drawPolyline(this.traceXpts, this.traceYpts, n10);
        this.drawMarkers(graphics, n, n2, n3, n4, n5);
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        this.analyzer.setPassFailLabel();
    }
}

