/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.marker.MarkerModel;
import java.awt.Component;
import java.awt.Graphics;

public class GsmMarker
extends Marker {
    public GsmMarker(TraceAnalyzer traceAnalyzer, MarkerModel markerModel, boolean bl) {
        super(traceAnalyzer, markerModel, bl);
    }

    public long boundValue(long l) {
        long l2 = this.getStartValueFromTrace();
        long l3 = this.getStopValueFromTrace();
        if (l < l2) {
            l = l2;
        }
        if (l > l3) {
            l = l3;
        }
        if (this.analyzer.isSplitTraceView()) {
            long l4 = this.analyzer.getPvtRiseStopValue();
            long l5 = this.analyzer.getPvtFallStartValue();
            if (l > l4 && l < (l5 - l4) / 2L && l < l5) {
                l = l4;
            }
            if (l > l4 && l >= (l5 - l4) / 2L && l < l5) {
                l = l5;
            }
        }
        return l;
    }

    protected void drawMarkerPart(Component component, Graphics graphics, boolean bl, Marker.Painter painter) {
        long l;
        long l2 = l = bl ? this.getAbsoluteDeltaValue() : this.getNormalValue();
        if (l < this.analyzer.getViewStartValue(l) || l > this.analyzer.getViewStopValue()) {
            return;
        }
        int n = this.measurement.getIndexForXValue(l);
        if (n < 0) {
            Marker.logger.warn("Value " + l + " not found in measurement with getIndexForXValue(), " + "most likely the measurement is invalid.");
            return;
        }
        painter.paint(component, graphics, l, n, bl);
    }

    protected long getStartValueFromTrace(long l) {
        return this.analyzer.getTraceStartValue(l);
    }

    protected long getStopValueFromTrace(long l) {
        return this.analyzer.getTraceStopValue(l);
    }
}

