/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.IndexSteppingValidator;
import elgato.infrastructure.marker.Marker;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.marker.MarkerModel;
import elgato.infrastructure.marker.MarkerSettings;
import elgato.infrastructure.marker.MarkerSettingsFactory;
import elgato.infrastructure.marker.RelativeSteppingValidator;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.measurement.gsm.GsmMarker;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;

public class GsmMarkerButtonFactory
extends MarkerButtonFactory {
    public GsmMarkerButtonFactory(MeasurementScreen measurementScreen, ValueInterface valueInterface, ValueInterface valueInterface2, LongActuator longActuator, boolean bl, Value[] valueArray, MarkerSettingsFactory markerSettingsFactory, String string) {
        this.setupSettings(measurementScreen, valueInterface, valueInterface2, bl, markerSettingsFactory, longActuator, valueArray, string);
        this.markers = this.createMarkers(measurementScreen.getTraceAnalyzer(), this.markerSettings);
        this.setupMarkerButtons();
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        GsmMeasurementSettings gsmMeasurementSettings = GsmMeasurementSettings.instance();
        boolean bl = true;
        int n = 0;
        if (gsmMeasurementSettings != null) {
            n = gsmMeasurementSettings.getViewType().intValue();
            if (n == 0) {
                bl = false;
            }
            if (n != ((GsmMeasurement)traceMeasurement).getViewType()) {
                return;
            }
        }
        Marker[] markerArray = this.getMarkers();
        for (int i = 0; i < markerArray.length; ++i) {
            Marker marker = markerArray[i];
            if (n != 0) {
                marker.setMeasurement(traceMeasurement);
            }
            if ((this.markerTypeButtons[i].isEnabled() || !bl) && (!this.markerTypeButtons[i].isEnabled() || bl)) continue;
            this.markerTypeButtons[i].setEnabled(bl);
            if (this.markerMenu == null || this.markerTypeButtons[i] != this.markerMenu.getItems()[1]) continue;
            this.updateMarkerActionButtonEnabledStates();
        }
    }

    private Marker[] createMarkers(TraceAnalyzer traceAnalyzer, MarkerSettings markerSettings) {
        Marker[] markerArray = new GsmMarker[4];
        this.normalValidator = new IndexSteppingValidator(traceAnalyzer);
        for (int i = 0; i < markerArray.length; ++i) {
            MarkerModel markerModel = markerSettings.getModel(i);
            markerModel.getNormalValue().setValidator(this.normalValidator);
            this.deltaValidators[i] = new RelativeSteppingValidator(traceAnalyzer, markerModel.getNormalValue());
            IndexSteppingValidator indexSteppingValidator = this.relativeDelta ? this.deltaValidators[i] : this.normalValidator;
            markerModel.getDeltaValue().setValidator(indexSteppingValidator);
            markerArray[i] = new GsmMarker(traceAnalyzer, markerModel, this.relativeDelta);
        }
        return markerArray;
    }
}

