/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.readings.ShortArrayReading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.gsm.GsmMeasurementSettings;
import java.io.DataInput;
import java.io.IOException;

public class GsmMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = -8610619437180698168L;
    private static final Queue pool = new Queue(3);
    public static final int CHANNEL_POWERS_ARRAY_SIZE = 256;
    public static final int CHANNEL_COMMON_ARRAY_SIZE = 40;
    public static final int PVT_TRACE_LENGTH = 401;
    public static final int PVT_MAX_SLOTS = 8;
    public static final int SPECTRUM_RES_BW = 3034;
    public static final int START_STOP_POSITIONS = 2;
    public static final int DEMOD_SUCCESS = 0;
    public static final int DEMOD_NOT_WITHIN_AUTO_BAR_COUNT = 1;
    public static final int DEMOD_VALID_SYNC_NOT_FOUND = 2;
    public static final int DEMOD_BCCH_NOT_FOUND = 3;
    public static final int DEMOD_NO_GRAPH_DATA = 4;
    public static final int PVT_RISE_FALL_SEPARATOR_START_BUCKET = 151;
    public static final int PVT_RISE_FALL_SEPARATOR_STOP_BUCKET = 164;
    public static final int PVT_RISE_FALL_SEPARATOR_MID_BUCKET = 157;
    public static boolean fromUnpack;
    private static XYContainer[] xyContainers;
    protected IntegerReading numChannelPowers = new IntegerReading();
    protected IntegerArrayReading channelPowerArr = new IntegerArrayReading(256);
    protected IntegerReading numDecodedChannels = new IntegerReading();
    protected IntegerArrayReading channelFreqArr = new IntegerArrayReading(40);
    protected IntegerArrayReading channelFreqErrArr = new IntegerArrayReading(40);
    protected ShortArrayReading bsicArr = new ShortArrayReading(40);
    protected IntegerArrayReading pkTsPwrArr = new IntegerArrayReading(40);
    protected IntegerArrayReading obwArr = new IntegerArrayReading(40);
    protected IntegerArrayReading rmsPhaseErrArr = new IntegerArrayReading(40);
    protected IntegerArrayReading peakPhaseErrArr = new IntegerArrayReading(40);
    protected IntegerArrayReading iqOffsetArr = new IntegerArrayReading(40);
    protected IntegerReading averageCount = new IntegerReading();
    protected IntegerReading typeOfChannelScan = new IntegerReading();
    protected IntegerReading atten = new IntegerReading();
    protected IntegerReading startCentFreq = new IntegerReading();
    protected IntegerReading stepSize = new IntegerReading();
    protected IntegerReading stopCentFreq = new IntegerReading();
    protected IntegerReading decodeCentFreq = new IntegerReading();
    protected IntegerReading numOfAutoChannels = new IntegerReading();
    protected IntegerArrayReading freqList = new IntegerArrayReading(40);
    protected IntegerReading averageType = new IntegerReading();
    protected IntegerReading numAverages = new IntegerReading();
    protected ShortArrayReading tscArr = new ShortArrayReading(40);
    protected IntegerArrayReading rmsEvmArr = new IntegerArrayReading(40);
    protected IntegerArrayReading peakEvmArr = new IntegerArrayReading(40);
    protected IntegerArrayReading pcttileEvmArr = new IntegerArrayReading(40);
    protected IntegerArrayReading pvtSlotRFTrace = new IntegerArrayReading(401);
    protected IntegerArrayReading pvtSlotUpperLimitTrace = new IntegerArrayReading(401);
    protected IntegerArrayReading pvtSlotLowerLimitTrace = new IntegerArrayReading(401);
    protected IntegerArrayReading pvtSlotInfo = new IntegerArrayReading(8);
    protected IntegerArrayReading pvtTSPower = new IntegerArrayReading(8);
    protected IntegerReading slotSync = new IntegerReading();
    protected IntegerReading specificTS = new IntegerReading();
    protected IntegerReading viewType = new IntegerReading();
    protected IntegerReading zoomType = new IntegerReading();
    protected IntegerReading zoomOffset = new IntegerReading();
    protected IntegerReading zoomOffsetRF = new IntegerReading();
    protected IntegerReading zoomInterval = new IntegerReading();
    protected IntegerReading pvtMask = new IntegerReading();
    protected IntegerReading slotSpectrumTraceLength = new IntegerReading();
    protected IntegerReading startCentFreqChan = new IntegerReading();
    protected IntegerReading startFreqMode = new IntegerReading();
    protected IntegerArrayReading slotSpectrumStartPosition = new IntegerArrayReading(2);
    protected IntegerArrayReading slotSpectrumStopPosition = new IntegerArrayReading(2);
    protected IntegerReading slotSpectrumBandwidth = new IntegerReading();
    protected IntegerReading frameStartSlot = new IntegerReading();
    protected IntegerReading demodStatus = new IntegerReading();
    protected IntegerReading pvtMaskRadioStd = new IntegerReading();
    private static int readingCount;
    public static final int NUM_CHANNEL_POWERS;
    public static final int CHANNEL_POWER_ARR;
    public static final int NUM_DECODED_CHANNELS;
    public static final int CHANNEL_FREQ_ARR;
    public static final int CHANNEL_FREQ_ERR_ARR;
    public static final int BSIC_ARR;
    public static final int PK_TS_PWR;
    public static final int OBW_ARR;
    public static final int RMS_PHASE_ERR_ARR;
    public static final int PEAK_PHASE_ERR_ARR;
    public static final int IQ_OFFSET_ARR;
    public static final int AVERAGE_COUNT;
    public static final int SCAN_TYPE;
    public static final int ATTEN;
    public static final int START_CENT_FREQ;
    public static final int STEP_SIZE;
    public static final int STOP_CENT_FREQ;
    public static final int DECODE_CENT_FREQ;
    public static final int NUM_OF_AUTO_CHANNELS;
    public static final int FREQ_LIST;
    public static final int AVERAGE_TYPE;
    public static final int NUM_AVERAGES;
    public static final int TSC_ARR;
    public static final int RMS_EVM_ARR;
    public static final int PEAK_EVM_ARR;
    public static final int PCTTILE_EVM_ARR;
    public static final int PVT_SLOT_RF_OR_SPECTRUM_TRACE;
    public static final int PVT_SLOT_UPPER_LIMIT_OR_SPECTRUM_TRACE;
    public static final int PVT_SLOT_LOWER_LIMIT_OR_SPECTRUM_TRACE;
    public static final int PVT_SLOT_INFO;
    public static final int PVT_SLOT_PWR;
    public static final int VIEW_TYPE;
    public static final int ZOOM_TYPE;
    public static final int ZOOM_INTERVAL;
    public static final int ZOOM_OFFSET;
    public static final int PVT_MASK;
    public static final int SLOT_SYNC;
    public static final int SPECIFIC_TS;
    public static final int SLOT_SPECTRUM_TRACE_LENGTH;
    public static final int START_CENT_FREQ_CHAN;
    public static final int START_FREQ_MODE;
    public static final int SLOT_SPECTRUM_START_POSITION;
    public static final int SLOT_SPECTRUM_STOP_POSITION;
    public static final int SLOT_SPECTRUM_BANDWIDTH;
    public static final int FRAME_START_SLOT;
    public static final int DEMOD_STATUS;
    public static final int PVT_MASK_RADIO_STD;
    private Reading[] readings = this.createReadings();

    protected Reading[] getGsmSensorReadings() {
        return new Reading[]{this.numChannelPowers, this.channelPowerArr, this.numDecodedChannels, this.channelFreqArr, this.channelFreqErrArr, this.bsicArr, this.pkTsPwrArr, this.obwArr, this.rmsPhaseErrArr, this.peakPhaseErrArr, this.iqOffsetArr, this.averageCount};
    }

    protected Reading[] getGsmActuatorReadings() {
        return new Reading[]{this.typeOfChannelScan, this.atten, this.startCentFreq, this.stepSize, this.stopCentFreq, this.decodeCentFreq, this.numOfAutoChannels, this.freqList, this.averageType, this.numAverages};
    }

    protected Reading[] getGsmSensorGroup2Readings() {
        return new Reading[]{this.tscArr, this.rmsEvmArr, this.peakEvmArr, this.pcttileEvmArr, this.pvtSlotRFTrace, this.pvtSlotUpperLimitTrace, this.pvtSlotLowerLimitTrace, this.pvtSlotInfo, this.pvtTSPower};
    }

    protected Reading[] getGsmActuatorGroup2Readings() {
        return new Reading[]{this.viewType, this.zoomType, this.zoomOffset, this.zoomOffsetRF, this.zoomInterval, this.pvtMask, this.slotSync, this.specificTS};
    }

    protected Reading[] getGsmSensorGroup3Readings() {
        return new Reading[]{this.slotSpectrumTraceLength};
    }

    protected Reading[] getGsmActuatorGroup3Readings() {
        return new Reading[]{this.startCentFreqChan, this.startFreqMode};
    }

    protected Reading[] getGsmSensorGroup4Readings() {
        return new Reading[]{this.slotSpectrumStartPosition, this.slotSpectrumStopPosition, this.slotSpectrumBandwidth, this.frameStartSlot, this.demodStatus};
    }

    protected Reading[] getGsmActuatorGroup4Readings() {
        return new Reading[]{this.pvtMaskRadioStd};
    }

    GsmMeasurement() {
    }

    public Reading[] createReadings() {
        int n = this.getGsmSensorReadings().length;
        int n2 = this.getGsmActuatorReadings().length;
        int n3 = this.getGsmSensorGroup2Readings().length;
        int n4 = this.getGsmActuatorGroup2Readings().length;
        int n5 = this.getGsmSensorGroup3Readings().length;
        int n6 = this.getGsmActuatorGroup3Readings().length;
        int n7 = this.getGsmSensorGroup4Readings().length;
        int n8 = this.getGsmActuatorGroup4Readings().length;
        Reading[] readingArray = new Reading[n + n2 + n3 + n4 + n5 + n6 + n7 + n8];
        System.arraycopy(this.getGsmSensorReadings(), 0, readingArray, 0, n);
        System.arraycopy(this.getGsmActuatorReadings(), 0, readingArray, n, n2);
        System.arraycopy(this.getGsmSensorGroup2Readings(), 0, readingArray, n + n2, n3);
        System.arraycopy(this.getGsmActuatorGroup2Readings(), 0, readingArray, n + n2 + n3, n4);
        System.arraycopy(this.getGsmSensorGroup3Readings(), 0, readingArray, n + n2 + n3 + n4, n5);
        System.arraycopy(this.getGsmActuatorGroup3Readings(), 0, readingArray, n + n2 + n3 + n4 + n5, n6);
        System.arraycopy(this.getGsmSensorGroup4Readings(), 0, readingArray, n + n2 + n3 + n4 + n5 + n6, n7);
        System.arraycopy(this.getGsmActuatorGroup4Readings(), 0, readingArray, n + n2 + n3 + n4 + n5 + n6 + n7, n8);
        return readingArray;
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public static GsmMeasurement unpack(DataInput dataInput) throws IOException {
        GsmMeasurement gsmMeasurement = GsmMeasurement.create();
        Reading[] readingArray = gsmMeasurement.getReadings();
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        fromUnpack = true;
        gsmMeasurement.sortPowers();
        fromUnpack = false;
        return gsmMeasurement;
    }

    static GsmMeasurement create() {
        GsmMeasurement gsmMeasurement = (GsmMeasurement)pool.dequeue();
        if (gsmMeasurement == null) {
            return new GsmMeasurement();
        }
        return gsmMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getNumChannelPowers() {
        return this.numChannelPowers.intValue();
    }

    public int[] getChannelPowerArr() {
        return this.channelPowerArr.getTrace();
    }

    public int getNumDecodedChannels() {
        return this.numDecodedChannels.intValue();
    }

    public int[] getChannelFreqArr() {
        return this.channelFreqArr.getTrace();
    }

    public int[] getChannelFreqErrArr() {
        return this.channelFreqErrArr.getTrace();
    }

    public int[] getBsicArr() {
        return this.bsicArr.getTrace();
    }

    public int[] getPkTsPwrArr() {
        return this.pkTsPwrArr.getTrace();
    }

    public int[] getObwArr() {
        return this.obwArr.getTrace();
    }

    public int[] getRmsPhaseErrArr() {
        return this.rmsPhaseErrArr.getTrace();
    }

    public int[] getPeakPhaseErrArr() {
        return this.peakPhaseErrArr.getTrace();
    }

    public int[] getIqOffsetArr() {
        return this.iqOffsetArr.getTrace();
    }

    public int getTypeOfChannelScan() {
        return this.typeOfChannelScan.intValue();
    }

    public int getAtten() {
        return this.atten.intValue();
    }

    public int getStartCentFreq() {
        return this.startCentFreq.intValue();
    }

    public int getStepSize() {
        return this.stepSize.intValue();
    }

    public int getStopCentFreq() {
        return this.stopCentFreq.intValue();
    }

    public int getDecodeCentFreq() {
        return this.decodeCentFreq.intValue();
    }

    public int getSpectrumResBW() {
        return 3034;
    }

    public int getNumOfAutoChannels() {
        return this.numOfAutoChannels.intValue();
    }

    public int[] getFreqList() {
        return this.freqList.getTrace();
    }

    public int getAverageType() {
        return this.averageType.intValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public int[] getTscArr() {
        return this.tscArr.getTrace();
    }

    public int[] getRmsEvmArr() {
        return this.rmsEvmArr.getTrace();
    }

    public int[] getPeakEvmArr() {
        return this.peakEvmArr.getTrace();
    }

    public int[] get95PctTileEvmArr() {
        return this.pcttileEvmArr.getTrace();
    }

    public int[] getPvtSlotRFTrace() {
        return this.pvtSlotRFTrace.getTrace();
    }

    public int[] getPvtSlotUpperLimitTrace() {
        return this.pvtSlotUpperLimitTrace.getTrace();
    }

    public int[] getPvtSlotLowerLimitTrace() {
        return this.pvtSlotLowerLimitTrace.getTrace();
    }

    public int getPvtSlotInfo(int n) {
        return this.pvtSlotInfo.getTrace()[n];
    }

    public int getPvtTSPower(int n) {
        return this.pvtTSPower.getTrace()[n];
    }

    public int getPvtTraceLength() {
        return 401;
    }

    public int getSlotSpectrumTraceLength() {
        switch (this.getViewType()) {
            default: 
        }
        return this.slotSpectrumTraceLength.intValue();
    }

    public long getPvtTraceStartValue() {
        return this.slotSpectrumStartPosition.getTrace()[0];
    }

    public long getPvtTraceStopValue() {
        return this.slotSpectrumStopPosition.getTrace()[0];
    }

    public long getPvtRiseStopValue() {
        return this.slotSpectrumStopPosition.getTrace()[1];
    }

    public long getPvtFallStartValue() {
        return this.slotSpectrumStartPosition.getTrace()[1];
    }

    public int getPvtSlotsPerFrame() {
        return 8;
    }

    public int getStartCentFreqChan() {
        return this.startCentFreqChan.intValue();
    }

    public int getStartFreqMode() {
        return this.startFreqMode.intValue();
    }

    public int getFrameStartSlot() {
        return this.frameStartSlot.intValue();
    }

    public int getDemodStatus() {
        return this.demodStatus.intValue();
    }

    public int getViewType() {
        return this.viewType.intValue();
    }

    public int getZoomType() {
        return this.zoomType.intValue();
    }

    public int getPvtMaskRadioStd() {
        return this.pvtMaskRadioStd.intValue();
    }

    public long getPvtValueForIndex(int n) {
        long l = this.getPvtTraceStartValue();
        return l + (long)n * (this.getPvtTraceStopValue() - l) / (long)(this.getSlotSpectrumTraceLength() - 1);
    }

    public String getMeasurementTitle() {
        boolean bl = MeasurementFactory.instance().optionAvailable("edgeAn");
        if (bl) {
            return Text.GSM_Bracket_w_slash_EDGE;
        }
        return Text.GSM;
    }

    public int[] getTrace() {
        return this.getChannelPowerArr();
    }

    public int[] getActiveTrace() {
        switch (this.getViewType()) {
            case 1: 
            case 2: {
                return this.getPvtSlotRFTrace();
            }
        }
        return this.getChannelPowerArr();
    }

    public int[] getMarkerTrace(int n) {
        switch (this.getViewType()) {
            case 1: {
                switch (n) {
                    case 1: {
                        return this.getPvtSlotUpperLimitTrace();
                    }
                    case 2: {
                        return this.getPvtSlotLowerLimitTrace();
                    }
                }
                return this.getPvtSlotRFTrace();
            }
            case 2: {
                if (this.getAverageType() != 0) {
                    switch (n) {
                        case 0: {
                            return this.getPvtSlotRFTrace();
                        }
                    }
                    return this.getPvtSlotUpperLimitTrace();
                }
                return this.getPvtSlotRFTrace();
            }
        }
        return this.getChannelPowerArr();
    }

    public int getTraceLength() {
        switch (this.getViewType()) {
            case 1: 
            case 2: {
                if (fromUnpack) break;
                return this.getSlotSpectrumTraceLength();
            }
        }
        if (this.getTypeOfChannelScan() == 1) {
            return this.getNumOfAutoChannels();
        }
        return this.getNumChannelPowers();
    }

    public long getFrequencyForChannel(int n) {
        long l;
        if (this.getTypeOfChannelScan() == 0) {
            if (n < 0 || n >= this.getNumChannelPowers()) {
                throw new IndexOutOfBoundsException("illegal channel " + n + ", numChannels=" + this.numChannelPowers);
            }
            l = this.getStartFreqMode() == 0 ? (long)(this.getStartCentFreq() + this.getStepSize() * n) * 1000L : (long)this.getStartCentFreqChan() * 1000L;
        } else if (this.getTypeOfChannelScan() == 1) {
            if (n < 0 || n >= this.getNumOfAutoChannels()) {
                throw new IndexOutOfBoundsException("illegal channel " + n + ", numChannels=" + this.numOfAutoChannels);
            }
            l = (long)GsmMeasurement.xyContainers[n].xValue * 1000L;
        } else if (this.getTypeOfChannelScan() == 2) {
            l = (long)this.getFreqList()[n] * 1000L;
        } else {
            throw new IllegalStateException("Invalid scanType: " + this.typeOfChannelScan);
        }
        return l;
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    public long getTraceStartValue() {
        switch (this.getViewType()) {
            case 1: 
            case 2: {
                return this.getPvtTraceStartValue();
            }
        }
        return this.startCentFreq.intValue();
    }

    public long getTraceStopValue() {
        switch (this.getViewType()) {
            case 1: {
                switch (this.getZoomType()) {
                    case 1: {
                        return this.getPvtTraceStopValue();
                    }
                }
                return this.getPvtTraceStopValue();
            }
            case 2: {
                return this.getPvtTraceStopValue();
            }
        }
        return this.stopCentFreq.intValue();
    }

    public long getTraceStartValue(long l) {
        switch (this.getViewType()) {
            case 1: {
                switch (this.getZoomType()) {
                    case 1: {
                        if (l >= this.getPvtRiseStopValue() + (this.getPvtFallStartValue() - this.getPvtRiseStopValue()) / 2L) {
                            return this.getPvtFallStartValue() - (this.getPvtRiseStopValue() - this.getTraceStartValue()) / 150L * 165L;
                        }
                        return this.getPvtTraceStartValue();
                    }
                }
                return this.getPvtTraceStartValue();
            }
            case 2: {
                return this.getPvtTraceStartValue();
            }
        }
        return this.startCentFreq.intValue();
    }

    public long getTraceStopValue(long l) {
        switch (this.getViewType()) {
            case 1: {
                switch (this.getZoomType()) {
                    case 1: {
                        if (l >= this.getPvtRiseStopValue() + (this.getPvtFallStartValue() - this.getPvtRiseStopValue()) / 2L) {
                            return this.getPvtTraceStopValue();
                        }
                        return this.getPvtRiseStopValue() + (this.getPvtRiseStopValue() - this.getTraceStartValue()) / 150L * 165L;
                    }
                }
                return this.getPvtTraceStopValue();
            }
            case 2: {
                return this.getPvtTraceStopValue();
            }
        }
        return this.stopCentFreq.intValue();
    }

    public int getIndexForXValue(long l) {
        long l2 = this.getTraceStartValue(l);
        long l3 = this.getTraceStopValue(l);
        long l4 = l3 - l2;
        if (l4 == 0L) {
            return 0;
        }
        long l5 = (l - l2) * (long)(this.getTraceLength() - 1);
        int n = (int)(l5 / l4);
        long l6 = l5 % l4;
        if (l6 >= l4 / 2L) {
            ++n;
        }
        if (this.getViewType() == 1 && this.getZoomType() == 1) {
            n = this.checkIndexforSplitTrace(n);
        }
        return n;
    }

    public long getXValueForIndex(int n) {
        long l;
        long l2;
        if (this.getViewType() == 1 && this.getZoomType() == 1) {
            if ((n = this.checkIndexforSplitTrace(n)) < this.getTraceLength() / 2) {
                l2 = this.getTraceStartValue(this.getPvtTraceStartValue());
                l = this.getTraceStopValue(this.getPvtRiseStopValue());
            } else {
                l2 = this.getTraceStartValue(this.getPvtFallStartValue());
                l = this.getTraceStopValue(this.getPvtTraceStopValue());
            }
        } else {
            l2 = this.getTraceStartValue();
            l = this.getTraceStopValue();
        }
        long l3 = Math.round((double)n * (double)(l - l2) / (double)(this.getTraceLength() - 1));
        return l2 + l3;
    }

    public int checkIndexforSplitTrace(int n) {
        if (n == 151) {
            n = 165;
        }
        if (n == 164) {
            n = 150;
        }
        if (n > 151 && n <= 157) {
            n = 150;
        }
        if (n > 157 && n < 164) {
            n = 165;
        }
        return n;
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public XYContainer[] getXYContainers() {
        return xyContainers;
    }

    private void sortPowers() {
        int n;
        int n2 = this.getTraceLength();
        for (n = 0; n < n2; ++n) {
            GsmMeasurement.xyContainers[n].yValue = this.getChannelPowerArr()[n];
        }
        if (this.getTypeOfChannelScan() == 1 || this.getTypeOfChannelScan() == 2) {
            for (n = 0; n < n2; ++n) {
                GsmMeasurement.xyContainers[n].xValue = this.getChannelFreqArr()[n];
                GsmMeasurement.xyContainers[n].xIndexOrig = n;
            }
        }
        if (this.getTypeOfChannelScan() == 1 && GsmMeasurementSettings.instance().getAutoOrder().intValue() == 1) {
            this.sort(xyContainers, this.getTraceLength());
        }
    }

    private void sort(XYContainer[] xYContainerArray, int n) {
        for (int i = 1; i < n; ++i) {
            int n2 = xYContainerArray[i].xValue;
            int n3 = xYContainerArray[i].yValue;
            int n4 = xYContainerArray[i].xIndexOrig;
            for (int j = i; j > 0 && xYContainerArray[j - 1].xValue > n2; --j) {
                xYContainerArray[j].xValue = xYContainerArray[j - 1].xValue;
                xYContainerArray[j].yValue = xYContainerArray[j - 1].yValue;
                xYContainerArray[j].xIndexOrig = xYContainerArray[j - 1].xIndexOrig;
            }
            xYContainerArray[j].xValue = n2;
            xYContainerArray[j].yValue = n3;
            xYContainerArray[j].xIndexOrig = n4;
        }
    }

    static {
        xyContainers = new XYContainer[256];
        for (int i = 0; i < xyContainers.length; ++i) {
            GsmMeasurement.xyContainers[i] = new XYContainer();
        }
        readingCount = 0;
        NUM_CHANNEL_POWERS = readingCount++;
        CHANNEL_POWER_ARR = readingCount++;
        NUM_DECODED_CHANNELS = readingCount++;
        CHANNEL_FREQ_ARR = readingCount++;
        CHANNEL_FREQ_ERR_ARR = readingCount++;
        BSIC_ARR = readingCount++;
        PK_TS_PWR = readingCount++;
        OBW_ARR = readingCount++;
        RMS_PHASE_ERR_ARR = readingCount++;
        PEAK_PHASE_ERR_ARR = readingCount++;
        IQ_OFFSET_ARR = readingCount++;
        AVERAGE_COUNT = readingCount++;
        SCAN_TYPE = readingCount++;
        ATTEN = readingCount++;
        START_CENT_FREQ = readingCount++;
        STEP_SIZE = readingCount++;
        STOP_CENT_FREQ = readingCount++;
        DECODE_CENT_FREQ = readingCount++;
        NUM_OF_AUTO_CHANNELS = readingCount++;
        FREQ_LIST = readingCount++;
        AVERAGE_TYPE = readingCount++;
        NUM_AVERAGES = readingCount++;
        TSC_ARR = readingCount++;
        RMS_EVM_ARR = readingCount++;
        PEAK_EVM_ARR = readingCount++;
        PCTTILE_EVM_ARR = readingCount++;
        PVT_SLOT_RF_OR_SPECTRUM_TRACE = readingCount++;
        PVT_SLOT_UPPER_LIMIT_OR_SPECTRUM_TRACE = readingCount++;
        PVT_SLOT_LOWER_LIMIT_OR_SPECTRUM_TRACE = readingCount++;
        PVT_SLOT_INFO = readingCount++;
        PVT_SLOT_PWR = readingCount++;
        VIEW_TYPE = readingCount++;
        ZOOM_TYPE = readingCount++;
        ZOOM_INTERVAL = readingCount++;
        ZOOM_OFFSET = readingCount++;
        PVT_MASK = readingCount++;
        SLOT_SYNC = readingCount++;
        SPECIFIC_TS = readingCount++;
        SLOT_SPECTRUM_TRACE_LENGTH = readingCount++;
        START_CENT_FREQ_CHAN = readingCount++;
        START_FREQ_MODE = readingCount++;
        SLOT_SPECTRUM_START_POSITION = readingCount++;
        SLOT_SPECTRUM_STOP_POSITION = readingCount++;
        SLOT_SPECTRUM_BANDWIDTH = readingCount++;
        FRAME_START_SLOT = readingCount++;
        DEMOD_STATUS = readingCount++;
        PVT_MASK_RADIO_STD = readingCount++;
    }

    public static class XYContainer {
        public int xValue = 0;
        public int yValue = 0;
        public int xIndexOrig = 0;

        XYContainer() {
        }
    }
}

