/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class GsmMeasurementGenerator
extends MeasurementGenerator {
    static final int POWER_MIN = 10000;
    static final int POWER_MAX = 30000;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return GsmMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        int n = 20000;
        dataOutput.writeInt(13);
        this.makeAndOutIntArray(256, dataOutput);
        dataOutput.writeInt(10);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutShortArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        dataOutput.writeInt(111);
        int n2 = GsmMeasurementSettings.instance().getScanMode().intValue();
        dataOutput.writeInt(n2);
        int n3 = GsmMeasurementSettings.instance().getRfInLoss().intValue();
        dataOutput.writeInt(n3);
        dataOutput.writeInt(GsmMeasurementSettings.instance().getStartFreq().intValue() / 1000);
        int n4 = GsmMeasurementSettings.instance().getStepSize().intValue() / 1000;
        if (n4 == 0) {
            n4 = 200;
        }
        dataOutput.writeInt(n4);
        dataOutput.writeInt(500);
        dataOutput.writeInt(500);
        dataOutput.writeInt(20);
        for (int i = 0; i < 40; ++i) {
            dataOutput.writeInt(850000 + i * 1000);
        }
        dataOutput.writeInt(1);
        dataOutput.writeInt(66);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(40, dataOutput);
        this.makeAndOutIntArray(401, dataOutput);
        this.makeAndOutIntArray(401, dataOutput);
        this.makeAndOutIntArray(401, dataOutput);
        this.makeAndOutIntArray(8, dataOutput);
        this.makeAndOutIntArray(8, dataOutput);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(0);
        dataOutput.writeInt(1);
        dataOutput.writeInt(0);
        this.makeAndOutIntArray(11, dataOutput);
        this.makeAndOutIntArray(11, dataOutput);
        this.makeAndOutIntArray(11, dataOutput);
        dataOutput.writeInt(11);
        dataOutput.writeInt(401);
        dataOutput.writeInt(GsmMeasurementSettings.instance().getStartFreqChan().intValue() / 1000);
        dataOutput.writeInt(0);
    }

    private void makeAndOutIntArray(int n, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeInt(100);
        }
    }

    private void makeAndOutShortArray(int n, DataOutput dataOutput) throws IOException {
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(100);
        }
    }
}

