/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.util.chanstd.Bands;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.util.Vector;

public class GsmMeasurementSettings
extends MeasurementSettings {
    private static GsmMeasurementSettings instance;
    private static final Logger logger;
    public static final String TOPIC_GSM = "gsmAn";
    static final String DISPLAY_TOPIC = "display.gsmAn";
    public static final int LEVEL_DBM_UNIT = 0;
    public static final int LEVEL_WATTS_UNIT = 1;
    public static final int SCANTYPE_RANGE = 0;
    public static final int SCANTYPE_AUTO = 1;
    public static final int SCANTYPE_LIST = 2;
    public static final int VALUE_GSM_DISPVALUE_OFF = 0;
    public static final int VALUE_GSM_DISPVALUE_PWR = 1;
    public static final int VALUE_GSM_ORDER_PWR = 0;
    public static final int VALUE_GSM_ORDER_FREQ = 1;
    public static final int VALUE_GSM_BAR_TOP_OFF = 0;
    public static final int VALUE_GSM_BAR_TOP_PWR = 1;
    public static final int VALUE_GSM_MID_BAR_OFF = 0;
    public static final int VALUE_GSM_MID_BAR_BSIC = 1;
    public static final int VALUE_GSM_BAR_UNITS_DBM = 0;
    public static final int VALUE_GSM_BAR_UNITS_WATTS = 1;
    public static final int VALUE_GSM_SLOT_HIGHEST_POWER = 0;
    public static final int VALUE_GSM_SLOT_AUTO = 1;
    public static final int VALUE_GSM_SLOT_GMSK = 2;
    public static final int VALUE_GSM_SLOT_8PSK = 3;
    public static final int VALUE_GSM_SLOT_SPECIFIED_TS = 4;
    public static final int VALUE_GSM_VIEW_TYPE_CHANNEL_SCANNER = 0;
    public static final int VALUE_GSM_VIEW_TYPE_POWER_VS_TIME = 1;
    public static final int VALUE_GSM_VIEW_TYPE_SPECTRUM = 2;
    public static final int VALUE_GSM_ZOOM_TYPE_SLOTS = 0;
    public static final int VALUE_GSM_ZOOM_TYPE_RISE_FALL = 1;
    public static final int VALUE_GSM_START_FREQ_MODE_BAND = 0;
    public static final int VALUE_GSM_START_FREQ_MODE_CHAN = 1;
    public static final int VALUE_GSM_PVT_RF_ENVELOPE_TRACE = 0;
    public static final int VALUE_GSM_PVT_UPPER_MASK_TRACE = 1;
    public static final int VALUE_GSM_PVT_LOWER_MASK_TRACE = 2;
    public static final int VALUE_GSM_SPECTRUM_NORMAL_TRACE = 0;
    public static final int VALUE_GSM_SPECTRUM_AVERAGED_TRACE = 1;
    public static final int GSM_LIMITS_SIZE = 9;
    public static final int LIMIT_CHAN_SCAN_PWR = 0;
    public static final int LIMIT_FREQ_ERROR = 1;
    public static final int LIMIT_TS_PWR = 2;
    public static final int LIMIT_IQ_OFFSET = 3;
    public static final int LIMIT_RMS_PHASE_ERROR = 4;
    public static final int LIMIT_PEAK_PHASE_ERROR = 5;
    public static final int LIMIT_RMS_EVM = 6;
    public static final int LIMIT_PEAK_EVM = 7;
    public static final int LIMIT_PCT_TILE_EVM = 8;
    public static final int QUARTER_SLOT_SIZE = 250;
    public static final String KEY_GSM_SCANMODE = "scanType";
    public static final String KEY_GSM_START_CF = "startCf";
    public static final String KEY_GSM_STEP_SIZE = "chStep";
    public static final String KEY_GSM_STOP_CF = "stopCf";
    public static final String KEY_GSM_DECODE_CF = "decodeCf";
    public static final String KEY_GSM_AUTO_CH_COUNT = "autoChCount";
    public static final String KEY_GSM_FREQLIST = "chFreqList";
    public static final String KEY_GSM_AVG_TYPE = "avgType";
    public static final String KEY_GSM_NUM_AVG = "numAvg";
    public static final String KEY_GSM_SLOT_SYNC = "slotSync";
    public static final String KEY_GSM_SPECIFIC_TS = "specificTS";
    public static final String KEY_GSM_VIEW_TYPE = "viewType";
    public static final String KEY_GSM_ZOOM_TYPE = "zoomType";
    public static final String KEY_GSM_ZOOM_OFFSET = "zoomOffset";
    public static final String KEY_GSM_ZOOM_OFFSET_RF = "zoomOffsetRF";
    public static final String KEY_GSM_ZOOM_INTERVAL = "zoomInterval";
    public static final String KEY_GSM_PVT_MASK = "pvtMask";
    public static final String KEY_GSM_START_CF_CHAN = "startCfChan";
    public static final String KEY_GSM_START_FREQ_MODE = "startFreqMode";
    public static final String KEY_GSM_STOP_CF_CHAN = "stopCfChan";
    public static final String KEY_GSM_PVT_MASK_RADIO_STD = "pvtMaskRadioStd";
    public static final String KEY_GSM_LEVELUNITS = "levelUnits";
    public static final String KEY_GSM_MEASBW = "chanWidth";
    public static final String KEY_GSM_CUST_MEASBW = "custChanWidth";
    public static final String KEY_GSM_UNITS = "gsmUnits";
    public static final String KEY_GSM_DISPVALUE = "dispValue";
    public static final String KEY_GSM_HIGH_LIMIT = "highLimit";
    public static final String KEY_GSM_LOW_LIMIT = "lowLimit";
    public static final String KEY_GSM_FREQ_ERR_HIGH_LIMIT = "freqErrorUpperLimit";
    public static final String KEY_GSM_FREQ_ERR_HIGH_LIMIT_HZ = "freqErrorUpperLimitHz";
    public static final String KEY_GSM_FREQ_ERR_LOW_LIMIT = "freqErrorLowerLimit";
    public static final String KEY_GSM_FREQ_ERR_LOW_LIMIT_HZ = "freqErrorLowerLimitHz";
    public static final String KEY_GSM_FREQ_ERR_LOW_LIMIT_COUPLE = "freqErrorLowerLimitAuto";
    public static final String KEY_GSM_TSPWR_HIGH_LIMIT = "tsPwrUpperLimit";
    public static final String KEY_GSM_TSPWR_LOW_LIMIT = "tsPwrLowerLimit";
    public static final String KEY_GSM_IQOFFSET_HIGH_LIMIT = "iqOffsetUpperLimit";
    public static final String KEY_GSM_RMS_PH_ERR_HIGH_LIMIT = "rmsPhaseErrUpperLimit";
    public static final String KEY_GSM_PEAK_PH_ERR_HIGH_LIMIT = "peakPhaseErrUpperLimit";
    public static final String KEY_GSM_RMS_EVM_HIGH_LIMIT = "rmsEvmUpperLimit";
    public static final String KEY_GSM_PEAK_EVM_HIGH_LIMIT = "peakEvmUpperLimit";
    public static final String KEY_GSM_PCTTILE_EVM_HIGH_LIMIT = "pctTileEvmUpperLimit";
    public static final String KEY_GSM_AUTO_ORDER = "autoOrder";
    public static final String KEY_GSM_BAR_TOP = "barTop";
    public static final String KEY_GSM_MID_BAR = "midBar";
    public static final String KEY_GSM_BAR_UNITS = "barUnits";
    public static final String KEY_GSM_FOCUS_INDEX = "focusIndex";
    public static final String KEY_GSM_PVT_MARKER_TRACE = "pvtMarkerTrace";
    public static final String KEY_GSM_SPECTRUM_MARKER_TRACE = "spectrumMarkerTrace";
    private ListActuator scanMode = new ListActuator("gsmAn", "scanType", Text.Scan_Mode, new Value[]{Value.createValue(Text.Range, 0), Value.createValue(Text.Auto, 1), Value.createValue(Text.List, 2)});
    private FrequencyActuator startFreq = FrequencyActuator.createKilohertz("gsmAn", "startCf", Text.Start_Freq);
    private FrequencyActuator stepSize = FrequencyActuator.createKilohertz("gsmAn", "chStep", Text.GSM_Step_Size);
    private FrequencyActuator stopFreq = FrequencyActuator.createKilohertz("gsmAn", "stopCf", Text.Stop_Freq);
    private FrequencyActuator decodeCf = FrequencyActuator.createKilohertz("gsmAn", "decodeCf", Text.Position);
    private LongActuator autoChCount = new LongActuator("gsmAn", "autoChCount", Text.Auto_Mode_n_Bar_Count, 0L);
    private StringActuator chFreqList = StringActuator.makeStringActuator("gsmAn", "chFreqList", "", "");
    private ListActuator averaging = ListActuator.createStandardAveraging("gsmAn");
    private LongActuator numAverages = LongActuator.createNumAverages("gsmAn", 100);
    private ScaleDivActuator scaleDiv = new ScaleDivActuator("display.gsmAn", 15000);
    private LongActuator refLevel = LongActuator.createRefLevelActuator("display.gsmAn", 20000, "dBm", -100000, 100000, this.scaleDiv);
    private ListActuator dBmWattsUnits = new ListActuator("display.gsmAn", "levelUnits", Text.Units, new Value[]{Value.createValue(Text.dBm, 0), Value.createValue(Text.Watts, 1)});
    private final DisplayGlobalMeasurementSettings displayGlobalSettings = DisplayGlobalMeasurementSettings.instance();
    private final LongActuator rfInLoss = LongActuator.createLoss("gsmAn", "atten", Text.RF_IN_Loss, 0);
    private ListActuator dispValue = new ListActuator("display.gsmAn", "dispValue", Text.Disp_Value, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.Pwr, 1)});
    private final ListActuator powerLimitsEnabled = this.makeOnOffActuator("display.gsmAn", "powerLimitsEnabled", Text.Limits);
    private final LongActuator highLimit = LongActuator.createPower("display.gsmAn", "highLimit", Text.High_Limit, new RangeValidator(-200000L, 100000L, 2), "dBm", 100);
    private final LongActuator lowLimit = LongActuator.createPower("display.gsmAn", "lowLimit", Text.Low_Limit, new RangeValidator(-200000L, 100000L, 2), "dBm", 100);
    private final ListActuator freqErrorLimitState = this.makeOnOffActuator("display.gsmAn", "freqErrorLimitState", Text.Limits);
    private LongActuator freqErrorUpperLimit = LongActuator.createDecimal("display.gsmAn", "freqErrorUpperLimit", Text.High_Limit, new RangeValidator(0L, 100000L), "ppm", 10000);
    private LongActuator freqErrorLowerLimit = LongActuator.createDecimal("display.gsmAn", "freqErrorLowerLimit", Text.Low_Limit, new RangeValidator(-100000L, 0L), "ppm", 10000);
    private ListActuator freqErrorLowerLimitAuto = new ListActuator("display.gsmAn", "freqErrorLowerLimitAuto", Text.Low_Limit, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private FrequencyActuator freqErrorUpperLimitHz = FrequencyActuator.createKilohertz("display.gsmAn", "freqErrorUpperLimitHz", Text.High_Limit);
    private FrequencyActuator freqErrorLowerLimitHz = FrequencyActuator.createKilohertz("display.gsmAn", "freqErrorLowerLimitHz", Text.Low_Limit);
    private final ListActuator tsPwrLimitState = this.makeOnOffActuator("display.gsmAn", "tsPwrLimitsState", Text.Limits);
    private final LongActuator tsPwrUpperLimit = LongActuator.createPower("display.gsmAn", "tsPwrUpperLimit", Text.High_Limit, new RangeValidator(-200000L, 100000L, 2), "dBm", 100);
    private final LongActuator tsPwrLowerLimit = LongActuator.createPower("display.gsmAn", "tsPwrLowerLimit", Text.Low_Limit, new RangeValidator(-200000L, 100000L, 2), "dBm", 100);
    private final ListActuator iqOffsetLimitState = this.makeOnOffActuator("display.gsmAn", "iqOffsetLimitState", Text.Limits);
    private LongActuator iqOffsetUpperLimit = LongActuator.createPower("display.gsmAn", "iqOffsetUpperLimit", Text.High_Limit, new RangeValidator(-100000L, 0L, 2), "dB", 100);
    private final ListActuator rmsPhaseErrorLimitState = this.makeOnOffActuator("display.gsmAn", "rmsPhaseErrorLimitState", Text.Limits);
    private LongActuator rmsPhaseErrorUpperLimit = LongActuator.createDecimal("display.gsmAn", "rmsPhaseErrUpperLimit", Text.High_Limit, new RangeValidator(0L, 180000L, 2), "deg", 1000);
    private final ListActuator peakPhaseErrorLimitState = this.makeOnOffActuator("display.gsmAn", "peakPhaseErrorLimitState", Text.Limits);
    private LongActuator peakPhaseErrorUpperLimit = LongActuator.createDecimal("display.gsmAn", "peakPhaseErrUpperLimit", Text.High_Limit, new RangeValidator(0L, 180000L, 2), "deg", 1000);
    private final ListActuator rmsEvmLimitState = this.makeOnOffActuator("display.gsmAn", "rmsEvmLimitState", Text.Limits);
    private LongActuator rmsEvmUpperLimit = LongActuator.createPercentActuator("display.gsmAn", "rmsEvmUpperLimit", Text.High_Limit, 100000, 1000);
    private final ListActuator peakEvmLimitState = this.makeOnOffActuator("display.gsmAn", "peakEvmLimitState", Text.Limits);
    private LongActuator peakEvmUpperLimit = LongActuator.createPercentActuator("display.gsmAn", "peakEvmUpperLimit", Text.High_Limit, 100000, 1000);
    private final ListActuator pctTileEvmLimitState = this.makeOnOffActuator("display.gsmAn", "pctTileEvmLimitState", Text.Limits);
    private LongActuator pctTileEvmUpperLimit = LongActuator.createPercentActuator("display.gsmAn", "pctTileEvmUpperLimit", Text.High_Limit, 100000, 1000);
    private Vector limitsToggles = new Vector();
    private ListActuator autoOrder = new ListActuator("display.gsmAn", "autoOrder", Text.Auto_Order, new Value[]{Value.createValue(Text.Pwr, 0), Value.createValue(Text.Freq, 1)});
    private ListActuator barTop = new ListActuator("display.gsmAn", "barTop", Text.Bar_Top, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.Pwr, 1)});
    private ListActuator midBar = new ListActuator("display.gsmAn", "midBar", Text.Mid_dash_Bar, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.BSIC, 1)});
    private FocusIndexLongActuator focusIndex = new FocusIndexLongActuator("display.gsmAn", "focusIndex", Text.Position);
    private ListActuator slotSync = new ListActuator("gsmAn", "slotSync", Text.Slot_Sync, new Value[]{Value.createValue(Text.Highest_Pwr, 0), Value.createValue(Text.Auto, 1), Value.createValue(Text.GMSK, 2), Value.createValue(Text._8PSK, 3), Value.createValue(Text.Specified_TS_n_hash_leftBanana_w_slash_BCCH_rightBanana, 4)});
    private LongActuator specificTS = new LongActuator("gsmAn", "specificTS", Text.TS_hash_n_leftBanana_w_slash_BCCH_rightBanana, 0L);
    private ListActuator viewType = new ListActuator("gsmAn", "viewType", Text.View, new Value[]{Value.createValue(Text.Channel_n_Scanner, 0), Value.createValue(Text.Power_vs_dot_n_Time, 1), Value.createValue(Text.Spectrum, 2)});
    private ListActuator zoomType = new ListActuator("gsmAn", "zoomType", Text.Zoom, new Value[]{Value.createValue(Text.Slots, 0), Value.createValue(Text.Rise_slash_Fall, 1)});
    private LongActuator zoomOffset = LongActuator.createSlots("gsmAn", "zoomOffset", Text.Zoom_Offset, 0L, 0L, 7750L, 250);
    private LongActuator zoomOffsetRF = LongActuator.createSlots("gsmAn", "zoomOffsetRF", Text.Zoom_Offset, 0L, 0L, 7000L, 1000);
    private LongActuator zoomInterval = LongActuator.createSlots("gsmAn", "zoomInterval", Text.Zoom_n_Interval, 1000L, 250L, 8000L, 250);
    private ListActuator pvtMask = new ListActuator("gsmAn", "pvtMask", Text.PvT_Mask, this.createOnOffValueSet());
    private FrequencyActuator startFreqChan = FrequencyActuator.createKilohertz("gsmAn", "startCfChan", Text.Start_Freq);
    private ListActuator startFreqMode = new ListActuator("gsmAn", "startFreqMode", Text.Start_Freq, new Value[]{Value.createValue(Text.Band, 0), Value.createValue(Text.Chan, 1)});
    private Value[] pvtMarkerTraceValues = new Value[]{Value.createValue(Text.RF_Envelope, 0), Value.createValue(Text.Upper_Mask, 1), Value.createValue(Text.Lower_Mask, 2)};
    private Value[] spectrumMarkerTraceValues = new Value[]{Value.createValue(Text.Normal, 0), Value.createValue(Text.Averaged, 1)};
    private FrequencyActuator stopFreqChan = FrequencyActuator.createKilohertz("display.gsmAn", "stopCfChan", Text.Stop_Freq);
    private LongActuator pvtMaskRadioStd = new LongActuator("gsmAn", "pvtMaskRadioStd", Text.Pvt_Mask_Radio_Std, 0L);
    boolean bLimitsSummaryState;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmMeasurementSettings;

    public GsmMeasurementSettings(String string) {
        super(string);
        this.add(this.scaleDiv);
        this.add(this.refLevel);
        this.add(this.dBmWattsUnits);
        this.add(this.scanMode);
        this.add(this.startFreq);
        this.add(this.stepSize);
        this.add(this.stopFreq);
        this.add(this.decodeCf);
        this.add(this.autoChCount);
        this.add(this.chFreqList);
        this.add(this.rfInLoss);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.dispValue);
        this.add(this.autoOrder);
        this.add(this.barTop);
        this.add(this.midBar);
        this.add(this.powerLimitsEnabled);
        this.add(this.highLimit);
        this.add(this.lowLimit);
        this.add(this.freqErrorLimitState);
        this.add(this.freqErrorUpperLimit);
        this.add(this.freqErrorUpperLimitHz);
        this.add(this.freqErrorLowerLimit);
        this.add(this.freqErrorLowerLimitHz);
        this.add(this.freqErrorLowerLimitAuto);
        this.add(this.tsPwrLimitState);
        this.add(this.tsPwrUpperLimit);
        this.add(this.tsPwrLowerLimit);
        this.add(this.iqOffsetLimitState);
        this.add(this.iqOffsetUpperLimit);
        this.add(this.rmsPhaseErrorLimitState);
        this.add(this.rmsPhaseErrorUpperLimit);
        this.add(this.peakPhaseErrorLimitState);
        this.add(this.peakPhaseErrorUpperLimit);
        this.add(this.rmsEvmLimitState);
        this.add(this.rmsEvmUpperLimit);
        this.add(this.peakEvmLimitState);
        this.add(this.peakEvmUpperLimit);
        this.add(this.pctTileEvmLimitState);
        this.add(this.pctTileEvmUpperLimit);
        this.add(this.focusIndex);
        this.add(this.slotSync);
        this.add(this.specificTS);
        this.add(this.viewType);
        this.add(this.zoomType);
        this.add(this.zoomOffset);
        this.add(this.zoomOffsetRF);
        this.add(this.zoomInterval);
        this.add(this.pvtMask);
        this.add(this.startFreqChan);
        this.add(this.startFreqMode);
        this.add(this.stopFreqChan);
        this.add(this.pvtMaskRadioStd);
        this.freqErrorUpperLimit.setIncrement(100);
        this.freqErrorLowerLimit.setIncrement(100);
        this.limitsToggles.setSize(9);
        this.limitsToggles.setElementAt(this.powerLimitsEnabled, 0);
        this.limitsToggles.setElementAt(this.freqErrorLimitState, 1);
        this.limitsToggles.setElementAt(this.tsPwrLimitState, 2);
        this.limitsToggles.setElementAt(this.iqOffsetLimitState, 3);
        this.limitsToggles.setElementAt(this.rmsPhaseErrorLimitState, 4);
        this.limitsToggles.setElementAt(this.peakPhaseErrorLimitState, 5);
        this.limitsToggles.setElementAt(this.rmsEvmLimitState, 6);
        this.limitsToggles.setElementAt(this.peakEvmLimitState, 7);
        this.limitsToggles.setElementAt(this.pctTileEvmLimitState, 8);
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), string + ".RfInLossListener");
        this.refLevel.setUnitsFactory(new DbmUnitsFactory());
        this.refLevel.setIncrement(this.scaleDiv.intValue() / 10);
        this.addDBmWattsUnitsValueListeners();
        this.autoChCount.setValidator(new RangeValidator(1L, 20L));
        this.startFreq.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.startFreqChan.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.stopFreq.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.stopFreqChan.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.focusIndex.setValidator(new RangeValidator(10000000L, 2500000000L));
        this.stepSize.setIncrement(1000);
        this.stepSize.setValidator(new RangeValidator(200000L, 2000000000L));
        this.specificTS.setValidator(new RangeValidator(0L, 7L));
        this.displayGlobalSettings.getChanStd().addValueListener(new ValueListener(){
            private final String listenerName = "GSM.chanStdListener";

            public String getListenerName() {
                return "GSM.chanStdListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.configStartFreqAndStepSize();
                GsmMeasurementSettings.this.updatePvTMaskRadioStd();
            }
        });
        this.displayGlobalSettings.getChanFreqUnits().addValueListener(new ValueListener(){
            private final String listenerName = "GSM.chanFreqUnitsListener";

            public String getListenerName() {
                return "GSM.chanFreqUnitsListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.configStartFreqAndStepSize();
            }
        });
        this.stepSize.addValueListener(new ValueListener(){
            private final String listenerName = "GSM.stepSizeListener";

            public String getListenerName() {
                return "GSM.stepSizeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.updateDecodeCf();
            }
        });
        this.highLimit.setIncrement(100);
        this.lowLimit.setIncrement(100);
        this.scaleDiv.addValueListener(new ValueListener(){
            private final String listenerName = "GSM.scaleDivListener";

            public String getListenerName() {
                return "GSM.scaleDivListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.refLevel.setIncrement(GsmMeasurementSettings.this.scaleDiv.intValue() / 10);
            }
        });
        this.configStartFreqAndStepSize();
        ValueListener valueListener = new ValueListener(){
            private final String listenerName = "GSM.freqErrorUpperLimListener";

            public String getListenerName() {
                return "GSM.freqErrorUpperLimListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.freqErrorUpperLimitHz.setValue(GsmMeasurementSettings.this.calculateFreqFromPpm(valueInterface.intValue()));
                if (GsmMeasurementSettings.this.freqErrorLowerLimitAuto.booleanValue()) {
                    GsmMeasurementSettings.this.freqErrorLowerLimit.setValue(valueInterface.intValue() * -1);
                }
            }
        };
        this.freqErrorUpperLimit.addValueListener(valueListener);
        ValueListener valueListener2 = new ValueListener(){
            private final String listenerName = "GSM.freqErrorLowerLimListener";

            public String getListenerName() {
                return "GSM.freqErrorLowerLimListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.freqErrorLowerLimitHz.setValue(GsmMeasurementSettings.this.calculateFreqFromPpm(valueInterface.intValue()));
            }
        };
        this.freqErrorLowerLimit.addValueListener(valueListener2);
        ValueListener valueListener3 = new ValueListener(){
            private final String listenerName = "GSM.freqErrorLowerLimModeListener";

            public String getListenerName() {
                return "GSM.freqErrorLowerLimModeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.booleanValue()) {
                    GsmMeasurementSettings.this.freqErrorLowerLimit.setValue(GsmMeasurementSettings.this.freqErrorUpperLimit.intValue() * -1);
                }
            }
        };
        this.freqErrorLowerLimitAuto.addValueListener(valueListener3);
        ValueListener valueListener4 = new ValueListener(){
            private final String listenerName = "GSM.freqErrorConvertorListener";

            public String getListenerName() {
                return "GSM.freqErrorConvertorListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.freqErrorUpperLimitHz.setValue(GsmMeasurementSettings.this.calculateFreqFromPpm(valueInterface.intValue(), GsmMeasurementSettings.this.freqErrorUpperLimit.intValue()));
                GsmMeasurementSettings.this.freqErrorLowerLimitHz.setValue(GsmMeasurementSettings.this.calculateFreqFromPpm(valueInterface.intValue(), GsmMeasurementSettings.this.freqErrorLowerLimit.intValue()));
            }
        };
        this.decodeCf.addValueListener(valueListener4);
        ValueListener valueListener5 = new ValueListener(){
            private final String listenerName = "GSM.zoomOffsetListener";

            public String getListenerName() {
                return "GSM.zoomOffsetListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                double d = valueInterface.intValue() / 250;
                long l = (long)d * 250L;
                GsmMeasurementSettings.this.zoomOffset.setValue(l);
            }
        };
        this.zoomOffset.addValueListener(valueListener5);
        ValueListener valueListener6 = new ValueListener(){
            private final String listenerName = "GSM.zoomOffsetRFListener";

            public String getListenerName() {
                return "GSM.zoomOffsetRFListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                double d = valueInterface.intValue() / 1000;
                long l = (long)d * 1000L;
                GsmMeasurementSettings.this.zoomOffsetRF.setValue(l);
            }
        };
        this.zoomOffsetRF.addValueListener(valueListener6);
        ValueListener valueListener7 = new ValueListener(){
            private final String listenerName = "GSM.zoomIntervalListener";

            public String getListenerName() {
                return "GSM.zoomIntervalListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                double d = valueInterface.intValue() / 250;
                long l = (long)d * 250L;
                GsmMeasurementSettings.this.zoomInterval.setValue(l);
            }
        };
        this.zoomInterval.addValueListener(valueListener7);
        this.refresh();
    }

    public int calculateFreqFromPpm(int n) {
        return this.calculateFreqFromPpm(this.decodeCf.intValue(), n);
    }

    public int calculateFreqFromPpm(int n, int n2) {
        return (int)((double)n * ((double)n2 / 10000.0) * 1.0E-6);
    }

    private void addListenersForFocusIndex() {
        this.focusIndex.addValueListener(new ValueListener(){
            private final String listenerName = "GSM.focusIndexListener";

            public String getListenerName() {
                return "GSM.focusIndexListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMeasurementSettings.this.decodeCf.send(valueInterface.longValue());
            }
        });
    }

    private void updateDecodeCf() {
        BandSelector bandSelector = this.getBandSelector();
        if (this.displayGlobalSettings.getChanFreqUnits().intValue() == 1) {
            int n = (int)(this.stepSize.longValue() / Band.getCurrentBandChannelWidth(this.getBandSelector()));
            this.decodeCf.configureForChannels(Text.Position, bandSelector, Value.createValue("", n));
            this.startFreq.configureForChannels(Text.Start_Chan, bandSelector, Value.createValue("", n));
            this.startFreqChan.configureForChannels(Text.Start_Chan, bandSelector, Value.createValue("", n));
        } else {
            this.decodeCf.configureForFreq(Text.Position);
            this.decodeCf.setIncrement((int)this.stepSize.longValue());
            this.startFreq.setIncrement(this.stepSize.intValue());
            this.startFreqChan.setIncrement(this.stepSize.intValue());
        }
    }

    private void configStartFreqAndStepSize() {
        BandSelector bandSelector = this.getBandSelector();
        if (this.displayGlobalSettings.getChanFreqUnits().intValue() == 1) {
            this.startFreq.configureForChannels(Text.Start_Chan, bandSelector, Value.createValue("", 1));
            this.startFreq.setIncrement((int)Band.getCurrentBandChannelWidth(bandSelector));
            this.startFreqChan.configureForChannels(Text.Start_Chan, bandSelector, Value.createValue("", 1));
            this.startFreqChan.setIncrement((int)Band.getCurrentBandChannelWidth(bandSelector));
            this.stepSize.configureForChannelCount(Text.GSM_Step_Size, bandSelector);
            this.stopFreq.configureForChannels(Text.Stop_Chan, bandSelector, Value.createValue("", 1));
            this.stopFreq.setIncrement((int)Band.getCurrentBandChannelWidth(bandSelector));
            this.stopFreqChan.configureForChannels(Text.Stop_Chan, bandSelector, Value.createValue("", 1));
            this.stopFreqChan.setIncrement((int)Band.getCurrentBandChannelWidth(bandSelector));
            int n = (int)(this.stepSize.longValue() / Band.getCurrentBandChannelWidth(this.getBandSelector()));
            this.decodeCf.configureForChannels(Text.Position, bandSelector, Value.createValue("", n));
        } else {
            this.startFreq.configureForFreq(Text.Start_Freq);
            this.startFreq.setIncrement(1000);
            this.startFreqChan.configureForFreq(Text.Start_Freq);
            this.startFreqChan.setIncrement(1000);
            this.stepSize.configureForFreq(Text.GSM_Step_Size);
            this.stopFreq.configureForFreq(Text.Stop_Freq);
            this.stopFreq.setIncrement(1000);
            this.stopFreqChan.configureForFreq(Text.Stop_Freq);
            this.stopFreqChan.setIncrement(1000);
            this.decodeCf.configureForFreq(Text.Position);
            this.decodeCf.setIncrement((int)this.stepSize.longValue());
        }
    }

    private void updatePvTMaskRadioStd() {
        Band band = Band.getCurrentBand(BandSelector.getGlobalBandSelector());
        if (band.equals(Bands.BAND_GSM_PCS_1900)) {
            this.pvtMaskRadioStd.send(1L);
        } else {
            this.pvtMaskRadioStd.send(0L);
        }
    }

    public BandSelector getBandSelector() {
        return BandSelector.getCustomBandSelector(this.displayGlobalSettings.getChanStd());
    }

    private void addDBmWattsUnitsValueListeners() {
        this.dBmWattsUnits.addValueListener(new ValueListener(){
            private final String listenerName = "GSM.dBmWattsUnitsListener";

            public String getListenerName() {
                return "GSM.dBmWattsUnitsListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == 1) {
                    GsmMeasurementSettings.this.refLevel.setConversion(DbmUnitsFactory.getWattsConversion());
                } else {
                    GsmMeasurementSettings.this.refLevel.setConversion(DbmUnitsFactory.getDbmConversion());
                }
                GsmMeasurementSettings.this.refLevel.setValue(GsmMeasurementSettings.this.refLevel.intValue());
            }
        });
    }

    private ListActuator makeOnOffActuator(String string, String string2, String string3) {
        return new ListActuator(string, string2, string3, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public ListActuator getdBmWattsUnits() {
        return this.dBmWattsUnits;
    }

    public LongActuator getAutoChCount() {
        return this.autoChCount;
    }

    public StringActuator getChannelList() {
        return this.chFreqList;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public ListActuator getScanMode() {
        return this.scanMode;
    }

    public FrequencyActuator getStartFreq() {
        return this.startFreq;
    }

    public FrequencyActuator getStartFreqChan() {
        return this.startFreqChan;
    }

    public FrequencyActuator getStepSize() {
        return this.stepSize;
    }

    public FrequencyActuator getStopFreq() {
        return this.stopFreq;
    }

    public FrequencyActuator getDecodeCf() {
        return this.decodeCf;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public LongActuator getRfInLoss() {
        return this.rfInLoss;
    }

    public ListActuator getDispValue() {
        return this.dispValue;
    }

    public ListActuator getAutoOrder() {
        return this.autoOrder;
    }

    public ListActuator getBarTop() {
        return this.barTop;
    }

    public ListActuator getMidBar() {
        return this.midBar;
    }

    public LongActuator getFocusIndex() {
        return this.focusIndex;
    }

    public ListActuator getSlotSync() {
        return this.slotSync;
    }

    public LongActuator getSpecficTS() {
        return this.specificTS;
    }

    public ListActuator getViewType() {
        return this.viewType;
    }

    public ListActuator getZoomType() {
        return this.zoomType;
    }

    public LongActuator getZoomOffset() {
        return this.zoomOffset;
    }

    public LongActuator getZoomOffsetRF() {
        return this.zoomOffsetRF;
    }

    public LongActuator getZoomInterval() {
        return this.zoomInterval;
    }

    public ListActuator getPvtMask() {
        return this.pvtMask;
    }

    public ListActuator getStartFreqMode() {
        return this.startFreqMode;
    }

    public FrequencyActuator getStopFreqChan() {
        this.stopFreqChan.setValue(this.startFreqChan.longValue());
        return this.stopFreqChan;
    }

    public LongActuator getPvtMaskRadioStd() {
        return this.pvtMaskRadioStd;
    }

    public static GsmMeasurementSettings instance() {
        if (instance == null) {
            instance = new GsmMeasurementSettings(TOPIC_GSM);
            logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getHighLimit() {
        return this.highLimit;
    }

    public LongActuator getLowLimit() {
        return this.lowLimit;
    }

    public LongActuator getFreqErrorUpperLimit() {
        return this.freqErrorUpperLimit;
    }

    public FrequencyActuator getFreqErrorUpperLimitHz() {
        return this.freqErrorUpperLimitHz;
    }

    public LongActuator getFreqErrorLowerLimit() {
        return this.freqErrorLowerLimit;
    }

    public FrequencyActuator getFreqErrorLowerLimitHz() {
        return this.freqErrorLowerLimitHz;
    }

    public ListActuator getFreqErrorLowerLimitAuto() {
        return this.freqErrorLowerLimitAuto;
    }

    public LongActuator getTsPwrUpperLimit() {
        return this.tsPwrUpperLimit;
    }

    public LongActuator getTsPwrLowerLimit() {
        return this.tsPwrLowerLimit;
    }

    public LongActuator getIqOffsetUpperLimit() {
        return this.iqOffsetUpperLimit;
    }

    public LongActuator getRmsPhErrUpperLimit() {
        return this.rmsPhaseErrorUpperLimit;
    }

    public LongActuator getPeakPhErrUpperLimit() {
        return this.peakPhaseErrorUpperLimit;
    }

    public LongActuator getRmsEvmUpperLimit() {
        return this.rmsEvmUpperLimit;
    }

    public LongActuator getPeakEvmUpperLimit() {
        return this.peakEvmUpperLimit;
    }

    public LongActuator getPctTileEvmUpperLimit() {
        return this.pctTileEvmUpperLimit;
    }

    public Value[] getPvtMarkerTraceValues() {
        return this.pvtMarkerTraceValues;
    }

    public Value[] getSpectrumMarkerTraceValues() {
        return this.spectrumMarkerTraceValues;
    }

    public ListActuator limitsToggleAt(int n) {
        ListActuator listActuator = (ListActuator)this.limitsToggles.elementAt(n);
        return listActuator;
    }

    public boolean getLimitsSummaryState() {
        this.bLimitsSummaryState = false;
        for (int i = 1; i < 9; ++i) {
            if (this.limitsToggleAt(i).getSelectedValue().longValue() != 1L) continue;
            this.bLimitsSummaryState = true;
            break;
        }
        return this.bLimitsSummaryState;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = LogManager.getLogger(class$elgato$measurement$gsm$GsmMeasurementSettings == null ? (class$elgato$measurement$gsm$GsmMeasurementSettings = GsmMeasurementSettings.class$("elgato.measurement.gsm.GsmMeasurementSettings")) : class$elgato$measurement$gsm$GsmMeasurementSettings);
    }

    private class FocusIndexLongActuator
    extends LongActuator {
        FocusIndexLongActuator(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public void setValue(long l) {
            long l2 = this.getValidator().validValue(l);
            ValueInterface valueInterface = this.getValueObject();
            valueInterface.setValue(l2);
            this.setValueObject(valueInterface);
        }
    }
}

