/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.MarkerSettingsFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.FreqChanListButton;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.ListButton;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.units.TimeUnits;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.EListModel;
import elgato.infrastructure.widgets.VectorEListModel;
import elgato.measurement.gsm.GsmAnalyzer;
import elgato.measurement.gsm.GsmMarkerButtonFactory;
import elgato.measurement.gsm.GsmMeasurementSettings;
import elgato.measurement.gsm.GsmScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class GsmMenuMgr
extends MeasurementMenuMgr {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$gsm$GsmScreen == null ? (class$elgato$measurement$gsm$GsmScreen = GsmMenuMgr.class$("elgato.measurement.gsm.GsmScreen")) : class$elgato$measurement$gsm$GsmScreen);
    protected GsmAnalyzer analyzer;
    GsmMeasurementSettings settings;
    static final BandSelector BAND_SELECTOR = GsmMeasurementSettings.instance().getBandSelector();
    MultiStateActuatorButton measTimeButton;
    MenuItem thresholdLevelButton;
    protected MenuButton setupButton;
    protected MenuButton levelMenuButton;
    private MenuButton mkrMenuButton;
    protected MenuItem startFrequencyButton;
    protected ActuatorEditor stepSizeButton;
    protected MenuItem stopFrequencyButton;
    protected MenuItem stopFrequencyChanButton;
    protected FreqChanListButton freqchanListButton;
    protected ActuatorEditor specificTSButton;
    protected GsmMarkerButtonFactory spectrumMarkerButtonFactory;
    protected GsmMarkerButtonFactory pvtMarkerButtonFactory;
    private MarkerSettingsFactory spectrumMarkerSettingsFactory;
    private MarkerSettingsFactory pvtMarkerSettingsFactory;
    private Menu more1of2LimitsMenu;
    private Menu more2of2LimitsMenu;
    private ListActuator scanMode;
    MultiStateActuatorButton scanModeButton;
    private ValueListener scanTypeValueListener;
    private MultiStateActuatorButton autoOrderButton;
    private MultiStateActuatorButton midBarButton;
    protected Menu displayMenu;
    protected Menu freqChanMenu;
    private ViewTypeValueListener viewTypeValueListener;
    private ZoomTypeValueListener zoomTypeValueListener;
    private ValueListener startFreqModeValueListener;
    private ValueListener startFreqChanValueListener;
    private MultiStateActuatorButton barTopMenuButton;
    private MultiStateActuatorButton dBmWattsMenuButton;
    private MultiStateActuatorButton zoomTypeButton;
    private ActuatorEditor zoomOffsetButton;
    private ActuatorEditor zoomOffsetRFButton;
    private ActuatorEditor zoomIntervalButton;
    private MultiStateActuatorButton pvtMaskButton;
    private ListActuator zoomType;
    private FrequencyActuator startFreq;
    private FrequencyActuator startFreqChan;
    private ListActuator startFreqMode;
    private MenuButton markerMenu_empty;
    private MenuButton markerMenu_spectrum;
    private MenuButton markerMenu_pvt;
    private Menu leftMenu;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmScreen;

    public GsmMenuMgr(MeasurementScreen measurementScreen, GsmMeasurementSettings gsmMeasurementSettings, GsmAnalyzer gsmAnalyzer) {
        super(measurementScreen);
        this.settings = gsmMeasurementSettings;
        this.analyzer = gsmAnalyzer;
        this.viewTypeValueListener = new ViewTypeValueListener(this);
        this.zoomTypeValueListener = new ZoomTypeValueListener(this);
        this.createMiscButtons();
        this.freqChanMenu = this.createFreqChanMenu();
        this.displayMenu = this.createDisplayMenu();
        this.createSpectrumMarkerButtonFactory();
        this.createPvtMarkerButtonFactory();
        this.markerMenu_spectrum = this.spectrumMarkerButtonFactory.getMenuButtonWithTrace();
        this.markerMenu_pvt = this.pvtMarkerButtonFactory.getMenuButtonWithTrace();
    }

    protected abstract MenuButton createFreqChanButton();

    protected abstract MenuItem createSetupMenuButton();

    protected abstract MenuButton createDisplayMenuButton();

    protected Menu gsmBuildLeftMenu() {
        this.leftMenu = new Menu(this.getLeftMenuTitle(), new MenuItem[]{this.createFreqChanButton(), this.createLevelMenuButton(), this.createDisplayMenuButton(), null, this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging()), this.createSetupMenuButton(), null});
        this.createMarkerButton();
        return this.leftMenu;
    }

    protected Menu buildLeftMenu() {
        Menu menu = this.gsmBuildLeftMenu();
        return menu;
    }

    protected void createMiscButtons() {
        this.freqchanListButton = this.createFreqchanListButton();
        this.stopFrequencyButton = this.createStopFrequencyButton();
        this.stopFrequencyChanButton = this.createStopFrequencyChanButton();
        this.startFrequencyButton = this.createStartFrequencyButton();
        this.stepSizeButton = this.createStepSizeButton();
        this.specificTSButton = this.createSpecificTSButton();
        this.barTopMenuButton = this.createBarTopButton();
        this.dBmWattsMenuButton = this.createDbmWattsUnitsButton();
        this.zoomOffsetButton = this.createZoomOffsetButton();
        this.zoomOffsetRFButton = this.createZoomOffsetRFButton();
        this.zoomIntervalButton = this.createZoomIntervalButton();
        this.zoomTypeButton = this.createZoomTypeButton();
        this.pvtMaskButton = this.createPvtMaskButton();
        this.markerMenu_empty = new SubMenuButton(Text.Marker, this.scn.getContextString("marker"), new Menu(Text.Marker, new MenuItem[0], 0));
        this.markerMenu_empty.setEnabled(false);
    }

    protected String getMeasurementName() {
        return "gsmAn";
    }

    private FreqChanListButton createFreqchanListButton() {
        FreqChanListButton freqChanListButton = new FreqChanListButton(Text.List, this.getContextString("freqchan.list"), new FrequencyListModelGetter(), new FrequencyListPersistor(), (GsmScreen)this.scn);
        return freqChanListButton;
    }

    MenuItem createStartFrequencyButton() {
        this.startFreq = this.settings.getStartFreq();
        this.startFreqChan = this.settings.getStartFreqChan();
        this.startFreqMode = this.settings.getStartFreqMode();
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton(this.startFreqMode, this.getContextString("frequencyChannel.start"), new ValueInterface[]{this.startFreq, this.startFreqChan}, "GsmScreen.startFreqButton", true);
        this.startFreqModeValueListener = new ValueListener(){
            private final String listenerName = "GsmScreen.startFreqModeValueListener";

            public String getListenerName() {
                return "GsmScreen.startFreqModeValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == 1) {
                    if (GsmMenuMgr.this.freqChanMenu != null) {
                        GsmMenuMgr.this.settings.getStopFreqChan().setValue(GsmMenuMgr.this.settings.getStartFreqChan().longValue());
                        GsmMenuMgr.this.freqChanMenu.setMenuItem(null, 4);
                        GsmMenuMgr.this.freqChanMenu.setMenuItem(GsmMenuMgr.this.stopFrequencyChanButton, 4);
                    }
                    GsmMenuMgr.this.stopFrequencyChanButton.setEnabled(false);
                } else if (GsmMenuMgr.this.freqChanMenu != null) {
                    GsmMenuMgr.this.freqChanMenu.setMenuItem(null, 4);
                    GsmMenuMgr.this.freqChanMenu.setMenuItem(GsmMenuMgr.this.stopFrequencyButton, 4);
                }
                GsmMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaint();
            }
        };
        this.startFreqChanValueListener = new ValueListener(){
            private final String listenerName = "GsmScreen.startFreqChanValueListener";

            public String getListenerName() {
                return "GsmScreen.startFreqChanValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMenuMgr.this.settings.getStopFreqChan().setValue(GsmMenuMgr.this.settings.getStartFreqChan().longValue());
            }
        };
        this.startFreqMode.addValueListener(this.startFreqModeValueListener);
        this.startFreqModeValueListener.valueChanged(this.startFreqMode.getSelectedValue());
        this.startFreqChan.addValueListener(this.startFreqChanValueListener);
        this.startFreqChanValueListener.valueChanged(this.startFreqMode.getSelectedValue());
        return trimodeActuatorButton;
    }

    ActuatorEditor createStepSizeButton() {
        FrequencyActuator frequencyActuator = this.settings.getStepSize();
        ActuatorEditor actuatorEditor = new ActuatorEditor(frequencyActuator, this.getContextString("frequencyChannel.step"), "GsmScreen.stepSizeButton");
        return actuatorEditor;
    }

    MenuItem createStopFrequencyButton() {
        FrequencyActuator frequencyActuator = this.settings.getStopFreq();
        return new ActuatorEditor(frequencyActuator, this.getContextString("frequencyChannel.stop"), "GsmScreen.stopFreqButton");
    }

    MenuItem createStopFrequencyChanButton() {
        FrequencyActuator frequencyActuator = this.settings.getStopFreqChan();
        return new ActuatorEditor(frequencyActuator, this.getContextString("frequencyChannel.stopchan"), "GsmScreen.stopFreqChanButton");
    }

    protected MenuItem createChanStdSelectButton() {
        return FrequencyChannelButtonFactory.createGsmChanStdSelectButton(this.getContextString("chan.std"), "GsmScreen");
    }

    protected MultiStateActuatorButton createScanModeButton(final MenuItem menuItem, final MenuItem menuItem2, final MenuItem menuItem3, final MenuItem menuItem4) {
        this.scanMode = this.settings.getScanMode();
        this.scanModeButton = new MultiStateActuatorButton(this.scanMode, this.getContextString("frequencyChannel.scanMode"), "GsmScreen.scanModeButton");
        this.scanTypeValueListener = new ValueListener(){
            private final String listenerName = "GsmScreen.scanTypeValueListener";

            public String getListenerName() {
                return "GsmScreen.scanTypeValueListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                GsmMenuMgr.this.setRangeEnabled(valueInterface.intValue() != 2, menuItem, menuItem2, menuItem3, menuItem4);
                GsmMenuMgr.this.createAutoOrderButton().setEnabled(valueInterface.intValue() == 1);
                GsmMenuMgr.this.createMidBarButton().setEnabled(valueInterface.intValue() != 0);
            }
        };
        this.scanMode.addValueListener(this.scanTypeValueListener);
        this.scanTypeValueListener.valueChanged(this.scanMode.getSelectedValue());
        return this.scanModeButton;
    }

    public MenuItem createUnitsButton() {
        return new MultiStateActuatorButton(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits(), "units", "GsmScreen.unitsButton");
    }

    protected SubMenuButton createLimitsButton() {
        this.more1of2LimitsMenu = new Menu(Text.Limits, new MenuItem[]{this.createChanScanPwrLimitsButton(), null, this.createFreqErrorLimitsButton(), this.createTsPwrLimitsButton(), this.createIqOffsetLimitsButton(), this.createMoreButton(Text.More_n_1_of_2), null});
        this.more2of2LimitsMenu = new Menu(Text.Limits, new MenuItem[]{this.createRmsPhaseErrorLimitsButton(), this.createPeakPhaseErrorLimitsButton(), this.createRmsEvmErrorLimitsButton(), this.createPeakEvmErrorLimitsButton(), this.create95tileEvmErrorLimitsButton(), this.createMore2Button(Text.More_n_2_of_2), null});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextId(), this.more1of2LimitsMenu);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected PushButton createMoreButton(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GsmMenuMgr.this.scn.getScreenManager().installRightMenu(GsmMenuMgr.this.more2of2LimitsMenu);
            }
        });
    }

    protected PushButton createMore2Button(String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GsmMenuMgr.this.scn.getScreenManager().installRightMenu(GsmMenuMgr.this.more1of2LimitsMenu);
            }
        });
    }

    private MenuItem createChanScanPwrLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Chan_Scan_n_Pwr_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.Chan_Scan, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(0), this.getContextId(), "GsmScreen.pwrLimEnabled"), new ActuatorEditor(this.settings.getHighLimit(), this.getContextId(), "GsmScreen.pwrLimHigh"), new ActuatorEditor(this.settings.getLowLimit(), this.getContextId(), "GsmScreen.pwrLimLow")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createFreqErrorLimitsButton() {
        ActuatorEditor actuatorEditor = new ActuatorEditor(this.settings.getFreqErrorUpperLimitHz(), this.getContextId(), "GsmScreen.freqErrHighLimHz");
        actuatorEditor.setEnabled(false);
        ActuatorEditor actuatorEditor2 = new ActuatorEditor(this.settings.getFreqErrorLowerLimitHz(), this.getContextId(), "GsmScreen.freqErrLowLimHz");
        actuatorEditor2.setEnabled(false);
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_n_Limits, this.getContextString("freqErrorLimits"), new Menu(Text.Freq_Error, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(1), this.getContextId(), "GsmScreen.freqErrorLimState"), new ActuatorEditor(this.settings.getFreqErrorUpperLimit(), this.getContextId(), "GsmScreen.freqErrHighLim"), this.createFreqErrorLowerLimitButton(), actuatorEditor, actuatorEditor2}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createFreqErrorLowerLimitButton() {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)this.settings.getFreqErrorLowerLimitAuto(), this.getContextString("freqErrorLimits"), new ValueInterface[]{this.settings.getFreqErrorLowerLimit(), this.settings.getFreqErrorLowerLimit()}, this.getListenerBaseName() + ".freqErrorLLimits");
        trimodeActuatorButton.setReadOnlyValueIndex(0);
        return trimodeActuatorButton;
    }

    private MenuItem createTsPwrLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.TS_Pwr_n_Limits, this.getContextString("tsPwrLimits"), new Menu(Text.TS_Pwr, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(2), this.getContextId(), "GsmScreen.tsPwrLimState"), new ActuatorEditor(this.settings.getTsPwrUpperLimit(), this.getContextId(), "GsmScreen.tsPwrLimHigh"), new ActuatorEditor(this.settings.getTsPwrLowerLimit(), this.getContextId(), "GsmScreen.tsPwrLimLow")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createIqOffsetLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.IQ_Offset_n_Limits, this.getContextString("iqOffsetLimits"), new Menu(Text.IQ_Offset, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(3), this.getContextId(), "GsmScreen.iqOffsetLimState"), new ActuatorEditor(this.settings.getIqOffsetUpperLimit(), this.getContextId(), "GsmScreen.iqOffsetHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createRmsPhaseErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.RMS_Ph_Err_n_Limits, this.getContextString("rmsPhaseErrorLimits"), new Menu(Text.RMS_Ph_Err, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(4), this.getContextId(), "GsmScreen.rmsPhaseErrorLimitState"), new ActuatorEditor(this.settings.getRmsPhErrUpperLimit(), this.getContextId(), "GsmScreen.rmsPhErrHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createPeakPhaseErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Peak_Ph_Err_n_Limits, this.getContextString("peakPhaseErrorLimits"), new Menu(Text.Peak_Ph_Err, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(5), this.getContextId(), "GsmScreen.peakPhaseErrorLimitState"), new ActuatorEditor(this.settings.getPeakPhErrUpperLimit(), this.getContextId(), "GsmScreen.peakPhErrHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createRmsEvmErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.RMS_EVM_n_Limits, this.getContextString("rmsEvmLimits"), new Menu(Text.RMS_EVM, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(6), this.getContextId(), "GsmScreen.rmsEvmLimitState"), new ActuatorEditor(this.settings.getRmsEvmUpperLimit(), this.getContextId(), "GsmScreen.rmsEvmHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createPeakEvmErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Peak_EVM_n_Limits, this.getContextString("peakEvmLimits"), new Menu(Text.Peak_EVM, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(7), this.getContextId(), "GsmScreen.peakEvmLimitState"), new ActuatorEditor(this.settings.getPeakEvmUpperLimit(), this.getContextId(), "GsmScreen.peakEvmHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem create95tileEvmErrorLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text._95pctTile_n_EVM_Limits, this.getContextString("pctTileEvmLimits"), new Menu(Text._95_pct_tile_EVM, new MenuItem[]{new MultiStateActuatorButton(this.settings.limitsToggleAt(8), this.getContextId(), "GsmScreen.pctTileEvmLimitState"), new ActuatorEditor(this.settings.getPctTileEvmUpperLimit(), this.getContextId(), "GsmScreen.pctTileHighLim")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createAutoModeBarCountButton() {
        return new ActuatorEditor(this.settings.getAutoChCount(), this.getContextString("gsm.autoModeBarCount"), "GsmScreen.barCountButton");
    }

    private void setRangeEnabled(boolean bl, MenuItem menuItem, MenuItem menuItem2, MenuItem menuItem3, MenuItem menuItem4) {
        menuItem.setEnabled(!bl);
        menuItem2.setEnabled(bl);
        menuItem3.setEnabled(bl);
        menuItem4.setEnabled(bl);
    }

    private MenuButton createLevelMenuButton() {
        GsmMeasurementSettings gsmMeasurementSettings = GsmMeasurementSettings.instance();
        MenuButton menuButton = new LevelButtonFactory(this.scn, this.analyzer, gsmMeasurementSettings.getRefLevel(), gsmMeasurementSettings.getScaleDiv(), true).createMinimalLevelMenu();
        menuButton.addMenuItem(6, MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), gsmMeasurementSettings.getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), "GsmScreen.RfInLossButton"));
        return menuButton;
    }

    protected ActuatorEditor createPositionButton() {
        return new ActuatorEditor(this.settings.getDecodeCf(), this.getContextString("position"), "GsmScreen.decodeCfButton");
    }

    protected MultiStateActuatorButton createBarTopButton() {
        return new MultiStateActuatorButton(this.settings.getBarTop(), this.getContextString("barTop"), "GsmScreen.barTopButton");
    }

    protected MultiStateActuatorButton createDbmWattsUnitsButton() {
        return new MultiStateActuatorButton(this.settings.getdBmWattsUnits(), this.getContextString("units"), "GsmScreen.dBmWattsUnitsButton");
    }

    protected MultiStateActuatorButton createAutoOrderButton() {
        if (this.autoOrderButton == null) {
            this.autoOrderButton = new MultiStateActuatorButton(GsmMeasurementSettings.instance().getAutoOrder(), this.getContextString("autoOrder"), "GsmScreen.autoOrderButton");
            this.autoOrderButton.setEnabled(this.scanMode.intValue() == 1);
        }
        return this.autoOrderButton;
    }

    protected MultiStateActuatorButton createMidBarButton() {
        if (this.midBarButton == null) {
            this.midBarButton = new MultiStateActuatorButton(GsmMeasurementSettings.instance().getMidBar(), this.getContextString("midBar"), "GsmScreen.midBarButton");
            this.midBarButton.setEnabled(this.scanMode.intValue() != 0);
        }
        return this.midBarButton;
    }

    protected MenuItem createSlotSyncButton() {
        return new ActuatorSubMenuButton(this.settings.getSlotSync(), this.getContextString("slotSync"), true, this.getListenerBaseName() + ".slotSync");
    }

    protected ActuatorEditor createSpecificTSButton() {
        LongActuator longActuator = this.settings.getSpecficTS();
        ActuatorEditor actuatorEditor = new ActuatorEditor(longActuator, this.getContextString("specificTS"), ".specificTS");
        return actuatorEditor;
    }

    protected MenuItem createViewTypeButton() {
        return new ActuatorSubMenuButton(this.settings.getViewType(), this.getContextString("viewType"), true, this.getListenerBaseName() + ".viewType");
    }

    protected MultiStateActuatorButton createZoomTypeButton() {
        this.zoomType = GsmMeasurementSettings.instance().getZoomType();
        this.zoomTypeButton = new MultiStateActuatorButton(this.zoomType, this.getContextString("zoomType"), ".zoomTypeButton");
        return this.zoomTypeButton;
    }

    protected ActuatorEditor createZoomOffsetButton() {
        return new ActuatorEditor(this.settings.getZoomOffset(), this.getContextString("zoomOffset"), ".zoomOffset");
    }

    protected ActuatorEditor createZoomOffsetRFButton() {
        return new ActuatorEditor(this.settings.getZoomOffsetRF(), this.getContextString("zoomOffsetRF"), ".zoomOffsetRF");
    }

    protected ActuatorEditor createZoomIntervalButton() {
        return new ActuatorEditor(this.settings.getZoomInterval(), this.getContextString("zoomInterval"), ".zoomInterval");
    }

    protected MultiStateActuatorButton createPvtMaskButton() {
        return new MultiStateActuatorButton(GsmMeasurementSettings.instance().getPvtMask(), this.getContextString("pvtMask"), ".pvtMaskButton");
    }

    public void prolog() {
        this.installDisplayButtons();
        this.setMarkerMenu();
        GsmMeasurementSettings.instance().getViewType().addValueListener(this.viewTypeValueListener);
        GsmMeasurementSettings.instance().getZoomType().addValueListener(this.zoomTypeValueListener);
    }

    public void cleanup() {
        this.removeValueListener();
        super.cleanup();
        if (this.spectrumMarkerButtonFactory != null && !this.spectrumMarkerButtonFactory.equals(this.getMarkerButtonFactory())) {
            this.spectrumMarkerButtonFactory.dispose();
            this.spectrumMarkerButtonFactory = null;
        }
        if (this.pvtMarkerButtonFactory != null && !this.pvtMarkerButtonFactory.equals(this.getMarkerButtonFactory())) {
            this.pvtMarkerButtonFactory.dispose();
            this.pvtMarkerButtonFactory = null;
        }
        this.spectrumMarkerSettingsFactory.dispose();
        this.spectrumMarkerSettingsFactory = null;
        this.pvtMarkerSettingsFactory.dispose();
        this.pvtMarkerSettingsFactory = null;
        this.settings = null;
        this.analyzer = null;
    }

    void removeValueListener() {
        if (this.scanTypeValueListener != null) {
            this.scanMode.removeValueListener(this.scanTypeValueListener);
            this.scanTypeValueListener = null;
        }
        if (this.viewTypeValueListener != null) {
            this.settings.getViewType().removeValueListener(this.viewTypeValueListener);
            this.viewTypeValueListener = null;
        }
        if (this.zoomTypeValueListener != null) {
            this.settings.getZoomType().removeValueListener(this.zoomTypeValueListener);
            this.zoomTypeValueListener = null;
        }
        if (this.startFreqModeValueListener != null) {
            this.startFreqMode.removeValueListener(this.startFreqModeValueListener);
            this.startFreqModeValueListener = null;
        }
        if (this.startFreqChanValueListener != null) {
            this.startFreqChan.removeValueListener(this.startFreqChanValueListener);
            this.startFreqChanValueListener = null;
        }
    }

    protected Menu createDisplayMenu() {
        return new Menu(Text.Display, new MenuItem[]{this.createViewTypeButton(), this.createPositionButton(), this.autoOrderButton, this.barTopMenuButton, this.midBarButton, this.dBmWattsMenuButton, null});
    }

    protected Menu createFreqChanMenu() {
        return new Menu(Text.Freq_slash_Chan, new MenuItem[]{this.createScanModeButton(this.freqchanListButton, this.startFrequencyButton, this.stepSizeButton, this.stopFrequencyButton), this.freqchanListButton, this.startFrequencyButton, this.stepSizeButton, this.stopFrequencyButton, this.createChanStdSelectButton(), this.createUnitsButton()});
    }

    protected MenuButton createMarkerButton() {
        this.setMarkerMenu();
        return this.mkrMenuButton;
    }

    private void setMarkerMenu() {
        this.leftMenu.setMenuItem(null, 6);
        switch (this.settings.getViewType().intValue()) {
            case 2: {
                this.mkrMenuButton = this.markerMenu_spectrum;
                break;
            }
            case 1: {
                this.mkrMenuButton = this.markerMenu_pvt;
                break;
            }
            default: {
                this.mkrMenuButton = this.markerMenu_empty;
            }
        }
        this.leftMenu.setMenuItem(this.mkrMenuButton, 6);
        ((GsmScreen)this.scn).setMarkerButtonFactory();
        this.scn.getScreenManager().getLeftMenuPanel().repaint();
    }

    private void createSpectrumMarkerButtonFactory() {
        FrequencyActuator frequencyActuator = FrequencyActuator.createKilohertz("", "", "");
        if (this.spectrumMarkerButtonFactory == null) {
            if (this.spectrumMarkerSettingsFactory == null) {
                this.spectrumMarkerSettingsFactory = MarkerSettingsFactory.instance();
            }
            this.spectrumMarkerButtonFactory = new GsmMarkerButtonFactory((MeasurementScreen)this.scn, null, null, frequencyActuator, true, this.settings.getSpectrumMarkerTraceValues(), this.spectrumMarkerSettingsFactory, ".view2");
        }
    }

    private void createPvtMarkerButtonFactory() {
        LongActuator longActuator = LongActuator.createDecimal("", "", "", "\u00b5s", 1000);
        longActuator.setUnitsFactory(new TimeUnits());
        if (this.pvtMarkerButtonFactory == null) {
            if (this.pvtMarkerSettingsFactory == null) {
                this.pvtMarkerSettingsFactory = MarkerSettingsFactory.instance();
            }
            this.pvtMarkerButtonFactory = new GsmMarkerButtonFactory((MeasurementScreen)this.scn, null, null, longActuator, true, this.settings.getPvtMarkerTraceValues(), this.pvtMarkerSettingsFactory, ".view1");
        }
    }

    public GsmMarkerButtonFactory getMarkerButtonFactory() {
        switch (this.settings.getViewType().intValue()) {
            case 2: {
                return this.spectrumMarkerButtonFactory;
            }
            case 1: {
                return this.pvtMarkerButtonFactory;
            }
        }
        return null;
    }

    void installDisplayButtons() {
        int n = this.settings.getViewType().intValue();
        int n2 = this.settings.getZoomType().intValue();
        switch (n) {
            case 0: {
                this.displayMenu.setMenuItem(this.autoOrderButton, 2);
                this.displayMenu.setMenuItem(this.barTopMenuButton, 3);
                this.displayMenu.setMenuItem(this.midBarButton, 4);
                this.displayMenu.setMenuItem(this.dBmWattsMenuButton, 5);
                break;
            }
            case 1: {
                this.displayMenu.setMenuItem(this.zoomTypeButton, 2);
                if (n2 == 0) {
                    this.displayMenu.setMenuItem(this.zoomOffsetButton, 3);
                    this.zoomIntervalButton.setEnabled(true);
                } else {
                    this.displayMenu.setMenuItem(this.zoomOffsetRFButton, 3);
                    this.zoomIntervalButton.setEnabled(false);
                }
                this.displayMenu.setMenuItem(this.zoomIntervalButton, 4);
                this.displayMenu.setMenuItem(this.pvtMaskButton, 5);
                break;
            }
            case 2: {
                this.displayMenu.setMenuItem(null, 2);
                this.displayMenu.setMenuItem(null, 3);
                this.displayMenu.setMenuItem(null, 4);
                this.displayMenu.setMenuItem(null, 5);
                break;
            }
            default: {
                logger.error("Unknown viewType value " + n);
            }
        }
        this.scn.getScreenManager().getRightMenuPanel().repaint();
    }

    protected String getLeftMenuTitle() {
        boolean bl = MeasurementFactory.instance().optionAvailable("edgeAn");
        if (bl) {
            return Text.GSM_Bracket_w_slash_EDGE;
        }
        return Text.GSM;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ZoomTypeValueListener
    implements ValueListener {
        private String listenerName = ".zoomTypeValueListener";
        private String baseName = null;
        private GsmMenuMgr menuMgr;

        public ZoomTypeValueListener(GsmMenuMgr gsmMenuMgr) {
            this.menuMgr = gsmMenuMgr;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.menuMgr.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.menuMgr.installDisplayButtons();
        }
    }

    private static class ViewTypeValueListener
    implements ValueListener {
        private String listenerName = ".viewTypeValueListener";
        private String baseName = null;
        private GsmMenuMgr menuMgr;

        public ViewTypeValueListener(GsmMenuMgr gsmMenuMgr) {
            this.menuMgr = gsmMenuMgr;
        }

        public String getListenerName() {
            if (this.baseName == null) {
                this.baseName = this.menuMgr.getListenerBaseName();
                this.listenerName = this.baseName + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.menuMgr.displayMenu.setMenuItem(null, 2);
            this.menuMgr.displayMenu.setMenuItem(null, 3);
            this.menuMgr.displayMenu.setMenuItem(null, 4);
            this.menuMgr.displayMenu.setMenuItem(null, 5);
            this.menuMgr.installDisplayButtons();
            this.menuMgr.setMarkerMenu();
        }
    }

    static class FrequencyListPersistor
    implements ItemSelectionListener {
        FrequencyListPersistor() {
        }

        public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
            EListModel eListModel = itemSelectionEvent.getModel();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < eListModel.size(); ++i) {
                long l = ((ValueInterface)eListModel.getItem(i)).longValue();
                if (l == 0L) continue;
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                long l2 = l / 1000L;
                stringBuffer.append(l2);
            }
            String string = stringBuffer.toString();
            StringActuator stringActuator = GsmMeasurementSettings.instance().getChannelList();
            stringActuator.setValue(string);
            stringActuator.send();
        }
    }

    class FrequencyListModelGetter
    implements ListButton.ModelGetter {
        FrequencyListModelGetter() {
        }

        public EListModel getModel() {
            Vector vector = this.parseFrequencies(GsmMenuMgr.this.settings.getChannelList().toString());
            return new VectorEListModel(vector);
        }

        private Vector parseFrequencies(String string) {
            Vector<FrequencyActuator> vector = new Vector<FrequencyActuator>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    FrequencyActuator frequencyActuator = (FrequencyActuator)((GsmScreen)GsmMenuMgr.this.scn).createNewItem();
                    frequencyActuator.setValue(new Long(string2) * 1000L);
                    vector.addElement(frequencyActuator);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error("Invalid frequency list token: '" + string2 + "'", numberFormatException);
                }
            }
            return vector;
        }
    }
}

