/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.MetricsTable;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.LabelOnlyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.measurement.gsm.GsmAnalyzer;
import elgato.measurement.gsm.GsmMeasurement;
import elgato.measurement.gsm.GsmMeasurementSettings;
import java.awt.Color;
import java.awt.Font;

class GsmMetrics
extends BasicMeasurementMetrics {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$gsm$GsmMetrics == null ? (class$elgato$measurement$gsm$GsmMetrics = GsmMetrics.class$("elgato.measurement.gsm.GsmMetrics")) : class$elgato$measurement$gsm$GsmMetrics);
    private GsmAnalyzer analyzer;
    static final NumberFieldStrategy dB = new FixedPointNumberFieldStrategy(1, "dB");
    static final NumberFieldStrategy dBm = new DecibelStrategy(1, true);
    static final NumberFieldStrategy watts = DbmUnitsFactory.getDBToWattStrategy();
    static final NumberFieldStrategy degree = new FixedPointNumberFieldStrategy(2, "\u00b0");
    static final NumberFieldStrategy plainNum = new NumberFieldStrategy();
    static final NumberFieldStrategy freq = new FrequencyStrategy();
    static final NumberFieldStrategy freqMilliHertz = FrequencyStrategy.createMillihertzFrequencyStrategy();
    static final FrequencyStrategy freqMaxDec = FrequencyStrategy.createWithMaxDecimalPlaces(3);
    static final NumberFieldStrategy percentage = new FixedPointNumberFieldStrategy(2, "%");
    static final LabelOnlyStrategy numText = new LabelOnlyStrategy();
    static final Color darkGreen = new Color(0, 160, 0);
    static final Color darkRed = new Color(255, 40, 32);
    private int metricsIndex;
    private long decodeCf;
    private int decodeCfChangedFromWhom;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmMetrics;

    public GsmMetrics(GsmAnalyzer gsmAnalyzer) {
        this.analyzer = gsmAnalyzer;
        Font font = new Font("SansSerif", 1, 12);
        MetricsTable[] metricsTableArray = this.getMetricsTables();
        for (int i = 0; i < metricsTableArray.length; ++i) {
            MetricsTable metricsTable = metricsTableArray[i];
            metricsTable.setMetricsFont(font);
        }
    }

    public void dispose() {
        this.analyzer = null;
    }

    public void setMetricsIndex(int n) {
        this.metricsIndex = n;
    }

    protected ValueSource[][] createValueSources() {
        return new ValueSource[][]{{new FrequencyValueSource(Text.Freq, freq), this.createFreqErrorValueSource(), new IntegerValueSource(Text.BSIC, plainNum, GsmMeasurement.BSIC_ARR), new TSCValueSource(Text.TSC, numText, GsmMeasurement.TSC_ARR), new ModTypeValueSource(Text.Mod_Type, numText, GsmMeasurement.TSC_ARR)}, {new PowerValueSource(Text.TS_Pwr, dBm), new PowerValueSource(Text.TS_Pwr, watts), this.createChObwValueSource(), this.createIqOffsetValueSource()}, {this.createRmsPhErrValueSource(), this.createPeakPhErrValueSource(), this.createRmsEvmValueSource(), this.createPeakEvmValueSource(), this.createPctTileEvmValueSource()}};
    }

    protected int getBarLeftMargin() {
        return 3;
    }

    protected int getBarRightMargin() {
        return 2;
    }

    public void docodeCfChanged(int n, long l) {
        this.decodeCfChangedFromWhom = n;
        this.decodeCf = l;
    }

    private ValueSource createFreqErrorValueSource() {
        return new ArrayReadingValueSource(Text.Freq_Err, freqMilliHertz, GsmMeasurement.CHANNEL_FREQ_ERR_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(1)) {
                    return GsmMetrics.this.analyzer.isFreqErrorWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(1), GsmMetrics.this.analyzer.isFreqErrorWithinLimits());
            }
        };
    }

    private ValueSource createChObwValueSource() {
        return new TwoLabelArrayReadingValueSource(Text.Ch_Obw, Text.Obw, freqMaxDec, GsmMeasurement.OBW_ARR){

            protected boolean useShortLabel() {
                return GsmMetrics.this.analyzer.isLimitOn(2);
            }
        };
    }

    private ValueSource createIqOffsetValueSource() {
        return new ArrayReadingValueSource(Text.IQ_Offset, dB, GsmMeasurement.IQ_OFFSET_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(3)) {
                    return GsmMetrics.this.analyzer.isIqOffsetWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(3), GsmMetrics.this.analyzer.isIqOffsetWithinLimits());
            }
        };
    }

    private ValueSource createRmsPhErrValueSource() {
        return new ArrayReadingValueSource(Text.RMS_Ph_Err, degree, GsmMeasurement.RMS_PHASE_ERR_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(4)) {
                    return GsmMetrics.this.analyzer.isRmsPhErrWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(4), GsmMetrics.this.analyzer.isRmsPhErrWithinLimits());
            }
        };
    }

    private ValueSource createPeakPhErrValueSource() {
        return new ArrayReadingValueSource(Text.Pk_Ph_Err, degree, GsmMeasurement.PEAK_PHASE_ERR_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(5)) {
                    return GsmMetrics.this.analyzer.isPeakPhErrWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(5), GsmMetrics.this.analyzer.isPeakPhErrWithinLimits());
            }
        };
    }

    private ValueSource createRmsEvmValueSource() {
        return new ArrayReadingValueSource(Text.RMS_EVM, percentage, GsmMeasurement.RMS_EVM_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(6)) {
                    return GsmMetrics.this.analyzer.isRmsEvmWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(6), GsmMetrics.this.analyzer.isRmsEvmWithinLimits());
            }
        };
    }

    private ValueSource createPeakEvmValueSource() {
        return new ArrayReadingValueSource(Text.Pk_EVM, percentage, GsmMeasurement.PEAK_EVM_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(7)) {
                    return GsmMetrics.this.analyzer.isPeakEvmWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(7), GsmMetrics.this.analyzer.isPeakEvmWithinLimits());
            }
        };
    }

    private ValueSource createPctTileEvmValueSource() {
        return new ArrayReadingValueSource(Text._95_pct_tile_EVM, percentage, GsmMeasurement.PCTTILE_EVM_ARR){

            public Color getValueColor() {
                if (GsmMetrics.this.analyzer.isLimitOn(8)) {
                    return GsmMetrics.this.analyzer.isPctTileEvmWithinLimits() ? MeasurementMetrics.DARK_GREEN : Color.red;
                }
                return super.getValueColor();
            }

            protected String getFormattedUnits() {
                return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(8), GsmMetrics.this.analyzer.isPctTileEvmWithinLimits());
            }
        };
    }

    private String getPassFailText(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? " (P)" : " (F)";
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ModTypeValueSource
    extends ValueSource {
        private final int arrayReadingId;

        public ModTypeValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.arrayReadingId = n;
        }

        protected long getRawValue() {
            if (GsmMetrics.this.metricsIndex == -1 || GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1 && GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                return Integer.MIN_VALUE;
            }
            if (((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTypeOfChannelScan() == 0) {
                int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, 0);
                if (n == -1) {
                    n = Integer.MIN_VALUE;
                }
                return n;
            }
            int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig);
            if (n == -1) {
                n = Integer.MIN_VALUE;
            }
            return n;
        }

        public void compute(boolean bl) {
            long l = this.getRawValue();
            int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig);
            this.isMeasurementValid = bl;
            boolean bl2 = this.validValue = !this.isInvalidValue(l);
            if (bl && this.validValue) {
                if (n > 15) {
                    this.result[0] = Text._8PSK;
                    this.result[1] = Text.EDGE_Bracket;
                } else {
                    this.result[0] = Text.GMSK;
                    this.result[1] = Text.GSM_Bracket;
                }
            } else {
                this.dashMetric();
            }
        }
    }

    private class TSCValueSource
    extends ValueSource {
        private final int arrayReadingId;

        public TSCValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.arrayReadingId = n;
        }

        protected long getRawValue() {
            if (GsmMetrics.this.metricsIndex == -1 || GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1 && GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                return Integer.MIN_VALUE;
            }
            if (((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTypeOfChannelScan() == 0) {
                int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, 0);
                if (n == -1) {
                    n = Integer.MIN_VALUE;
                }
                return n;
            }
            int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig);
            if (n == -1) {
                n = Integer.MIN_VALUE;
            }
            return n;
        }

        public void compute(boolean bl) {
            long l = this.getRawValue();
            this.isMeasurementValid = bl;
            boolean bl2 = this.validValue = !this.isInvalidValue(l);
            if (bl && this.validValue) {
                if (l >= 8L && l < 16L) {
                    this.result[0] = Text.n_slash_a;
                    this.result[1] = Text.LeftBanana_Sync_RighBanana;
                }
                if (l >= 16L) {
                    String string;
                    this.result[0] = string = Long.toString(l -= 16L);
                    this.result[1] = "";
                } else if (l < 8L) {
                    String string;
                    this.result[0] = string = Long.toString(l);
                    this.result[1] = "";
                }
            } else {
                this.dashMetric();
            }
        }
    }

    private class PowerValueSource
    extends ValueSource {
        public PowerValueSource(String string, NumberFieldStrategy numberFieldStrategy) {
            super(string, numberFieldStrategy, true);
        }

        protected long getRawValue() {
            if (GsmMetrics.this.metricsIndex == -1 || GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.metricsIndex < 0 || GsmMetrics.this.metricsIndex >= ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTraceLength()) {
                logger.warn("ArrayReadingPowerValueSource(): metricsIndex = " + GsmMetrics.this.metricsIndex);
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1 && GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                return Integer.MIN_VALUE;
            }
            if (((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTypeOfChannelScan() == 0) {
                return ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getPkTsPwrArr()[0];
            }
            int n = ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig;
            return ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getPkTsPwrArr()[n];
        }

        public Color getValueColor() {
            if (GsmMeasurementSettings.instance().limitsToggleAt(2).booleanValue()) {
                if (this.isMeasurementValid() && this.isValueValid()) {
                    int n = GsmMeasurementSettings.instance().getTsPwrUpperLimit().intValue();
                    int n2 = GsmMeasurementSettings.instance().getTsPwrLowerLimit().intValue();
                    int n3 = ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig;
                    int n4 = ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getPkTsPwrArr()[n3];
                    if (n4 < n2 || n4 > n) {
                        return darkRed;
                    }
                    return darkGreen;
                }
                return ValueSource.DARK_BLUE;
            }
            return super.getValueColor();
        }

        protected String getFormattedUnits() {
            return super.getFormattedUnits() + GsmMetrics.this.getPassFailText(GsmMetrics.this.analyzer.isLimitOn(2), GsmMetrics.this.analyzer.isTsPwrWithinLimits());
        }
    }

    private class IntegerValueSource
    extends ValueSource {
        private final int arrayReadingId;

        public IntegerValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.arrayReadingId = n;
        }

        protected long getRawValue() {
            if (GsmMetrics.this.metricsIndex == -1 || GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1 && GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                return Integer.MIN_VALUE;
            }
            if (((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTypeOfChannelScan() == 0) {
                int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, 0);
                if (n == -1) {
                    n = Integer.MIN_VALUE;
                }
                return n;
            }
            int n = GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig);
            if (n == -1) {
                n = Integer.MIN_VALUE;
            }
            return n;
        }
    }

    private class ArrayReadingValueSource
    extends ValueSource {
        private final int arrayReadingId;

        public ArrayReadingValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.arrayReadingId = n;
        }

        protected long getRawValue() {
            if (GsmMetrics.this.metricsIndex == -1 || GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1 && GsmMeasurementSettings.instance().getScanMode().intValue() == 0) {
                return Integer.MIN_VALUE;
            }
            if (((GsmMeasurement)GsmMetrics.this.getMeasurement()).getTypeOfChannelScan() == 0) {
                return GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, 0);
            }
            return GsmMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, ((GsmMeasurement)GsmMetrics.this.getMeasurement()).getXYContainers()[((GsmMetrics)GsmMetrics.this).metricsIndex].xIndexOrig);
        }
    }

    protected class TwoLabelArrayReadingValueSource
    extends ArrayReadingValueSource {
        private String shortLabel;

        public TwoLabelArrayReadingValueSource(String string, String string2, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, n);
            this.shortLabel = string2;
        }

        public String getLabel() {
            if (this.useShortLabel()) {
                return this.shortLabel;
            }
            return super.getLabel();
        }

        protected boolean useShortLabel() {
            return true;
        }
    }

    private class FrequencyValueSource
    extends ValueSource {
        public FrequencyValueSource(String string, NumberFieldStrategy numberFieldStrategy) {
            super(string, numberFieldStrategy, true);
        }

        protected long getRawValue() {
            if (GsmMetrics.this.getMeasurement() == null) {
                return Integer.MIN_VALUE;
            }
            if (GsmMetrics.this.decodeCfChangedFromWhom == 1) {
                return GsmMetrics.this.decodeCf;
            }
            return (long)((GsmMeasurement)GsmMetrics.this.getMeasurement()).getDecodeCentFreq() * 1000L;
        }
    }
}

