/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.gsm;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.NewItemCreator;
import elgato.infrastructure.units.PrefixedUnitsConversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.measurement.gsm.GsmAnalyzer;
import elgato.measurement.gsm.GsmMeasurementSettings;
import elgato.measurement.gsm.GsmMenuMgr;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;

public class GsmScreen
extends MeasurementScreen
implements NewItemCreator {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$gsm$GsmScreen == null ? (class$elgato$measurement$gsm$GsmScreen = GsmScreen.class$("elgato.measurement.gsm.GsmScreen")) : class$elgato$measurement$gsm$GsmScreen);
    static final BandSelector BAND_SELECTOR = GsmMeasurementSettings.instance().getBandSelector();
    protected GsmAnalyzer analyzer;
    protected GsmMenuMgr menuMgr;
    MultiStateActuatorButton measTimeButton;
    MenuItem thresholdLevelButton;
    protected MenuButton setupButton;
    protected MenuButton levelMenuButton;
    MenuItem startFrequencyButton;
    ActuatorEditor stepSizeButton;
    MenuItem stopFrequencyButton;
    MultiStateActuatorButton scanModeButton;
    private static boolean upDownArrowEvent = false;
    private final GsmMeasurementSettings settings = GsmMeasurementSettings.instance();
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmScreen;
    static /* synthetic */ Class class$elgato$measurement$gsm$GsmMeasurement;

    protected Command[] getInitialGetCommands() {
        return new Command[0];
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.menuMgr.prolog();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        this.menuMgr.cleanup();
        this.analyzer = null;
    }

    protected void refreshMeasurementSettings() {
        this.getGsmMeasurementSettings().refresh();
    }

    protected String getMeasurementName() {
        return "gsmAn";
    }

    protected void setupAnalyzer() {
        this.analyzer = new GsmAnalyzer();
        this.createMenuMgr();
        LongActuator longActuator = new LongActuator("", "", "");
        longActuator.setConversion(new PrefixedUnitsConversion(Text.Chan));
        this.setMarkerButtonFactory();
    }

    public void setMarkerButtonFactory() {
        this.analyzer.setMarkerButtonFactory(this.menuMgr.getMarkerButtonFactory());
    }

    protected Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$gsm$GsmMeasurement == null ? (class$elgato$measurement$gsm$GsmMeasurement = GsmScreen.class$("elgato.measurement.gsm.GsmMeasurement")) : class$elgato$measurement$gsm$GsmMeasurement;
    }

    protected String getTitle() {
        return Text.GSM_Analyzer;
    }

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    protected GsmMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createGsmMenuMgr(this, this.settings, this.analyzer);
        return this.menuMgr;
    }

    public boolean isChanMode() {
        return DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().intValue() == 1;
    }

    protected GsmMeasurementSettings getGsmMeasurementSettings() {
        return GsmMeasurementSettings.instance();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        upDownArrowEvent = n == 38 || n == 40;
    }

    public static boolean isUpDownArrowEvent() {
        return upDownArrowEvent;
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        throw new RuntimeException("getTestResults() not implemented");
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public Object createNewItem() {
        Band band = Band.getCurrentBand(BAND_SELECTOR);
        long l = band.getDefaultChannel().getCenterFrequency();
        FrequencyActuator frequencyActuator = new FrequencyActuator("", "", "");
        frequencyActuator.setWebPlugConversion(WebplugConversions.createNull());
        frequencyActuator.setValue(l);
        if (this.isChanMode()) {
            frequencyActuator.configureForChannels("", BAND_SELECTOR, Value.createValue("", 1));
        }
        return frequencyActuator;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

