/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.onePortInsertionLoss;

import elgato.infrastructure.actuators.ActuatorField;
import elgato.infrastructure.analyzer.AntennaTraceAnalyzer;
import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.OnePortLossTraceChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement;
import elgato.measurement.onePortInsertionLoss.OnePortLossMeasurementSettings;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMetrics;
import java.awt.Component;

public class OnePortInsertionLossAnalyzer
extends AntennaTraceAnalyzer {
    private OnePortInsertionLossMeasurement measurement;
    private OnePortLossMeasurementSettings settings;
    private InsertionLossMetrics metrics;
    private final NumberFieldStrategy freqStrategyTraceSave = new NumberFieldStrategy("Hz");
    private final NumberFieldStrategy decibelStrategyTraceSave = new DecibelStrategy(1, false);
    private AntennaTraceAnalyzer.XStartListener xStartListener = new AntennaTraceAnalyzer.XStartListener(this);
    private AntennaTraceAnalyzer.XStopListener xStopListener = new AntennaTraceAnalyzer.XStopListener(this);

    public OnePortInsertionLossAnalyzer() {
        super(OnePortLossMeasurementSettings.instance().getRefLevel(), OnePortLossMeasurementSettings.instance().getScaleDiv(), "1PortInsLossAn");
        this.settings = OnePortLossMeasurementSettings.instance();
        this.metrics = new InsertionLossMetrics();
        this.settings.getStartFrequency().addValueListener(this.xStartListener);
        this.settings.getStopFrequency().addValueListener(this.xStopListener);
        this.settings.getLimitsToggle().addValueListener(this.limitsStateListener);
        TraceChart traceChart = this.getChart();
        traceChart.setManualXRange(false);
        this.init();
    }

    public void dispose() {
        this.settings.getStartFrequency().removeValueListener(this.xStartListener);
        this.settings.getStopFrequency().removeValueListener(this.xStopListener);
        this.settings.getLimitsToggle().removeValueListener(this.limitsStateListener);
        this.xStartListener = null;
        this.xStopListener = null;
        super.dispose();
    }

    protected AntennaTraceChart getLineChart() {
        return new OnePortLossTraceChart();
    }

    protected TraceAnalyzer.AverageDynamicLabel getAverageDynamicLabel() {
        return new TraceAnalyzer.AverageDynamicLabel(OnePortInsertionLossMeasurement.AVERAGE_TYPE, OnePortInsertionLossMeasurement.NUM_AVERAGES, OnePortInsertionLossMeasurement.AVERAGE_COUNT);
    }

    protected Component createBottomPanel() {
        return new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        TraceChart traceChart;
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        if ((traceChart = this.getChart()).isManualXRange()) {
            traceChart.setManualXRange(false);
        }
        this.measurement = (OnePortInsertionLossMeasurement)measurement;
        this.metrics.setReadingFields(this.createMyReadingFields());
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    public TabDelimitable[] createReadingFields() {
        int n;
        TabDelimitable[] tabDelimitableArray;
        OnePortInsertionLossMeasurement onePortInsertionLossMeasurement = (OnePortInsertionLossMeasurement)this.getMeasurement();
        int n2 = onePortInsertionLossMeasurement.getTrace().length;
        int n3 = 0;
        int n4 = 0;
        ReadingField[] readingFieldArray = this.createMyReadingFields();
        int n5 = readingFieldArray.length;
        ActuatorField[] actuatorFieldArray = new ActuatorField[4];
        OnePortLossMeasurementSettings onePortLossMeasurementSettings = OnePortLossMeasurementSettings.instance();
        actuatorFieldArray[0] = new ActuatorField(onePortLossMeasurementSettings.getStartFrequency());
        actuatorFieldArray[1] = new ActuatorField(onePortLossMeasurementSettings.getStopFrequency());
        actuatorFieldArray[2] = new ActuatorField(onePortLossMeasurementSettings.getCalStartFreq());
        actuatorFieldArray[3] = new ActuatorField(onePortLossMeasurementSettings.getCalStopFreq());
        int n6 = actuatorFieldArray.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            n3 = 5;
            tabDelimitableArray = new TabDelimitable[n5 + n6 + n2 + n3];
            for (n = 0; n < n5; ++n) {
                tabDelimitableArray[n4++] = readingFieldArray[n];
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            TraceSaveTabDelimitable.fillTabDelimitables(onePortInsertionLossMeasurement, "Trace", this.freqStrategyTraceSave, 1, this.decibelStrategyTraceSave, tabDelimitableArray, n4);
            n4 += onePortInsertionLossMeasurement.getTraceLength();
        } else {
            n3 = 2;
            tabDelimitableArray = new TabDelimitable[n5 + n6 + n3];
            for (n = 0; n < n5; ++n) {
                tabDelimitableArray[n4++] = readingFieldArray[n];
            }
        }
        tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("SETUP DATA");
        if (onePortInsertionLossMeasurement.isValidCalibration()) {
            for (n = 0; n < n6; ++n) {
                tabDelimitableArray[n4++] = actuatorFieldArray[n];
            }
        } else {
            n6 = 2;
            for (n = 0; n < n6; ++n) {
                tabDelimitableArray[n4++] = actuatorFieldArray[n];
            }
            String string = onePortLossMeasurementSettings.getCalStartFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string);
            string = onePortLossMeasurementSettings.getCalStopFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string);
        }
        return tabDelimitableArray;
    }

    private ReadingField[] createMyReadingFields() {
        return new ReadingField[]{new IntegerReadingField(this, "Average Insertion Loss", "dB", OnePortInsertionLossMeasurement.AVERAGE_INSERTION_LOSS, 1000.0, 2)};
    }

    protected boolean isValidCalibration(Measurement measurement) {
        return ((OnePortInsertionLossMeasurement)measurement).isValidCalibration();
    }

    protected long getSettingsXstart() {
        return OnePortLossMeasurementSettings.instance().getStartFrequency().longValue();
    }

    protected long getSettingsXstop() {
        return OnePortLossMeasurementSettings.instance().getStopFrequency().longValue();
    }

    protected String getCalibratedText() {
        return Text.Calibrated + " (" + OnePortLossMeasurementSettings.instance().getCalStartFreq().toString() + " - " + OnePortLossMeasurementSettings.instance().getCalStopFreq().toString() + ")";
    }

    protected void setLimitsState() {
        AntennaTraceChart antennaTraceChart = (AntennaTraceChart)this.getOurChart();
        antennaTraceChart.setShowLimits(this.settings.getLimitsToggle().booleanValue());
    }
}

