/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.onePortInsertionLoss;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.util.FastMath;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class OnePortInsertionLossMeasurementGenerator
extends MeasurementGenerator {
    private Random rand = new Random();
    private boolean random = true;
    private int averageType;
    private int numAverages;
    private int interferenceMode;
    private int stop;
    private int start;
    private int calMode;
    private int validCal;
    private int averageInsertionLoss;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return OnePortInsertionLossMeasurement.unpack(dataInput);
    }

    public int getNumAverages() {
        return this.numAverages;
    }

    public void setAverageInsertionLoss(int n) {
        this.averageInsertionLoss = n;
    }

    public void setAverageType(int n) {
        this.averageType = n;
    }

    public void setCalMode(int n) {
        this.calMode = n;
    }

    public void setInterferenceMode(int n) {
        this.interferenceMode = n;
    }

    public void setNumAverages(int n) {
        this.numAverages = n;
    }

    public void setRand(Random random) {
        this.rand = random;
    }

    public void setRandom(boolean bl) {
        this.random = bl;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setStop(int n) {
        this.stop = n;
    }

    public void setValidCal(int n) {
        this.validCal = n;
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < 256; ++i) {
            dataOutput.writeInt(32768 - (FastMath.sin((i / 2 - 128) * 32768 / 256) + this.nextInt(-2000, 2000)));
        }
        dataOutput.writeInt(this.getAverageInsertionLoss());
        dataOutput.writeInt(this.getValidCal());
        dataOutput.writeInt(this.getCalMode());
        dataOutput.writeInt(this.getStart());
        dataOutput.writeInt(this.getStop());
        dataOutput.writeInt(this.getAverageType());
        dataOutput.writeInt(this.getNumAverage());
        dataOutput.writeInt(this.getInterferenceMode());
        dataOutput.writeInt(this.getNumAverage());
    }

    private int getAverageType() {
        if (this.random) {
            return this.nextInt(0, 2);
        }
        return this.averageType;
    }

    private int getNumAverage() {
        if (this.random) {
            return this.nextInt(1, 40);
        }
        return this.numAverages;
    }

    private int getInterferenceMode() {
        if (this.random) {
            return this.nextInt(0, 1);
        }
        return this.interferenceMode;
    }

    private int getStop() {
        if (this.random) {
            return this.nextInt(20000, 34000);
        }
        return this.stop;
    }

    private int getStart() {
        if (this.random) {
            return this.nextInt(10000, 15000);
        }
        return this.start;
    }

    private int getCalMode() {
        if (this.random) {
            return this.nextInt(0, 5);
        }
        return this.calMode;
    }

    private int getValidCal() {
        if (this.random) {
            return this.nextInt(0, 1);
        }
        return this.validCal;
    }

    private int getAverageInsertionLoss() {
        if (this.random) {
            return this.nextInt(0, 6);
        }
        return this.averageInsertionLoss;
    }

    private int nextInt(int n, int n2) {
        int n3 = Math.abs(this.rand.nextInt()) % (n2 - n);
        return n + n3;
    }
}

