/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.onePortInsertionLoss;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.CommonLossMenuMgr;
import elgato.infrastructure.menu.ClearCalButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossAnalyzer;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossMeasurement;
import elgato.measurement.onePortInsertionLoss.OnePortInsertionLossScreen;
import elgato.measurement.onePortInsertionLoss.OnePortLossMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class OnePortInsertionLossMenuMgr
extends CommonLossMenuMgr {
    private static final int INSERTION_LOSS_UNCALIBRATED_MODE = 0;
    private MenuItem calStartFreqButton;
    private MenuItem calStopFreqButton;

    public OnePortInsertionLossMenuMgr(OnePortInsertionLossScreen onePortInsertionLossScreen, OnePortLossMeasurementSettings onePortLossMeasurementSettings, OnePortInsertionLossAnalyzer onePortInsertionLossAnalyzer) {
        super(onePortInsertionLossScreen, onePortLossMeasurementSettings, onePortInsertionLossAnalyzer);
        this.calStartFreqButton = new ActuatorEditor(onePortLossMeasurementSettings.getCalStartFreq(), "", this.getListenerBaseName() + ".calStartFreqButton");
        this.calStopFreqButton = new ActuatorEditor(onePortLossMeasurementSettings.getCalStopFreq(), "", this.getListenerBaseName() + ".calStopFreqButton");
    }

    protected Menu buildLeftMenu() {
        return new Menu(Text.One_Port_Loss, new MenuItem[]{this.createCalFreqChanButton(OnePortLossMeasurementSettings.instance(), Text.Freq_slash_n_Calibrate, Text.Freq_slash_Calibrate), this.createLevelButton(OnePortLossMeasurementSettings.instance()), null, null, this.createAverageSweepButton(OnePortLossMeasurementSettings.instance()), this.createSetupButton(OnePortLossMeasurementSettings.instance()), this.markerButtonFactory.getMenuButtonWithMinPeaks()});
    }

    public MarkerButtonFactory createMarkerButtonFactory() {
        this.markerButtonFactory = new MarkerButtonFactory((OnePortInsertionLossScreen)this.scn, null, null, OnePortLossMeasurementSettings.instance().getStartFrequency(), true);
        return this.markerButtonFactory;
    }

    protected MenuItem createCalButton() {
        return new PushButton(Text.Calibrate, this.getContextString("calibrate"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OnePortLossMeasurementSettings onePortLossMeasurementSettings = OnePortLossMeasurementSettings.instance();
                onePortLossMeasurementSettings.storeCalStartStopFreqValues();
                if (!((OnePortInsertionLossMeasurement)OnePortInsertionLossMenuMgr.this.analyzer.getMeasurement()).isValidCalibration()) {
                    onePortLossMeasurementSettings.getCalStopFreq().send(onePortLossMeasurementSettings.getStopFrequency().longValue());
                    onePortLossMeasurementSettings.getCalStartFreq().send(onePortLossMeasurementSettings.getStartFrequency().longValue());
                }
                OnePortInsertionLossMenuMgr.this.scn.getScreenManager().pushScreen(AntennaCalibrateScreen.createOnePortLoss(OnePortInsertionLossMenuMgr.this.analyzer, OnePortInsertionLossMenuMgr.this.calStartFreqButton, OnePortInsertionLossMenuMgr.this.calStopFreqButton));
            }
        });
    }

    protected ClearCalButton createClearCalButton() {
        return new ClearCalButton(Text.Clear_n_Calibration, this.getContextString("clear.calibration"), "antSpInsLoss", 0);
    }

    protected MenuItem createLimitsButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(OnePortLossMeasurementSettings.instance().getLimitsToggle(), "", "OnePortInsLoss.limOnOff");
        Menu menu = new Menu(Text.Limits, new MenuItem[]{multiStateActuatorButton, this.createUpperLimitButton(), this.createLowerLimitButton(), null, null, null, null});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), menu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createLowerLimitButton() {
        return new ActuatorEditor(OnePortLossMeasurementSettings.instance().getLowerLimit(), this.getContextString("onePortLowerLimit"), "OnePortInsLoss.lLim");
    }

    private MenuItem createUpperLimitButton() {
        return new ActuatorEditor(OnePortLossMeasurementSettings.instance().getUpperLimit(), this.getContextString("onePortUpperLimit"), "OnePortInsLoss.uLim");
    }

    protected MenuItem createSourceLevelButton() {
        return null;
    }

    protected String getMeasurementName() {
        return "antSpInsLoss";
    }
}

