/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.onePortInsertionLoss;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurementSettings;

public class OnePortLossMeasurementSettings
extends InsertionLossMeasurementSettings {
    public static final String TOPIC_ONE_PORT_INSERTIONLOSS = "antSpInsLoss";
    protected static InsertionLossMeasurementSettings instance;
    private FrequencyActuator calStartFreq;
    private FrequencyActuator calStopFreq;
    private long fStoredCalStartFreq;
    private long fStoredCalStopFreq;

    protected OnePortLossMeasurementSettings() {
        super(TOPIC_ONE_PORT_INSERTIONLOSS);
        this.createHardwareFeatureListener(this.refLevel, this.scaleDiv, TOPIC_ONE_PORT_INSERTIONLOSS);
    }

    protected void addAdditionalActuators() {
        super.addAdditionalActuators();
        this.calStartFreq = FrequencyActuator.createGlobalKilohertz(TOPIC_ONE_PORT_INSERTIONLOSS, "calStart", Text.Calibration_n_Start_Freq);
        this.calStopFreq = FrequencyActuator.createGlobalKilohertz(TOPIC_ONE_PORT_INSERTIONLOSS, "calStop", Text.Calibration_n_Stop_Freq);
        this.add(this.calStartFreq);
        this.add(this.calStopFreq);
        this.calStartFreq.setLongLabel(Text.Calibration_Start_Freq);
        this.calStopFreq.setLongLabel(Text.Calibration_Stop_Freq);
        this.setValidatorToFreqSrcLimits(this.calStartFreq, 3);
        this.setValidatorToFreqSrcLimits(this.calStopFreq, 3);
        this.calStartFreq.setValue(1850000000L);
        this.calStopFreq.setValue(1990000000L);
        PercentValueListener percentValueListener = PercentValueListener.createTenPercentValueListener(this.calStartFreq, this.calStopFreq, "antSpInsLoss.calStartStop10PctListener");
        this.calStartFreq.addValueListener(percentValueListener);
        this.calStopFreq.addValueListener(percentValueListener);
    }

    public static OnePortLossMeasurementSettings instance() {
        if (instance == null) {
            instance = new OnePortLossMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return (OnePortLossMeasurementSettings)instance;
    }

    public String getTopic() {
        return TOPIC_ONE_PORT_INSERTIONLOSS;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public FrequencyActuator getCalStartFreq() {
        return this.calStartFreq;
    }

    public FrequencyActuator getCalStopFreq() {
        return this.calStopFreq;
    }

    public void storeCalStartStopFreqValues() {
        this.fStoredCalStartFreq = this.calStartFreq.longValue();
        this.fStoredCalStopFreq = this.calStopFreq.longValue();
    }

    public void restoreCalStartStopFreqValues() {
        this.calStopFreq.send(this.fStoredCalStopFreq);
        this.calStartFreq.send(this.fStoredCalStartFreq);
    }
}

