/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.analyzer.DialPainter;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.SaveData;
import elgato.infrastructure.mainScreens.Saveable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.readings.DoubleReadingField;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.strategies.WattStrategy;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.FastMath;
import elgato.infrastructure.util.Platform;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.HydroBorderPainter;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.measurement.powerMeter.PowerMeterMeasurement;
import elgato.measurement.powerMeter.PowerMeterMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.JComponent;

public class PowerMeter
extends JComponent
implements Analyzer,
MeasurementListener,
ValueListener,
Saveable {
    private static final Resources res = Resources.getResources((class$elgato$measurement$powerMeter$PowerMeter == null ? (class$elgato$measurement$powerMeter$PowerMeter = PowerMeter.class$("elgato.measurement.powerMeter.PowerMeter")) : class$elgato$measurement$powerMeter$PowerMeter).getName());
    private static final HydroBorderPainterConfig BORDER_DIAL = res.getBorderConfig("dialBorder");
    private static final HydroBorderPainterConfig BORDER_READING = res.getBorderConfig("readingBorder");
    private static final Color COLOR_BACKGROUND = res.getColor("bgcolor");
    private static final Color COLOR_DIAL_NOLIMITS = res.getColor("dialNolimitColor");
    private static final Color COLOR_DIAL_PASS = res.getColor("dialPassColor");
    private static final Color COLOR_DIAL_FAIL = res.getColor("dialFailColor");
    private static final Color COLOR_NEEDLE = res.getColor("needleColor");
    private static final Color COLOR_NEEDLE_PEGGED = res.getColor("needleColor.pegged");
    private static final Color COLOR_TICK10 = res.getColor("tick10Color");
    private static final Color COLOR_TICK5 = res.getColor("tick5Color");
    private static final Color COLOR_TICK1 = res.getColor("tick1Color");
    private static final Color COLOR_TICK_TEXT = res.getColor("tickTextColor");
    private static final Color COLOR_READING = res.getColor("readingColor");
    private static final Color COLOR_LOSS = res.getColor("readingLossColor");
    private static final Color COLOR_CALZERO = res.getColor("calZeroColor");
    private static final Color COLOR_TITLE = res.getColor("titleColor");
    private static final int SIDE_SPACE = 46;
    private static final int TOP_SPACE = 70;
    private static final int DIAL_VISIBLE_AMOUNT = 142;
    private static final int DIAL_MINOR_RADIUS = 7;
    private static final int NEEDLE_LEN_ADD = 13;
    private static final int TICK_LENGTH_MINOR = 12;
    private static final int TICK_LENGTH_MAJOR = 18;
    private static final int CUTOUT_EXTENT = 5461;
    private static final int CALZERO_MARGIN = 16;
    private static final Font tickFont = res.getFont("tickFont");
    private static FontMetrics tickFontMetrics;
    private static final Font readingFont;
    private static FontMetrics readingFontMetrics;
    private static final Font readingUnitsFont;
    private static FontMetrics readingUnitsFontMetrics;
    private static final Font readingLossFont;
    private static FontMetrics readingLossFontMetrics;
    private static final Font calZeroFont;
    private static FontMetrics calZeroFontMetrics;
    private static final Font dialTitleFont;
    private static FontMetrics dialTitleFontMetrics;
    private static final Font dialUnitsFont;
    private static FontMetrics dialUnitsFontMetrics;
    private static final String dialTitle;
    private static final String dialUnitsAbsolute = "dBm";
    private static final String dialUnitsRelative = "dB";
    private static final NumberFieldStrategy dbStrategy;
    private NumberFieldStrategy dialReadingStrategy;
    protected static final int NA = Integer.MIN_VALUE;
    private final DialPainter dialPainter;
    private Image limitsWarningImage;
    private Image limitsWarningArrowL;
    private Image limitsWarningArrowR;
    private Image cautionImage;
    private PowerMeterMeasurementSettings settings;
    private int lowEnd = Integer.MIN_VALUE;
    private int highEnd = Integer.MIN_VALUE;
    private boolean limitEnabled = false;
    private int limitLow = Integer.MIN_VALUE;
    private int limitHigh = Integer.MIN_VALUE;
    private PowerMeterMeasurement measurement;
    private int pivotX;
    private int pivotY;
    private int dialRadius;
    private boolean dialDirty = true;
    private Image dialFace;
    private NumberFieldStrategy logPowerFormat;
    private NumberFieldStrategy linearPowerFormat;
    ReadingField[] readingFields;
    private DefaultProgressIndicator progressIndicator;
    private final String listenerBaseName = "PowerMeterAn";
    private final String listenerName = "PowerMeterAn.listener";
    private final StringBuffer drawMeterErrorBuf = new StringBuffer(60);
    private final int[] drawNeedleXs = new int[4];
    private final int[] drawNeedleYs = new int[4];
    private final int[] drawTickXs = new int[4];
    private final int[] drawTickYs = new int[4];
    private final String[] formatResult = new String[2];
    static /* synthetic */ Class class$elgato$measurement$powerMeter$PowerMeter;

    PowerMeter() {
        this.settings = PowerMeterMeasurementSettings.instance();
        this.setLayout(new BorderLayout());
        this.setBackground(COLOR_BACKGROUND);
        this.dialPainter = new DialPainter();
        this.dialPainter.setMinorRadius(7);
        this.progressIndicator = new DefaultProgressIndicator(Text.MEASUREMENT_LOADING);
        this.add((Component)this.progressIndicator, "Center");
        this.startProgressTimer();
        this.limitsWarningImage = this.getImageByKey("limitsFail.warningImage");
        this.limitsWarningArrowL = this.getImageByKey("limitsFail.warningArrowImageL");
        this.limitsWarningArrowR = this.getImageByKey("limitsFail.warningArrowImageR");
        this.cautionImage = this.getImageByKey("AttenuatorWarningCautionImage");
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.limitsWarningImage, 0);
        mediaTracker.addImage(this.limitsWarningArrowL, 1);
        mediaTracker.addImage(this.limitsWarningArrowR, 2);
        mediaTracker.addImage(this.cautionImage, 3);
        try {
            mediaTracker.waitForAll(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.settings.getLoLimit().addValueListener(this);
        this.settings.getHiLimit().addValueListener(this);
        this.settings.getLoEnd().addValueListener(this);
        this.settings.getHiEnd().addValueListener(this);
        this.settings.getRangeLimitEnabled().addValueListener(this);
        this.updateModels();
    }

    public String getListenerName() {
        return "PowerMeterAn.listener";
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.updateModels();
        this.dialDirty = true;
        this.repaint();
    }

    private Image getImageByKey(String string) {
        URL uRL = this.getClass().getResource("/" + res.getString(string));
        if (uRL == null) {
            throw new RuntimeException("Couldn't find image for key " + string);
        }
        return this.getToolkit().getImage(uRL);
    }

    private void updateModels() {
        this.lowEnd = this.settings.getLoEnd().intValue();
        this.highEnd = this.settings.getHiEnd().intValue();
        this.limitLow = this.settings.getLoLimit().intValue();
        this.limitHigh = this.settings.getHiLimit().intValue();
        this.limitEnabled = this.settings.getRangeLimitEnabled().booleanValue();
    }

    public void dispose() {
        if (this.progressIndicatorActive()) {
            this.stopProgressTimer();
        }
        this.settings.getLoLimit().removeValueListener(this);
        this.settings.getHiLimit().removeValueListener(this);
        this.settings.getLoEnd().removeValueListener(this);
        this.settings.getHiEnd().removeValueListener(this);
        this.settings.getRangeLimitEnabled().removeValueListener(this);
    }

    protected void paintComponent(Graphics graphics) {
        this.checkFontMetrics(graphics);
        Dimension dimension = this.getSize();
        if (this.measurement != null) {
            if (this.progressIndicatorActive()) {
                this.removeAll();
                this.stopProgressTimer();
            }
            this.setupPowerFormats();
            Rectangle rectangle = this.calculateUpperRectangle(dimension);
            this.drawMeter(rectangle, graphics);
            Rectangle rectangle2 = new Rectangle(0, rectangle.y + rectangle.height, dimension.width, dimension.height - rectangle.height);
            this.drawReading(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
    }

    void setupPowerFormats() {
        this.logPowerFormat = this.getLogPowerFormat();
        this.linearPowerFormat = this.getLinearPowerFormat();
    }

    private NumberFieldStrategy getLogPowerFormat() {
        if (this.measurement.isRelativeMode()) {
            return new DecibelStrategy(this.measurement.getResolution() - 1);
        }
        return new DecibelStrategy(this.measurement.getResolution() - 1, true);
    }

    private NumberFieldStrategy getLinearPowerFormat() {
        if (this.measurement.isRelativeMode()) {
            return new FixedPointNumberFieldStrategy(this.measurement.getResolution() - 1, "%");
        }
        return new WattStrategy(this.measurement.getResolution() - 1, this.measurement.getLinearPowerExp());
    }

    public boolean checkMeterInvariants(StringBuffer stringBuffer) {
        if (this.limitEnabled && this.limitLow >= this.limitHigh) {
            stringBuffer.append(Text.SCREEN_POWER_INVALID_LIMITS);
            return false;
        }
        if (this.lowEnd >= this.highEnd) {
            stringBuffer.append(Text.SCREEN_POWER_INVALID_ENDS);
            return false;
        }
        return true;
    }

    private void drawMeter(Rectangle rectangle, Graphics graphics) {
        if (!this.checkMeterInvariants(this.drawMeterErrorBuf)) {
            this.drawError(graphics, rectangle, this.drawMeterErrorBuf.toString());
            this.drawMeterErrorBuf.setLength(0);
            return;
        }
        Shape shape = graphics.getClip();
        graphics.setClip(rectangle);
        this.pivotX = rectangle.x + rectangle.width / 2;
        this.pivotY = rectangle.y + this.dialRadius + 70;
        this.drawDial(graphics, rectangle);
        graphics.setClip(shape);
    }

    private void drawError(Graphics graphics, Rectangle rectangle, String string) {
        graphics.setColor(BORDER_DIAL.getBackgroundColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.white);
        graphics.setFont(dialUnitsFont);
        graphics.drawString(string, (rectangle.width - dialUnitsFontMetrics.stringWidth(string)) / 2, rectangle.height / 2);
    }

    private Rectangle calculateUpperRectangle(Dimension dimension) {
        this.dialRadius = (dimension.width / 2 - 46 << 16) / FastMath.sin(2730);
        return new Rectangle(0, 0, dimension.width, 142 * this.dialRadius >> 8);
    }

    private void drawDial(Graphics graphics, Rectangle rectangle) {
        int n;
        this.drawDialFace(graphics, rectangle);
        this.drawCalAndZeroIndicators(graphics, rectangle);
        int n2 = this.measurement.getLogPower();
        if (this.limitEnabled) {
            n = 0;
            if (n2 < this.limitLow) {
                n = -1;
            } else if (n2 > this.limitHigh) {
                n = 1;
            }
            if (n != 0) {
                this.drawRangeFailIndicator(graphics, rectangle, n);
            }
        }
        n = n2;
        boolean bl = true;
        if (n < this.lowEnd || this.measurement.getStatusCode() == 3) {
            n = this.lowEnd;
        } else if (n > this.highEnd) {
            n = this.highEnd;
        } else {
            bl = false;
        }
        this.drawNeedle(graphics, this.valueToAngle(n), bl);
    }

    private void drawCalAndZeroIndicators(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(COLOR_CALZERO);
        graphics.setFont(calZeroFont);
        int n = rectangle.y + 16 + calZeroFontMetrics.getAscent();
        graphics.drawString(this.measurement.isValidCal() ? Text.Calibrated : Text.Uncalibrated, rectangle.x + 16, n);
        if (!this.measurement.isValidZero()) {
            String string = Text.Zero_Recommended;
            graphics.drawString(string, rectangle.x + rectangle.width - calZeroFontMetrics.stringWidth(string) - 16, n);
        }
    }

    private void drawRangeFailIndicator(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.pivotY - (this.dialRadius - this.dialRadius / 18);
        int n3 = rectangle.x + (rectangle.width - this.limitsWarningImage.getWidth(null)) / 2;
        graphics.drawImage(this.limitsWarningImage, n3, n2, this);
        if (n < 0) {
            graphics.drawImage(this.limitsWarningArrowL, n3 - this.limitsWarningArrowL.getWidth(null) - 10, n2, this);
        } else if (n > 0) {
            graphics.drawImage(this.limitsWarningArrowR, n3 + this.limitsWarningImage.getWidth(null) + 10, n2, this);
        }
    }

    private void drawDialFace(Graphics graphics, Rectangle rectangle) {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.dialFace == null || this.dialFace.getWidth(null) != rectangle.width || this.dialFace.getHeight(null) != rectangle.height;
        if (bl || this.dialDirty) {
            this.dialDirty = false;
            if (bl) {
                this.dialFace = this.createImage(rectangle.width, rectangle.height);
            }
            Graphics graphics2 = this.dialFace.getGraphics();
            HydroBorderPainter.paintBorder(graphics2, 0, 0, rectangle.width, rectangle.height, false, BORDER_DIAL);
            Platform.setAntialias(graphics2, true);
            if (!this.limitEnabled || this.limitLow == Integer.MIN_VALUE || this.limitHigh == Integer.MIN_VALUE) {
                object = new int[]{-10922, -5462};
                this.dialPainter.setArcColors(new Color[]{COLOR_DIAL_NOLIMITS});
            } else {
                object = new int[]{-10922, this.valueToAngle(this.limitLow) - 8192, this.valueToAngle(this.limitHigh) - 8192, -5462};
                this.dialPainter.setArcColors(new Color[]{COLOR_DIAL_FAIL, COLOR_DIAL_PASS, COLOR_DIAL_FAIL});
            }
            this.dialPainter.setArcAngles((int[])object);
            this.dialPainter.setCenter(this.pivotX, this.pivotY);
            this.dialPainter.setMajorRadius(this.dialRadius);
            this.dialPainter.paint(graphics2, rectangle.width, rectangle.height, this);
            this.drawTicks(graphics2);
        }
        graphics.drawImage(this.dialFace, rectangle.x, rectangle.y, null);
        int n = rectangle.width / 2;
        graphics.setColor(COLOR_TITLE);
        graphics.setFont(dialTitleFont);
        graphics.drawString(dialTitle, n - dialTitleFontMetrics.stringWidth(dialTitle) / 2, rectangle.height - 50);
        graphics.setColor(Color.white);
        graphics.setFont(dialUnitsFont);
        object = this.measurement.isRelativeMode() ? dialUnitsRelative : dialUnitsAbsolute;
        graphics.drawString((String)object, n - dialUnitsFontMetrics.stringWidth((String)object) / 2, rectangle.height - 28);
    }

    private void drawNeedle(Graphics graphics, int n, boolean bl) {
        int n2 = -this.dialRadius - 13;
        this.drawNeedleXs[0] = -1;
        this.drawNeedleYs[0] = n2;
        this.drawNeedleXs[1] = 1;
        this.drawNeedleYs[1] = n2;
        this.drawNeedleXs[2] = 6;
        this.drawNeedleYs[2] = 0;
        this.drawNeedleXs[3] = -6;
        this.drawNeedleYs[3] = 0;
        PowerMeter.rotatePoints(this.drawNeedleXs, this.drawNeedleYs, n);
        graphics.translate(this.pivotX, this.pivotY);
        graphics.setColor(bl ? COLOR_NEEDLE_PEGGED : COLOR_NEEDLE);
        graphics.fillPolygon(this.drawNeedleXs, this.drawNeedleYs, 4);
        graphics.translate(-this.pivotX, -this.pivotY);
    }

    private void drawTicks(Graphics graphics) {
        int n;
        graphics.setFont(tickFont);
        int n2 = this.highEnd - this.lowEnd;
        int n3 = FastMath.log10(n2);
        int n4 = FastMath.pow10(n3 - 1);
        int n5 = n2 / n4;
        boolean bl = true;
        boolean bl2 = false;
        if (n5 < 15) {
            n4 /= 10;
            bl = false;
        }
        int n6 = (n = n4 * 10) >= 1000 ? 0 : 3 - FastMath.log10(n);
        int n7 = n2 / n;
        if (n7 < 5) {
            bl2 = true;
            if (n < 10000) {
                ++n6;
            }
        }
        this.dialReadingStrategy = new FixedPointNumberFieldStrategy(n6);
        if (bl) {
            this.drawTicks1(graphics, false, n4, n4, 12, 1, COLOR_TICK1);
        }
        this.drawTicks1(graphics, bl2, n4 * 5, n4 * 10, 12, 2, COLOR_TICK5);
        this.drawTicks1(graphics, true, 0, n, 18, 3, COLOR_TICK10);
    }

    private void drawTicks1(Graphics graphics, boolean bl, int n, int n2, int n3, int n4, Color color) {
        int n5 = this.highEnd;
        for (int i = FastMath.ceil(this.lowEnd, n2) + n; i <= n5; i += n2) {
            this.drawTick(graphics, bl, i, n3, n4, color);
        }
    }

    private void drawTick(Graphics graphics, boolean bl, int n, int n2, int n3, Color color) {
        int n4 = -n3 / 2;
        int n5 = n3 + n4;
        int n6 = -this.dialRadius;
        n6 = bl ? (n6 += 7) : (n6 -= 7);
        int n7 = -this.dialRadius - n2;
        this.drawTickXs[0] = n4;
        this.drawTickYs[0] = n7;
        this.drawTickXs[1] = n5;
        this.drawTickYs[1] = n7;
        this.drawTickXs[2] = n5;
        this.drawTickYs[2] = n6;
        this.drawTickXs[3] = n4;
        this.drawTickYs[3] = n6;
        int n8 = this.valueToAngle(n);
        PowerMeter.rotatePoints(this.drawTickXs, this.drawTickYs, n8);
        graphics.translate(this.pivotX, this.pivotY);
        graphics.setColor(color);
        graphics.fillPolygon(this.drawTickXs, this.drawTickYs, 4);
        if (bl) {
            this.dialReadingStrategy.formatWithUnits(n, this.formatResult);
            String string = this.formatResult[0];
            Point point = new Point(0, n7 - 3);
            PowerMeter.rotatePoint(point, n8);
            graphics.setColor(COLOR_TICK_TEXT);
            graphics.drawString(string, point.x - tickFontMetrics.stringWidth(string) / 2, point.y);
        }
        graphics.translate(-this.pivotX, -this.pivotY);
    }

    final int valueToAngle(int n) {
        long l = (long)n - (long)this.lowEnd << 32;
        int n2 = this.highEnd - this.lowEnd;
        return (int)((l / (long)n2 * 5461L >> 32) - 2730L);
    }

    private void checkFontMetrics(Graphics graphics) {
        if (tickFontMetrics == null) {
            tickFontMetrics = ((Component)this).getFontMetrics(tickFont);
            readingFontMetrics = graphics.getFontMetrics(readingFont);
            readingUnitsFontMetrics = graphics.getFontMetrics(readingUnitsFont);
            readingLossFontMetrics = graphics.getFontMetrics(readingLossFont);
            calZeroFontMetrics = graphics.getFontMetrics(calZeroFont);
            dialTitleFontMetrics = graphics.getFontMetrics(dialTitleFont);
            dialUnitsFontMetrics = graphics.getFontMetrics(dialUnitsFont);
        }
    }

    private void drawReading(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 + (n4 * 10 >> 5);
        int n6 = n2 + n4 / 6;
        HydroBorderPainter.paintBorder(graphics, n, n2, n3, n4, true, BORDER_READING);
        this.drawAttenuatorWarningInReadingArea(graphics, n, n2, n3, n4);
        if (this.measurement.getStatusCode() == 3) {
            graphics.setColor(Color.red);
            String string = Text.No_Power_Sensor_Installed;
            graphics.setFont(readingUnitsFont);
            graphics.drawString(string, (n3 - readingUnitsFontMetrics.stringWidth(string)) / 2, n5);
        } else {
            graphics.setColor(COLOR_READING);
            this.logPowerFormat.formatWithUnits(this.measurement.getLogPower(), this.formatResult);
            this.draw1Reading(graphics, n + (n3 * 12 >> 5), n5, this.formatResult[0], this.formatResult[1]);
            this.formatLinearPower(this.formatResult);
            this.draw1Reading(graphics, n + (n3 * 28 >> 5), n5, this.formatResult[0], this.formatResult[1]);
        }
        int n7 = this.measurement.getOffset();
        if (n7 != 0) {
            StringBuffer stringBuffer = new StringBuffer(60);
            stringBuffer.append(Text.Power_Meter_Loss);
            stringBuffer.append(' ');
            stringBuffer.append(dbStrategy.format(n7));
            graphics.setFont(readingLossFont);
            graphics.setColor(COLOR_LOSS);
            String string = stringBuffer.toString();
            graphics.drawString(string, n + (n3 - readingLossFontMetrics.stringWidth(string)) / 2, n6);
        }
    }

    private void drawAttenuatorWarningInReadingArea(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 14;
        int n6 = 65;
        Rectangle rectangle = new Rectangle(n + n5, n2 + n4 - n6 - n5, n3 - n5 * 2, n6);
        graphics.setColor(res.getColor("AttenuatorWarningBackground"));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n7 = this.cautionImage.getHeight(null);
        int n8 = this.cautionImage.getWidth(null);
        int n9 = 20;
        int n10 = rectangle.x + n9;
        graphics.drawImage(this.cautionImage, n10, rectangle.y + (rectangle.height - n7) / 2, null);
        Font font = res.getFont("AttenuatorWarningTitleFont");
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Color color = res.getColor("AttenuatorWarningTitleColor");
        Font font2 = res.getFont("AttenuatorWarningMessageFont");
        FontMetrics fontMetrics2 = graphics.getFontMetrics(font2);
        Color color2 = res.getColor("AttenuatorWarningMessageColor");
        int n11 = fontMetrics.getHeight() + fontMetrics2.getHeight() * 2;
        int n12 = n10 + n8 + n9;
        int n13 = rectangle.y + (rectangle.height - n11) / 2 - 0;
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.drawString(Text.SCREEN_POWER_ATTENWARN_TITLE, n12, n13 += fontMetrics.getAscent());
        graphics.setFont(font2);
        graphics.setColor(color2);
        graphics.drawString(Text.SCREEN_POWER_ATTENWARN_MSG1, n12, n13 += fontMetrics2.getHeight());
        graphics.drawString(Text.SCREEN_POWER_ATTENWARN_MSG2, n12, n13 += fontMetrics2.getHeight());
    }

    void formatLinearPower(String[] stringArray) {
        int n = this.measurement.getLinearPower();
        if (this.measurement.isRelativeMode()) {
            int n2 = this.measurement.getLinearPowerExp();
            if (n2 == 0) {
                this.linearPowerFormat.formatWithUnits(n, stringArray);
            } else if (n2 == -3) {
                this.linearPowerFormat.formatWithUnits(n / 1000, stringArray);
            } else if (n2 < 0) {
                this.linearPowerFormat.formatWithUnits(1L, stringArray);
                stringArray[0] = "<" + stringArray[0];
            } else {
                this.linearPowerFormat.formatWithUnits(1000000L, stringArray);
                stringArray[0] = ">" + stringArray[0];
            }
        } else {
            this.linearPowerFormat.formatWithUnits(n, stringArray);
        }
    }

    private void draw1Reading(Graphics graphics, int n, int n2, String string, String string2) {
        graphics.setFont(readingFont);
        graphics.drawString(string, n - readingFontMetrics.stringWidth(string), n2 += readingFontMetrics.getAscent() / 2);
        graphics.setFont(readingUnitsFont);
        graphics.drawString(string2, n + readingUnitsFontMetrics.stringWidth(" "), n2);
    }

    public void measurementReceived(Measurement measurement) {
        final PowerMeterMeasurement powerMeterMeasurement = (PowerMeterMeasurement)measurement;
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                PowerMeter.this.measurement = powerMeterMeasurement;
            }
        }, "PowerMeter.measurementReceived");
        this.repaint();
    }

    static void rotatePoint(Point point, int n) {
        int n2 = point.x;
        int n3 = point.y;
        int n4 = FastMath.cos(n);
        int n5 = FastMath.sin(n);
        point.x = n4 * n2 - n5 * n3 >> 16;
        point.y = n5 * n2 + n4 * n3 >> 16;
    }

    static void rotatePoints(int[] nArray, int[] nArray2, int n) {
        int n2 = FastMath.cos(n);
        int n3 = FastMath.sin(n);
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = nArray[i];
            int n5 = nArray2[i];
            nArray[i] = n2 * n4 - n3 * n5 >> 16;
            nArray2[i] = n3 * n4 + n2 * n5 >> 16;
        }
    }

    private boolean progressIndicatorActive() {
        return this.progressIndicator != null;
    }

    private void startProgressTimer() {
        this.progressIndicator.start();
    }

    private void stopProgressTimer() {
        this.progressIndicator.stop();
        this.progressIndicator = null;
    }

    public ReadingField[] getSaveableFields() {
        PowerMeterMeasurement powerMeterMeasurement = (PowerMeterMeasurement)this.getMeasurement();
        boolean bl = powerMeterMeasurement.isRelativeMode();
        if (bl) {
            return new ReadingField[]{new IntegerReadingField(this, "Relative Power in dB", dialUnitsRelative, 0, 1000.0, 2), new MyDoubleReadingField(this, "Relative Power in %", "%", 1, 3)};
        }
        return new ReadingField[]{new IntegerReadingField(this, "Power in dBm", dialUnitsAbsolute, 0, 1000.0, 2), new DoubleReadingField(this, "Power in Watts", "Watts", 1, 3)};
    }

    public void saveData(PrintWriter printWriter) {
        SaveData.saveData(this.getSaveableFields(), printWriter, this.getMeasurement().getMeasurementTitle() + " Data");
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        readingFont = res.getFont("readingFont");
        readingUnitsFont = res.getFont("readingUnitsFont");
        readingLossFont = res.getFont("readingLossFont");
        calZeroFont = res.getFont("calZeroFont");
        dialTitleFont = res.getFont("dialTitleFont");
        dialUnitsFont = res.getFont("dialUnitsFont");
        dialTitle = Text.Power;
        dbStrategy = new DecibelStrategy(1);
    }

    static class MyDoubleReadingField
    extends DoubleReadingField {
        public MyDoubleReadingField(Analyzer analyzer, String string, String string2, int n, int n2) {
            super(analyzer, string, string2, n, n2);
        }

        public String getValue() {
            if (this.analyzer.getMeasurement() == null) {
                return "";
            }
            double d = this.analyzer.getMeasurement().getDoubleReadingValue(this.getReadingIndex());
            if (d < 0.001) {
                return "<0.001";
            }
            if (d > 1000.0) {
                return ">1000";
            }
            return this.formatValue(d, this.decimalPlace);
        }
    }
}

