/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.DoubleReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import java.io.DataInput;
import java.io.IOException;

public class PowerMeterMeasurement
implements Measurement {
    private static final long serialVersionUID = -8610619437180698168L;
    private static final boolean VERIFY = "true".equals(System.getProperty("PowerMeterMeasurement.verify"));
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$powerMeter$PowerMeterMeasurement == null ? (class$elgato$measurement$powerMeter$PowerMeterMeasurement = PowerMeterMeasurement.class$("elgato.measurement.powerMeter.PowerMeterMeasurement")) : class$elgato$measurement$powerMeter$PowerMeterMeasurement);
    private static final Queue pool = new Queue(3);
    public static final int MODE_OFF = 0;
    public static final int MODE_ON = 1;
    public static final int MODE_ZERO = 3;
    public static final int MODE_CALIBRATE = 2;
    public static final int STATUS_CODE_NO_SENSOR = 3;
    protected IntegerReading logPower = new IntegerReading();
    protected DoubleReading power = new DoubleReading();
    protected BooleanReading validCal = new BooleanReading();
    protected BooleanReading validZero = new BooleanReading();
    protected IntegerReading statusCode = new IntegerReading();
    protected BooleanReading eePromSensor = new BooleanReading();
    protected IntegerReading powerMeterMode = new IntegerReading();
    protected BooleanReading referenceSource = new BooleanReading();
    protected IntegerReading referenceCalFactor = new IntegerReading();
    protected BooleanReading relativeMode = new BooleanReading();
    protected IntegerReading setReferencePower = new IntegerReading();
    protected IntegerReading calibrationFactor = new IntegerReading();
    protected IntegerReading frequency = new IntegerReading();
    protected IntegerReading resolution = new IntegerReading();
    protected IntegerReading offset = new IntegerReading();
    protected IntegerReading lowerLimit = new IntegerReading();
    protected IntegerReading upperLimit = new IntegerReading();
    public static final int LOG_POWER = 0;
    public static final int POWER = 1;
    public static final int VALID_CAL = 2;
    public static final int VALID_ZERO = 3;
    public static final int STATUS_CODE = 4;
    public static final int EE_PROM_SENSOR = 5;
    public static final int POWER_METER_MODE = 6;
    public static final int REFERENCE_SOURCE = 7;
    public static final int REFERENCE_CAL_FACTOR = 8;
    public static final int RELATIVE_MODE = 9;
    public static final int SET_REFERENCE_POWER = 10;
    public static final int CALIBRATION_FACTOR = 11;
    public static final int FREQUENCY = 12;
    public static final int RESOLUTION = 13;
    public static final int OFFSET = 14;
    public static final int LOWER_LIMIT = 15;
    public static final int UPPER_LIMIT = 16;
    private Reading[] readings = new Reading[]{this.logPower, this.power, this.validCal, this.validZero, this.statusCode, this.eePromSensor, this.powerMeterMode, this.referenceSource, this.referenceCalFactor, this.relativeMode, this.setReferencePower, this.calibrationFactor, this.frequency, this.resolution, this.offset, this.lowerLimit, this.upperLimit};
    static /* synthetic */ Class class$elgato$measurement$powerMeter$PowerMeterMeasurement;

    public static PowerMeterMeasurement unpack(DataInput dataInput) throws IOException {
        PowerMeterMeasurement powerMeterMeasurement = PowerMeterMeasurement.create();
        Reading[] readingArray = powerMeterMeasurement.getReadings();
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        if (VERIFY) {
            powerMeterMeasurement.verify();
        }
        return powerMeterMeasurement;
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    private static PowerMeterMeasurement create() {
        PowerMeterMeasurement powerMeterMeasurement = (PowerMeterMeasurement)pool.dequeue();
        if (powerMeterMeasurement == null) {
            return new PowerMeterMeasurement();
        }
        return powerMeterMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getLogPower() {
        return this.logPower.intValue();
    }

    public int getLinearPower() {
        return this.power.getMantissa();
    }

    public int getUpperLimit() {
        return this.upperLimit.intValue();
    }

    public int getLinearPowerExp() {
        return this.power.getExponent();
    }

    public boolean isValidCal() {
        return this.validCal.booleanValue();
    }

    public boolean isValidZero() {
        return this.validZero.booleanValue();
    }

    public int getStatusCode() {
        return this.statusCode.intValue();
    }

    public boolean hasEePromSensor() {
        return this.eePromSensor.booleanValue();
    }

    public int getPowerMeterMode() {
        return this.powerMeterMode.intValue();
    }

    public boolean getReferenceSource() {
        return this.referenceSource.booleanValue();
    }

    public int getReferenceCalFactor() {
        return this.referenceCalFactor.intValue();
    }

    public boolean isRelativeMode() {
        return this.relativeMode.booleanValue();
    }

    public int getSetReferencePower() {
        return this.setReferencePower.intValue();
    }

    public int getCalibrationFactor() {
        return this.calibrationFactor.intValue();
    }

    public int getFrequency() {
        return this.frequency.intValue();
    }

    public int getResolution() {
        return this.resolution.intValue();
    }

    public int getOffset() {
        return this.offset.intValue();
    }

    public int getLowerLimit() {
        return this.lowerLimit.intValue();
    }

    boolean verify() {
        boolean bl = true;
        if (this.getLinearPowerExp() % 3 != 0) {
            bl = false;
            logger.warn("verify: invalid linear power exp: " + this.getLinearPowerExp());
        }
        return bl;
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    public long getLongReadingValue(int n) {
        throw new IllegalStateException("Power Meter measurement does not have LongReadings");
    }

    public float getFloatReadingValue(int n) {
        throw new IllegalStateException("Power Meter measurement does not have FloatReadings");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new IllegalStateException("Power Meter measurement does not have IntegerArrayReadings");
    }

    public String getMeasurementTitle() {
        return Text.Power_Meter;
    }

    public boolean hasCurrentSettings() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

