/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.util.FastMath;
import elgato.measurement.powerMeter.PowerMeterMeasurement;
import elgato.measurement.powerMeter.PowerMeterMeasurementSettings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class PowerMeterMeasurementGenerator
extends MeasurementGenerator {
    private double phase = 0.0;
    public boolean fixedData;

    public Measurement unpack(DataInput dataInput) throws IOException {
        return PowerMeterMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        PowerMeterMeasurementSettings powerMeterMeasurementSettings = PowerMeterMeasurementSettings.instance();
        this.phase = !this.fixedData ? (this.phase += 0.3141592653589793) : 1.5707963267948966;
        double d = (Math.sin(this.phase) / 2.0 + 0.5) * 55.0 - 5.0;
        double d2 = Math.pow(10.0, d / 10.0);
        float f = FastMath.float_log10((float)d2);
        int n = f < 0.0f ? -6 : (f < 3.0f ? -3 : (f < 6.0f ? 0 : (f < 9.0f ? 3 : (f < 12.0f ? 6 : 0))));
        int n2 = (int)(d2 / Math.pow(10.0, n));
        dataOutput.writeInt((int)(d * 1000.0));
        dataOutput.writeInt(n2);
        dataOutput.writeInt(n);
        dataOutput.writeInt(this.phase % 6.0 < 4.0 ? 1 : 0);
        dataOutput.writeInt(this.phase % 5.0 < 3.0 ? 1 : 0);
        dataOutput.writeInt(this.phase / 3.0 % 5.0 < 1.0 ? 3 : 6);
        dataOutput.writeInt(1);
        dataOutput.writeInt(1);
        dataOutput.writeInt(1);
        dataOutput.writeInt((int)(d2 * 1000000.0));
        dataOutput.writeInt(powerMeterMeasurementSettings.getRelMode().intValue());
        dataOutput.writeInt(0);
        dataOutput.writeInt((int)(d2 * 1000000.0));
        dataOutput.writeInt((int)(d2 * 1000000.0));
        dataOutput.writeInt(powerMeterMeasurementSettings.getResolution().intValue());
        dataOutput.writeInt(powerMeterMeasurementSettings.getPwrOffset().intValue());
        dataOutput.writeInt(powerMeterMeasurementSettings.getLoLimit().intValue());
        dataOutput.writeInt(powerMeterMeasurementSettings.getHiLimit().intValue());
    }
}

