/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.UnitsConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public class PowerMeterMeasurementSettings
extends MeasurementSettings {
    public static final String TOPIC_POWER = "pwrMeter";
    public static final String TOPIC_POWER_DISPLAY = "display.pwrMeter";
    public static final String KEY_POWER_REFCALFACTOR = "pmRefCf";
    public static final String KEY_POWER_CALFACTOR = "calFactor";
    public static final String KEY_POWER_PMMODE = "pmMode";
    public static final String KEY_POWER_REF_ENABLED = "pmRef";
    public static final String KEY_POWER_REL_MODE = "relMode";
    public static final String KEY_POWER_REL = "setRefPwr";
    public static final String KEY_POWER_PM_LOSS = "pwrOffset";
    public static final String KEY_POWER_PM_LOSS_ENABLED = "pwrOffsetEnabled";
    public static final String KEY_POWER_LIMIT_LO = "displayLPwrLim";
    public static final String KEY_POWER_LIMIT_HI = "displayUPwrLim";
    public static final String KEY_POWER_RANGE_ENABLED = "rangeEnabled";
    public static final String KEY_POWER_RANGE_LO = "rangeLo";
    public static final String KEY_POWER_RANGE_HI = "rangeHi";
    public static final String KEY_POWER_RESOLUTION = "res";
    private static PowerMeterMeasurementSettings instance;
    private LongActuator loEnd = LongActuator.createPower("display.pwrMeter", "rangeLo", Text.Low_End);
    private LongActuator hiEnd = LongActuator.createPower("display.pwrMeter", "rangeHi", Text.Hi_End);
    private LongActuator loLimit = LongActuator.createPower("display.pwrMeter", "displayLPwrLim", Text.Low_Limit, new RangeValidator(-100000L, 100000L, 1));
    private LongActuator hiLimit = LongActuator.createPower("display.pwrMeter", "displayUPwrLim", Text.Hi_Limit, new RangeValidator(-100000L, 100000L, 1));
    private LongActuator pwrLoss = LongActuator.createLoss("pwrMeter", "pwrOffset", Text.PM_Loss, 0);
    private LongActuator stashedLoss = LongActuator.createStashingLoss("display.pwrMeter", "pwrOffset", 0);
    private ListActuator lossToggle = new ListActuator("display.global", "lossToggle", Text.PM_Loss, this.createOnOffValueSet());
    private LongActuator refCF = LongActuator.createPercentActuator("pwrMeter", "pmRefCf", Text.Ref_CF, 150000, 1000);
    private LongActuator calFactor = LongActuator.createPercentActuator("pwrMeter", "calFactor", Text.Cal_Factor, 150000, 1000);
    public static final int REL_MODE_ON = 1;
    public static final int REL_MODE_OFF = 0;
    private ListActuator relMode = new ListActuator("pwrMeter", "relMode", Text.Relative, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private static final int POWER_REF_ON = 1;
    private static final int POWER_REF_OFF = 0;
    private ListActuator pmRef = new ListActuator("pwrMeter", "pmRef", Text.Power_Ref, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private static final int LIMIT_ON = 1;
    private static final int LIMIT_OFF = 0;
    private ListActuator rangeLimitEnabled = new ListActuator("display.pwrMeter", "rangeEnabled", Text.Limits, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private ListActuator resolution = new ListActuator("pwrMeter", "res", Text.Resolution, new Value[]{Value.createValue("1", 1), Value.createValue("2", 2), Value.createValue("3", 3), Value.createValue("4", 4)});

    private PowerMeterMeasurementSettings() {
        super(TOPIC_POWER);
        this.add(this.loEnd);
        this.add(this.hiEnd);
        this.add(this.loLimit);
        this.add(this.hiLimit);
        this.add(this.pwrLoss);
        this.add(this.relMode);
        this.add(this.pmRef);
        this.add(this.calFactor);
        this.add(this.refCF);
        this.add(this.resolution);
        this.add(this.rangeLimitEnabled);
        this.add(this.stashedLoss);
        this.add(this.lossToggle);
        this.makeStashedLossActuatorSet(this.lossToggle, this.pwrLoss, this.stashedLoss, "pwrMeter.pwrLoss");
        this.calFactor.addValueListener(PercentValueListener.createTenPercentValueListener(this.calFactor, "PwrMeter.calFactor"));
        this.refCF.addValueListener(PercentValueListener.createTenPercentValueListener(this.refCF, "PwrMeter.refCf"));
        this.relMode.setValue(0);
        final LongActuator[] longActuatorArray = new LongActuator[]{this.loEnd, this.hiEnd, this.loLimit, this.hiLimit};
        this.relMode.addValueListener(new ValueListener(){
            private final String listenerName = "PwrMeter.relModeListener";

            public String getListenerName() {
                return "PwrMeter.relModeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                String string = valueInterface.intValue() == 0 ? "dBm" : "dB";
                for (int i = 0; i < longActuatorArray.length; ++i) {
                    LongActuator longActuator = longActuatorArray[i];
                    ((UnitsConversion)longActuator.getConversion()).setLabel(string);
                    longActuator.fireValueChanged();
                }
            }
        });
        this.pmRef.setValue(0);
        this.refresh();
    }

    public static PowerMeterMeasurementSettings instance() {
        if (instance == null) {
            instance = new PowerMeterMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getLoEnd() {
        return this.loEnd;
    }

    public LongActuator getHiEnd() {
        return this.hiEnd;
    }

    public LongActuator getLoLimit() {
        return this.loLimit;
    }

    public LongActuator getHiLimit() {
        return this.hiLimit;
    }

    public LongActuator getPwrOffset() {
        return this.pwrLoss;
    }

    public ListActuator getRelMode() {
        return this.relMode;
    }

    public ListActuator getPmRef() {
        return this.pmRef;
    }

    public ListActuator getRangeLimitEnabled() {
        return this.rangeLimitEnabled;
    }

    public LongActuator getCalFactor() {
        return this.calFactor;
    }

    public LongActuator getRefCF() {
        return this.refCF;
    }

    public ListActuator getResolution() {
        return this.resolution;
    }

    public ListActuator getLossToggle() {
        return this.lossToggle;
    }

    public LongActuator getStashedLoss() {
        return this.stashedLoss;
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.loEnd, this.hiEnd};
    }
}

