/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.calibration.AbstractCalibrateScreen;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandTimeoutException;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.MessageScreen;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderedProgressIndicator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PowerMeterModeScreen
extends Screen {
    private int pmMode;
    private String buttonText;
    private String inProgressMessage;
    private String contextId;
    protected ScreenManager screenManager;
    PowerMeterModeButton commandButton;

    public PowerMeterModeScreen(int n, String string, String string2, String string3) {
        this.pmMode = n;
        this.buttonText = string;
        this.inProgressMessage = string2;
        this.contextId = string3;
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.screenManager = screenManager;
        ModalKeyManager modalKeyManager = new ModalKeyManager(screenManager);
        modalKeyManager.setEscapePopsScreen(false);
        GlobalKeyManager.registerInstance(modalKeyManager);
        Component component = this.makeScreen();
        screenManager.installDisplay(component);
        screenManager.installLeftMenu(this.createLeftMenu());
        screenManager.installRightMenu(this.createRightMenu());
    }

    public void uninstallScreen(ScreenManager screenManager) {
        GlobalKeyManager.makeInstance(screenManager);
        super.uninstallScreen(screenManager);
    }

    private Component makeScreen() {
        String string;
        String string2;
        String[] stringArray = new String[3];
        switch (this.pmMode) {
            case 2: {
                string2 = Text.POWER_METER_CALIBRATE_HEADING;
                stringArray[0] = Text.POWER_METER_CALIBRATE_INSTRUCTIONS_1;
                stringArray[1] = Text.POWER_METER_CALIBRATE_INSTRUCTIONS_2;
                stringArray[2] = Text.POWER_METER_CALIBRATE_INSTRUCTIONS_3;
                string = "images/power_meter_cal.png";
                break;
            }
            case 3: {
                string2 = Text.POWER_METER_ZERO_HEADING;
                stringArray[0] = Text.POWER_METER_ZERO_INSTRUCTIONS_1;
                stringArray[1] = Text.POWER_METER_ZERO_INSTRUCTIONS_2;
                stringArray[2] = Text.POWER_METER_ZERO_INSTRUCTIONS_3;
                string = "images/power_meter_zero.png";
                break;
            }
            default: {
                throw new IllegalStateException("Invalid pmMode for cal/zero: " + this.pmMode);
            }
        }
        FixedPanel fixedPanel = new FixedPanel(string, false);
        fixedPanel.addCenteredLabel(25, string2);
        fixedPanel.addLabel(50, 240, stringArray[0]);
        fixedPanel.addLabel(50, 270, stringArray[1]);
        fixedPanel.addLabel(50, 300, stringArray[2]);
        return AbstractCalibrateScreen.wrapWithCalibrateBorder(fixedPanel);
    }

    private Menu createLeftMenu() {
        return new Menu("", new MenuItem[0]);
    }

    private Menu createRightMenu() {
        return new Menu(this.buttonText, new MenuItem[]{this.createCommandButton(Text.Continue, this.contextId), null, null, null, null, null, PushButton.createPopScreenCancelButton(this.getScreenManager())});
    }

    MenuItem createCommandButton(String string, String string2) {
        this.commandButton = new PowerMeterModeButton(string, this.getContextString(string2));
        return this.commandButton;
    }

    protected void doOtherStuff() {
    }

    class PowerMeterModeButton
    extends PushButton
    implements ActionListener {
        private final int COMMAND_TIMEOUT = 90000;
        private BorderedProgressIndicator progressIndicator;

        PowerMeterModeButton(String string, String string2) {
            super(string, string2);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.progressIndicator = new BorderedProgressIndicator(new DefaultProgressIndicator(new String[]{PowerMeterModeScreen.this.inProgressMessage, Text.One_moment_please}));
            PowerMeterModeScreen.this.getScreenManager().installDisplay(this.progressIndicator);
            PowerMeterModeScreen.this.getScreenManager().getLeftMenuPanel().clear();
            PowerMeterModeScreen.this.getScreenManager().getRightMenuPanel().clear();
            Command command = Command.makeSetCommand("pwrMeter");
            command.addProperty("pmMode", Integer.toString(PowerMeterModeScreen.this.pmMode));
            Thread thread = new Thread(new Runnable(this, command){
                private final /* synthetic */ Command val$command;
                private final /* synthetic */ PowerMeterModeButton this$1;
                {
                    this.this$1 = powerMeterModeButton;
                    this.val$command = command;
                }

                public void run() {
                    PowerMeterModeButton.access$200(this.this$1, this.val$command);
                }
            });
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void perform(Command command) {
            try {
                try {
                    MeasurementFactory.instance().getCommandProcessor().call(command, "notifyEvent", 90000L);
                }
                catch (Throwable throwable) {
                    EventDispatchThread.invokeLater(new Runnable(this){
                        private final /* synthetic */ PowerMeterModeButton this$1;
                        {
                            this.this$1 = powerMeterModeButton;
                        }

                        public void run() {
                            PowerMeterModeButton.access$300(this.this$1).stop();
                            PowerMeterModeButton.access$400(this.this$1).getScreenManager().popScreen();
                            PowerMeterModeButton.access$400(this.this$1).doOtherStuff();
                        }
                    }, "PowerMeterModeScreen.PowerMeterModeButton.perform");
                    throw throwable;
                }
                EventDispatchThread.invokeLater(new /* invalid duplicate definition of identical inner class */, "PowerMeterModeScreen.PowerMeterModeButton.perform");
            }
            catch (CommandTimeoutException commandTimeoutException) {
                this.showErrorMessage();
            }
            catch (InterruptedException interruptedException) {
                this.showErrorMessage();
            }
        }

        private void showErrorMessage() {
            String string = "<html><body>" + Text.Power_Meter_Zero_Cal_Failure_1 + " " + PowerMeterModeScreen.this.buttonText + " " + Text.Power_Meter_Zero_Cal_Failure_2 + "</body></html>";
            MessageScreen messageScreen = new MessageScreen(string, true, 0);
            EventDispatchThread.invokeLater(new Runnable(this, messageScreen){
                private final /* synthetic */ MessageScreen val$messageScreen;
                private final /* synthetic */ PowerMeterModeButton this$1;
                {
                    this.this$1 = powerMeterModeButton;
                    this.val$messageScreen = messageScreen;
                }

                public void run() {
                    MeasurementFactory.instance().getScreenManager().pushScreen(this.val$messageScreen);
                }
            }, "PowerMeterModeScreen.PowerMeterModeButton.showErrorMessage");
        }

        static /* synthetic */ void access$200(PowerMeterModeButton powerMeterModeButton, Command command) {
            powerMeterModeButton.perform(command);
        }

        static /* synthetic */ BorderedProgressIndicator access$300(PowerMeterModeButton powerMeterModeButton) {
            return powerMeterModeButton.progressIndicator;
        }

        static /* synthetic */ PowerMeterModeScreen access$400(PowerMeterModeButton powerMeterModeButton) {
            return powerMeterModeButton.PowerMeterModeScreen.this;
        }
    }
}

