/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerMeter;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.ScreenButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.powerMeter.PowerMeter;
import elgato.measurement.powerMeter.PowerMeterMeasurement;
import elgato.measurement.powerMeter.PowerMeterMeasurementSettings;
import elgato.measurement.powerMeter.PowerMeterModeScreen;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PowerMeterScreen
extends MeasurementScreen {
    private static final String DISPLAY_TOPIC = "display.pwrMeter";
    PowerMeter meter;
    static /* synthetic */ Class class$elgato$measurement$powerMeter$PowerMeterMeasurement;

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        this.meter = null;
    }

    MenuItem createLimitsEnabledButton() {
        return new MultiStateActuatorButton(PowerMeterMeasurementSettings.instance().getRangeLimitEnabled(), this.getContextString("powerMeterSetup.limits"), this.getListenerBaseName() + ".limEnabledButton");
    }

    private MenuItem makeModeButton(int n, String string, String string2, String string3) {
        return ScreenButton.newPushingButton(string, new PowerMeterModeScreen(n, string, string2, string3));
    }

    public MenuItem makeZeroButton() {
        return this.makeModeButton(3, Text.Zero, Text.The_Test_Set_is_zeroing_the_power_meter, "powerMeterCalibrate.zero");
    }

    public MenuItem makeCalibrateButton() {
        return this.makeModeButton(2, Text.Calibrate, Text.The_Test_Set_is_calibrating_the_power_meter, "powerMeterCalibrate.calibrate");
    }

    MenuItem createPowerMeterLossButton(String string) {
        PowerMeterMeasurementSettings powerMeterMeasurementSettings = PowerMeterMeasurementSettings.instance();
        return MeasurementScreen.createLossButton(powerMeterMeasurementSettings.getStashedLoss(), powerMeterMeasurementSettings.getPwrOffset(), powerMeterMeasurementSettings.getLossToggle(), this.getContextString("pm.loss"), this.getListenerBaseName() + ".pmLossButton");
    }

    MenuItem createRelativeOnOffButton() {
        ListActuator listActuator = PowerMeterMeasurementSettings.instance().getRelMode();
        return new MultiStateActuatorButton(listActuator, this.getContextString("powerMeterRelativeOffset.multiStateRelative"), this.getListenerBaseName() + ".relModeButton");
    }

    MenuItem createPowerRefButton() {
        return new MultiStateActuatorButton(PowerMeterMeasurementSettings.instance().getPmRef(), this.getContextString("powerMeterCalibrate.powerRef"), this.getListenerBaseName() + ".pwrRefButton");
    }

    MenuItem makeRelButton(String string) {
        return new PushButton(Text.Set_n_Relative, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Command command = Command.makeSetCommand("pwrMeter");
                command.addProperty("setRefPwr", "1");
                MeasurementFactory.instance().getCommandProcessor().send(command);
            }
        });
    }

    MultiStateActuatorButton makeResolutionButton(String string) {
        return new MultiStateActuatorButton(PowerMeterMeasurementSettings.instance().getResolution(), this.getContextString("powerMeterResolution"), this.getListenerBaseName() + ".resolutionButton");
    }

    protected Menu buildLeftMenu() {
        return new Menu(Text.Power_Meter, new MenuItem[]{new SimpleMenuButton(Text.Zero_slash_n_Calibrate, this.getContextString("powerMeterCalibrate"), new Menu(Text.Zero_slash_Calibrate, new MenuItem[]{null, this.makeZeroButton(), this.createrefCFButton(), this.makeCalibrateButton(), this.createCalFactorButton(), null, this.createPowerRefButton()})), new SimpleMenuButton(Text.Relatve_slash_n_Loss, this.getContextString("powerMeterRelativeOffset"), new Menu(Text.Relative_slash_Loss, new MenuItem[]{this.createRelativeOnOffButton(), this.makeRelButton(this.getContextString("powerMeterRelativeOffset.relative")), null, null, null, null, this.createPowerMeterLossButton(this.getContextString("powerMeterRelativeOffset.offsetLoss"))})), null, null, null, new SimpleMenuButton(Text.Setup, this.getContextString("powerMeterSetup"), new Menu(Text.Setup, new MenuItem[]{this.makeResolutionButton(this.getContextString("powerMeterSetup.resolution")), this.createLoEndButton(), this.createHiEndButton(), this.createLimitsEnabledButton(), this.createLoLimitButton(), this.createHiLimitButton()}))});
    }

    ActuatorEditor createHiLimitButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getHiLimit(), this.getContextString("powerMeterSetup.limits"), this.getListenerBaseName() + ".hiLimitButton");
    }

    ActuatorEditor createLoLimitButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getLoLimit(), this.getContextString("powerMeterSetup.limits"), this.getListenerBaseName() + ".lowLimitButton");
    }

    ActuatorEditor createHiEndButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getHiEnd(), this.getContextString("powerMeterSetup.ends"), this.getListenerBaseName() + ".hiEndButton");
    }

    ActuatorEditor createLoEndButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getLoEnd(), this.getContextString("powerMeterSetup.ends"), this.getListenerBaseName() + ".lowEndButton");
    }

    MenuItem createCalFactorButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getCalFactor(), this.getContextString("powerMeterCalibrate.calFactor"), this.getListenerBaseName() + ".calFactorButton");
    }

    MenuItem createrefCFButton() {
        return new ActuatorEditor(PowerMeterMeasurementSettings.instance().getRefCF(), this.getContextString("powerMeterCalibrate.pmRefCf"), this.getListenerBaseName() + ".refCfButton");
    }

    protected Command[] getInitialGetCommands() {
        return new Command[]{this.createDisplayGetCommand(), this.createLocalGetCommand()};
    }

    Command createDisplayGetCommand() {
        Command command = Command.makeGetCommand(DISPLAY_TOPIC);
        command.addProperty("pwrOffsetEnabled", 0L);
        command.addProperty("rangeEnabled", 0L);
        return command;
    }

    Command createLocalGetCommand() {
        Command command = Command.makeGetCommand(this.getTopic());
        command.addProperty("res", 2L);
        command.addProperty("pmRef", 1L);
        return command;
    }

    protected String getMeasurementName() {
        return "pwrMeter";
    }

    protected void setupAnalyzer() {
        this.meter = new PowerMeter();
    }

    public PowerMeter getPowerMeter() {
        return this.meter;
    }

    protected Component getAnalyzerPanel() {
        return this.meter;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$powerMeter$PowerMeterMeasurement == null ? (class$elgato$measurement$powerMeter$PowerMeterMeasurement = PowerMeterScreen.class$("elgato.measurement.powerMeter.PowerMeterMeasurement")) : class$elgato$measurement$powerMeter$PowerMeterMeasurement;
    }

    protected void refreshMeasurementSettings() {
        PowerMeterMeasurementSettings.instance().refresh();
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        PowerMeterMeasurement powerMeterMeasurement = (PowerMeterMeasurement)this.getAnalyzer().getMeasurement();
        if (powerMeterMeasurement == null) {
            this.displayErrorMessageScreen(screenManager);
            return "";
        }
        if (string.equals("Power Sensor Verification")) {
            string = "TX RMS Power";
        }
        return MeasurementScreen.createResultLine(powerMeterMeasurement.getLogPower(), (double)PowerMeterMeasurementSettings.instance().getHiLimit().longValue() / 1000.0, (double)PowerMeterMeasurementSettings.instance().getLoLimit().longValue() / 1000.0, string, "dBm");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

