/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerSupply;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import elgato.measurement.powerSupply.PowerSupplyMonitor;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;

public class PowerSupplyIndicator
extends JComponent
implements PowerSupplyMonitor.ChangeListener,
ValueListener {
    static final Font batteryPercentFont = new Font("SansSerif", 0, 9);
    final PowerSupplyMonitor monitor = PowerSupplyMonitor.instance();
    boolean haveLicenses;
    private Vector icons = new Vector();
    private final String listenerName = "PowerSupplyIndicator.sourceListener";

    public PowerSupplyIndicator() {
        this.icons.addElement(new SourceIndicator());
        this.icons.addElement(new DcBiasTeeIndicator());
        this.icons.addElement(new ACIndicator());
        int n = 0;
        int n2 = this.monitor.getFirstBattery();
        while (n < this.monitor.getBatteryCount()) {
            this.icons.addElement(new Battery(n2));
            ++n;
            ++n2;
        }
        this.monitor.addChangeListener(this);
    }

    public void setLicenses() {
        this.haveLicenses = true;
        if (this.haveSource()) {
            this.getSourceBackgroundMode().addValueListener(this);
        }
        this.repaint();
    }

    public void stateChanged() {
        this.repaint();
    }

    public String getListenerName() {
        return "PowerSupplyIndicator.sourceListener";
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.repaint();
    }

    boolean haveSource() {
        return MeasurementFactory.instance().measurementAvailable("source");
    }

    boolean isSourceBackgroundMode() {
        return this.getSourceBackgroundMode().booleanValue();
    }

    private ListActuator getSourceBackgroundMode() {
        return SigGenMeasurementSettings.instance().getBackgroundMode();
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = dimension.width - 1;
        for (int i = this.icons.size() - 1; i >= 0; --i) {
            Icon icon = (Icon)this.icons.elementAt(i);
            if (icon instanceof VanishingIcon && !((VanishingIcon)icon).isShowing()) continue;
            icon.paintIcon(this, graphics, n -= icon.getIconWidth(), (dimension.height - icon.getIconHeight()) / 2);
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.icons.size(); ++i) {
            Icon icon = (Icon)this.icons.elementAt(i);
            n2 += icon.getIconWidth();
            n = Math.max(n, icon.getIconHeight());
        }
        return new Dimension(n2, n);
    }

    private class SourceIndicator
    extends VanishingIcon {
        public SourceIndicator() {
            super("images/SourceIcon.png");
        }

        public boolean isShowing() {
            return PowerSupplyIndicator.this.haveLicenses && PowerSupplyIndicator.this.haveSource() && PowerSupplyIndicator.this.isSourceBackgroundMode();
        }
    }

    private class DcBiasTeeIndicator
    extends VanishingIcon {
        public DcBiasTeeIndicator() {
            super("images/DcBiasTeeOn.png");
        }

        public boolean isShowing() {
            return PowerSupplyIndicator.this.monitor.isDcBiasTeeOn();
        }
    }

    private class ACIndicator
    extends VanishingIcon {
        public ACIndicator() {
            super("images/PowerPlug22.png");
        }

        public boolean isShowing() {
            return PowerSupplyIndicator.this.monitor.isOnAcPower();
        }
    }

    private abstract class VanishingIcon
    implements Icon {
        private Image image;

        public VanishingIcon(String string) {
            this.image = ImageIcon.loadImage(string, PowerSupplyIndicator.this);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.isShowing()) {
                graphics.drawImage(this.image, n, n2, null);
            }
        }

        public int getIconWidth() {
            return this.image.getWidth(null);
        }

        public int getIconHeight() {
            return this.image.getHeight(null);
        }

        public abstract boolean isShowing();
    }

    private class Battery
    implements Icon {
        static final int WIDTH = 24;
        static final int HEIGHT = 24;
        private final int batteryNumber;
        private PowerSupplyMonitor.BatteryBean batteryBean;

        public Battery(int n) {
            this.batteryNumber = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.batteryBean = PowerSupplyIndicator.this.monitor.getBatteryBean(this.batteryNumber);
            if (this.batteryBean == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics(batteryPercentFont);
            int n3 = 13;
            int n4 = 24;
            int n5 = 2;
            int n6 = n3 - n5;
            int n7 = n6 * 5 / 8;
            int n8 = n + (n4 - n7) / 2;
            int n9 = n2 + n5;
            int n10 = 2;
            n10 = n10 & 0xFFFFFFFE | n7 & 1;
            int n11 = n8 + (n7 - n10) / 2;
            int n12 = n11 + n10;
            int n13 = n2;
            Color color = this.getBatteryBackgroundColor();
            graphics.setColor(color);
            graphics.fillRect(n11, n13, n10, n5);
            if (this.isMissing()) {
                graphics.fillRect(n8, n9, n7, n6);
            } else {
                this.fillGradient(graphics, n8, n9, n7, n6, color, 192, 48);
            }
            graphics.setColor(this.getBatteryOutlineColor());
            graphics.drawLine(n8, n9, n8, n9 + n6);
            graphics.drawLine(n8, n9 + n6, n8 + n7, n9 + n6);
            graphics.drawLine(n8 + n7, n9 + n6, n8 + n7, n9);
            graphics.drawLine(n8 + n7, n9, n12, n9);
            graphics.drawLine(n12, n9, n12, n13);
            graphics.drawLine(n12, n13, n11, n13);
            graphics.drawLine(n11, n13, n11, n9);
            graphics.drawLine(n11, n9, n8, n9);
            if (!this.isMissing()) {
                int n14 = this.batteryBean.getPercentCharge();
                int n15 = (n6 - 1) * n14 / 100;
                this.fillGradient(graphics, n8 + 1, n9 + n6 - n15, n7 - 1, n15, this.colorForCharge(n14), 80, 140);
                graphics.setFont(batteryPercentFont);
                graphics.setColor(Color.black);
                String string = n14 + "%";
                int n16 = n + (24 - fontMetrics.stringWidth(string) + 2) / 2;
                graphics.drawString(string, n16, 24);
            }
        }

        private boolean isMissing() {
            return this.batteryBean.getStatus() == PowerSupplyMeasurement.BatteryStatus.Missing;
        }

        private Color getBatteryOutlineColor() {
            if (this.isMissing()) {
                return Color.gray;
            }
            return Color.black;
        }

        private Color getBatteryBackgroundColor() {
            if (this.isMissing()) {
                return Color.lightGray;
            }
            return Color.darkGray;
        }

        private void fillGradient(Graphics graphics, int n, int n2, int n3, int n4, Color color, int n5, int n6) {
            int n7 = 7 - 8 * n5 / 256;
            for (int i = 8; i > 0; --i) {
                int n8 = n6 - Math.abs(i - n7) * n6 * 2 / 4;
                graphics.setColor(this.colorAdd(color, n8));
                int n9 = n3 / i;
                graphics.fillRect(n, n2, n9, n4);
                n += n9;
                n3 -= n9;
            }
        }

        private Color colorAdd(Color color, int n) {
            int n2 = Math.max(0, Math.min(color.getRed() + n, 255));
            int n3 = Math.max(0, Math.min(color.getGreen() + n, 255));
            int n4 = Math.max(0, Math.min(color.getBlue() + n, 255));
            return new Color(n2, n3, n4);
        }

        private Color colorForCharge(int n) {
            if (n < 25) {
                return Color.red;
            }
            if (n < 50) {
                return Color.yellow;
            }
            return Color.green;
        }

        public int getIconWidth() {
            return 24;
        }

        public int getIconHeight() {
            return 24;
        }
    }
}

