/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerSupply;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import java.io.DataInput;
import java.io.IOException;
import java.util.Hashtable;

public class PowerSupplyMeasurement
implements Measurement {
    private static final long serialVersionUID = 2136061728970097936L;
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$powerSupply$PowerSupplyMeasurement == null ? (class$elgato$measurement$powerSupply$PowerSupplyMeasurement = PowerSupplyMeasurement.class$("elgato.measurement.powerSupply.PowerSupplyMeasurement")) : class$elgato$measurement$powerSupply$PowerSupplyMeasurement);
    private static final Queue pool = new Queue(3);
    private static boolean powerFirmwareInstalled = false;
    private static boolean firmwareChecked = false;
    public static final int AC_POWER = 0;
    public static final int TEMPERATURE = 1;
    public static final int VOLTAGE = 2;
    public static final int ESTIMATED_RUN_TIME = 3;
    public static final int MAXIMUM_ERROR = 4;
    public static final int PERCENT_CHARGE = 5;
    public static final int BATTERY_STATUS = 6;
    public static final int BATTERY = 7;
    public static final int DC_BIAS_TEE = 8;
    public static final int CURRENT = 9;
    public static final int CYCLE_COUNT = 10;
    public static final int SERIAL_NUMBER = 11;
    public static final int MANUFACTURE_DATE = 12;
    public static final int DC_POWER_IN_STATE = 13;
    private Reading[] readings = new Reading[]{new BooleanReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new BooleanReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading(), new IntegerReading()};
    static /* synthetic */ Class class$elgato$measurement$powerSupply$PowerSupplyMeasurement;

    public static PowerSupplyMeasurement unpack(DataInput dataInput) throws IOException {
        PowerSupplyMeasurement powerSupplyMeasurement = PowerSupplyMeasurement.create();
        Reading[] readingArray = powerSupplyMeasurement.getReadings();
        if (logger.isDebugEnabled()) {
            logger.debug("Received power supply measurement ");
        }
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
            if (!logger.isDebugEnabled()) continue;
            logger.debug(" * Reading " + i + ": " + readingArray[i]);
        }
        return powerSupplyMeasurement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerFirmwareInstalled() {
        if (firmwareChecked) {
            return powerFirmwareInstalled;
        }
        try {
            if (this.readings[0].booleanValue()) {
                powerFirmwareInstalled = true;
                boolean bl = true;
                return bl;
            }
            for (int i = 1; i <= 6; ++i) {
                if (this.readings[i].intValue() == 0) continue;
                powerFirmwareInstalled = true;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            firmwareChecked = true;
        }
        powerFirmwareInstalled = false;
        return false;
    }

    Reading[] getReadings() {
        return this.readings;
    }

    private static PowerSupplyMeasurement create() {
        PowerSupplyMeasurement powerSupplyMeasurement = (PowerSupplyMeasurement)pool.dequeue();
        if (powerSupplyMeasurement == null) {
            return new PowerSupplyMeasurement();
        }
        return powerSupplyMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public boolean getBooleanReadingValue(int n) {
        return this.readings[n].booleanValue();
    }

    public int getIntegerReadingValue(int n) {
        return this.readings[n].intValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("You don't exist. Go away");
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("You don't exist. Go away");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Power Supply measurement does not have FloatReadings");
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("You don't exist. Go away");
    }

    public String getMeasurementTitle() {
        return Text.Power_Supply;
    }

    public boolean hasCurrentSettings() {
        return true;
    }

    public boolean isBatteryPresent(int n) {
        return (this.readings[6].intValue() & n) == n;
    }

    public BatteryStatus getBatteryStatus() {
        if (this.isBatteryPresent(this.readings[7].intValue())) {
            return BatteryStatus.Present;
        }
        return BatteryStatus.Missing;
    }

    public int getNewBatteryCount() {
        int n = this.readings[6].intValue();
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                --n;
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BatteryStatus {
        private static final Hashtable stati = new Hashtable();
        public static final BatteryStatus Unknown = BatteryStatus.create(-1, "----");
        public static final BatteryStatus Missing = BatteryStatus.create(0, Text.Missing);
        public static final BatteryStatus Present = BatteryStatus.create(6, Text.Present);
        private final String name;

        private static BatteryStatus create(int n, String string) {
            BatteryStatus batteryStatus = new BatteryStatus(string);
            stati.put(new Integer(n), batteryStatus);
            return batteryStatus;
        }

        public static BatteryStatus lookupValue(int n) {
            BatteryStatus batteryStatus = (BatteryStatus)stati.get(new Integer(n));
            if (batteryStatus == null) {
                return Missing;
            }
            return batteryStatus;
        }

        private BatteryStatus(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }
}

