/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerSupply;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class PowerSupplyMeasurementGenerator
extends MeasurementGenerator {
    private Random random = new Random(2345L);
    protected int currentBattery = 1;

    protected void writePayload(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.isAcPower() ? 1 : 0);
        dataOutput.writeInt(this.getTemperature());
        dataOutput.writeInt(this.getVoltage());
        dataOutput.writeInt(this.getEstRunTime());
        dataOutput.writeInt(this.getMaxError());
        dataOutput.writeInt(this.getPercentCharge());
        dataOutput.writeInt(this.getBatteryStatus());
        dataOutput.writeInt(this.getBattery());
        dataOutput.writeInt(this.isDcBiasTeeOn() ? 1 : 0);
    }

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return PowerSupplyMeasurement.unpack(dataInput);
    }

    public int getBattery() {
        int n = this.currentBattery;
        this.currentBattery = 1 + this.currentBattery % 2;
        return n;
    }

    public int getBatteryStatus() {
        return Math.abs(this.random.nextInt()) % 7;
    }

    public int getPercentCharge() {
        return (this.random.nextInt() & 3) == 0 ? 100 : Math.abs(this.random.nextInt()) % 100;
    }

    public int getMaxError() {
        return (this.random.nextInt() & 0xFFFF) % 200;
    }

    public int getEstRunTime() {
        return (this.random.nextInt() & 3) == 0 ? 65535 : this.random.nextInt() & 0xFF;
    }

    public int getVoltage() {
        return 11770 + (this.random.nextInt() & 0xFFF);
    }

    public int getTemperature() {
        return 2340 + (this.random.nextInt() & 0x1F);
    }

    public boolean isAcPower() {
        return (this.random.nextInt() & 0xFF) < 100;
    }

    public boolean isDcBiasTeeOn() {
        return (this.random.nextInt() & 0xFF) < 64;
    }
}

