/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.powerSupply;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.strategies.PercentageStrategy;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.powerSupply.PowerSupplyMeasurement;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Vector;

public class PowerSupplyMonitor
implements MeasurementListener {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$powerSupply$PowerSupplyMonitor == null ? (class$elgato$measurement$powerSupply$PowerSupplyMonitor = PowerSupplyMonitor.class$("elgato.measurement.powerSupply.PowerSupplyMonitor")) : class$elgato$measurement$powerSupply$PowerSupplyMonitor);
    private static final int FirstBattery = 1;
    private static final int MaxBatteryCount = 2;
    private static final PowerSupplyMonitor instance = new PowerSupplyMonitor();
    public static final int Power_Auto = 0;
    public static boolean active = false;
    private int dcPowerIn;
    private boolean onAcPower;
    private boolean powerFirmwareInstalled = false;
    private boolean firmwareChecked = false;
    private boolean dcBiasTeeOn = false;
    private int batteryCount;
    private boolean[] batteryPresent = new boolean[2];
    private BatteryBean[] powerSupplyMeasurements = new BatteryBean[2];
    private final Vector changeListeners = new Vector();
    private PowerSupplyMeasurement powerSupplyMeasurement;
    static /* synthetic */ Class class$elgato$measurement$powerSupply$PowerSupplyMonitor;

    PowerSupplyMonitor() {
    }

    public static PowerSupplyMonitor instance() {
        return instance;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.powerSupplyMeasurement != null) {
            this.powerSupplyMeasurement.recycle();
        }
        this.powerSupplyMeasurement = (PowerSupplyMeasurement)measurement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Vector vector = this.changeListeners;
        synchronized (vector) {
            this.changeListeners.addElement(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Vector vector = this.changeListeners;
        synchronized (vector) {
            this.changeListeners.removeElement(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Vector vector = this.changeListeners;
        synchronized (vector) {
            for (int i = 0; i < this.changeListeners.size(); ++i) {
                ChangeListener changeListener = (ChangeListener)this.changeListeners.elementAt(i);
                changeListener.stateChanged();
            }
        }
    }

    public void measurementReceived(Measurement measurement) {
        if (logger.isDebugEnabled()) {
            logger.debug("PowerSupplyMonitor.measurementReceived: " + measurement);
        }
        this.setMeasurement(measurement);
        this.onAcPower = this.powerSupplyMeasurement.getBooleanReadingValue(0);
        this.dcPowerIn = this.powerSupplyMeasurement.getIntegerReadingValue(13);
        this.dcBiasTeeOn = this.powerSupplyMeasurement.getBooleanReadingValue(8);
        this.batteryPresent[0] = this.powerSupplyMeasurement.isBatteryPresent(1);
        this.batteryPresent[1] = this.powerSupplyMeasurement.isBatteryPresent(2);
        this.batteryCount = this.powerSupplyMeasurement.getNewBatteryCount();
        active = true;
        int n = this.powerSupplyMeasurement.getIntegerReadingValue(7);
        if (n < 1 || n >= 3) {
            logger.error("returning, no new bean created for which battery: " + n);
            return;
        }
        if (this.powerSupplyMeasurements[this.batteryIndex(n)] != null) {
            this.powerSupplyMeasurements[this.batteryIndex(n)].setMeasurement(this.powerSupplyMeasurement);
        } else {
            this.powerSupplyMeasurements[this.batteryIndex((int)n)] = new BatteryBean(this.powerSupplyMeasurement);
        }
        if (!this.firmwareChecked) {
            this.powerFirmwareInstalled = this.powerSupplyMeasurement.isPowerFirmwareInstalled();
            this.firmwareChecked = true;
        }
        this.fireChangeEvent();
    }

    public boolean isPowerFirmwareInstalled() {
        return this.powerFirmwareInstalled;
    }

    public boolean isOnAcPower() {
        return this.onAcPower;
    }

    public boolean isDcBiasTeeOn() {
        return this.dcBiasTeeOn;
    }

    public int getFirstBattery() {
        return 1;
    }

    public int getBatteryCount() {
        return 2;
    }

    public int getCurrentBatteryCount() {
        return this.batteryCount;
    }

    public BatteryBean getBatteryBean(int n) {
        BatteryBean batteryBean = this.powerSupplyMeasurements[this.batteryIndex(n)];
        if (batteryBean == null) {
            this.powerSupplyMeasurements[this.batteryIndex((int)n)] = batteryBean = new BatteryBean();
        }
        return batteryBean;
    }

    private int batteryIndex(int n) {
        return n - 1;
    }

    public int getDcPowerIn() {
        return this.dcPowerIn;
    }

    public String getDcPowerInString() {
        switch (this.dcPowerIn) {
            case 0: {
                return Text.DC_Power_In_Auto;
            }
            case 1: {
                return Text.Recondition_Battery;
            }
            case 2: {
                return Text.Charging;
            }
            case 3: {
                return Text.Discharging;
            }
        }
        return Text.Unknown;
    }

    public boolean isReconditioningSupported() {
        String string = MeasurementFactory.instance().getComponentRevision("PS_Rev");
        boolean bl = string != null && UIHelper.compareVersionNumbers(string, "18") >= 0;
        return bl;
    }

    public boolean canReconditionNow() {
        return this.getCurrentBatteryCount() == 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ChangeListener {
        public void stateChanged();
    }

    public static class BatteryBean {
        private static final PercentageStrategy percentageStrategy = new PercentageStrategy(0);
        private static final NumberFormat numFormat = NumberFormat.getInstance();
        private static final int kelvinToCelsius = 2731;
        private int temp;
        private int volt;
        private PowerSupplyMeasurement.BatteryStatus status;
        private int charge;
        private int runTime;
        private int maxError;
        private boolean onBattery;
        private int current;
        private int cycleCount;
        private int serialNum;
        private int mfgDate;

        public BatteryBean(PowerSupplyMeasurement powerSupplyMeasurement) {
            this.setMeasurement(powerSupplyMeasurement);
        }

        public BatteryBean() {
            this.status = PowerSupplyMeasurement.BatteryStatus.Unknown;
        }

        public void setMeasurement(PowerSupplyMeasurement powerSupplyMeasurement) {
            this.temp = powerSupplyMeasurement.getIntegerReadingValue(1);
            this.volt = powerSupplyMeasurement.getIntegerReadingValue(2);
            this.status = powerSupplyMeasurement.getBatteryStatus();
            this.charge = powerSupplyMeasurement.getIntegerReadingValue(5);
            this.runTime = powerSupplyMeasurement.getIntegerReadingValue(3);
            this.maxError = powerSupplyMeasurement.getIntegerReadingValue(4);
            this.onBattery = !powerSupplyMeasurement.getBooleanReadingValue(0);
            this.current = powerSupplyMeasurement.getIntegerReadingValue(9);
            this.cycleCount = powerSupplyMeasurement.getIntegerReadingValue(10);
            this.serialNum = powerSupplyMeasurement.getIntegerReadingValue(11);
            this.mfgDate = powerSupplyMeasurement.getIntegerReadingValue(12);
        }

        public String getTempString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            int n = this.temp - 2731;
            return n / 10 + "." + Math.abs(n % 10) + "\u00b0C";
        }

        public String getVoltString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            return this.volt / 1000 + "." + this.volt % 1000 + " V";
        }

        public PowerSupplyMeasurement.BatteryStatus getStatus() {
            return this.status;
        }

        public int getPercentCharge() {
            return this.charge;
        }

        public String getPercentChargeString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            return percentageStrategy.format(this.charge * 100);
        }

        public String getRunTimeString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            if (!this.onBattery) {
                return Text.External_DC_Power;
            }
            if (this.runTime > 2000) {
                return Text.Not_in_use;
            }
            return this.runTime + " min";
        }

        public String getMaxErrorString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            int n = this.maxError * 100;
            if (n > 10000) {
                return Text.Recondition_Battery;
            }
            return percentageStrategy.format(n);
        }

        public String getCurrentString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            return numFormat.format(this.current) + " mA";
        }

        public String getCycleCountString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            return numFormat.format(this.cycleCount);
        }

        public String getSerialNumString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            return numFormat.format(this.serialNum);
        }

        public String getMfgDateString() {
            if (!this.isDataAvailable()) {
                return "----";
            }
            DateFormat dateFormat = DateFormat.getDateInstance();
            return dateFormat.format(new Date((long)this.mfgDate * 1000L));
        }

        public boolean isDataAvailable() {
            return this.status == PowerSupplyMeasurement.BatteryStatus.Present;
        }
    }
}

