/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.actuators.ActuatorField;
import elgato.infrastructure.analyzer.AntennaTraceAnalyzer;
import elgato.infrastructure.analyzer.AntennaTraceChart;
import elgato.infrastructure.analyzer.ReturnLossTraceChart;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.strategies.DBToSWRStrategy;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.MultiplexingNumberStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import elgato.measurement.returnLoss.ReturnLossMeasurementSettings;
import elgato.measurement.returnLoss.ReturnLossMetrics;
import java.awt.Color;
import java.awt.Component;

public class ReturnLossAnalyzer
extends AntennaTraceAnalyzer {
    private ReturnLossMeasurement measurement;
    private ReturnLossMetrics metrics;
    private final NumberFieldStrategy freqStrategyTraceSave = new NumberFieldStrategy("Hz");
    private final NumberFieldStrategy decibelStrategyTraceSave = new DecibelStrategy(1, false);
    private AntennaTraceAnalyzer.XStartListener xStartListener = new AntennaTraceAnalyzer.XStartListener(this);
    private AntennaTraceAnalyzer.XStopListener xStopListener = new AntennaTraceAnalyzer.XStopListener(this);
    ReturnLossMeasurementSettings settings;

    public ReturnLossAnalyzer() {
        super(ReturnLossMeasurementSettings.instance().getRefLevel(), ReturnLossMeasurementSettings.instance().getScaleDiv(), "RetLossAn");
        this.metrics = new ReturnLossMetrics();
        this.settings = ReturnLossMeasurementSettings.instance();
        this.settings.getStartFrequency().addValueListener(this.xStartListener);
        this.settings.getStopFrequency().addValueListener(this.xStopListener);
        this.settings.getLimitsToggle().addValueListener(this.limitsStateListener);
        TraceChart traceChart = this.getChart();
        traceChart.setManualXRange(false);
        this.init();
        this.settings.getLimitsToggle().fireValueChanged();
    }

    public void dispose() {
        this.settings.getStartFrequency().removeValueListener(this.xStartListener);
        this.settings.getStopFrequency().removeValueListener(this.xStopListener);
        this.settings.getLimitsToggle().removeValueListener(this.limitsStateListener);
        this.settings = null;
        super.dispose();
    }

    protected TraceAnalyzer.AverageDynamicLabel getAverageDynamicLabel() {
        return new TraceAnalyzer.AverageDynamicLabel(ReturnLossMeasurement.AVERAGE_TYPE, ReturnLossMeasurement.NUM_AVERAGES, ReturnLossMeasurement.AVERAGE_COUNT);
    }

    protected Component createBottomPanel() {
        return new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true);
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected void setMeasurement(Measurement measurement) {
        ReturnLossMeasurement returnLossMeasurement;
        TraceChart traceChart;
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        if ((traceChart = this.getChart()).isManualXRange()) {
            traceChart.setManualXRange(false);
        }
        this.measurement = returnLossMeasurement = (ReturnLossMeasurement)measurement;
    }

    protected Color getDataBackgroundColor() {
        return MenuPanel.BG_COLOR;
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    public TabDelimitable[] createReadingFields() {
        int n;
        TabDelimitable[] tabDelimitableArray;
        ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)this.getMeasurement();
        int n2 = returnLossMeasurement.getTrace().length;
        int n3 = 0;
        int n4 = 0;
        ReadingField[] readingFieldArray = this.createMyReadingFields();
        int n5 = readingFieldArray.length;
        ActuatorField[] actuatorFieldArray = new ActuatorField[4];
        ReturnLossMeasurementSettings returnLossMeasurementSettings = ReturnLossMeasurementSettings.instance();
        actuatorFieldArray[0] = new ActuatorField(returnLossMeasurementSettings.getStartFrequency());
        actuatorFieldArray[1] = new ActuatorField(returnLossMeasurementSettings.getStopFrequency());
        actuatorFieldArray[2] = new ActuatorField(returnLossMeasurementSettings.getCalStartFreq());
        actuatorFieldArray[3] = new ActuatorField(returnLossMeasurementSettings.getCalStopFreq());
        int n6 = actuatorFieldArray.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            n3 = 5;
            tabDelimitableArray = new TabDelimitable[n5 + n6 + n2 + n3];
            for (n = 0; n < n5; ++n) {
                tabDelimitableArray[n4++] = readingFieldArray[n];
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            TraceSaveTabDelimitable.fillTabDelimitables(returnLossMeasurement, "Trace", this.freqStrategyTraceSave, 1, this.decibelStrategyTraceSave, tabDelimitableArray, n4);
            n4 += returnLossMeasurement.getTrace().length;
        } else {
            n3 = 2;
            tabDelimitableArray = new TabDelimitable[n5 + n6 + n3];
            for (n = 0; n < n5; ++n) {
                tabDelimitableArray[n4++] = readingFieldArray[n];
            }
        }
        tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
        tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("SETUP DATA");
        if (returnLossMeasurement.isValidCalibration()) {
            for (n = 0; n < n6; ++n) {
                tabDelimitableArray[n4++] = actuatorFieldArray[n];
            }
        } else {
            n6 = 2;
            for (n = 0; n < n6; ++n) {
                tabDelimitableArray[n4++] = actuatorFieldArray[n];
            }
            String string = returnLossMeasurementSettings.getCalStartFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string);
            string = returnLossMeasurementSettings.getCalStopFreq().getLongLabel() + "\t-----";
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable(string);
        }
        return tabDelimitableArray;
    }

    protected AntennaTraceChart getLineChart() {
        return new ReturnLossTraceChart();
    }

    private ReadingField[] createMyReadingFields() {
        return new ReadingField[]{new IntegerReadingField(this, Text.Best + " " + Text.Frequency, "MHz", ReturnLossMeasurement.MINIMUM_PT_FREQ, 1000.0, 3), new IntegerReadingField(this, Text.Best + " " + Text.Return_Loss, "dB", ReturnLossMeasurement.MINIMUM_PT_LOSS, 1000.0, 3), new IntegerReadingField(this, Text.Best + " " + Text.SWR, "", ReturnLossMeasurement.MINIMUM_PT_SWR, 1000.0, 3), new IntegerReadingField(this, Text.Worst + " " + Text.Frequency, "MHz", ReturnLossMeasurement.MAX_PT_FREQ, 1000.0, 3), new IntegerReadingField(this, Text.Worst + " " + Text.Return_Loss, "dB", ReturnLossMeasurement.MAX_PT_LOSS, 1000.0, 3), new IntegerReadingField(this, Text.Worst + " " + Text.SWR, "", ReturnLossMeasurement.MAX_PT_SWR, 1000.0, 3)};
    }

    protected boolean isValidCalibration(Measurement measurement) {
        return ((ReturnLossMeasurement)measurement).isValidCalibration();
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return new MultiplexingNumberStrategy(super.getYAxisNormalStrategy(), new DBToSWRStrategy(), ", ");
    }

    protected long getSettingsXstart() {
        return ReturnLossMeasurementSettings.instance().getStartFrequency().longValue();
    }

    protected long getSettingsXstop() {
        return ReturnLossMeasurementSettings.instance().getStopFrequency().longValue();
    }

    protected String getCalibratedText() {
        return Text.Calibrated + " (" + ReturnLossMeasurementSettings.instance().getCalStartFreq().toString() + " - " + ReturnLossMeasurementSettings.instance().getCalStopFreq().toString() + ")";
    }

    protected void setLimitsState() {
        AntennaTraceChart antennaTraceChart = (AntennaTraceChart)this.getOurChart();
        antennaTraceChart.setShowLimits(this.settings.getLimitsToggle().booleanValue());
    }
}

