/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.returnLoss.ReturnLossMeasurementSettings;
import java.io.DataInput;
import java.io.IOException;

public class ReturnLossMeasurement
extends TraceMeasurement {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$returnLoss$ReturnLossMeasurement == null ? (class$elgato$measurement$returnLoss$ReturnLossMeasurement = ReturnLossMeasurement.class$("elgato.measurement.returnLoss.ReturnLossMeasurement")) : class$elgato$measurement$returnLoss$ReturnLossMeasurement);
    private static final long serialVersionUID = -608139708113629961L;
    private static final Queue pool = new Queue(3);
    private static int readingCount = 0;
    public static final int TRACE = readingCount++;
    public static final int SWR_TRACE = readingCount++;
    public static final int MINIMUM_PT_FREQ = readingCount++;
    public static final int MINIMUM_PT_LOSS = readingCount++;
    public static final int MINIMUM_PT_SWR = readingCount++;
    public static final int MAX_PT_FREQ = readingCount++;
    public static final int MAX_PT_LOSS = readingCount++;
    public static final int MAX_PT_SWR = readingCount++;
    public static final int VALID_CALIBRATION = readingCount++;
    public static final int CAL_MEASUREMENT_MODE = readingCount++;
    public static final int START_FREQUENCY = readingCount++;
    public static final int STOP_FREQUENCY = readingCount++;
    public static final int AVERAGE_TYPE = readingCount++;
    public static final int NUM_AVERAGES = readingCount++;
    public static final int INTERFERENCE_MODE = readingCount++;
    public static final int AVERAGE_COUNT = readingCount++;
    public static final int CAL_START_FREQ = readingCount++;
    public static final int CAL_STOP_FREQ = readingCount++;
    protected IntegerArrayReading trace = new IntegerArrayReading(256);
    protected IntegerArrayReading swrTrace = new IntegerArrayReading(256);
    protected IntegerReading minimumPtFreq = new IntegerReading();
    protected IntegerReading minimumPtLoss = new IntegerReading();
    protected IntegerReading minimumPtSwr = new IntegerReading();
    protected IntegerReading maximumPtFreq = new IntegerReading();
    protected IntegerReading maximumPtLoss = new IntegerReading();
    protected IntegerReading maximumPtSwr = new IntegerReading();
    protected BooleanReading validCalibration = new BooleanReading();
    protected IntegerReading calMeasurementMode = new IntegerReading();
    protected IntegerReading startFrequency = new IntegerReading();
    protected IntegerReading stopFrequency = new IntegerReading();
    protected IntegerReading averageType = new IntegerReading();
    protected IntegerReading numAverages = new IntegerReading();
    protected IntegerReading interferenceMode = new IntegerReading();
    protected IntegerReading averageCount = new IntegerReading();
    protected IntegerReading calStart = new IntegerReading();
    protected IntegerReading calStop = new IntegerReading();
    private static int readCount = 0;
    private static int mismatchCount = 0;
    private Reading[] readings = new Reading[]{this.trace, this.swrTrace, this.minimumPtFreq, this.minimumPtLoss, this.minimumPtSwr, this.maximumPtFreq, this.maximumPtLoss, this.maximumPtSwr, this.validCalibration, this.calMeasurementMode, this.startFrequency, this.stopFrequency, this.averageType, this.numAverages, this.interferenceMode, this.averageCount, this.calStart, this.calStop};
    static /* synthetic */ Class class$elgato$measurement$returnLoss$ReturnLossMeasurement;

    public ReturnLossMeasurement() {
        this.setTraceInverted(true);
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public static ReturnLossMeasurement unpack(DataInput dataInput) throws IOException {
        ReturnLossMeasurement returnLossMeasurement = ReturnLossMeasurement.create();
        Reading[] readingArray = returnLossMeasurement.getReadings();
        if (readCount < Integer.MAX_VALUE) {
            ++readCount;
        }
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        return returnLossMeasurement;
    }

    public static ReturnLossMeasurement create() {
        ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)pool.dequeue();
        if (returnLossMeasurement == null) {
            return new ReturnLossMeasurement();
        }
        return returnLossMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int[] getTrace() {
        return this.trace.getTrace();
    }

    public long getTraceStartValue() {
        return this.getStartFrequency() * 1000L;
    }

    public long getTraceStopValue() {
        return this.getStopFrequency() * 1000L;
    }

    public int[] getSwrTrace() {
        return this.swrTrace.getTrace();
    }

    public int getMinimumPtFreq() {
        return this.minimumPtFreq.intValue();
    }

    public int getAverageType() {
        return this.averageType.intValue();
    }

    public int getCalMeasurementMode() {
        return this.calMeasurementMode.intValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public long getStartFrequency() {
        return this.startFrequency.intValue();
    }

    public long getStopFrequency() {
        return this.stopFrequency.intValue();
    }

    public boolean isValidCalibration() {
        return this.validCalibration.booleanValue();
    }

    public int getMaximumPtFreq() {
        return this.maximumPtFreq.intValue();
    }

    public int getMaximumPtLoss() {
        return this.maximumPtLoss.intValue();
    }

    public int getMaximumPtSwr() {
        return this.maximumPtSwr.intValue();
    }

    public int getMinimumPtLoss() {
        return this.minimumPtLoss.intValue();
    }

    public int getMinimumPtSwr() {
        return this.minimumPtSwr.intValue();
    }

    public int getInterferenceMode() {
        return this.interferenceMode.intValue();
    }

    public int getCalStart() {
        return this.calStart.intValue();
    }

    public int getCalStop() {
        return this.calStop.intValue();
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("method not implemented yet");
    }

    public String getMeasurementTitle() {
        return Text.Return_Loss;
    }

    protected boolean actuatorsMatchCurrentSettings() {
        ReturnLossMeasurementSettings returnLossMeasurementSettings = ReturnLossMeasurementSettings.instance();
        boolean bl = true;
        if (readCount == 0) {
            return true;
        }
        if (!this.resultEqualsSetting(logger, returnLossMeasurementSettings.getStartFrequency(), this.startFrequency.longValue() * 1000L)) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, returnLossMeasurementSettings.getStopFrequency(), this.stopFrequency.longValue() * 1000L)) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, returnLossMeasurementSettings.getCalStartFreq(), this.calStart.longValue() * 1000L)) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, returnLossMeasurementSettings.getCalStopFreq(), this.calStop.longValue() * 1000L)) {
            bl = false;
        }
        mismatchCount = bl ? 0 : ++mismatchCount;
        if (mismatchCount > 3) {
            logger.warn("Result/Setting mismatch #" + mismatchCount + ", resetting and continuing as if matched");
            mismatchCount = 0;
            bl = true;
            returnLossMeasurementSettings.invalidate();
            returnLossMeasurementSettings.refresh();
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

