/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandChannelEmulator;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.infrastructure.util.FastMath;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class ReturnLossMeasurementGenerator
extends MeasurementGenerator {
    private Random rand = new Random();
    private int calibratedState = -1;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return ReturnLossMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        int n;
        for (n = 0; n < 256; ++n) {
            dataOutput.writeInt(32768 - (FastMath.sin((n / 2 - 128) * 32768 / 256) + this.nextInt(-2000, 2000)));
        }
        for (n = 0; n < 256; ++n) {
            dataOutput.writeInt(n * 120);
        }
        dataOutput.writeInt(this.nextInt(25000, 1000000));
        dataOutput.writeInt(this.nextInt(4000, 34000));
        dataOutput.writeInt(this.nextInt(1000, 4000));
        dataOutput.writeInt(this.nextInt(25000, 1000000));
        dataOutput.writeInt(this.nextInt(4000, 34000));
        dataOutput.writeInt(this.nextInt(1000, 4000));
        if (this.calibratedState == -1) {
            dataOutput.writeInt(this.rand.nextInt() & 1);
        } else {
            dataOutput.writeInt(this.calibratedState);
        }
        dataOutput.writeInt(2);
        dataOutput.writeInt(this.nextInt(100000, 200000));
        dataOutput.writeInt(this.nextInt(200000, 500000));
        dataOutput.writeInt(this.nextInt(0, 2));
        dataOutput.writeInt(this.nextInt(5, 30));
        dataOutput.writeInt(9);
        dataOutput.writeInt(11);
    }

    private int nextInt(int n, int n2) {
        int n3 = Math.abs(this.rand.nextInt()) % (n2 - n);
        return n + n3;
    }

    public void setCalibrated() {
        this.calibratedState = 1;
    }

    public void setUncalibrated() {
        this.calibratedState = 0;
    }

    public void setCommandChannelEmulator(CommandChannelEmulator commandChannelEmulator) {
        Command command = Command.makeSetCommand("antRetLoss");
        command.addProperty("mode", 1L);
        commandChannelEmulator.addListener(command, (CommandChannelEmulator.EmulatorCommandListener)new UncalibratedListener());
    }

    private class UncalibratedListener
    implements CommandChannelEmulator.EmulatorCommandListener {
        private UncalibratedListener() {
        }

        public Command processCommand(Command command) {
            ReturnLossMeasurementGenerator.this.setUncalibrated();
            return null;
        }
    }
}

