/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.CommonLossMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.infrastructure.valueobject.ValueInterface;

public class ReturnLossMeasurementSettings
extends CommonLossMeasurementSettings {
    private static ReturnLossMeasurementSettings instance;
    public static final String TOPIC_RETURNLOSS = "antRetLoss";
    public static final String TOPIC_RETURNLOSS_DISPLAY = "display.antRetLoss";
    private ListActuator limitsToggle;
    private LongActuator lowerLimit;
    private FrequencyActuator calStartFreq;
    private FrequencyActuator calStopFreq;
    private long fStoredCalStartFreq;
    private long fStoredCalStopFreq;
    private boolean doingLimitSetAll = true;

    protected ReturnLossMeasurementSettings() {
        super(TOPIC_RETURNLOSS);
        this.createHardwareFeatureListener(this.refLevel, this.scaleDiv, TOPIC_RETURNLOSS);
    }

    protected void addAdditionalActuators() {
        super.addAdditionalActuators();
        this.doingLimitSetAll = true;
        this.limitsToggle = new ListActuator(this.DISPLAY_TOPIC, "limitsToggle", Text.Limits, this.createOnOffValueSet());
        this.lowerLimit = LongActuator.createPower(this.DISPLAY_TOPIC, "lowerLimit", Text.get("Return_Loss_Limit"));
        this.calStartFreq = FrequencyActuator.createGlobalKilohertz(TOPIC_RETURNLOSS, "calStart", Text.Calibration_n_Start_Freq);
        this.calStopFreq = FrequencyActuator.createGlobalKilohertz(TOPIC_RETURNLOSS, "calStop", Text.Calibration_n_Stop_Freq);
        this.add(this.limitsToggle);
        this.add(this.lowerLimit);
        this.add(this.calStartFreq);
        this.add(this.calStopFreq);
        this.calStartFreq.setLongLabel(Text.Calibration_Start_Freq);
        this.calStopFreq.setLongLabel(Text.Calibration_Stop_Freq);
        this.setValidatorToFreqSrcLimits(this.calStartFreq, 3);
        this.setValidatorToFreqSrcLimits(this.calStopFreq, 3);
        this.calStartFreq.setValue(1850000000L);
        this.calStopFreq.setValue(1990000000L);
        PercentValueListener percentValueListener = PercentValueListener.createTenPercentValueListener(this.calStartFreq, this.calStopFreq, "antRetLoss.calStartStop10PctListener");
        this.calStartFreq.addValueListener(percentValueListener);
        this.calStopFreq.addValueListener(percentValueListener);
        this.limitsToggle.setValue(0);
        this.limitsToggle.addValueListener(new CommonLossMeasurementSettings.CommonLossValueListener("limitsToggle"){

            public void valueChanged(ValueInterface valueInterface) {
                ReturnLossMeasurementSettings.this.setAllLimits();
            }
        });
        this.lowerLimit.addValueListener(new CommonLossMeasurementSettings.CommonLossValueListener("lowerLimit"){

            public void valueChanged(ValueInterface valueInterface) {
                if (!ReturnLossMeasurementSettings.this.doingLimitSetAll) {
                    ReturnLossMeasurementSettings.this.setAllLimits();
                }
            }
        });
    }

    public void allowValidationNow() {
        this.doingLimitSetAll = false;
    }

    public void setAllLimits() {
        if (MeasurementSettings.suspendValidation) {
            return;
        }
        this.doingLimitSetAll = true;
        this.lowerLimit.setValidator(new RangeValidator(Math.max(0L, this.refLevel.longValue()), Math.min(50000L, this.refLevel.longValue() + 10L * this.scaleDiv.longValue())));
        this.doingLimitSetAll = false;
    }

    public static ReturnLossMeasurementSettings instance() {
        if (instance == null) {
            instance = new ReturnLossMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public ListActuator getLimitsToggle() {
        return this.limitsToggle;
    }

    public LongActuator getLowerLimit() {
        return this.lowerLimit;
    }

    public FrequencyActuator getCalStartFreq() {
        return this.calStartFreq;
    }

    public FrequencyActuator getCalStopFreq() {
        return this.calStopFreq;
    }

    public void storeCalStartStopFreqValues() {
        this.fStoredCalStartFreq = this.calStartFreq.longValue();
        this.fStoredCalStopFreq = this.calStopFreq.longValue();
    }

    public void restoreCalStartStopFreqValues() {
        this.calStopFreq.send(this.fStoredCalStopFreq);
        this.calStartFreq.send(this.fStoredCalStartFreq);
    }
}

