/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.calibration.AntennaCalibrateScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.CommonLossMenuMgr;
import elgato.infrastructure.menu.ClearCalButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.returnLoss.ReturnLossAnalyzer;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import elgato.measurement.returnLoss.ReturnLossMeasurementSettings;
import elgato.measurement.returnLoss.ReturnLossScreen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class ReturnLossMenuMgr
extends CommonLossMenuMgr {
    static final int RETURN_LOSS_UNCALIBRATED_MODE = 0;
    protected MenuItem setupButton;
    private MenuItem calStartFreqButton;
    private MenuItem calStopFreqButton;
    MarkerButtonFactory markerButtonFactory = this.createMarkerButtonFactory();

    public ReturnLossMenuMgr(ReturnLossScreen returnLossScreen, ReturnLossMeasurementSettings returnLossMeasurementSettings, ReturnLossAnalyzer returnLossAnalyzer) {
        super(returnLossScreen, returnLossMeasurementSettings, returnLossAnalyzer);
        this.setupButton = this.createSetupButton(ReturnLossMeasurementSettings.instance());
        this.calStartFreqButton = new ActuatorEditor(returnLossMeasurementSettings.getCalStartFreq(), "", this.getListenerBaseName() + ".calStartFreqButton");
        this.calStopFreqButton = new ActuatorEditor(returnLossMeasurementSettings.getCalStopFreq(), "", this.getListenerBaseName() + ".calStopFreqButton");
    }

    protected Menu buildLeftMenu() {
        return new Menu(Text.Return_Loss, new MenuItem[]{this.createCalFreqChanButton(ReturnLossMeasurementSettings.instance(), Text.Freq_slash_n_Calibrate, Text.Freq_slash_Calibrate), this.createLevelButton(ReturnLossMeasurementSettings.instance()), null, null, this.createAverageSweepButton(ReturnLossMeasurementSettings.instance().getNumAverages(), ReturnLossMeasurementSettings.instance().getAveraging()), this.setupButton, this.markerButtonFactory.getMenuButtonWithMinPeaks()});
    }

    private MarkerButtonFactory createMarkerButtonFactory() {
        return new MarkerButtonFactory((ReturnLossScreen)this.scn, null, null, ReturnLossMeasurementSettings.instance().getStartFrequency(), true);
    }

    protected ClearCalButton createClearCalButton() {
        return new ClearCalButton(Text.Clear_n_Calibration, this.getContextString("clear.calibration"), "antRetLoss", 0);
    }

    protected MenuItem createSourceLevelButton() {
        return null;
    }

    protected MenuItem createCalButton() {
        return new PushButton(Text.Calibrate, this.getContextString("returnLossCalibrate.calibrate"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReturnLossMeasurementSettings returnLossMeasurementSettings = ReturnLossMeasurementSettings.instance();
                returnLossMeasurementSettings.storeCalStartStopFreqValues();
                if (!((ReturnLossMeasurement)ReturnLossMenuMgr.this.analyzer.getMeasurement()).isValidCalibration()) {
                    returnLossMeasurementSettings.getCalStopFreq().send(returnLossMeasurementSettings.getStopFrequency().longValue());
                    returnLossMeasurementSettings.getCalStartFreq().send(returnLossMeasurementSettings.getStartFrequency().longValue());
                }
                ReturnLossMenuMgr.this.scn.getScreenManager().pushScreen(AntennaCalibrateScreen.createReturnLoss(ReturnLossMenuMgr.this.analyzer, ReturnLossMenuMgr.this.calStartFreqButton, ReturnLossMenuMgr.this.calStopFreqButton));
            }
        });
    }

    protected String getMeasurementName() {
        return "antRetLoss";
    }

    protected MenuItem createLimitsButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(ReturnLossMeasurementSettings.instance().getLimitsToggle(), "", this.getListenerBaseName() + ".limOnOff");
        Menu menu = new Menu(Text.Limits, new MenuItem[]{multiStateActuatorButton, this.createLowerLimitButton(), null, null, null, null, null});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), menu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createLowerLimitButton() {
        return new ActuatorEditor(ReturnLossMeasurementSettings.instance().getLowerLimit(), this.getContextString("returnLossLowerLimit"), this.getListenerBaseName() + ".rlLowerLim");
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }
}

