/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.returnLoss;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.GridBagMeasurementMetrics;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.returnLoss.ReturnLossMeasurement;
import elgato.measurement.returnLoss.ReturnLossMeasurementSettings;
import java.awt.Color;
import java.awt.Insets;

class ReturnLossMetrics
extends GridBagMeasurementMetrics {
    private static final NumberFieldStrategy frequencyStrategy = new FrequencyStrategy();

    ReturnLossMetrics() {
    }

    protected void setupMetrics() {
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.anchor = 10;
        this.gbc.fill = 2;
        this.gbc.insets = new Insets(0, 80, 0, 5);
        this.placeComponent(this.gridBag, this.gbc, new ELabel(Text.Best, this.labelColor, this.labelFont, 4, 2));
        this.gbc.gridx = 2;
        this.placeComponent(this.gridBag, this.gbc, new ELabel(Text.Worst, this.labelColor, this.labelFont, 4, 2));
        this.gbc.insets = new Insets(0, 36, 0, 32);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.anchor = 17;
        this.placeComponent(this.gridBag, this.gbc, new ELabel(Text.Frequency, this.labelColor, this.labelFont));
        this.gbc.gridy = 3;
        this.placeComponent(this.gridBag, this.gbc, new ELabel(Text.Return_Loss, this.labelColor, this.labelFont));
        this.gbc.gridy = 4;
        this.placeComponent(this.gridBag, this.gbc, new ELabel(Text.SWR, this.labelColor, this.labelFont));
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.gridx = 1;
        this.gbc.gridy = 2;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                return frequencyStrategy.format((long)returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MINIMUM_PT_FREQ) * 1000L);
            }
        }));
        this.gbc.gridy = 3;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                String string = "";
                if (ReturnLossMeasurementSettings.instance().getLimitsToggle().longValue() == 1L) {
                    long l = ReturnLossMeasurementSettings.instance().getLowerLimit().longValue();
                    if ((long)returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MINIMUM_PT_LOSS) <= l) {
                        this.setChunkColor(0, Color.red);
                        string = " (F)";
                    } else {
                        this.setChunkColor(0, MeasurementMetrics.DARK_GREEN);
                        string = " (P)";
                    }
                } else {
                    this.setChunkColor(0, Color.black);
                }
                return UIHelper.formatFixed(returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MINIMUM_PT_LOSS), 1) + " dB" + string;
            }
        }));
        this.gbc.gridy = 4;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                return UIHelper.formatFixed(returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MINIMUM_PT_SWR), 2);
            }
        }));
        this.gbc.gridx = 2;
        this.gbc.gridy = 2;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                return frequencyStrategy.format((long)returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MAX_PT_FREQ) * 1000L);
            }
        }));
        this.gbc.gridy = 3;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                return UIHelper.formatFixed(returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MAX_PT_LOSS), 1) + " dB";
            }
        }));
        this.gbc.gridy = 4;
        this.placeComponent(this.gridBag, this.gbc, this.addLabel(new DynamicLabel(4, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                ReturnLossMeasurement returnLossMeasurement = (ReturnLossMeasurement)measurement;
                return UIHelper.formatFixed(returnLossMeasurement.getIntegerReadingValue(ReturnLossMeasurement.MAX_PT_SWR), 2);
            }
        }));
    }
}

