/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.sigGen;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import java.io.DataInput;
import java.io.IOException;

public class SigGenMeasurement
implements Measurement {
    private static final Queue pool = new Queue(3);
    public static final String NAME = "source";
    public static final int RF_POWER_ON_OFF = 0;
    public static final int CENTER_FREQUENCY = 1;
    public static final int CENTER_FREQUENCY_FINE_TUNING_OFFSET = 2;
    public static final int SOURCE_AMPLITUDE = 3;
    public static final int RF_OUT_LOSS = 4;
    public static final int MODULATION_FORMAT = 5;
    public static final int MODULATION_PILOT_IDENTIFIER = 6;
    private BooleanReading rfPowerOnOff = new BooleanReading();
    private IntegerReading centerFrequency = new IntegerReading();
    private IntegerReading centerFrequencyFineTuningOffset = new IntegerReading();
    private IntegerReading sourceAmplitude = new IntegerReading();
    private IntegerReading rFOutLoss = new IntegerReading();
    private IntegerReading modulationFormat = new IntegerReading();
    private IntegerReading modulationPilotIdentifier = new IntegerReading();
    private IntegerReading reverseFundamentalChannelPower = new IntegerReading();
    private IntegerReading noiseCorrection = new IntegerReading();
    private Reading[] readings = new Reading[]{this.rfPowerOnOff, this.sourceAmplitude, this.centerFrequency, this.centerFrequencyFineTuningOffset, this.rFOutLoss, this.modulationFormat, this.modulationPilotIdentifier, this.reverseFundamentalChannelPower, this.noiseCorrection};

    public Reading[] getReadings() {
        return this.readings;
    }

    public static SigGenMeasurement unpack(DataInput dataInput) throws IOException {
        SigGenMeasurement sigGenMeasurement = SigGenMeasurement.create();
        Reading[] readingArray = sigGenMeasurement.getReadings();
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        return sigGenMeasurement;
    }

    private static SigGenMeasurement create() {
        SigGenMeasurement sigGenMeasurement = (SigGenMeasurement)pool.dequeue();
        if (sigGenMeasurement == null) {
            return new SigGenMeasurement();
        }
        return sigGenMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public boolean getRfPowerOnOff() {
        return this.rfPowerOnOff.booleanValue();
    }

    public int getCenterFrequency() {
        return this.centerFrequency.intValue();
    }

    public int getCenterFrequencyFineTuningOffset() {
        return this.centerFrequencyFineTuningOffset.intValue();
    }

    public int getSourceAmplitude() {
        return this.sourceAmplitude.intValue();
    }

    public int getrFOutLoss() {
        return this.rFOutLoss.intValue();
    }

    public int getModulationFormat() {
        return this.modulationFormat.intValue();
    }

    public int getModulationPilotIdentifier() {
        return this.modulationPilotIdentifier.intValue();
    }

    public long getReverseFundamentalChannelPower() {
        return this.reverseFundamentalChannelPower.intValue();
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("not implemented");
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("not implemented");
    }

    public float getFloatReadingValue(int n) {
        throw new IllegalStateException("Not Implemented");
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("not implemented");
    }

    public String getMeasurementTitle() {
        return Text.Sig_Gen;
    }

    public boolean hasCurrentSettings() {
        return true;
    }

    public int getNoiseCorrection() {
        return this.noiseCorrection.intValue();
    }
}

