/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.sigGen;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;

public class SigGenMeasurementSettings
extends MeasurementSettings {
    public static final String TOPIC_SIGNAL_GENERATOR = "source";
    public static final String TOPIC_SIGNAL_GENERATOR_DISPLAY = "display.source";
    public static final String KEY_SIGGEN_MODULATION_FORMAT = "modulation";
    public static final String KEY_SIGGEN_RF_POWER = "pwrOnOff";
    public static final String KEY_SIGGEN_SRC_AMP = "srcAmp";
    public static final String KEY_SIGGEN_AMP_STEP = "ampStep";
    public static final String KEY_SIGGEN_CENTER_FREQUENCY = "srcCf";
    public static final String KEY_SIGGEN_CENTER_FREQUENCY_OFFSET = "srcCfOffset";
    public static final String KEY_SIGGEN_PILOT_ID = "pilotId";
    public static final String KEY_SIGGEN_FREQ_STEP = "srcFreqStep";
    public static final String KEY_SIGGEN_CHAN_STEP = "srcChanStep";
    public static final String KEY_SIGGEN_REVERSE_CHANNEL_POWER = "rfchPwr";
    public static final String KEY_RFOUT_LOSS = "rfOutLoss";
    public static final String KEY_SIGGEN_ARB_FILE_LOCATION = "arbFileLocation";
    public static final String KEY_SIGGEN_ARB_FILE_NAME = "arbFileName";
    public static final long SOURCE_UNCAL_LEVEL = 23000L;
    public static final int VALUE_SIG_GEN_256 = 256;
    public static final int VALUE_SIG_GEN_272 = 272;
    public static final int VALUE_SIG_GEN_288 = 288;
    public static final int VALUE_SIG_GEN_289 = 289;
    public static final int VALUE_SIG_GEN_290 = 290;
    public static final int VALUE_SIG_GEN_292 = 292;
    public static final int VALUE_SIG_GEN_800 = 800;
    public static final int VALUE_SIG_GEN_802 = 802;
    public static final int VALUE_SIG_GEN_1091 = 1091;
    public static final int VALUE_SIG_GEN_1363 = 1363;
    public static final int VALUE_SIG_GEN_1123 = 1123;
    public static final int VALUE_SIG_GEN_1139 = 1139;
    public static final int VALUE_SIG_GEN_1667 = 1667;
    public static final int VALUE_CW_MODULATION = 0;
    public static final String TOPIC = "source";
    public static final String TOPIC_DISPLAY = "display.source";
    private static SigGenMeasurementSettings instance;
    private LongActuator reverseFundChannelPower = new LongActuator(this.getTopic(), "rfchPwr", Text.RFCH_Pwr, FactorConversion.createFixedPoint("dB", 1000));
    private LongActuator amplitude = (LongActuator)this.add(new LongActuator("source", "srcAmp", Text.Amplitude, new FactorConversion("dBm", 1000L)));
    private LongActuator amplitudeStep = (LongActuator)this.add(new LongActuator("display.source", "ampStep", Text.Ampl_Step, new FactorConversion("dB", 1000L)));
    private LongActuator pnOffset = (LongActuator)this.add(new LongActuator("source", "pilotId", Text.PN_Offset, 0L));
    private ListActuator rfOnOff = new ListActuator("source", "pwrOnOff", Text.RF, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private ListActuator modulationFormat = new ListActuator("source", "modulation", Text.Format, this.getValidValues());
    private LongActuator rfOutLoss = LongActuator.createLoss("source", "rfOutLoss", Text.RF_OUT_Loss, 0);
    private LongActuator stashedLoss = LongActuator.createStashingLoss("display.source", "rfOutLoss", 0);
    private ListActuator lossToggle = new ListActuator("display.global", "lossToggle", Text.RF_OUT_Loss, this.createOnOffValueSet());
    private FrequencyActuator centerFrequency = CenterFrequencyActuator.createCenterFrequencyActuator("source", "srcCf");
    private FrequencyActuator freqStep = new FrequencyActuator("display.source", "srcFreqStep", Text.Freq_Step);
    private LongActuator chanStep = new LongActuator("display.source", "srcChanStep", Text.Chan_Step, 1L);
    private ListActuator backgroundMode = new ListActuator("source", "backgroundMode", Text.Persist_n_Sig_Gen, new ValueInterface[]{Value.createValue(Text.Yes, 1), Value.createValue(Text.No, 0)});
    private ListActuator arbFileLocation = new ListActuator("display.source", "arbFileLocation", Text.File_n_Location, new Value[]{Value.createValue(Text.PCMCIA, 0), Value.createValue(Text.CF, 1)});
    private final StringActuator arbFilenameActuator = StringActuator.makeStringActuator("display.source", "arbFileName", "Arb Filename", Text.Arb_File);
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public SigGenMeasurementSettings() {
        super("source");
        this.amplitude.setValidator(new RangeValidator(-200000L, 200000L, 2));
        this.amplitude.setPalette(Palette.createSignedDecimal());
        this.amplitudeStep.setValidator(new RangeValidator(100L, 50000L, 2));
        this.amplitude.setIncrement(1000);
        this.amplitudeStep.setPalette(Palette.createUnsignedDecimal());
        this.amplitudeStep.addValueListener(new ValueListener(){
            private final String listenerName = "SigGen.amplitudeStepListener";

            public String getListenerName() {
                return "SigGen.amplitudeStepListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SigGenMeasurementSettings.this.amplitude.setIncrement(valueInterface.intValue());
            }
        });
        this.amplitudeStep.setIncrement(1000);
        this.pnOffset.setValidator(new RangeValidator(0L, 511L));
        this.reverseFundChannelPower.setPalette(Palette.createSignedDecimal());
        this.add(this.rfOnOff);
        this.add(this.modulationFormat);
        this.add(this.centerFrequency);
        this.add(this.freqStep);
        this.add(this.chanStep);
        this.add(this.backgroundMode);
        this.add(this.reverseFundChannelPower);
        this.add(this.rfOutLoss);
        this.add(this.stashedLoss);
        this.add(this.lossToggle);
        this.add(this.arbFileLocation);
        this.add(this.arbFilenameActuator);
        this.setValidatorToFreqSrcLimits(this.centerFrequency);
        this.backgroundMode.setValue(0);
        this.freqStep.setValidator(new RangeValidator(1000L, 1000000000L));
        this.freqStep.setIncrement(1000);
        this.freqStep.setPalette(Palette.createUnsignedDecimal());
        this.chanStep.setValidator(new RangeValidator(1L, 100L));
        this.makeStashedLossActuatorSet(this.lossToggle, this.rfOutLoss, this.stashedLoss, "SigGen.RfOutLossListener");
        this.configureCenterFrequency();
        ValueListener valueListener = new ValueListener(){
            private final String listenerName = "SigGen.cfListener";

            public String getListenerName() {
                return "SigGen.cfListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SigGenMeasurementSettings.this.configureCenterFrequency();
            }
        };
        DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
        displayGlobalMeasurementSettings.getChanFreqUnits().addValueListener(valueListener);
        displayGlobalMeasurementSettings.getChanStd().addValueListener(valueListener);
        this.freqStep.addValueListener(valueListener);
        this.chanStep.addValueListener(valueListener);
        this.refresh();
    }

    public static SigGenMeasurementSettings instance() {
        if (instance == null) {
            instance = new SigGenMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    private ValueInterface[] getValidValues() {
        Vector<Value> vector = new Vector<Value>();
        MeasurementFactory measurementFactory = MeasurementFactory.instance();
        boolean bl = measurementFactory.measurementAvailable("cdma1xEvdoAn");
        boolean bl2 = measurementFactory.optionAvailable("cdmaSource");
        vector.addElement(Value.createValue(Text.SIG_GEN_MOD_0_SHORT, Text.SIG_GEN_MOD_0_LONG, 0));
        if (bl2) {
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_256_SHORT, Text.SIG_GEN_MOD_256_LONG, 256));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_272_SHORT, Text.SIG_GEN_MOD_272_LONG, 272));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_288_SHORT, Text.SIG_GEN_MOD_288_LONG, 288));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_289_SHORT, Text.SIG_GEN_MOD_289_LONG, 289));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_290_SHORT, Text.SIG_GEN_MOD_290_LONG, 290));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_292_SHORT, Text.SIG_GEN_MOD_292_LONG, 292));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_800_SHORT, Text.SIG_GEN_MOD_800_LONG, 800));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_802_SHORT, Text.SIG_GEN_MOD_802_LONG, 802));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_1363_SHORT, Text.SIG_GEN_MOD_1363_LONG, 1363));
        }
        if (bl && bl2) {
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_1091_SHORT, Text.SIG_GEN_MOD_1091_LONG, 1091));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_1123_SHORT, Text.SIG_GEN_MOD_1123_LONG, 1123));
            vector.addElement(Value.createValue(Text.SIG_GEN_MOD_1139_SHORT, Text.SIG_GEN_MOD_1139_LONG, 1139));
        }
        Object[] objectArray = new Value[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setValidModulationFormats() {
        this.modulationFormat.setValueList(this.getValidValues());
    }

    private void configureCenterFrequency() {
        if (DisplayGlobalMeasurementSettings.instance().isChannelSelected()) {
            this.centerFrequency.configureForChannels(Text.Channel, BandSelector.getGlobalBandSelector(), this.chanStep);
            this.setChannelIncrement(this.getChanStep());
        } else {
            this.centerFrequency.configureForFreq(Text.Frequency);
            this.centerFrequency.setIncrement(this.getFrequencyStep().intValue());
        }
    }

    private void setChannelIncrement(LongActuator longActuator) {
        long l = Band.getCurrentBand(DisplayGlobalMeasurementSettings.instance().getChanStd().intValue()).getBandSegments()[0].getChannelBandWidth();
        this.getCenterFrequency().setIncrement((int)((long)longActuator.intValue() * l));
    }

    public LongActuator getAmplitude() {
        return this.amplitude;
    }

    public LongActuator getAmplitudeStep() {
        return this.amplitudeStep;
    }

    public LongActuator getPNOffset() {
        return this.pnOffset;
    }

    public ListActuator getRFOnOff() {
        return this.rfOnOff;
    }

    public ListActuator getModulationFormat() {
        return this.modulationFormat;
    }

    public LongActuator getRfOutLoss() {
        return this.rfOutLoss;
    }

    public FrequencyActuator getCenterFrequency() {
        return this.centerFrequency;
    }

    public FrequencyActuator getFrequencyStep() {
        return this.freqStep;
    }

    public LongActuator getChanStep() {
        return this.chanStep;
    }

    public LongActuator getRfchPwr() {
        return this.reverseFundChannelPower;
    }

    public boolean isCwModulated() {
        return this.getModulationFormat().intValue() == 0;
    }

    public boolean isArbPlayback() {
        return this.getModulationFormat().intValue() == 1091;
    }

    public ListActuator getBackgroundMode() {
        return this.backgroundMode;
    }

    public ListActuator getLossToggle() {
        return this.lossToggle;
    }

    public LongActuator getStashedLoss() {
        return this.stashedLoss;
    }

    public ListActuator getArbFileLocation() {
        return this.arbFileLocation;
    }

    public void setDataFilename(String string) {
        this.arbFilenameActuator.setValue(string);
    }

    public String getArbFilename() {
        return this.arbFilenameActuator.toString();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public String getString(String string) {
        try {
            Actuator actuator = this.get(string);
            if (actuator == null) {
                return "";
            }
            return actuator.toString();
        }
        catch (Exception exception) {
            MeasurementSettings.logger.error("Unable to get actuator for key " + string);
            return "";
        }
    }
}

