/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.sigGen;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuMgr;
import elgato.infrastructure.menu.SigGenButtonFactory;
import elgato.infrastructure.menu.TimeFreqRefButtonFactory;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.sigGen.SigGenScreen;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JLabel;

public abstract class SigGenMenuMgr
extends MenuMgr {
    private final Logger logger = LogManager.getLogger(class$elgato$measurement$sigGen$SigGenScreen == null ? (class$elgato$measurement$sigGen$SigGenScreen = SigGenMenuMgr.class$("elgato.measurement.sigGen.SigGenScreen")) : class$elgato$measurement$sigGen$SigGenScreen);
    final SigGenMeasurementSettings settings;
    private ActuatorEditor freqChannelButton;
    private ActuatorEditor freqChanStepButton;
    protected MenuItem modulationButton;
    protected ListActuatorButton modulationFormatButton;
    protected ActuatorEditor reverseFundamentalChannelPowerButton;
    protected ActuatorEditor pnOffsetButton;
    protected final ValueListener unitsChangedListener = new ValueListener(){
        private final String listenerName = "SigGenScreen.unitsChangedListener";

        public String getListenerName() {
            return "SigGenScreen.unitsChangedListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SigGenMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(SigGenMenuMgr.this.createFreqChanStepButton(), 1);
            SigGenMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaint();
        }
    };
    protected final ValueListener modulationListener = new ValueListener(){
        private final String listenerName = "SigGenScreen.modulationListener";

        public String getListenerName() {
            return "SigGenScreen.modulationListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = !SigGenMeasurementSettings.instance().isCwModulated() && !SigGenMeasurementSettings.instance().isArbPlayback();
            SigGenMenuMgr.this.pnOffsetButton.setEnabled(bl);
            SigGenMenuMgr.this.setRevFundEnabled(valueInterface);
        }
    };
    static /* synthetic */ Class class$elgato$measurement$sigGen$SigGenScreen;

    protected void setRevFundEnabled(ValueInterface valueInterface) {
        boolean bl = this.isCdmaOaModulation(valueInterface);
        this.reverseFundamentalChannelPowerButton.setEnabled(bl);
    }

    private boolean isCdmaOaModulation(ValueInterface valueInterface) {
        return valueInterface.intValue() == 800 || valueInterface.intValue() == 802;
    }

    public SigGenMenuMgr(SigGenScreen sigGenScreen, SigGenMeasurementSettings sigGenMeasurementSettings) {
        super(sigGenScreen);
        this.settings = sigGenMeasurementSettings;
        this.createMiscButtons();
    }

    protected abstract MenuItem createFreqChanButton();

    protected abstract MenuButton createLevelButton();

    protected abstract MenuItem createModulationButton();

    Menu buildLeftMenu() {
        return new Menu(Text.Sig_Gen, new MenuItem[]{this.createFreqChanButton(), this.createLevelButton(), this.createModulationButton(), null, null, null, null});
    }

    public void prolog() {
        this.setRevFundEnabled(this.settings.getModulationFormat().getSelectedValue());
        DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().addValueListener(this.unitsChangedListener);
        this.settings.getModulationFormat().addValueListener(this.modulationListener);
    }

    public void cleanup() {
        DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().removeValueListener(this.unitsChangedListener);
        this.settings.getModulationFormat().removeValueListener(this.modulationListener);
    }

    private void createMiscButtons() {
        this.freqChannelButton = SigGenButtonFactory.createFrequencyButton(this.scn);
        this.freqChanStepButton = this.createFreqChanStepButton();
        this.modulationFormatButton = SigGenButtonFactory.createModulationFormatButton(this.scn, Text.Format);
        this.pnOffsetButton = this.createPnOffsetButton();
        this.reverseFundamentalChannelPowerButton = this.createFundamentalChannelPowerButton();
    }

    protected Menu createLevelMenu() {
        return new Menu(Text.Amplitude, new MenuItem[]{SigGenButtonFactory.createRfButton(this.scn), SigGenButtonFactory.createAmplitudeButton(this.scn), this.createAmplitudeStepButton(), null, null, null, SigGenButtonFactory.createLossButton(this.scn)}, 1);
    }

    ActuatorEditor createAmplitudeStepButton() {
        return new ActuatorEditor(SigGenMeasurementSettings.instance().getAmplitudeStep(), this.getContextString("amplitude.step"), this.getListenerBaseName() + ".amplitudeStep");
    }

    ActuatorEditor createFreqChanStepButton() {
        if (DisplayGlobalMeasurementSettings.instance().isChannelSelected()) {
            return new ActuatorEditor(SigGenMeasurementSettings.instance().getChanStep(), this.getContextString("channel.step"), this.getListenerBaseName() + ".chanStep");
        }
        return new ActuatorEditor(SigGenMeasurementSettings.instance().getFrequencyStep(), this.getContextString("frequency.step"), this.getListenerBaseName() + ".freqStep");
    }

    public Menu createRightMenuWithTimeRef(ScreenManager screenManager) {
        return new Menu(Text.Freq_slash_Chan, new MenuItem[]{this.freqChannelButton, this.freqChanStepButton, TimeFreqRefButtonFactory.createTimeFreqRefButton(this.getListenerBaseName()), SigGenButtonFactory.createPersistButton(this.scn, Text.Persist_n_Sig_Gen), null, FrequencyChannelButtonFactory.createChanStdSelectButton(this.getContextString("chan.std"), this.getListenerBaseName()), MeasurementScreen.createFreqChanUnitsButton(this.getListenerBaseName() + ".freqChanUnitsButton")}, 0);
    }

    protected ActuatorEditor createFundamentalChannelPowerButton() {
        return new ActuatorEditor(SigGenMeasurementSettings.instance().getRfchPwr(), this.getContextString("rfchPwr"), this.getListenerBaseName() + ".rfChPwrButton");
    }

    ActuatorEditor createPnOffsetButton() {
        ActuatorEditor actuatorEditor = new ActuatorEditor(SigGenMeasurementSettings.instance().getPNOffset(), this.getContextString("pnOffset"), this.getListenerBaseName() + ".pnOffsetButton");
        boolean bl = !SigGenMeasurementSettings.instance().isCwModulated() && !SigGenMeasurementSettings.instance().isArbPlayback();
        actuatorEditor.setEnabled(bl);
        return actuatorEditor;
    }

    protected String getMeasurementName() {
        return "adjChan";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class UnderliningJLabel
    extends JLabel {
        private boolean underline;

        public UnderliningJLabel(String string) {
            super(string);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.underline) {
                graphics.setColor(this.getForeground());
                graphics.setFont(this.getFont());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.fillRect(0, fontMetrics.getAscent() + 2, this.getSize().width, 3);
            }
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public void setUnderline(boolean bl) {
            this.underline = bl;
        }
    }
}

