/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.sigGen;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.OptionSecurity;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.HydroBorder;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.measurement.sigGen.SigGenMeasurementSettings;
import elgato.measurement.sigGen.SigGenMenuMgr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;

public class SigGenScreen
extends Screen
implements OptionSecurity {
    private static final Resources res = Resources.getResources((class$elgato$measurement$sigGen$SigGenScreen == null ? (class$elgato$measurement$sigGen$SigGenScreen = SigGenScreen.class$("elgato.measurement.sigGen.SigGenScreen")) : class$elgato$measurement$sigGen$SigGenScreen).getName());
    SigGenMenuMgr menuMgr;
    private DisplayPanel display;
    private final SigGenMeasurementSettings settings = SigGenMeasurementSettings.instance();
    static /* synthetic */ Class class$elgato$measurement$sigGen$SigGenScreen;

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.createMenuMgr();
        DisplayGlobalMeasurementSettings.instance().refresh();
        this.settings.refresh();
        screenManager.installLeftMenu(this.buildLeftMenu());
        this.pressHomeButton();
        this.menuMgr.prolog();
        this.display = new DisplayPanel(res.getBorderConfig("subpanelBorder"));
        BorderWrapper borderWrapper = new BorderWrapper(this.display, res.getBorderConfig("border"), true);
        MeasurementFactory.instance().getCommandProcessor().setActive(this.getTopic());
        screenManager.installDisplay(borderWrapper);
    }

    public void uninstallScreen(ScreenManager screenManager) {
        this.display.dispose();
        this.menuMgr.cleanup();
        MeasurementFactory.instance().getCommandProcessor().setInactive();
    }

    protected SigGenMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createSigGenMenuMgr(this, this.settings);
        return this.menuMgr;
    }

    private String getTopic() {
        return "source";
    }

    Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    public boolean modulationAvailable() {
        return MeasurementFactory.instance().optionAvailable("cdmaSource");
    }

    public String optionName() {
        return this.getTopic();
    }

    public SigGenMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DisplayPanel
    extends JPanel
    implements ValueListener {
        private Font labelFont = new Font("SansSerif", 1, 24);
        private Font bigValueFont = new Font("SansSerif", 0, 24);
        private Font smallValueFont = new Font("SansSerif", 0, 16);
        private JLabel freqChanLabel;
        private JLabel freqChanValue;
        private JLabel amplitudeValue;
        private JLabel modulationValue;
        private JLabel outLossTextAndValue;
        private SigGenMenuMgr.UnderliningJLabel rfOffButton;
        private SigGenMenuMgr.UnderliningJLabel rfOnButton;
        private final FrequencyActuator freqChan = SigGenMeasurementSettings.instance().getCenterFrequency();
        private final LongActuator amplitude = SigGenMeasurementSettings.instance().getAmplitude();
        private final ListActuator rfOnOff = SigGenMeasurementSettings.instance().getRFOnOff();
        private final ListActuator modulationFormat = SigGenMeasurementSettings.instance().getModulationFormat();
        private final LongActuator rfOutLoss = SigGenMeasurementSettings.instance().getRfOutLoss();
        private final String listenerName = "SigGenScreen.DisplayPanel.listener";

        DisplayPanel(HydroBorderPainterConfig hydroBorderPainterConfig) {
            super(new TableLayout(new float[][]{{0.5f, -1.0f}, {-1.0f, 0.25f, 0.25f}}));
            Color color = hydroBorderPainterConfig.getBackgroundColor();
            this.setBackground(null);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), new HydroBorder(hydroBorderPainterConfig, true)), BorderFactory.createEmptyBorder(4, 4, 4, 4));
            JPanel jPanel = new JPanel(new TableLayout(new float[][]{{-1.0f}, {0.1f, 0.3f, 0.3f, -1.0f}}));
            jPanel.setBorder(compoundBorder);
            jPanel.setBackground(color);
            this.freqChanLabel = this.newLabelLabel("");
            jPanel.add((Component)this.freqChanLabel, "0, 1");
            this.freqChanValue = this.newValueLabel(this.bigValueFont);
            jPanel.add((Component)this.freqChanValue, "0, 2");
            this.add((Component)jPanel, "0,0");
            JPanel jPanel2 = new JPanel(new TableLayout(new float[][]{{-1.0f}, {0.1f, 0.3f, 0.3f, -1.0f}}));
            jPanel2.setBorder(compoundBorder);
            jPanel2.setBackground(color);
            jPanel2.add((Component)this.newLabelLabel(Text.Amplitude), "0, 1");
            this.amplitudeValue = this.newValueLabel(this.bigValueFont);
            jPanel2.add((Component)this.amplitudeValue, "0, 2");
            this.outLossTextAndValue = this.newValueLabel(this.smallValueFont);
            jPanel2.add((Component)this.outLossTextAndValue, "0, 4");
            this.add((Component)jPanel2, "1,0");
            JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
            jPanel3.setBorder(compoundBorder);
            jPanel3.setBackground(color);
            jPanel3.add(this.newLabelLabel(Text.Modulation + " " + Text.Format));
            this.modulationValue = this.newValueLabel(this.smallValueFont);
            jPanel3.add(this.modulationValue);
            this.add((Component)jPanel3, "0,1,1,1");
            JPanel jPanel4 = new JPanel(new TableLayout(new float[][]{{-1.0f, 20.0f, -1.0f}, {0.5f, -1.0f}}));
            jPanel4.setBorder(compoundBorder);
            jPanel4.setBackground(color);
            jPanel4.add((Component)this.newLabelLabel(Text.RF), "0,0,2,0");
            this.rfOnButton = new SigGenMenuMgr.UnderliningJLabel(Text.On);
            jPanel4.add((Component)this.rfOnButton, "0,1,r,c");
            this.rfOnButton.setForeground(Color.white);
            this.rfOnButton.setBackground(color);
            this.rfOnButton.setFont(this.bigValueFont);
            this.rfOffButton = new SigGenMenuMgr.UnderliningJLabel(Text.Off);
            jPanel4.add((Component)this.rfOffButton, "2,1,l,c");
            this.rfOffButton.setForeground(Color.white);
            this.rfOffButton.setBackground(color);
            this.rfOffButton.setFont(this.bigValueFont);
            this.add((Component)jPanel4, "0,2,1,2");
            this.freqChan.addValueListener(this);
            this.amplitude.addValueListener(this);
            this.rfOnOff.addValueListener(this);
            this.modulationFormat.addValueListener(this);
            this.rfOutLoss.addValueListener(this);
            this.updateLabels();
        }

        public void dispose() {
            this.freqChan.removeValueListener(this);
            this.amplitude.removeValueListener(this);
            this.rfOnOff.removeValueListener(this);
            this.modulationFormat.removeValueListener(this);
            this.rfOutLoss.removeValueListener(this);
        }

        private JLabel newLabelLabel(String string) {
            JLabel jLabel = new JLabel(string, 0);
            jLabel.setFont(this.labelFont);
            jLabel.setForeground(Color.white);
            jLabel.setBackground(null);
            return jLabel;
        }

        private JLabel newValueLabel(Font font) {
            JLabel jLabel = new JLabel("", 0);
            jLabel.setFont(font);
            jLabel.setForeground(Color.white);
            jLabel.setBackground(null);
            return jLabel;
        }

        private void updateLabels() {
            this.freqChanLabel.setText(this.freqChan.getLabel());
            this.freqChanValue.setText(this.freqChan.toString());
            this.amplitudeValue.setText(this.amplitude.toString());
            this.modulationValue.setText(this.modulationFormat.getSelectedValue().getLongLabel());
            this.outLossTextAndValue.setText(Text.RF_OUT_Loss + " " + this.rfOutLoss);
            boolean bl = this.rfOnOff.intValue() != 0;
            this.selectRadioButton(this.rfOffButton, !bl);
            this.selectRadioButton(this.rfOnButton, bl);
            boolean bl2 = this.freqChan.longValue() != 0L;
            this.setVisible(bl2);
        }

        private void selectRadioButton(SigGenMenuMgr.UnderliningJLabel underliningJLabel, boolean bl) {
            underliningJLabel.setUnderline(bl);
        }

        public String getListenerName() {
            return "SigGenScreen.DisplayPanel.listener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            this.updateLabels();
            this.repaint();
        }
    }

    static class ModulationFormat {
        static final EListCellRenderer renderer = new DefaultEListCellRenderer(){

            protected String stringValue(Object object) {
                return ((ModulationFormat)object).getLongName();
            }
        };
        private final int formatID;
        private final String shortName;
        private final String longName;

        public ModulationFormat(int n, String string, String string2) {
            this.formatID = n;
            this.shortName = string;
            this.longName = string2;
        }

        public int getFormatID() {
            return this.formatID;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getLongName() {
            return this.longName;
        }

        public String toString() {
            return this.shortName;
        }
    }
}

