/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.LabelOnlyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.strategies.SuffixedFixedPointNumberFieldStrategy;
import elgato.infrastructure.util.Text;
import elgato.measurement.spectrum.SpectrumMeasurement;

class IaMetrics
extends BasicMeasurementMetrics {
    static final NumberFieldStrategy dBm = new DecibelStrategy(1, true);
    static final NumberFieldStrategy freq = FrequencyStrategy.createWithMaxDecimalPlaces(5);
    static final NumberFieldStrategy labelOnly = new LabelOnlyStrategy();
    private static final long MEASUREMENT_NOT_MADE = Integer.MIN_VALUE;
    private static NumberFieldStrategy[] suffixedfixedPointArr = new SuffixedFixedPointNumberFieldStrategy[]{new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0), new SuffixedFixedPointNumberFieldStrategy(0)};
    static final float[] tableColumnWidths = new float[]{0.28f, -1.0f, -1.0f};

    public IaMetrics() {
        super(tableColumnWidths);
    }

    public void dispose() {
        super.dispose();
    }

    protected ValueSource[][] createValueSources() {
        FrequencyValueSource frequencyValueSource = new FrequencyValueSource(Text.Freq, freq);
        LabelOnlyValueSource labelOnlyValueSource = new LabelOnlyValueSource("Signal Pointer:", labelOnly);
        LabelOnlyValueSource labelOnlyValueSource2 = new LabelOnlyValueSource("Possible Signals:", labelOnly);
        LevelValueSource levelValueSource = new LevelValueSource(Text.Lev, dBm);
        PossSignalValueSource possSignalValueSource = new PossSignalValueSource("----", suffixedfixedPointArr[0], 0);
        PossSignalValueSource possSignalValueSource2 = new PossSignalValueSource("----", suffixedfixedPointArr[1], 1);
        PossSignalValueSource possSignalValueSource3 = new PossSignalValueSource("----", suffixedfixedPointArr[2], 2);
        PossSignalValueSource possSignalValueSource4 = new PossSignalValueSource("----", suffixedfixedPointArr[3], 3);
        PossSignalValueSource possSignalValueSource5 = new PossSignalValueSource("----", suffixedfixedPointArr[4], 4);
        PossSignalValueSource possSignalValueSource6 = new PossSignalValueSource("----", suffixedfixedPointArr[5], 5);
        PossSignalValueSource possSignalValueSource7 = new PossSignalValueSource("----", suffixedfixedPointArr[6], 6);
        return new ValueSource[][]{{labelOnlyValueSource, frequencyValueSource, levelValueSource}, {labelOnlyValueSource2, possSignalValueSource, possSignalValueSource2, possSignalValueSource3}, {possSignalValueSource4, possSignalValueSource5, possSignalValueSource6, possSignalValueSource7}};
    }

    protected int getBarLeftMargin() {
        return 3;
    }

    protected int getBarRightMargin() {
        return 2;
    }

    private SpectrumMeasurement getSpectrumMeasurement() {
        return (SpectrumMeasurement)this.getMeasurement();
    }

    private class LevelValueSource
    extends ValueSource {
        public LevelValueSource(String string, NumberFieldStrategy numberFieldStrategy) {
            super(string, numberFieldStrategy, true);
        }

        protected long getRawValue() {
            SpectrumMeasurement spectrumMeasurement = IaMetrics.this.getSpectrumMeasurement();
            long l = spectrumMeasurement.getIaCf();
            if (l != Integer.MIN_VALUE) {
                int n = spectrumMeasurement.getIndexForXValue(l);
                if (n >= 0 && n <= spectrumMeasurement.getTraceLength() - 1) {
                    return spectrumMeasurement.getTrace()[n];
                }
                return -333000L;
            }
            return -333000L;
        }
    }

    private class FrequencyValueSource
    extends ValueSource {
        public FrequencyValueSource(String string, NumberFieldStrategy numberFieldStrategy) {
            super(string, numberFieldStrategy, true);
        }

        protected long getRawValue() {
            return IaMetrics.this.getSpectrumMeasurement().getIaCf();
        }
    }

    private class PossSignalValueSource
    extends ValueSource {
        private int identity;
        private NumberFieldStrategy strategy;

        public PossSignalValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.strategy = numberFieldStrategy;
            this.identity = n;
        }

        protected long getRawValue() {
            SpectrumMeasurement.IaResult[] iaResultArray = IaMetrics.this.getSpectrumMeasurement().getIaResults();
            this.setLabel(iaResultArray[this.identity].getNetworkStdName());
            ((SuffixedFixedPointNumberFieldStrategy)this.strategy).setSuffix(iaResultArray[this.identity].getSuffix());
            return iaResultArray[this.identity].getChanNum();
        }
    }

    private class LabelOnlyValueSource
    extends ValueSource {
        public LabelOnlyValueSource(String string, NumberFieldStrategy numberFieldStrategy) {
            super(string, numberFieldStrategy, true);
        }

        protected long getRawValue() {
            return 999L;
        }
    }
}

