/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import java.awt.Component;
import java.util.Vector;

class ObwMetrics
extends MeasurementMetrics {
    private Measurement meas;
    static final FrequencyStrategy freq = FrequencyStrategy.createWithMaxDecimalPlaces(3);
    static final NumberFieldStrategy dBm = new DecibelStrategy(1, true);
    private Vector labels = new Vector();

    ObwMetrics() {
        this.setLayout(new TableLayout(new float[][]{{0.48f, 0.04f, 0.48f}, {25.0f, 25.0f}}));
        this.add((Component)new ELabel(Text.Occupied_BW, this.labelColor, this.labelFont, 4, 2), "0, 0, f, c");
        this.add((Component)this.addLabel(new DynamicLabel(3, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                return freq.format(measurement.getLongReadingValue(4));
            }
        }), "2, 0, f, c");
        this.add((Component)new ELabel(Text.Occupied_PWR, this.labelColor, this.labelFont, 4, 2), "0, 1, f, c");
        this.add((Component)this.addLabel(new DynamicLabel(3, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                return dBm.format(measurement.getLongReadingValue(5));
            }
        }), "2, 1, f, c");
    }

    public void dispose() {
        this.labels.removeAllElements();
        this.labels = null;
        this.removeAll();
        this.meas = null;
    }

    private DynamicLabel addLabel(DynamicLabel dynamicLabel) {
        this.getLabels().addElement(dynamicLabel);
        return dynamicLabel;
    }

    public Vector getLabels() {
        return this.labels;
    }

    public void setMeasurement(Measurement measurement) {
        this.meas = measurement;
        DynamicLabel.updateLabelsForMeasurement(this.getLabels(), measurement);
    }

    public TabDelimitable[] getTabDelimitables() {
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[2];
        ObwValueSource obwValueSource = new ObwValueSource(Text.Occupied_BW, freq, 4);
        tabDelimitableArray[0] = obwValueSource;
        ObwValueSource obwValueSource2 = new ObwValueSource(Text.Occupied_PWR, dBm, 5);
        tabDelimitableArray[1] = obwValueSource2;
        return tabDelimitableArray;
    }

    private class ObwValueSource
    extends ValueSource {
        private NumberFieldStrategy strategy;
        private final String[] result = new String[2];
        private int id;

        public ObwValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.strategy = numberFieldStrategy;
            this.id = n;
            this.result[0] = "";
            this.result[1] = "";
        }

        protected long getRawValue() {
            return ObwMetrics.this.meas.getLongReadingValue(this.id);
        }

        public String toTabDelimitedString() {
            this.strategy.formatWithUnits(this.cookValue(this.getRawValue()), this.result);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLabel()).append('\t').append(this.result[0]);
            stringBuffer.append('\t').append(this.result[1]);
            return stringBuffer.toString();
        }
    }
}

