/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JPanel;

public class SemMetrics
extends MeasurementMetrics {
    private Measurement meas;
    static final NumberFieldStrategy dBm = new DecibelStrategy(1, true);
    private Vector labels = new Vector();
    private Font unsupportChanStdLabelFont = new Font("SansSerif", 2, 12);
    ELabel unsupportedChanStdLabel = new ELabel(Text.SEM_UnsupportedStd_Note, Color.red, this.unsupportChanStdLabelFont, 2, 2);

    SemMetrics() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new TableLayout(new float[][]{{0.48f, 0.04f, 0.48f}, {12.5f, 25.0f, 12.5f}}));
        jPanel.add((Component)new ELabel(Text.Ref_PWR, this.labelColor, this.labelFont, 4, 2), "0, 1, f, c");
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, this.valueColor, this.valueFont){

            protected String formatValue(Measurement measurement) {
                return dBm.format(measurement.getLongReadingValue(5));
            }
        }), "2, 1, f, c");
        this.add((Component)jPanel, "North");
        this.add((Component)this.unsupportedChanStdLabel, "South");
    }

    private DynamicLabel addLabel(DynamicLabel dynamicLabel) {
        this.getLabels().addElement(dynamicLabel);
        return dynamicLabel;
    }

    public Vector getLabels() {
        return this.labels;
    }

    public void dispose() {
        this.labels.removeAllElements();
        this.remove(this.unsupportedChanStdLabel);
        this.unsupportedChanStdLabel = null;
        this.removeAll();
        this.meas = null;
    }

    public void setMeasurement(Measurement measurement) {
        this.meas = measurement;
        DynamicLabel.updateLabelsForMeasurement(this.getLabels(), measurement);
    }

    public TabDelimitable[] getTabDelimitables() {
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[1];
        SemValueSource semValueSource = new SemValueSource(Text.Ref_PWR, dBm, 5);
        tabDelimitableArray[0] = semValueSource;
        return tabDelimitableArray;
    }

    private class SemValueSource
    extends ValueSource {
        private NumberFieldStrategy strategy;
        private final String[] result = new String[1];
        private int id;

        public SemValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n) {
            super(string, numberFieldStrategy, true);
            this.strategy = numberFieldStrategy;
            this.id = n;
            this.result[0] = "";
        }

        protected long getRawValue() {
            return SemMetrics.this.meas.getLongReadingValue(this.id);
        }

        public String toTabDelimitedString() {
            this.strategy.formatWithUnits(this.cookValue(this.getRawValue()), this.result);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLabel()).append('\t').append(this.result[0]);
            return stringBuffer.toString();
        }
    }
}

