/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.widgets.ImageIcon;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class Spectrogram
extends SpectralChart {
    private final Image arrowIconObwD = ImageIcon.loadImage("images/ObwMarkerD.png", new Canvas());
    private final Image arrowIconObwU = ImageIcon.loadImage("images/ObwMarkerU.png", new Canvas());
    private final Image arrowIconIaD = ImageIcon.loadImage("images/IaMarker.png", new Canvas());
    private final Image arrowIconIaU = ImageIcon.loadImage("images/IaMarkerU.png", new Canvas());
    private int obwIndexStart;
    private int obwIndexStop;
    private int iaSignal;
    private int traceLength;

    public Spectrogram(int n) {
        super(n);
        this.traceLength = n;
        this.obwIndexStart = -1;
        this.obwIndexStop = -1;
        this.iaSignal = -1;
    }

    public void drawExtras(Graphics graphics) {
        if (this.obwIndexStart != -1) {
            this.drawTracker(graphics, this.obwIndexStart, this.arrowIconObwD, this.arrowIconObwU);
            this.drawTracker(graphics, this.obwIndexStop, this.arrowIconObwD, this.arrowIconObwU);
        }
        if (this.iaSignal != -1) {
            this.drawTracker(graphics, this.iaSignal, this.arrowIconIaD, this.arrowIconIaU);
        }
    }

    public void setObw(int n, int n2) {
        this.obwIndexStart = n;
        this.obwIndexStop = n2;
    }

    public void setIa(int n) {
        this.iaSignal = n;
    }

    public void drawTracker(Graphics graphics, int n, Image image, Image image2) {
        int n2 = this.getImageLeft() + n * this.getImageWidth() / (this.traceLength - 1) + this.getImageWidth() / (this.traceLength - 1) / 2;
        int n3 = n2 - image.getWidth(null) / 2;
        int n4 = this.getImageTop();
        int n5 = this.getImageHeight() + this.getImageTop();
        graphics.drawImage(image, n3, n4 - image.getHeight(null), null);
        graphics.drawImage(image2, n3, n5, null);
        graphics.setColor(Color.gray);
        graphics.drawLine(n2, n4, n2, n5);
    }
}

