/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.analyzer.SpectralChartPanel;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.marker.IndexSteppingValidator;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.spectrum.IaMetrics;
import elgato.measurement.spectrum.ObwMetrics;
import elgato.measurement.spectrum.SemMetrics;
import elgato.measurement.spectrum.Spectrogram;
import elgato.measurement.spectrum.SpectrumLineChart;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SpectrumAnalyzer
extends TraceAnalyzer {
    private SpectrumMeasurement measurement;
    private TraceChart chart;
    private SpectrumLineChart spectogramChart;
    private JPanel mainPanel;
    private JPanel chartCard;
    private JPanel bottomPanel;
    private final NumberFieldStrategy decibelStrategy = new DecibelStrategy(1, true);
    private final NumberFieldStrategy deltaDecibelStrategy = new DecibelStrategy(1, false);
    private final NumberFieldStrategy freqStrategyTraceSave = new NumberFieldStrategy("Hz");
    private final String CARD_SPECTRUM = "spectrum";
    private final String CARD_SPECTROGRAM = "spectrogram";
    private CardLayout cardLayout;
    private Container cardPanel;
    Container spectrumTracePanel;
    private Spectrogram spectrogram;
    private JComponent topView1;
    private JComponent topView2;
    private JComponent topView;
    private IaMetrics iaMetrics;
    private ObwMetrics obwMetrics;
    private SemMetrics semMetrics;
    private Container iaMetricsPanel;
    private Container obwMetricsPanel;
    private Container semMetricsPanel;
    private ELabel startFrequencyLabel;
    private ELabel centerFrequencyLabel;
    private ELabel stopFrequencyLabel;
    private JPanel spectrumCard;
    private SpectralChartPanel spectralChartCard;
    private ELabel spectrogramTraceChartStartFreqLabel;
    private ELabel spectrogramTraceChartStopFreqLabel;
    private long lastSpectrogramTraceCapturedAt;
    private int spectrogramFrameCounter;
    IndexSteppingValidator iaCfValidatorIndexStepping;
    private static int textHeight = 15;
    private ValueListener startFrequencyValueListener = new ValueListener(){
        private final String listenerName = "SpectrumAnalyzer.startFreqValueListener";

        public String getListenerName() {
            return "SpectrumAnalyzer.startFreqValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            long l = valueInterface.longValue();
            String string = SpectrumAnalyzer.access$000().format(l);
            SpectrumAnalyzer.this.startFrequencyLabel.setChunk(0, string);
            SpectrumAnalyzer.this.spectrogramTraceChartStartFreqLabel.setChunk(0, string);
            SpectrumAnalyzer.this.chart.setXStart(l);
            SpectrumAnalyzer.this.spectralChartCard.setXStart(l);
            SpectrumAnalyzer.this.chart.repaint();
        }
    };
    private ValueListener centerFrequencyValueListener = new ValueListener(){
        private final String listenerName = "SpectrumAnalyzer.ctrFreqValueListener";

        public String getListenerName() {
            return "SpectrumAnalyzer.ctrFreqValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SpectrumAnalyzer.this.centerFrequencyLabel.setChunk(0, Text.Center + " " + SpectrumAnalyzer.access$500().format(valueInterface.longValue()));
        }
    };
    private ValueListener stopFrequencyValueListener = new ValueListener(){
        private final String listenerName = "SpectrumAnalyzer.stopFreqValueListener";

        public String getListenerName() {
            return "SpectrumAnalyzer.stopFreqValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            long l = valueInterface.longValue();
            String string = SpectrumAnalyzer.access$700().format(l);
            SpectrumAnalyzer.this.stopFrequencyLabel.setChunk(0, string);
            SpectrumAnalyzer.this.spectrogramTraceChartStopFreqLabel.setChunk(0, string);
            SpectrumAnalyzer.this.chart.setXStop(l);
            SpectrumAnalyzer.this.spectralChartCard.setXStop(l);
            SpectrumAnalyzer.this.chart.repaint();
        }
    };
    private ValueListener spectrogramEnabledListener = new ValueListener(){
        private final String listenerName = "SpectrumAnalyzer.spectrogramEnabledListener";

        public String getListenerName() {
            return "SpectrumAnalyzer.spectrogramEnabledListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SpectrumAnalyzer.this.updateViewMode();
        }
    };
    private ValueListener spectrogramPaletteListener = new ValueListener(){
        private final String listenerName = "SpectrumAnalyzer.spectogramPaletteListener";

        public String getListenerName() {
            return "SpectrumAnalyzer.spectogramPaletteListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            SpectrumAnalyzer.this.updateSpectrogramPalette();
        }
    };

    SpectrumAnalyzer() {
        super("SpectrumAnalyzer");
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        this.listenToActuator(spectrumMeasurementSettings.getRefLevel());
        this.listenToActuator(spectrumMeasurementSettings.getScaleDiv());
        this.listenToActuator(spectrumMeasurementSettings.getIaThreshold());
        this.listenToActuator(spectrumMeasurementSettings.getIaCf());
        this.startFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 3, 0);
        this.centerFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 2, 0);
        this.stopFrequencyLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT, 4, 0);
        Font font = new Font("SansSerif", 0, 9);
        this.spectrogramTraceChartStartFreqLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, font, 3, 0);
        this.spectrogramTraceChartStopFreqLabel = new ELabel("", TraceAnalyzer.VALUE_COLOR, font, 4, 0);
        this.mainPanel = new JPanel(new BorderLayout());
        this.spectrumTracePanel = new JPanel();
        this.spectrumTracePanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)new BorderWrapper(this.spectrumTracePanel, TraceAnalyzer.getChartBorder(), true), "Center");
        this.topView1 = this.makeTopPanel();
        this.topView2 = this.makeSecondPanel();
        this.topView = new JPanel(new GridLayout(0, 1));
        this.topView.setBackground(null);
        this.topView.add(this.topView1);
        this.topView.add(this.topView2);
        this.spectrumCard = this.makeSpectrumAnalyzerCard();
        this.spectrogram = new Spectrogram(256);
        this.spectogramChart = new SpectrumLineChart();
        this.spectralChartCard = new SpectralChartPanel(this.spectrogram, this.spectogramChart, this.spectrogramTraceChartStartFreqLabel, this.spectrogramTraceChartStopFreqLabel);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBackground(null);
        this.cardPanel.add((Component)this.spectrumCard, "spectrum");
        this.cardPanel.add((Component)this.spectralChartCard, "spectrogram");
        this.spectrumTracePanel.add((Component)this.topView, "North");
        this.spectrumTracePanel.add((Component)this.cardPanel, "Center");
        this.iaMetrics = new IaMetrics();
        this.obwMetrics = new ObwMetrics();
        this.semMetrics = new SemMetrics();
        this.iaMetricsPanel = new BorderWrapper(this.iaMetrics, MeasurementMetrics.BORDER, true);
        this.obwMetricsPanel = new BorderWrapper(this.obwMetrics, MeasurementMetrics.BORDER, true);
        this.semMetricsPanel = new BorderWrapper(this.semMetrics, MeasurementMetrics.BORDER, true);
        this.addValueListenerAndInitialize(spectrumMeasurementSettings.getStartFreq(), this.startFrequencyValueListener);
        this.addValueListenerAndInitialize(spectrumMeasurementSettings.getCenterFrequency(), this.centerFrequencyValueListener);
        this.addValueListenerAndInitialize(spectrumMeasurementSettings.getStopFreq(), this.stopFrequencyValueListener);
        this.updateChartVerticalRange();
        spectrumMeasurementSettings.getSpectrogramEnabled().addValueListener(this.spectrogramEnabledListener);
        spectrumMeasurementSettings.getSpectrogramPalette().addValueListener(this.spectrogramPaletteListener);
        this.updateSpectrogramPalette();
        this.updateViewMode();
        this.iaCfValidatorIndexStepping = new IndexSteppingValidator(this);
        spectrumMeasurementSettings.getIaCf().setValidator(this.iaCfValidatorIndexStepping);
    }

    private void updateMetricsView() {
        if (this.measurement.getSemOnOff() == 1) {
            if (!this.mainPanel.isAncestorOf(this.semMetricsPanel)) {
                this.mainPanel.remove(this.iaMetricsPanel);
                this.mainPanel.remove(this.obwMetricsPanel);
                this.mainPanel.add((Component)this.semMetricsPanel, "South");
                this.mainPanel.validate();
                this.semMetricsPanel.repaint();
            }
        } else if (this.mainPanel.isAncestorOf(this.semMetricsPanel)) {
            this.mainPanel.remove(this.semMetricsPanel);
            this.mainPanel.validate();
        }
        if (this.measurement.getObwOnOff() == 1) {
            if (!this.mainPanel.isAncestorOf(this.obwMetricsPanel)) {
                this.mainPanel.remove(this.iaMetricsPanel);
                this.mainPanel.remove(this.semMetricsPanel);
                this.mainPanel.add((Component)this.obwMetricsPanel, "South");
                this.mainPanel.validate();
                this.obwMetricsPanel.repaint();
            }
        } else if (this.mainPanel.isAncestorOf(this.obwMetricsPanel)) {
            this.mainPanel.remove(this.obwMetricsPanel);
            this.mainPanel.validate();
        }
        if (this.measurement.getIaOnOff() == 1) {
            if (!this.mainPanel.isAncestorOf(this.iaMetricsPanel)) {
                this.mainPanel.remove(this.obwMetricsPanel);
                this.mainPanel.remove(this.semMetricsPanel);
                this.mainPanel.add((Component)this.iaMetricsPanel, "South");
                this.mainPanel.validate();
                this.iaMetricsPanel.repaint();
            }
        } else if (this.mainPanel.isAncestorOf(this.iaMetricsPanel)) {
            this.mainPanel.remove(this.iaMetricsPanel);
            this.mainPanel.validate();
        }
        if (this.measurement.getIaOnOff() == 1 && this.isSpectrogramMode()) {
            this.iaMetrics.setMeasurement(this.measurement);
            this.iaMetricsPanel.repaint();
        } else if (this.measurement.getIaOnOff() == 1) {
            this.iaMetrics.setMeasurement(this.measurement);
        }
        if (this.measurement.getObwOnOff() == 1 && this.isSpectrogramMode()) {
            this.obwMetrics.setMeasurement(this.measurement);
            this.obwMetricsPanel.repaint();
        } else if (this.measurement.getObwOnOff() == 1) {
            this.obwMetrics.setMeasurement(this.measurement);
        }
        if (this.measurement.getSemOnOff() == 1) {
            this.semMetrics.setMeasurement(this.measurement);
            if (this.isSpectrogramMode()) {
                this.semMetricsPanel.repaint();
            }
        }
    }

    public void dispose() {
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        spectrumMeasurementSettings.getIaCf().setValidator(null);
        spectrumMeasurementSettings.getStartFreq().removeValueListener(this.startFrequencyValueListener);
        spectrumMeasurementSettings.getCenterFrequency().removeValueListener(this.centerFrequencyValueListener);
        spectrumMeasurementSettings.getStopFreq().removeValueListener(this.stopFrequencyValueListener);
        spectrumMeasurementSettings.getSpectrogramEnabled().removeValueListener(this.spectrogramEnabledListener);
        spectrumMeasurementSettings.getSpectrogramPalette().removeValueListener(this.spectrogramPaletteListener);
        this.semMetrics.dispose();
        this.semMetrics = null;
        this.iaMetrics.removeAll();
        this.iaMetrics.dispose();
        this.iaMetrics = null;
        this.obwMetrics.dispose();
        this.obwMetrics = null;
        this.bottomPanel.removeAll();
        this.chartCard.removeAll();
        this.cardPanel.removeAll();
        this.semMetricsPanel.removeAll();
        this.obwMetricsPanel.removeAll();
        this.iaMetricsPanel.removeAll();
        this.spectogramChart.dispose();
        this.spectralChartCard.dispose();
        this.chart.dispose();
        this.topView1.removeAll();
        this.topView2.removeAll();
        this.topView.removeAll();
        this.spectrumTracePanel.removeAll();
        this.spectrogram.removeAll();
        this.spectrumCard.removeAll();
        this.mainPanel.removeAll();
        this.semMetricsPanel = null;
        this.obwMetricsPanel = null;
        this.iaMetricsPanel = null;
        this.spectogramChart = null;
        this.chart = null;
        this.topView1 = null;
        this.topView2 = null;
        this.topView = null;
        this.spectrumTracePanel = null;
        this.spectrogram = null;
        this.spectralChartCard = null;
        this.bottomPanel = null;
        this.chartCard = null;
        this.cardPanel = null;
        this.cardLayout = null;
        this.spectrumCard = null;
        this.mainPanel = null;
        if (this.measurement != null) {
            this.measurement.dispose();
            this.measurement = null;
        }
        this.startFrequencyValueListener = null;
        this.centerFrequencyValueListener = null;
        this.stopFrequencyValueListener = null;
        this.spectrogramEnabledListener = null;
        this.spectrogramPaletteListener = null;
        this.iaCfValidatorIndexStepping.dispose();
        this.iaCfValidatorIndexStepping = null;
        super.dispose();
    }

    private JPanel makeSpectrumAnalyzerCard() {
        this.chart = new SpectrumLineChart();
        this.chart.setManualXRange(true);
        TraceAnalyzer.AverageDynamicLabel averageDynamicLabel = new TraceAnalyzer.AverageDynamicLabel(0, 1, 6);
        this.chart.addDLabel(averageDynamicLabel, -5, 20);
        this.chart.addDLabel(new TraceAnalyzer.RangeControlDynamicLabel(2, 3), 5, 20);
        this.chartCard = new JPanel(new BorderLayout());
        this.chartCard.setBackground(null);
        this.chartCard.add((Component)this.chart, "Center");
        this.chartCard.add((Component)this.createBottomPanel(), "South");
        return this.chartCard;
    }

    private void updateViewMode() {
        String string;
        if (this.isSpectrogramMode()) {
            string = "spectrogram";
        } else {
            string = "spectrum";
            this.spectralChartCard.getSpectralChart().releaseImageBuffer();
        }
        this.cardLayout.show(this.cardPanel, string);
    }

    private void updateSpectrogramPalette() {
        SpectralChart.PaletteMaker[] paletteMakerArray = SpectralChart.getAllPalettes();
        int n = SpectrumMeasurementSettings.instance().getSpectrogramPalette().intValue();
        this.spectralChartCard.getSpectralChart().setPalette(paletteMakerArray[n].createPalette());
    }

    protected boolean shouldMeasurementReceivedAutomaticallyPaintEverything() {
        return !this.isSpectrogramMode();
    }

    private boolean isSpectrogramMode() {
        return SpectrumMeasurementSettings.instance().getSpectrogramEnabled().booleanValue();
    }

    private void addValueListenerAndInitialize(Actuator actuator, ValueListener valueListener) {
        actuator.addValueListener(valueListener);
        valueListener.valueChanged(actuator);
    }

    private JComponent createBottomPanel() {
        this.bottomPanel = new JPanel(new GridLayout(1, 0));
        this.bottomPanel.setBackground(null);
        this.bottomPanel.add(this.configureLabel(this.startFrequencyLabel));
        this.bottomPanel.add(this.configureLabel(this.centerFrequencyLabel));
        this.bottomPanel.add(this.configureLabel(this.stopFrequencyLabel));
        return this.bottomPanel;
    }

    private ELabel configureLabel(ELabel eLabel) {
        int n = 80;
        eLabel.setPreferredSize(new Dimension(n, textHeight));
        return eLabel;
    }

    protected JComponent makeTopPanel() {
        float[][] fArrayArray = new float[][]{{80.0f, -1.0f}, {-2.0f}};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return "Ref " + UIHelper.formatFixed(SpectrumAnalyzer.this.getRefLevel(), 1) + " dBm";
            }
        }), "0,0");
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return SpectrumAnalyzer.this.getCurrentMarkerDescription();
            }
        }), "1,0");
        jPanel.setBackground(null);
        return jPanel;
    }

    protected JComponent makeSecondPanel() {
        float[][] fArrayArray = new float[][]{{-1.0f, -1.0f, -1.0f}, {-2.0f}};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        jPanel.add((Component)this.addLabel(new DynamicLabel(3, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return UIHelper.formatFixed(SpectrumMeasurementSettings.instance().getScaleDiv().intValue(), 0) + " dB/";
            }
        }), "0,0");
        jPanel.add((Component)this.addLabel(new DynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return "Res BW " + SpectrumAnalyzer.access$1300().format(((SpectrumMeasurement)measurement).getResolutionBandwidth());
            }
        }), "1,0");
        jPanel.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Text.RF_IN_Loss + " " + UIHelper.formatFixed(((SpectrumMeasurement)measurement).getAttenuation(), 1) + " dB";
            }
        }), "2,0");
        jPanel.setBackground(null);
        return jPanel;
    }

    public void updateChartVerticalRange() {
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        int n = this.getRefLevel();
        int n2 = n - spectrumMeasurementSettings.getScaleDiv().intValue() * 10;
        this.chart.setVerticalRange(n, n2);
        this.spectralChartCard.setVerticalRange(n, n2);
    }

    private int getRefLevel() {
        return SpectrumMeasurementSettings.instance().getRefLevel().intValue();
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    protected Component getPane() {
        return this.mainPanel;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (SpectrumMeasurement)measurement;
        String string = TraceAnalyzer.freqStrategy.format(this.measurement.getStartFrequency());
        String string2 = TraceAnalyzer.freqStrategy.format(this.measurement.getStopFrequency());
        String string3 = TraceAnalyzer.freqStrategy.format(this.measurement.getCenterFrequency());
        this.startFrequencyLabel.setChunk(0, string);
        this.stopFrequencyLabel.setChunk(0, string2);
        this.centerFrequencyLabel.setChunk(0, string3);
        this.spectrogramTraceChartStartFreqLabel.setChunk(0, string);
        this.spectrogramTraceChartStopFreqLabel.setChunk(0, string2);
        this.semMetrics.unsupportedChanStdLabel.setVisible(!SpectrumMeasurementSettings.instance().bSemChanStdSupported);
        this.updateMetricsView();
        SpectrumMeasurementSettings.instance().setSemRefPwr(this.measurement.getIntegerReadingValue(5), SpectrumMeasurementSettings.instance().getSpectrumEmissionMask().booleanValue());
    }

    protected void doUpdateChartMarkers() {
        super.doUpdateChartMarkers();
        this.spectralChartCard.getSpectralChart().setMarkers(this.getMarkerButtonFactory().getMarkers());
    }

    protected void updateChartMeasurements() {
        boolean bl;
        boolean bl2;
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        long l = spectrumMeasurementSettings.getSpectrogramCaptureInterval().longValue() * 1000L;
        long l2 = System.currentTimeMillis();
        if (l == 0L) {
            bl2 = true;
        } else {
            long l3 = this.lastSpectrogramTraceCapturedAt;
            if (l3 <= 0L) {
                bl2 = true;
            } else {
                boolean bl3 = bl2 = l2 >= l3 + l;
            }
        }
        if (bl2) {
            this.spectralChartCard.addTrace(this.measurement.getTrace());
            this.lastSpectrogramTraceCapturedAt = l2;
        }
        if (this.isSpectrogramMode()) {
            int n = spectrumMeasurementSettings.getSpectrogramFrameSkip().intValue();
            if (this.spectrogramFrameCounter >= n) {
                this.spectralChartCard.getTraceChart().repaint();
                this.spectralChartCard.getSpectralChart().repaint();
                bl = true;
                this.spectrogramFrameCounter = 0;
            } else {
                bl = false;
                ++this.spectrogramFrameCounter;
            }
        } else {
            bl = true;
        }
        if (bl) {
            super.updateChartMeasurements();
            if (this.measurement.getObwOnOff() == 1 || this.measurement.getSemOnOff() == 1) {
                this.spectrogram.setObw(this.measurement.getObwStart(), this.measurement.getObwStop());
            } else {
                this.spectrogram.setObw(-1, -1);
            }
            if (this.measurement.getIaOnOff() == 1) {
                long l4 = this.measurement.getIaCf();
                int n = this.measurement.getIndexForXValue(l4);
                this.spectrogram.setIa(n);
            } else {
                this.spectrogram.setIa(-1);
            }
        }
    }

    protected TraceChart getChart() {
        return this.chart;
    }

    public MeasurementMetrics getMeasurementMetrics() {
        if (this.measurement.getIaOnOff() == 1) {
            return this.iaMetrics;
        }
        if (this.measurement.getObwOnOff() == 1) {
            return this.obwMetrics;
        }
        if (this.measurement.getSemOnOff() == 1) {
            return this.semMetrics;
        }
        return null;
    }

    protected TraceChart[] getCharts() {
        return new TraceChart[]{this.chart, this.spectralChartCard.getTraceChart()};
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        boolean bl = false;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 0 && this.measurement.getIaOnOff() == 0 && this.measurement.getObwOnOff() == 0) {
            return null;
        }
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            bl = true;
        }
        int n = 0;
        int n2 = this.measurement.getTrace().length;
        int n3 = 0;
        int n4 = 0;
        if (this.measurement.getIaOnOff() == 1) {
            n = this.iaMetrics.getTabDelimitables().length;
            if (bl) {
                n3 = 3;
                tabDelimitableArray = new TabDelimitable[this.iaMetrics.getTabDelimitables().length + n2 + n3];
            } else {
                tabDelimitableArray = new TabDelimitable[this.iaMetrics.getTabDelimitables().length];
            }
            for (int i = 0; i < n; ++i) {
                tabDelimitableArray[i] = this.iaMetrics.getTabDelimitables()[i];
            }
            n4 = n;
        } else if (this.measurement.getObwOnOff() == 1) {
            n = this.obwMetrics.getTabDelimitables().length;
            if (bl) {
                n3 = 3;
                tabDelimitableArray = new TabDelimitable[this.obwMetrics.getTabDelimitables().length + n2 + n3];
            } else {
                tabDelimitableArray = new TabDelimitable[this.obwMetrics.getTabDelimitables().length];
            }
            for (int i = 0; i < n; ++i) {
                tabDelimitableArray[i] = this.obwMetrics.getTabDelimitables()[i];
            }
            n4 = n;
        } else if (this.measurement.getSemOnOff() == 1) {
            n = this.semMetrics.getTabDelimitables().length;
            if (bl) {
                n3 = 3;
                tabDelimitableArray = new TabDelimitable[this.semMetrics.getTabDelimitables().length + n2 + n3];
            } else {
                tabDelimitableArray = new TabDelimitable[this.semMetrics.getTabDelimitables().length];
            }
            for (int i = 0; i < n; ++i) {
                tabDelimitableArray[i] = this.semMetrics.getTabDelimitables()[i];
            }
            n4 = n;
        } else {
            n3 = 3;
            tabDelimitableArray = new TabDelimitable[n2 + n3];
        }
        if (bl) {
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            TraceSaveTabDelimitable.fillTabDelimitables(this.measurement, "Trace", this.freqStrategyTraceSave, 1, this.decibelStrategy, tabDelimitableArray, n4);
        }
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return this.decibelStrategy;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return this.deltaDecibelStrategy;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return TraceAnalyzer.freqStrategy;
    }

    public void clearSpectrogramHistory() {
        this.spectralChartCard.clearSpectrogramHistory();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        if (!this.isSpectrogramMode()) {
            int n = rectangle.x;
            int n2 = rectangle.y;
            rectangle = this.spectrumTracePanel.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
        }
        return super.filterPrintImage(image, rectangle);
    }

    static /* synthetic */ NumberFieldStrategy access$000() {
        return TraceAnalyzer.freqStrategy;
    }

    static /* synthetic */ NumberFieldStrategy access$500() {
        return TraceAnalyzer.freqStrategy;
    }

    static /* synthetic */ NumberFieldStrategy access$700() {
        return TraceAnalyzer.freqStrategy;
    }

    static /* synthetic */ NumberFieldStrategy access$1300() {
        return TraceAnalyzer.freqStrategy;
    }
}

