/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;

public class SpectrumLimits {
    private static final String TOPIC_DISPLAY = "display.spectrum";
    private static final String KEY_SPECTRUM_G2_UPPER_MASK_LEVEL = "U2mask";
    private static final String KEY_SPECTRUM_G2_LOWER_MASK_LEVEL = "L2mask";
    private static final String KEY_SPECTRUM_G3_LOWER_MASK_LEVEL = "L3mask";
    private static final String KEY_SPECTRUM_G3_UPPER_MASK_LEVEL = "U3mask";
    private static final String KEY_SPECTRUM_G2_LOWER_SPAN = "L2span";
    private static final String KEY_SPECTRUM_G2_UPPER_SPAN = "U2span";
    private final SpectrumMeasurementSettings settings;
    private String topic = "";
    private boolean disabled = false;
    private final ListActuator groupOneOnOff;
    private final ListActuator groupTwoOnOff;
    private final ListActuator groupThreeOnOff;
    private final ListActuator limitsMaskGroups;
    private final FrequencyActuator centerMaskFrequency;
    private final FrequencyActuator spanMaskFrequency;
    private final FrequencyActuator spanMaskFrequencyGroupTwoLower;
    private final FrequencyActuator spanMaskFrequencyGroupTwoUpper;
    private final LongActuator maskLevel;
    private final LongActuator maskLevelGroupTwoLower;
    private final LongActuator maskLevelGroupTwoUpper;
    private final LongActuator maskLevelGroupThreeLower;
    private final LongActuator maskLevelGroupThreeUpper;
    private final ListActuator limitsMaskLevelTwoSelect;
    private final ListActuator limitsMaskLevelThreeSelect;

    public SpectrumLimits(SpectrumMeasurementSettings spectrumMeasurementSettings, String string) {
        this.settings = spectrumMeasurementSettings;
        this.topic = string;
        this.groupOneOnOff = new ListActuator(TOPIC_DISPLAY, string + "." + "limitsToggle.groupOne", "Center\nSegment", this.createOnOffValueSet());
        this.groupTwoOnOff = new ListActuator(TOPIC_DISPLAY, string + "." + "limitsToggle.groupTwo", "1st Segment", this.createOnOffValueSet());
        this.groupThreeOnOff = new ListActuator(TOPIC_DISPLAY, string + "." + "limitsToggle.groupThree", "2nd Segment", this.createOnOffValueSet());
        this.limitsMaskGroups = new ListActuator(TOPIC_DISPLAY, string + "." + "limitsMaskGroups", "Segments" + (string.equals("upper") ? "\nUpper" : "\nLower"), new Value[]{Value.createValue("Center", 1), Value.createValue("1st", 2), Value.createValue("2nd", 3)});
        this.centerMaskFrequency = new CenterFrequencyMaskActuator();
        this.spanMaskFrequency = new SpanMaskActuator(string + "." + "spanMaskFrequency", Text.get("Limit_Span_Center"));
        this.spanMaskFrequencyGroupTwoLower = new SpanMaskActuator(string + "." + KEY_SPECTRUM_G2_LOWER_SPAN);
        this.spanMaskFrequencyGroupTwoUpper = new SpanMaskActuator(string + "." + KEY_SPECTRUM_G2_UPPER_SPAN);
        this.maskLevel = new MaskLevelActuator(TOPIC_DISPLAY, string + "." + "groupOneLevel", Text.get("Limit_Level_Center"), 0L);
        this.maskLevelGroupTwoLower = LongActuator.createPower(TOPIC_DISPLAY, string + "." + KEY_SPECTRUM_G2_LOWER_MASK_LEVEL, Text.Limit_Level, new RangeValidator(-150000L, 0L));
        this.maskLevelGroupTwoUpper = LongActuator.createPower(TOPIC_DISPLAY, string + "." + KEY_SPECTRUM_G2_UPPER_MASK_LEVEL, Text.Limit_Level, new RangeValidator(-150000L, 0L));
        this.maskLevelGroupThreeLower = LongActuator.createPower(TOPIC_DISPLAY, string + "." + KEY_SPECTRUM_G3_LOWER_MASK_LEVEL, Text.Limit_Level, new RangeValidator(-150000L, 0L));
        this.maskLevelGroupThreeUpper = LongActuator.createPower(TOPIC_DISPLAY, string + "." + KEY_SPECTRUM_G3_UPPER_MASK_LEVEL, Text.Limit_Level, new RangeValidator(-150000L, 0L));
        this.limitsMaskLevelTwoSelect = new ListActuator(TOPIC_DISPLAY, string + "." + "limMask2Select", "1st Segment", new Value[]{Value.createValue("Left", 0), Value.createValue("Right", 1)});
        this.limitsMaskLevelThreeSelect = new ListActuator(TOPIC_DISPLAY, string + "." + "limMask3Select", "2nd Segment", new Value[]{Value.createValue("Left", 0), Value.createValue("Right", 1)});
    }

    public void setValidationDisabled(boolean bl) {
        this.disabled = bl;
    }

    public void add() {
        this.settings.add(this.maskLevel);
        this.settings.add(this.limitsMaskGroups);
        this.settings.add(this.maskLevelGroupTwoLower);
        this.settings.add(this.maskLevelGroupTwoUpper);
        this.settings.add(this.maskLevelGroupThreeLower);
        this.settings.add(this.maskLevelGroupThreeUpper);
        this.settings.add(this.limitsMaskLevelTwoSelect);
        this.settings.add(this.limitsMaskLevelThreeSelect);
        this.settings.add(this.groupOneOnOff);
        this.settings.add(this.groupTwoOnOff);
        this.settings.add(this.groupThreeOnOff);
        this.settings.add(this.spanMaskFrequency);
        this.settings.add(this.spanMaskFrequencyGroupTwoLower);
        this.settings.add(this.spanMaskFrequencyGroupTwoUpper);
        this.settings.add(this.centerMaskFrequency);
        this.groupOneOnOff.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.groupOneOnOff";

            public String getListenerName() {
                return "SpectrumLimits.groupOneOnOff";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumLimits.this.setGroupOnePowerLimits();
            }
        });
        this.maskLevel.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.maskLevel";

            public String getListenerName() {
                return "SpectrumLimits.maskLevel";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumLimits.this.setGroupTwoPowerLimits();
                SpectrumLimits.this.setGroupThreePowerLimits();
            }
        });
        this.maskLevelGroupTwoLower.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.maskLevelGroupTwoLower";

            public String getListenerName() {
                return "SpectrumLimits.maskLevelGroupTwoLower";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumLimits.this.setGroupThreePowerLimits();
            }
        });
        this.maskLevelGroupTwoUpper.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.maskLevelGroupTwoUpper";

            public String getListenerName() {
                return "SpectrumLimits.maskLevelGroupTwoUpper";
            }

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumLimits.this.setGroupThreePowerLimits();
            }
        });
        this.centerMaskFrequency.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.centerMaskFrequency";

            public String getListenerName() {
                return "SpectrumLimits.centerMaskFrequency";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (SpectrumLimits.this.centerMaskFrequency.longValue() == 0L) {
                    SpectrumLimits.this.centerMaskFrequency.setValue(SpectrumLimits.this.settings.getCenterFrequency().longValue());
                }
            }
        });
        this.groupThreeOnOff.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.groupThreeOnOff";

            public String getListenerName() {
                return "SpectrumLimits.groupThreeOnOff";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (SpectrumLimits.this.groupThreeOnOff.longValue() == 1L) {
                    if (SpectrumLimits.this.maskLevelGroupThreeLower.longValue() >= SpectrumLimits.this.maskLevelGroupTwoLower.longValue()) {
                        SpectrumLimits.this.maskLevelGroupThreeLower.setValue(SpectrumLimits.this.maskLevelGroupTwoLower.longValue() - SpectrumLimits.this.settings.getScaleDiv().longValue());
                    }
                    if (SpectrumLimits.this.maskLevelGroupThreeUpper.longValue() >= SpectrumLimits.this.maskLevelGroupTwoUpper.longValue()) {
                        SpectrumLimits.this.maskLevelGroupThreeUpper.setValue(SpectrumLimits.this.maskLevelGroupTwoUpper.longValue() - SpectrumLimits.this.settings.getScaleDiv().longValue());
                    }
                    if (SpectrumLimits.this.spanMaskFrequencyGroupTwoLower.longValue() == 0L) {
                        SpectrumLimits.this.spanMaskFrequencyGroupTwoLower.setValue(SpectrumLimits.this.settings.getSpan().longValue() / 10L);
                    }
                    if (SpectrumLimits.this.spanMaskFrequencyGroupTwoUpper.longValue() == 0L) {
                        SpectrumLimits.this.spanMaskFrequencyGroupTwoUpper.setValue(SpectrumLimits.this.settings.getSpan().longValue() / 10L);
                    }
                }
            }
        });
        this.groupTwoOnOff.addValueListener(new ValueListener(){
            private final String listenerName = "SpectrumLimits.groupTwoOnOff";

            public String getListenerName() {
                return "SpectrumLimits.groupTwoOnOff";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (SpectrumLimits.this.groupTwoOnOff.longValue() == 1L) {
                    int n = SpectrumLimits.this.groupThreeOnOff.intValue();
                    SpectrumLimits.this.groupThreeOnOff.setValue(1);
                    if (SpectrumLimits.this.maskLevelGroupTwoLower.longValue() == 0L) {
                        SpectrumLimits.this.maskLevelGroupTwoLower.setValue(0L - SpectrumLimits.this.settings.getScaleDiv().longValue());
                    }
                    if (SpectrumLimits.this.maskLevelGroupTwoUpper.longValue() == 0L) {
                        SpectrumLimits.this.maskLevelGroupTwoUpper.setValue(0L - SpectrumLimits.this.settings.getScaleDiv().longValue());
                    }
                    if (SpectrumLimits.this.spanMaskFrequencyGroupTwoLower.longValue() == 0L) {
                        SpectrumLimits.this.spanMaskFrequencyGroupTwoLower.setValue(SpectrumLimits.this.settings.getSpan().longValue() / 10L);
                    }
                    if (SpectrumLimits.this.spanMaskFrequencyGroupTwoUpper.longValue() == 0L) {
                        SpectrumLimits.this.spanMaskFrequencyGroupTwoUpper.setValue(SpectrumLimits.this.settings.getSpan().longValue() / 10L);
                    }
                    SpectrumLimits.this.groupThreeOnOff.setValue(n);
                }
            }
        });
    }

    public void setAllPowerLimits() {
        this.setGroupOnePowerLimits();
        this.setGroupTwoPowerLimits();
        this.setGroupThreePowerLimits();
    }

    private void setGroupThreePowerLimits() {
        if (!this.disabled) {
            RangeValidator rangeValidator = new RangeValidator(Integer.MIN_VALUE, this.getMaskLevelGroupTwoUpper().longValue());
            this.maskLevelGroupThreeUpper.setValidator(rangeValidator);
            rangeValidator = new RangeValidator(Integer.MIN_VALUE, this.getMaskLevelGroupTwoLower().longValue());
            this.maskLevelGroupThreeLower.setValidator(rangeValidator);
        }
    }

    private void setGroupTwoPowerLimits() {
        if (!this.disabled) {
            RangeValidator rangeValidator = new RangeValidator(Integer.MIN_VALUE, 0L);
            this.maskLevelGroupTwoLower.setValidator(rangeValidator);
            this.maskLevelGroupTwoUpper.setValidator(rangeValidator);
        }
    }

    private void setGroupOnePowerLimits() {
        this.maskLevel.setValidator(new RangeValidator(Integer.MIN_VALUE, Integer.MAX_VALUE, 2));
    }

    private Value[] createOnOffValueSet() {
        return new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)};
    }

    public SpectrumMeasurementSettings getSettings() {
        return this.settings;
    }

    public ListActuator getGroupOneOnOff() {
        return this.groupOneOnOff;
    }

    public ListActuator getGroupTwoOnOff() {
        return this.groupTwoOnOff;
    }

    public ListActuator getGroupThreeOnOff() {
        return this.groupThreeOnOff;
    }

    public ListActuator getLimitsMaskGroups() {
        return this.limitsMaskGroups;
    }

    public FrequencyActuator getMaskCenterFrequency() {
        return this.centerMaskFrequency;
    }

    public FrequencyActuator getMaskSpan() {
        return this.spanMaskFrequency;
    }

    public FrequencyActuator getMaskSpanGroupTwoLower() {
        return this.spanMaskFrequencyGroupTwoLower;
    }

    public FrequencyActuator getMaskSpanGroupTwoUpper() {
        return this.spanMaskFrequencyGroupTwoUpper;
    }

    public LongActuator getMaskLevel() {
        return this.maskLevel;
    }

    public LongActuator getMaskLevelGroupTwoLower() {
        return this.maskLevelGroupTwoLower;
    }

    public LongActuator getMaskLevelGroupTwoUpper() {
        return this.maskLevelGroupTwoUpper;
    }

    public LongActuator getMaskLevelGroupThreeLower() {
        return this.maskLevelGroupThreeLower;
    }

    public LongActuator getMaskLevelGroupThreeUpper() {
        return this.maskLevelGroupThreeUpper;
    }

    public ListActuator getMaskLevelTwoSelect() {
        return this.limitsMaskLevelTwoSelect;
    }

    public ListActuator getMaskLevelThreeSelect() {
        return this.limitsMaskLevelThreeSelect;
    }

    public long getGroupOneSpanLimit() {
        if (this.getMaskCenterFrequency().longValue() > this.settings.getCenterFrequency().longValue()) {
            return 2L * (this.settings.getStopFreq().longValue() - this.getMaskCenterFrequency().longValue() - this.getGroupOnePadding());
        }
        return 2L * (this.getMaskCenterFrequency().longValue() - this.settings.getStartFreq().longValue() - this.getGroupOnePadding());
    }

    public long getGroupOneCenterFreqLowerLimit() {
        return this.settings.getStartFreq().longValue() + this.getMaskSpan().longValue() / 2L + this.getGroupOnePadding();
    }

    public long getGroupOneCenterFreqUpperLimit() {
        return this.settings.getStopFreq().longValue() - this.getMaskSpan().longValue() / 2L - this.getGroupOnePadding();
    }

    public long getGroupTwoSpanLowerLimit() {
        if (this.getGroupThreeOnOff().longValue() == 0L) {
            return this.getMaskSpanGroupTwoLower().longValue();
        }
        return this.getMaskCenterFrequency().longValue() - this.getMaskSpan().longValue() / 2L - this.settings.getStartFreq().longValue() - this.getGroupTwoPadding();
    }

    public long getGroupTwoSpanUpperLimit() {
        if (this.getGroupThreeOnOff().longValue() == 0L) {
            return this.getMaskSpanGroupTwoUpper().longValue();
        }
        return this.settings.getStopFreq().longValue() - (this.getMaskCenterFrequency().longValue() + this.getMaskSpan().longValue() / 2L) - this.getGroupTwoPadding();
    }

    public long getGroupTwoPowerLimit() {
        return this.settings.getBottomPowerLevel() - this.getMaskLevel().longValue();
    }

    public long getGroupThreePowerLimit(boolean bl) {
        LongActuator longActuator = bl ? this.getMaskLevelGroupTwoUpper() : this.getMaskLevelGroupTwoLower();
        return this.settings.getBottomPowerLevel() - this.getMaskLevel().longValue() - longActuator.longValue();
    }

    protected long getGroupOneBottomLimit() {
        return this.settings.getBottomPowerLevel() + this.settings.getScaleDiv().longValue() / 2L;
    }

    protected long getGroupOneTopLimit() {
        return this.settings.getRefLevel().longValue();
    }

    private long getGroupOnePadding() {
        if (this.getGroupThreeOnOff().longValue() == 1L) {
            return this.settings.getSpan().longValue() / 10L;
        }
        return this.settings.getSpan().longValue() / 20L;
    }

    private long getGroupTwoPadding() {
        return this.settings.getSpan().longValue() / 20L;
    }

    public void setMaskDefaults() {
        if (this.spanMaskFrequency.longValue() == 0L || this.centerMaskFrequency.longValue() == 0L) {
            this.centerMaskFrequency.setValue(this.settings.getCenterFrequency().longValue());
            this.spanMaskFrequency.setValue(this.getGroupOneSpanLimit() / 2L);
            this.groupTwoOnOff.setValue(0);
            this.groupThreeOnOff.setValue(0);
            this.spanMaskFrequencyGroupTwoLower.setValue(0);
            this.spanMaskFrequencyGroupTwoUpper.setValue(0);
        }
    }

    public void syncCenterFrequency() {
        this.centerMaskFrequency.setValue(this.settings.getCenterFrequency().longValue());
    }

    void setIncrement(int n) {
        this.centerMaskFrequency.setIncrement(n);
        this.spanMaskFrequency.setIncrement(n);
        this.spanMaskFrequencyGroupTwoLower.setIncrement(n);
        this.spanMaskFrequencyGroupTwoUpper.setIncrement(n);
    }

    public void copyLimits(SpectrumLimits spectrumLimits) {
        this.maskLevel.setValue(spectrumLimits.maskLevel.longValue());
        this.maskLevelGroupTwoLower.setValue(spectrumLimits.maskLevelGroupTwoLower.longValue());
        this.maskLevelGroupTwoUpper.setValue(spectrumLimits.maskLevelGroupTwoUpper.longValue());
        this.maskLevelGroupThreeLower.setValue(spectrumLimits.maskLevelGroupThreeLower.longValue());
        this.maskLevelGroupThreeUpper.setValue(spectrumLimits.maskLevelGroupThreeUpper.longValue());
        this.limitsMaskGroups.setValue(spectrumLimits.limitsMaskGroups.intValue());
        this.limitsMaskLevelTwoSelect.setValue(spectrumLimits.limitsMaskLevelTwoSelect.intValue());
        this.limitsMaskLevelThreeSelect.setValue(spectrumLimits.limitsMaskLevelThreeSelect.intValue());
        this.centerMaskFrequency.setValue(spectrumLimits.centerMaskFrequency.longValue());
        this.spanMaskFrequency.setValue(spectrumLimits.spanMaskFrequency.longValue());
        this.spanMaskFrequencyGroupTwoLower.setValue(spectrumLimits.spanMaskFrequencyGroupTwoLower.longValue());
        this.spanMaskFrequencyGroupTwoUpper.setValue(spectrumLimits.spanMaskFrequencyGroupTwoUpper.longValue());
        this.groupOneOnOff.setValue(spectrumLimits.groupOneOnOff.intValue());
        this.groupTwoOnOff.setValue(spectrumLimits.groupTwoOnOff.intValue());
        this.groupThreeOnOff.setValue(spectrumLimits.groupThreeOnOff.intValue());
    }

    private class MaskLevelActuator
    extends LongActuator {
        public MaskLevelActuator(String string, String string2, String string3, long l) {
            super(string, string2, string3, l);
            this.setConversion(FactorConversion.createFixedPoint("dBm", 1000));
            this.setPalette(Palette.createSignedDecimal());
            this.setIncrement(1000);
        }
    }

    private class SpanMaskActuator
    extends FrequencyActuator {
        public SpanMaskActuator(String string) {
            this(string, Text.Limit_Span);
        }

        public SpanMaskActuator(String string, String string2) {
            super(SpectrumLimits.TOPIC_DISPLAY, string, string2);
            this.setValidator(new RangeValidator(0L, 2000000000L, 3));
        }
    }

    private class CenterFrequencyMaskActuator
    extends FrequencyActuator {
        public CenterFrequencyMaskActuator() {
            super(SpectrumLimits.TOPIC_DISPLAY, SpectrumLimits.this.topic + ".spanCenterFrequency", "Limit 1 CF");
        }
    }
}

