/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.analyzer.LineChart;
import elgato.infrastructure.analyzer.SemMask;
import elgato.infrastructure.analyzer.SemSegment;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.spectrum.SpectrumLimits;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class SpectrumLineChart
extends LineChart {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$spectrum$SpectrumMeasurement == null ? (class$elgato$measurement$spectrum$SpectrumMeasurement = SpectrumLineChart.class$("elgato.measurement.spectrum.SpectrumMeasurement")) : class$elgato$measurement$spectrum$SpectrumMeasurement);
    private final Image arrowIconIa = ImageIcon.loadImage("images/IaMarker.png", new Canvas());
    private final Image arrowIconObw = ImageIcon.loadImage("images/ObwMarker.png", new Canvas());
    private static final Resources res = Resources.getResources((class$elgato$measurement$spectrum$SpectrumLineChart == null ? (class$elgato$measurement$spectrum$SpectrumLineChart = SpectrumLineChart.class$("elgato.measurement.spectrum.SpectrumLineChart")) : class$elgato$measurement$spectrum$SpectrumLineChart).getName());
    private static final Color thresholdLineColor = res.getColor("IaThresholdColor");
    static /* synthetic */ Class class$elgato$measurement$spectrum$SpectrumMeasurement;
    static /* synthetic */ Class class$elgato$measurement$spectrum$SpectrumLineChart;

    protected void drawMarkers(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (((SpectrumMeasurement)this.measurement).getIaOnOff() == 1) {
            int n6 = this.getYTop();
            int n7 = this.getYBottom();
            int n8 = n7 - n6;
            graphics.setColor(thresholdLineColor);
            int n9 = SpectrumMeasurementSettings.instance().getIaAutoThres().intValue() == 0 ? SpectrumMeasurementSettings.instance().getIaThreshold().intValue() : ((SpectrumMeasurement)this.measurement).getIaThreshold();
            int n10 = (n9 - n6) * n4 / n8;
            graphics.drawLine(n, n10, n + n3, n10);
            this.addIaPointer(graphics);
        } else if (((SpectrumMeasurement)this.measurement).getObwOnOff() == 1) {
            this.addObwPointers(graphics);
        }
        super.drawMarkers(graphics, n, n2, n3, n4, n5);
    }

    protected void addIaPointer(Graphics graphics) {
        long l = SpectrumMeasurementSettings.instance().getIaCf().longValue();
        int n = this.measurement.getIndexForXValue(l);
        int n2 = 0;
        if (n >= 0 && n <= this.measurement.getTraceLength() - 1) {
            n2 = n;
        }
        if (n2 < 0) {
            logger.warn("pointerIndex = " + n2);
        }
        int n3 = -99;
        int n4 = -99;
        try {
            n3 = this.traceXpts[n2];
            n4 = this.traceYpts[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            logger.warn("pointerIndex = " + n2);
            logger.warn("traceXValue = " + n3);
            logger.warn("traceYValue = " + n4);
            logger.warn("getXStartTraceIndex() = " + this.getXStartTraceIndex());
        }
        graphics.drawImage(this.arrowIconIa, this.traceXpts[n2] - this.arrowIconIa.getWidth(null) / 2, this.traceYpts[n2] - this.arrowIconIa.getHeight(null), null);
    }

    protected void addObwPointers(Graphics graphics) {
        long l = ((SpectrumMeasurement)this.measurement).getObwStart();
        long l2 = ((SpectrumMeasurement)this.measurement).getObwStop();
        int n = this.getXStartTraceIndex();
        int n2 = this.getXStopTraceIndex();
        if (l < (long)n || l > (long)n2) {
            l = n;
        }
        if (l2 < (long)n || l2 > (long)n2) {
            l2 = n2;
        }
        int n3 = (int)l - n;
        int n4 = (int)l2 - n;
        graphics.drawImage(this.arrowIconObw, this.traceXpts[n3] - this.arrowIconObw.getWidth(null) / 2, this.traceYpts[n3] - this.arrowIconObw.getHeight(null), null);
        graphics.drawImage(this.arrowIconObw, this.traceXpts[n4] - this.arrowIconObw.getWidth(null) / 2, this.traceYpts[n4] - this.arrowIconObw.getHeight(null), null);
    }

    private void showPassFailIcon(Graphics graphics, Image image, long l, long l2, long l3, int n, int n2) {
        graphics.drawImage(image, TraceChart.plotPointValue(l, l2, l3, n) - 8, n2 - 25, null);
    }

    private long findCenterOfSegment(long l, long l2) {
        return (l2 - l) / 2L + l;
    }

    protected void showLimits(Graphics graphics, int n, int n2) {
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        if (spectrumMeasurementSettings.getUpperLimits().getGroupOneOnOff().longValue() == 1L) {
            this.showLimits(n2, n, graphics, spectrumMeasurementSettings.getUpperLimits());
        }
        if (spectrumMeasurementSettings.getLowerLimits().getGroupOneOnOff().longValue() == 1L) {
            this.showLimits(n2, n, graphics, spectrumMeasurementSettings.getLowerLimits());
        }
        if (spectrumMeasurementSettings.bSemState && spectrumMeasurementSettings.bSemChanStdSupported && spectrumMeasurementSettings.currentSemMask != null) {
            this.plotSemMask(n2, n, graphics, spectrumMeasurementSettings.currentSemMask);
        }
    }

    private void showLimits(int n, int n2, Graphics graphics, SpectrumLimits spectrumLimits) {
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        long l = spectrumLimits.getMaskCenterFrequency().longValue();
        long l2 = spectrumLimits.getMaskSpan().longValue();
        long l3 = l - l2 / 2L;
        long l4 = l + l2 / 2L;
        long l5 = l3 - spectrumLimits.getMaskSpanGroupTwoLower().longValue();
        long l6 = l4 + spectrumLimits.getMaskSpanGroupTwoUpper().longValue();
        int n3 = this.getYTop();
        int n4 = this.getYBottom() - n3;
        long l7 = this.getXStart();
        long l8 = this.getXStop() - l7;
        if (spectrumLimits.getGroupTwoOnOff().longValue() == 0L) {
            l3 = l7;
            l4 = l7 + l8;
            l = spectrumMeasurementSettings.getCenterFrequency().longValue();
        } else if (spectrumLimits.getGroupThreeOnOff().longValue() == 0L) {
            l5 = l7;
            l6 = l7 + l8;
        }
        int n5 = ((int)spectrumLimits.getMaskLevel().longValue() - n3) * n / n4;
        int n6 = TraceChart.plotPointValue(l3, l7, l8, n2);
        int n7 = TraceChart.plotPointValue(l4, l7, l8, n2);
        int n8 = TraceChart.plotPointValue(l5, l7, l8, n2);
        int n9 = TraceChart.plotPointValue(l6, l7, l8, n2);
        int n10 = -((int)spectrumLimits.getMaskLevelGroupTwoLower().longValue());
        int n11 = -((int)spectrumLimits.getMaskLevelGroupTwoUpper().longValue());
        int n12 = -((int)spectrumLimits.getMaskLevelGroupThreeLower().longValue());
        int n13 = -((int)spectrumLimits.getMaskLevelGroupThreeUpper().longValue());
        int n14 = ((int)spectrumLimits.getMaskLevel().longValue() - n3 - n10) * n / n4;
        int n15 = ((int)spectrumLimits.getMaskLevel().longValue() - n3 - n11) * n / n4;
        int n16 = ((int)spectrumLimits.getMaskLevel().longValue() - n3 - n12) * n / n4;
        int n17 = ((int)spectrumLimits.getMaskLevel().longValue() - n3 - n13) * n / n4;
        graphics.setColor(Color.yellow);
        graphics.drawLine(n6, n5, n7, n5);
        if (spectrumLimits.getGroupTwoOnOff().longValue() == 1L) {
            graphics.drawLine(n8, n14, n6, n14);
            graphics.drawLine(n6, n14, n6, n5);
            graphics.drawLine(n7, n5, n7, n15);
            graphics.drawLine(n7, n15, n9, n15);
            if (spectrumLimits.getGroupThreeOnOff().longValue() == 1L) {
                graphics.drawLine(0, n16, n8, n16);
                graphics.drawLine(n8, n16, n8, n14);
                graphics.drawLine(n9, n15, n9, n17);
                graphics.drawLine(n9, n17, n2, n17);
            }
        }
        PassFailResults passFailResults = PassFailResults.createPassFailResults(this.measurement, spectrumLimits);
        passFailResults.determineResults(l3, l6, l4, l5, n10, n11, n12, n13, l7, l8);
        this.showPassFailIcon(graphics, passFailResults.groupOneImage, l, l7, l8, n2, n5);
        if (spectrumLimits.getGroupTwoOnOff().longValue() == 1L) {
            this.showPassFailIcon(graphics, passFailResults.groupTwoLowerImage, this.findCenterOfSegment(l5, l3), l7, l8, n2, n14);
            this.showPassFailIcon(graphics, passFailResults.groupTwoUpperImage, this.findCenterOfSegment(l4, l6), l7, l8, n2, n15);
            if (spectrumLimits.getGroupThreeOnOff().longValue() == 1L) {
                this.showPassFailIcon(graphics, passFailResults.groupThreeLowerImage, this.findCenterOfSegment(l7, l5), l7, l8, n2, n16);
                this.showPassFailIcon(graphics, passFailResults.groupThreeUpperImage, this.findCenterOfSegment(l6, l7 + l8), l7, l8, n2, n17);
            }
        }
    }

    private void plotSemMask(int n, int n2, Graphics graphics, SemMask semMask) {
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        graphics.setColor(Color.yellow);
        long l = spectrumMeasurementSettings.getCenterFrequency().longValue();
        int n8 = this.getYTop();
        int n9 = this.getYBottom() - n8;
        long l2 = this.getXStart();
        long l3 = this.getXStop() - l2;
        for (n3 = 0; n3 < semMask.numSegments; ++n3) {
            SemSegment semSegment = semMask.segments[n3];
            long l4 = semSegment.getType() == 1 ? semMask.referenceLevel : 0L;
            long l5 = semSegment.getStartUpperLimit();
            long l6 = semSegment.getStopUpperLimit();
            n6 = TraceChart.plotPointValue(l5 + l4, n8, n9, n);
            n4 = TraceChart.plotPointValue(l + semSegment.getStartFreq() * 1000L, l2, l3, n2);
            graphics.drawLine(n5, n6, n5, n7);
            n7 = TraceChart.plotPointValue(l6 + l4, n8, n9, n);
            n5 = TraceChart.plotPointValue(l + semSegment.getStopFreq() * 1000L, l2, l3, n2);
            if (this.upperSegmentPass(semSegment, l4)) {
                graphics.setColor(Color.yellow);
                graphics.drawLine(n4, n6, n5, n7);
                semSegment.setPassed(true);
                continue;
            }
            graphics.setColor(Color.white);
            graphics.drawLine(n4, n6 - 1, n5, n7 - 1);
            graphics.setColor(Color.pink);
            graphics.drawLine(n4, n6, n5, n7);
            graphics.setColor(Color.red);
            graphics.drawLine(n4, n6 + 1, n5, n7 + 1);
            semSegment.setPassed(false);
        }
    }

    private boolean upperSegmentPass(SemSegment semSegment, long l) {
        int[] nArray = this.measurement.getTrace();
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        long l2 = spectrumMeasurementSettings.getCenterFrequency().longValue() + semSegment.getStartFreq() * 1000L;
        long l3 = spectrumMeasurementSettings.getCenterFrequency().longValue() + semSegment.getStopFreq() * 1000L;
        for (int i = 0; i < this.measurement.getTraceLength(); ++i) {
            long l4;
            if (this.measurement.getXValueForIndex(i) < l2 || this.measurement.getXValueForIndex(i) >= l3) continue;
            if (semSegment.getStartUpperLimit() == semSegment.getStopUpperLimit()) {
                l4 = semSegment.getStartUpperLimit() + l;
            } else {
                float f = (float)semSegment.getStopUpperLimit() - (float)semSegment.getStartUpperLimit();
                long l5 = semSegment.getStartUpperLimit() + l;
                l4 = Math.round((f /= (float)this.measurement.getIndexForXValue(l3) - (float)this.measurement.getIndexForXValue(l2)) * (float)(i - this.measurement.getIndexForXValue(l2)) + (float)l5);
            }
            if ((long)nArray[i] <= l4) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Image access$000() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$100() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$200() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$300() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$400() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$500() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$600() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$700() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$800() {
        return TraceChart.failImage;
    }

    static /* synthetic */ Image access$900() {
        return TraceChart.failImage;
    }

    public static class PassFailResults {
        private static PassFailResults instance;
        private TraceMeasurement measurement;
        private SpectrumLimits limits;
        Image groupOneImage;
        Image groupTwoLowerImage;
        Image groupTwoUpperImage;
        Image groupThreeLowerImage;
        Image groupThreeUpperImage;

        static PassFailResults createPassFailResults(TraceMeasurement traceMeasurement, SpectrumLimits spectrumLimits) {
            if (instance == null) {
                instance = new PassFailResults(traceMeasurement, spectrumLimits);
            } else {
                PassFailResults.instance.measurement = traceMeasurement;
                PassFailResults.instance.limits = spectrumLimits;
            }
            return instance;
        }

        private PassFailResults(TraceMeasurement traceMeasurement, SpectrumLimits spectrumLimits) {
            this.measurement = traceMeasurement;
            this.limits = spectrumLimits;
        }

        public void determineResults(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10) {
            this.groupOneImage = TraceChart.passImage;
            this.groupTwoLowerImage = TraceChart.passImage;
            this.groupTwoUpperImage = TraceChart.passImage;
            this.groupThreeLowerImage = TraceChart.passImage;
            this.groupThreeUpperImage = TraceChart.passImage;
            int[] nArray = this.measurement.getTrace();
            if (SpectrumMeasurementSettings.instance().getUpperLimits() == this.limits) {
                for (int i = 0; i < this.measurement.getTraceLength(); ++i) {
                    if (this.measurement.getXValueForIndex(i) > l && this.measurement.getXValueForIndex(i) < l3 && this.limits.getMaskLevel().longValue() <= (long)nArray[i]) {
                        this.groupOneImage = SpectrumLineChart.access$000();
                    }
                    if (this.limits.getGroupTwoOnOff().longValue() != 1L) continue;
                    if (this.limits.getGroupThreeOnOff().longValue() == 1L) {
                        if (this.measurement.getXValueForIndex(i) >= l9 && this.measurement.getXValueForIndex(i) <= l4 && this.limits.getMaskLevel().longValue() - l7 <= (long)nArray[i]) {
                            this.groupThreeLowerImage = SpectrumLineChart.access$100();
                        }
                        if (this.measurement.getXValueForIndex(i) >= l2 && this.measurement.getXValueForIndex(i) <= l9 + l10 && this.limits.getMaskLevel().longValue() - l8 <= (long)nArray[i]) {
                            this.groupThreeUpperImage = SpectrumLineChart.access$200();
                        }
                    }
                    if (this.measurement.getXValueForIndex(i) >= l4 && this.measurement.getXValueForIndex(i) <= l && this.limits.getMaskLevel().longValue() - l5 <= (long)nArray[i]) {
                        this.groupTwoLowerImage = SpectrumLineChart.access$300();
                    }
                    if (this.measurement.getXValueForIndex(i) < l3 || this.measurement.getXValueForIndex(i) > l2 || this.limits.getMaskLevel().longValue() - l6 > (long)nArray[i]) continue;
                    this.groupTwoUpperImage = SpectrumLineChart.access$400();
                }
            } else {
                for (int i = 0; i < this.measurement.getTraceLength(); ++i) {
                    if (this.measurement.getXValueForIndex(i) > l && this.measurement.getXValueForIndex(i) < l3 && this.limits.getMaskLevel().longValue() >= (long)nArray[i]) {
                        this.groupOneImage = SpectrumLineChart.access$500();
                    }
                    if (this.limits.getGroupTwoOnOff().longValue() != 1L) continue;
                    if (this.limits.getGroupThreeOnOff().longValue() == 1L) {
                        if (this.measurement.getXValueForIndex(i) >= l9 && this.measurement.getXValueForIndex(i) <= l4 && this.limits.getMaskLevel().longValue() - l7 >= (long)nArray[i]) {
                            this.groupThreeLowerImage = SpectrumLineChart.access$600();
                        }
                        if (this.measurement.getXValueForIndex(i) >= l2 && this.measurement.getXValueForIndex(i) <= l9 + l10 && this.limits.getMaskLevel().longValue() - l8 >= (long)nArray[i]) {
                            this.groupThreeUpperImage = SpectrumLineChart.access$700();
                        }
                    }
                    if (this.measurement.getXValueForIndex(i) >= l4 && this.measurement.getXValueForIndex(i) <= l && this.limits.getMaskLevel().longValue() - l5 >= (long)nArray[i]) {
                        this.groupTwoLowerImage = SpectrumLineChart.access$800();
                    }
                    if (this.measurement.getXValueForIndex(i) < l3 || this.measurement.getXValueForIndex(i) > l2 || this.limits.getMaskLevel().longValue() - l6 < (long)nArray[i]) continue;
                    this.groupTwoUpperImage = SpectrumLineChart.access$900();
                }
            }
        }
    }
}

