/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.InvalidFrequencyException;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.io.DataInput;
import java.io.IOException;

public class SpectrumMeasurement
extends TraceMeasurement {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$spectrum$SpectrumMeasurement == null ? (class$elgato$measurement$spectrum$SpectrumMeasurement = SpectrumMeasurement.class$("elgato.measurement.spectrum.SpectrumMeasurement")) : class$elgato$measurement$spectrum$SpectrumMeasurement);
    static final long serialVersionUID = 6135684990514704195L;
    private static final Queue pool = new Queue(3);
    public static final int AVERAGE_TYPE = 0;
    public static final int NUM_AVERAGES = 1;
    public static final int RANGE_HOLD = 2;
    public static final int RANGE_SETTING = 3;
    public static final int OBW_FREQ = 4;
    public static final int OBW_POWER = 5;
    public static final int AVERAGE_COUNT = 6;
    private long iaSignalCfOld = -999999L;
    private static final int UNDEFINED = -1;
    private int[] chanStdIndicesIaType = new int[10];
    private int nextIaResultIndex;
    private static final int IARESULTS_MAX = 7;
    private IaResult[] iaResults = new IaResult[]{new IaResult(), new IaResult(), new IaResult(), new IaResult(), new IaResult(), new IaResult(), new IaResult(), new IaResult()};
    public static final int IA_TYPES_SIZE = 8;
    public static final int IA_SIGNAL_TYPE_NOISE = 0;
    public static final int IA_SIGNAL_TYPE_CW = 1;
    public static final int IA_SIGNAL_TYPE_AM = 2;
    public static final int IA_SIGNAL_TYPE_FM = 3;
    public static final int IA_SIGNAL_TYPE_AMPS = 4;
    public static final int IA_SIGNAL_TYPE_NMT = 5;
    public static final int IA_SIGNAL_TYPE_TACS = 6;
    public static final int IA_SIGNAL_TYPE_IDEN = 7;
    public static final int IA_SIGNAL_TYPE_TDMA = 8;
    public static final int IA_SIGNAL_TYPE_GSM = 9;
    public static final int IA_SIGNAL_TYPE_CDMA = 10;
    public static final int IA_SIGNAL_TYPE_WCDMA = 11;
    public static final int IA_SIGNAL_TYPE_TETRA = 12;
    public static final int IA_SIGNAL_TYPE_PDC = 13;
    public static final int IA_SIGNAL_TYPE_PAGE = 14;
    public static final int IA_SIGNAL_TYPE_UNIDENTIFIED = 15;
    public static final int SA_DETECTOR_PEAK = 0;
    public static final int SA_DETECTOR_SAMPLE = 1;
    public static final int SA_DETECTOR_PIT = 2;
    public static final int SA_DETECTOR_AVERAGE = 3;
    private static final String[] iaCodeName = new String[]{Text.Noise, Text.CW, Text.AM, Text.FM, Text.AMPS, Text.NMT, Text.TACS, Text.IDEN, Text.TDMA, Text.GSM, Text.CDMA, Text.WCDMA, Text.Tetra, Text.PDC, Text.PAGE, Text.Unidentified};
    private static int readCount = 0;
    private static int mismatchCount = 0;
    private int[] trace = new int[256];
    private int minPower;
    private int maxPower;
    private long centerFrequency;
    private long span;
    private int attenuation;
    private long resolutionBandwidth;
    private boolean autoResolutionBandwidth;
    private int averageType;
    private int numAverages;
    private boolean averageAsLogPower;
    private int sensitivity;
    private int rangeHold;
    private int rangeSetting;
    private int obwStart;
    private int obwStop;
    private int obwHz;
    private int obwPower;
    private int iaThreshold;
    private long iaSignalCf;
    private int iaTypeCount;
    private int[] iaTypes = new int[8];
    private int limitsOnOff;
    private int averageCount;
    private int rangeUpDown;
    private int obwOnOff;
    private int obwPctPwr;
    private int iaOnOff;
    private long iaCf;
    private int iaAutoThreshold;
    private int iaManualThreshold;
    private int zoomToSignal;
    private int detectorType;
    private int semOnOff;
    private int semNoiseCorrOnOff;
    static /* synthetic */ Class class$elgato$measurement$spectrum$SpectrumMeasurement;

    public static SpectrumMeasurement unpack(DataInput dataInput) throws IOException {
        int n;
        SpectrumMeasurement spectrumMeasurement = SpectrumMeasurement.create();
        if (readCount < Integer.MAX_VALUE) {
            ++readCount;
        }
        for (n = 0; n < 256; ++n) {
            spectrumMeasurement.trace[n] = dataInput.readInt();
        }
        spectrumMeasurement.minPower = dataInput.readInt();
        spectrumMeasurement.maxPower = dataInput.readInt();
        spectrumMeasurement.centerFrequency = (long)dataInput.readInt() * 1000L;
        spectrumMeasurement.centerFrequency += (long)dataInput.readInt();
        spectrumMeasurement.span = (long)dataInput.readInt() * 1000L;
        spectrumMeasurement.attenuation = dataInput.readInt();
        spectrumMeasurement.resolutionBandwidth = dataInput.readInt();
        spectrumMeasurement.autoResolutionBandwidth = dataInput.readInt() != 0;
        spectrumMeasurement.averageType = dataInput.readInt();
        spectrumMeasurement.numAverages = dataInput.readInt();
        spectrumMeasurement.averageAsLogPower = dataInput.readInt() != 0;
        spectrumMeasurement.sensitivity = dataInput.readInt();
        spectrumMeasurement.rangeHold = dataInput.readInt();
        spectrumMeasurement.rangeSetting = dataInput.readInt();
        spectrumMeasurement.obwStart = dataInput.readInt();
        spectrumMeasurement.obwStop = dataInput.readInt();
        spectrumMeasurement.obwHz = dataInput.readInt();
        spectrumMeasurement.obwPower = dataInput.readInt();
        spectrumMeasurement.iaThreshold = dataInput.readInt();
        int n2 = dataInput.readInt();
        if (n2 == Integer.MIN_VALUE) {
            spectrumMeasurement.iaSignalCf = n2;
            n2 = dataInput.readInt();
        } else {
            spectrumMeasurement.iaSignalCf = (long)n2 * 1000L;
            spectrumMeasurement.iaSignalCf += (long)dataInput.readInt();
        }
        spectrumMeasurement.iaTypeCount = dataInput.readInt();
        for (n = 0; n < 8; ++n) {
            spectrumMeasurement.iaTypes[n] = dataInput.readInt();
        }
        spectrumMeasurement.averageCount = dataInput.readInt();
        spectrumMeasurement.rangeUpDown = dataInput.readInt();
        spectrumMeasurement.obwOnOff = dataInput.readInt();
        spectrumMeasurement.obwPctPwr = dataInput.readInt();
        spectrumMeasurement.iaOnOff = dataInput.readInt();
        n2 = dataInput.readInt();
        if (n2 == Integer.MIN_VALUE) {
            spectrumMeasurement.iaCf = n2;
            n2 = dataInput.readInt();
        } else {
            spectrumMeasurement.iaCf = (long)n2 * 1000L;
            spectrumMeasurement.iaCf += (long)dataInput.readInt();
        }
        spectrumMeasurement.iaAutoThreshold = dataInput.readInt();
        spectrumMeasurement.iaManualThreshold = dataInput.readInt();
        spectrumMeasurement.zoomToSignal = dataInput.readInt();
        spectrumMeasurement.detectorType = dataInput.readInt();
        spectrumMeasurement.semOnOff = dataInput.readInt();
        spectrumMeasurement.semNoiseCorrOnOff = dataInput.readInt();
        spectrumMeasurement.iaSignalChanStdSearch(spectrumMeasurement.iaSignalCf, spectrumMeasurement.iaResults);
        return spectrumMeasurement;
    }

    public static SpectrumMeasurement create() {
        SpectrumMeasurement spectrumMeasurement = (SpectrumMeasurement)pool.dequeue();
        if (spectrumMeasurement == null) {
            return new SpectrumMeasurement();
        }
        return spectrumMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public void dispose() {
        for (int i = 0; i < pool.size(); ++i) {
            SpectrumMeasurement spectrumMeasurement = (SpectrumMeasurement)pool.dequeue();
            if (spectrumMeasurement == null || spectrumMeasurement == this) continue;
            spectrumMeasurement.disposeArrays();
        }
        this.disposeArrays();
    }

    private void disposeArrays() {
        for (int i = 0; i < this.iaResults.length; ++i) {
            this.iaResults[i] = null;
        }
        this.iaResults = null;
        this.iaTypes = null;
        this.chanStdIndicesIaType = null;
        this.trace = null;
    }

    public int getMinPower() {
        return this.minPower;
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public long getCenterFrequency() {
        return this.centerFrequency;
    }

    public long getSpan() {
        return this.span;
    }

    public long getStartFrequency() {
        return this.centerFrequency - this.span / 2L;
    }

    public long getStopFrequency() {
        return this.centerFrequency + this.span / 2L;
    }

    public int getAttenuation() {
        return this.attenuation;
    }

    public long getResolutionBandwidth() {
        return this.resolutionBandwidth;
    }

    public boolean isAutoResolutionBandwidth() {
        return this.autoResolutionBandwidth;
    }

    public int getAverageType() {
        return this.averageType;
    }

    public int getNumAverages() {
        return this.numAverages;
    }

    public boolean isAverageAsLogPower() {
        return this.averageAsLogPower;
    }

    public int getAverageCount() {
        return this.averageCount;
    }

    public int[] getTrace() {
        return this.trace;
    }

    public long getTraceStartValue() {
        return this.getStartFrequency();
    }

    public long getTraceStopValue() {
        return this.getStopFrequency();
    }

    public int getIntegerReadingValue(int n) {
        switch (n) {
            case 0: {
                return this.getAverageType();
            }
            case 1: {
                return this.getNumAverages();
            }
            case 6: {
                return this.getAverageCount();
            }
            case 2: {
                return this.getRangeHold();
            }
            case 3: {
                return this.getRangeSetting();
            }
            case 4: {
                return this.getObwHz();
            }
            case 5: {
                return this.getObwPower();
            }
        }
        throw new RuntimeException("Hack to allow TraceAnalyzer.AveragingLabel to use this method until we change SpectrumMeasurement to use an array of Readings.");
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public long getLongReadingValue(int n) {
        switch (n) {
            case 4: {
                return this.getObwHz();
            }
            case 5: {
                return this.getObwPower();
            }
        }
        throw new RuntimeException("method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("method not implemented yet");
    }

    public String getMeasurementTitle() {
        return Text.Spectrum_Analyzer;
    }

    public int getSensitivity() {
        return this.sensitivity;
    }

    public int getRangeHold() {
        return this.rangeHold;
    }

    public int getRangeSetting() {
        return this.rangeSetting;
    }

    public int getRangeUpDown() {
        return this.rangeUpDown;
    }

    public int getObwStart() {
        return this.obwStart;
    }

    public int getObwStop() {
        return this.obwStop;
    }

    public int getObwHz() {
        return this.obwHz;
    }

    public int getObwPower() {
        return this.obwPower;
    }

    public int getIaThreshold() {
        return this.iaThreshold;
    }

    public long getIaSignalCf() {
        return this.iaSignalCf;
    }

    public int getIaTypeCount() {
        return this.iaTypeCount;
    }

    public int getIaTypes(int n) {
        if (n < 0) {
            logger.warn("getIaTypes(" + n + ") invalid index, using index=0");
            return this.iaTypes[0];
        }
        if (n >= 8) {
            int n2 = 7;
            logger.warn("getIaTypes(" + n + ") invalid index, using index=" + n2);
            return this.iaTypes[n2];
        }
        return this.iaTypes[n];
    }

    public int getObwOnOff() {
        return this.obwOnOff;
    }

    public int getObwPctPwr() {
        return this.obwPctPwr;
    }

    public int getIaOnOff() {
        return this.iaOnOff;
    }

    public int getLimitsOnOff() {
        return this.limitsOnOff;
    }

    public long getIaCf() {
        return this.iaCf;
    }

    public int getIaAutoThreshold() {
        return this.iaAutoThreshold;
    }

    public int getIaManualThreshold() {
        return this.iaManualThreshold;
    }

    public int getZoomToSignal() {
        return this.zoomToSignal;
    }

    public int getDetectorType() {
        return this.detectorType;
    }

    public int getSemOnOff() {
        return this.semOnOff;
    }

    protected boolean actuatorsMatchCurrentSettings() {
        SpectrumMeasurementSettings spectrumMeasurementSettings = SpectrumMeasurementSettings.instance();
        boolean bl = true;
        if (readCount == 0) {
            return true;
        }
        if (!this.resultEqualsSetting(logger, spectrumMeasurementSettings.getCenterFrequency(), this.centerFrequency)) {
            bl = false;
        } else if (!this.resultEqualsSetting(logger, spectrumMeasurementSettings.getSpan(), this.span)) {
            bl = false;
        }
        mismatchCount = bl ? 0 : ++mismatchCount;
        if (mismatchCount > 10) {
            logger.warn("Result/Setting mismatch #" + mismatchCount + ", resetting and continuing as if matched");
            mismatchCount = 0;
            bl = true;
            spectrumMeasurementSettings.invalidate();
            spectrumMeasurementSettings.refresh();
        }
        return bl;
    }

    public IaResult[] getIaResults() {
        return this.iaResults;
    }

    private void iaSignalChanStdSearch(long l, IaResult[] iaResultArray) {
        int n;
        int n2;
        DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = SpectrumMeasurementSettings.instance().getDisplayGlobalMeasurementSettings();
        if (l == this.iaSignalCfOld) {
            return;
        }
        this.iaSignalCfOld = l;
        this.initIaResults();
        this.nextIaResultIndex = 0;
        int n3 = 0;
        int n4 = displayGlobalMeasurementSettings.getChanStd().intValue();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = Band.getBands()[n4].getTechnologyType();
        if (displayGlobalMeasurementSettings.getChanFreqUnits().intValue() == 1) {
            n2 = this.isUserChanStdInIaTypes(n5);
            if (n2 != -1) {
                bl2 = SpectrumMeasurement.iaChanNumSearch("User Selected Chan Std", n4, l, 0, iaResultArray);
                if (bl2) {
                    ++this.nextIaResultIndex;
                    bl3 = true;
                }
                n3 = this.getChanStdIndicesIaType(n5);
                for (n = 0; n < n3; ++n) {
                    if (this.chanStdIndicesIaType[n] == n4 || !(bl2 = SpectrumMeasurement.iaChanNumSearch(iaCodeName[n5], this.chanStdIndicesIaType[n], l, this.nextIaResultIndex, iaResultArray))) continue;
                    bl3 = true;
                    ++this.nextIaResultIndex;
                    if (this.nextIaResultIndex != 7) continue;
                    return;
                }
                if (!bl3) {
                    this.setIaResultSignalTypeNoChanNum(n2);
                    ++this.nextIaResultIndex;
                }
            }
            bl = true;
        }
        for (n2 = 0; n2 < this.iaTypeCount; ++n2) {
            n = this.getIaTypes(n2);
            if (n == 15) {
                logger.warn("iaType is the Unidentified!");
            }
            if (this.isSignalTypeNoChanNum(n)) {
                this.setIaResultSignalTypeNoChanNum(n);
                ++this.nextIaResultIndex;
                if (this.nextIaResultIndex != 7) continue;
                return;
            }
            if (bl && n == n5) continue;
            bl2 = false;
            bl3 = false;
            n3 = this.getChanStdIndicesIaType(n);
            for (int i = 0; i < n3; ++i) {
                bl2 = SpectrumMeasurement.iaChanNumSearch(iaCodeName[n], this.chanStdIndicesIaType[i], l, this.nextIaResultIndex, iaResultArray);
                if (!bl2) continue;
                bl3 = true;
                ++this.nextIaResultIndex;
                if (this.nextIaResultIndex != 7) continue;
                return;
            }
            if (bl3) continue;
            this.setIaResultSignalTypeNoChanNum(n);
            ++this.nextIaResultIndex;
            if (this.nextIaResultIndex != 7) continue;
            return;
        }
    }

    private int getChanStdIndicesIaType(int n) {
        boolean bl = false;
        int n2 = 0;
        Band[] bandArray = Band.getBands();
        for (int i = 0; i < bandArray.length; ++i) {
            if (bandArray[i].getTechnologyType() != n) continue;
            if (n2 >= this.chanStdIndicesIaType.length) {
                logger.warn("SpectrumMeasurement: chanStdIndicesIaType requires bigger array!");
                break;
            }
            this.chanStdIndicesIaType[n2++] = i;
            bl = true;
        }
        if (!bl) {
            return 0;
        }
        return n2;
    }

    private int isUserChanStdInIaTypes(int n) {
        for (int i = 0; i < this.iaTypeCount; ++i) {
            int n2 = this.getIaTypes(i);
            if (n != n2) continue;
            return n2;
        }
        return -1;
    }

    private boolean isSignalTypeNoChanNum(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 6 || n == 12 || n == 13 || n == 14 || n >= 15;
    }

    private void setIaResultSignalTypeNoChanNum(int n) {
        String string = "";
        if (n > 15) {
            string = iaCodeName[15];
            logger.warn("iaType index " + n + " is greater than that for Unidentified, set it to Unidentified!");
        } else {
            string = iaCodeName[n];
        }
        this.iaResults[this.nextIaResultIndex].setIaCodeName(string);
        this.iaResults[this.nextIaResultIndex].setNetworkStdName(string);
        this.iaResults[this.nextIaResultIndex].setChanNum(-999L);
        this.iaResults[this.nextIaResultIndex].setSuffix("");
        this.iaResults[this.nextIaResultIndex].setResultValid(true);
    }

    private static boolean iaChanNumSearch(String string, int n, long l, int n2, IaResult[] iaResultArray) {
        long l2;
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        try {
            Band band = Band.getCurrentBand(n);
            string3 = band.isFrequencyFwdChannel(l) ? band.getChannelFwdUnitLabel() : band.getChannelRevUnitLabel();
            double d = Band.getCurrentBand(n).convertFrequencyToChannelNumber(l);
            l2 = (long)((d += 0.500000001) * 1000.0);
            string2 = Band.getCurrentBand(n).getMiniLabel();
            bl = true;
        }
        catch (InvalidFrequencyException invalidFrequencyException) {
            l2 = -333000L;
        }
        if (bl) {
            iaResultArray[n2].setIaCodeName(string);
            iaResultArray[n2].setNetworkStdName(string2);
            iaResultArray[n2].setChanNum(l2);
            iaResultArray[n2].setSuffix(string3);
            iaResultArray[n2].setResultValid(true);
        }
        return bl;
    }

    private void initIaResults() {
        for (int i = 0; i < 8; ++i) {
            this.iaResults[i].setIaCodeName("");
            this.iaResults[i].setModulationType(-1);
            this.iaResults[i].setChanNum(-999L);
            this.iaResults[i].setNetworkStdName("");
            this.iaResults[i].setSuffix("");
            this.iaResults[i].setResultValid(false);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class IaResult {
        private int modulationType;
        private String networkStd;
        private long chanNumLong;
        private String suffix;
        private String iaCodeName;
        private boolean resultValid = false;

        public void setModulationType(int n) {
            this.modulationType = n;
        }

        public int getModulationType() {
            return this.modulationType;
        }

        public void setChanNum(long l) {
            this.chanNumLong = l;
        }

        public long getChanNum() {
            return this.chanNumLong;
        }

        public void setNetworkStdName(String string) {
            this.networkStd = string;
        }

        public String getNetworkStdName() {
            return this.networkStd;
        }

        public void setSuffix(String string) {
            this.suffix = string;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setIaCodeName(String string) {
            this.iaCodeName = string;
        }

        public String getIaCodeName() {
            return this.iaCodeName;
        }

        public void setResultValid(boolean bl) {
            this.resultValid = bl;
        }

        public boolean getResultValid() {
            return this.resultValid;
        }
    }
}

