/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SpectrumMeasurementGenerator
extends MeasurementGenerator {
    private static final int TRUE = 1;
    public int span = 1500;
    public int minPower = -54000;
    public int maxPower = 46000;
    public int attenuation = 55;
    public int resolutionBandwidth = 100;
    public int autoResolutionBandwidth = 1;
    public int averageType = 2;
    public int numAverages = 9;
    public int averageAsLogPower = 1;
    public int obwOnOff = 0;
    public int iaOnOff = 0;
    public int detectorType = 0;
    public int semOnOff = 0;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return SpectrumMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        long l = SpectrumMeasurementSettings.instance().getCenterFrequency().longValue();
        this.generateKnownTrace(dataOutput);
        dataOutput.writeInt(this.minPower);
        dataOutput.writeInt(this.maxPower);
        dataOutput.writeInt((int)(l / 1000L));
        dataOutput.writeInt((int)(l % 1000L));
        dataOutput.writeInt(this.span);
        dataOutput.writeInt(this.attenuation);
        dataOutput.writeInt(this.resolutionBandwidth);
        dataOutput.writeInt(this.autoResolutionBandwidth);
        dataOutput.writeInt(this.averageType);
        dataOutput.writeInt(this.numAverages);
        dataOutput.writeInt(this.averageAsLogPower);
        dataOutput.writeInt(0);
        dataOutput.writeInt(2);
        dataOutput.writeInt(-20000);
        if (0 == this.obwOnOff) {
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(Integer.MIN_VALUE);
        } else {
            dataOutput.writeInt(55);
            dataOutput.writeInt(85);
            dataOutput.writeInt(855000);
            dataOutput.writeInt(-85000);
        }
        if (0 == this.iaOnOff) {
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeInt(0);
            for (int i = 0; i < 8; ++i) {
                dataOutput.writeInt(Integer.MIN_VALUE);
            }
        } else {
            dataOutput.writeInt(-95000);
            dataOutput.writeInt((int)(l / 1000L));
            dataOutput.writeInt((int)(l % 1000L));
            dataOutput.writeInt(2);
            dataOutput.writeInt(9);
            dataOutput.writeInt(11);
            for (int i = 2; i < 8; ++i) {
                dataOutput.writeInt(Integer.MIN_VALUE);
            }
        }
        dataOutput.writeInt(this.numAverages);
        dataOutput.writeInt(0);
        dataOutput.writeInt(this.obwOnOff);
        dataOutput.writeInt(95000);
        dataOutput.writeInt(this.iaOnOff);
        dataOutput.writeInt((int)(l / 1000L));
        dataOutput.writeInt((int)(l % 1000L));
        dataOutput.writeInt(0);
        dataOutput.writeInt(-95000);
        dataOutput.writeInt(0);
        dataOutput.writeInt(this.detectorType);
        dataOutput.writeInt(this.semOnOff);
    }

    private void generateKnownTrace(DataOutput dataOutput) throws IOException {
        int n;
        int[] nArray = new int[256];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = 0;
        }
        nArray[4] = 10000;
        nArray[5] = 50000;
        nArray[6] = 10000;
        nArray[253] = 10000;
        nArray[254] = 50000;
        nArray[255] = 10000;
        for (n = 0; n < nArray.length; ++n) {
            dataOutput.writeInt(nArray[n]);
        }
    }
}

