/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FreqChanActuatorConfigurator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.analyzer.SemMask;
import elgato.infrastructure.analyzer.SemMaskWCDMA;
import elgato.infrastructure.analyzer.SpectralChart;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.strategies.PercentageAdjustmentStrategy;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.util.chanstd.Bands;
import elgato.infrastructure.valueobject.PercentValueListener;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.spectrum.SpectrumLimits;

public class SpectrumMeasurementSettings
extends MeasurementSettings {
    public static final String TOPIC = "spectrum";
    public static final String TOPIC_DISPLAY = "display.spectrum";
    public static final String KEY_SPECTRUM_RBW = "rbw";
    public static final String KEY_SPECTRUM_AUTORBW = "autoRbw";
    public static final String KEY_SPECTRUM_IA_THRESHOLD = "iaThreshold";
    public static final String KEY_SPECTRUM_IA_ZOOM_TO_SIG = "zoomToSig";
    public static final String KEY_SPECTRUM_DETECTOR_TYPE = "detectorType";
    public static final String KEY_SPECTRUM_OBW = "occupiedBw";
    public static final int UPPER_LIMIT = 1;
    public static final int LOWER_LIMIT = 2;
    public boolean bSemChanStdSupported = false;
    public SemMask currentSemMask = null;
    private static SpectrumMeasurementSettings instance;
    private final DisplayGlobalMeasurementSettings globalDisplaySettings = DisplayGlobalMeasurementSettings.instance();
    private final ScaleDivActuator scaleDiv = new ScaleDivActuator("display.spectrum", 15000);
    private final FrequencyActuator span = FrequencyActuator.createKilohertz("spectrum", "span", Text.Span);
    private final FrequencyActuator centerFrequency = CenterFrequencyActuator.createCenterFrequencyActuator("spectrum", "cf");
    private final LongActuator refLevel = LongActuator.createRefLevelActuator("display.spectrum", 20000, "dBm", -150000, 100000, this.scaleDiv);
    private final FrequencyActuator stopFreq = new StopFrequencyActuator();
    private final FrequencyActuator startFreq = new StartFrequencyActuator();
    private final DisplayGlobalMeasurementSettings displayGlobalSettings = DisplayGlobalMeasurementSettings.instance();
    private final LongActuator rfInLoss = LongActuator.createLoss("spectrum", "atten", Text.RF_IN_Loss, 0);
    private final LongActuator resBandWidth = new FrequencyActuator(this.getTopic(), "rbw", Text.Res_BW);
    private final ListActuator autoResBandWidth = new ListActuator(this.getTopic(), "autoRbw", Text.Res_BW, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private final ListActuator averaging = ListActuator.createStandardAveraging("spectrum");
    private final LongActuator numAverages = LongActuator.createNumAverages("spectrum", 5000);
    private final ListActuator sensitivity = ListActuator.createSensitivity(this.getTopic());
    private final ListActuator rangeHold = ListActuator.createRangeHold("spectrum");
    private final LongActuator rangeUpDown = new LongActuator("spectrum", "rangeUpDown", "RangeUpDown");
    private final ListActuator detectorType = SpectrumMeasurementSettings.createDetectorType("spectrum");
    private final ListActuator spectrogramEnabled = new ListActuator("display.spectrum", "spectrogramEnabled", Text.Spectrogram, this.createOnOffValueSet());
    private final ListActuator spectrogramPalette = new ListActuator("display.spectrum", "spectrogramPalette", Text.Palette, SpectralChart.createPaletteValues());
    private final LongActuator spectrogramCaptureInterval = new LongActuator("display.spectrum", "spectrogramCaptureInterval", Text.Update_n_Interval);
    private final LongActuator spectrogramFrameSkip = new LongActuator("display.spectrum", "spectrogramFrameSkip", Text.Frame_Skip);
    private LongActuator calculatedAutoFrequencyStep = new FrequencyActuator("", "", "");
    private final ListActuator occupiedBw = new ListActuator(this.getTopic(), "occupiedBw", Text.Occupied_n_BW, this.createOnOffValueSet());
    private final LongActuator obwPower = LongActuator.createPercentActuator(this.getTopic(), "obwPower", Text.Power, 100000, 1000);
    private final ListActuator intfAn = new ListActuator(this.getTopic(), "intfAn", Text.Interference_n_ID, this.createOnOffValueSet());
    private final FrequencyActuator iaCf = FrequencyActuator.createKilohertz("spectrum", "iaCf", Text.Signal_n_Pointer);
    private final ListActuator iaAutoThres = new ListActuator(this.getTopic(), "iaAutoThres", Text.Threshold, new Value[]{Value.createValue(Text.Auto, 1), Value.createValue(Text.Manual, 0)});
    private final LongActuator iaThreshold = LongActuator.createPower(this.getTopic(), "iaThreshold", Text.Signal_n_Threshold);
    private final ListActuator spectrumEmissionMask = new ListActuator(this.getTopic(), "spectrumEmissionMask", Text.SEM, this.createOnOffValueSet());
    private final ListActuator semNoiseCorrection = new ListActuator(this.getTopic(), "semNoiseCorrection", "Noise Corr", this.createOnOffValueSet());
    private final ListActuator upperLowerToggle = new ListActuator("display.spectrum", "upperLowerToggle", "Limit Line", new Value[]{Value.createValue("Upper", 1), Value.createValue("Lower", 2)});
    private final SpectrumLimits lowerLimits = new SpectrumLimits(this, "lower");
    private final SpectrumLimits upperLimits = new SpectrumLimits(this, "upper");
    private final SpectrumLimits copyLowerLimits = new SpectrumLimits(this, "copyLower");
    private final SpectrumLimits copyUpperLimits = new SpectrumLimits(this, "copyUpper");
    public boolean bSemState = false;

    public static SpectrumMeasurementSettings instance() {
        if (instance == null) {
            instance = new SpectrumMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    SpectrumMeasurementSettings() {
        super(TOPIC);
        instance = this;
        this.add(this.scaleDiv);
        this.sensitivity.setValue(1);
        this.add(this.sensitivity);
        this.add(this.centerFrequency);
        this.add(this.span);
        this.add(this.rfInLoss);
        this.add(this.resBandWidth);
        this.add(this.autoResBandWidth);
        this.add(this.rangeHold);
        this.add(this.rangeUpDown);
        this.add(this.detectorType);
        this.add(this.averaging);
        this.add(this.refLevel);
        this.add(this.numAverages);
        this.add(this.spectrogramEnabled);
        this.add(this.spectrogramPalette);
        this.add(this.spectrogramCaptureInterval);
        this.add(this.spectrogramFrameSkip);
        this.add(this.occupiedBw);
        this.add(this.obwPower);
        this.add(this.intfAn);
        this.add(this.iaCf);
        this.add(this.iaAutoThres);
        this.add(this.iaThreshold);
        this.add(this.spectrumEmissionMask);
        this.add(this.semNoiseCorrection);
        this.add(this.upperLowerToggle);
        this.lowerLimits.add();
        this.upperLimits.add();
        this.setValidatorToFreqExtLimits(this.centerFrequency);
        this.setValidatorToFreqExtLimits(this.stopFreq);
        this.setValidatorToFreqExtLimits(this.startFreq);
        RangeValidator rangeValidator = new RangeValidator(1000L, Long.MAX_VALUE, 3);
        this.span.setValidator(rangeValidator);
        rangeValidator.setAdjustmentStrategy(new PercentageAdjustmentStrategy(100));
        this.makeStashedLossActuatorSet(DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.rfInLoss, DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), "SA.RfInLossListener");
        this.resBandWidth.addValueListener(PercentValueListener.createOnePercentValueListener(this.resBandWidth, "SA.rbw"));
        RangeValidator rangeValidator2 = new RangeValidator(-200000L, 100000L, 2);
        this.iaThreshold.setValidator(rangeValidator2);
        this.iaThreshold.setConversion(new FactorConversion("dBm", 1000L));
        this.calculatedAutoFrequencyStep.setWebPlugConversion(WebplugConversions.createNull());
        new FreqChanActuatorConfigurator(this.centerFrequency, this.displayGlobalSettings.getChanFreqUnits(), this.displayGlobalSettings.getChanStd(), this.displayGlobalSettings.getChannelStep(), this.displayGlobalSettings.getFrequencyStep(), BandSelector.getGlobalBandSelector(), "SA.cfListener");
        this.addFreqAutoStepValueListener();
        SpectrumValueListener spectrumValueListener = new SpectrumValueListener("freqChange"){

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumMeasurementSettings.this.startFreq.fireValueChanged();
                SpectrumMeasurementSettings.this.stopFreq.fireValueChanged();
            }
        };
        this.centerFrequency.addValueListener(spectrumValueListener);
        this.span.addValueListener(spectrumValueListener);
        this.upperLimits.setIncrement(100000);
        this.lowerLimits.setIncrement(100000);
        this.spectrogramEnabled.setValue(0);
        RangeValidator rangeValidator3 = new RangeValidator(0L, Integer.MAX_VALUE);
        this.spectrogramCaptureInterval.setUnitsFactory(new MeasurementSettings.UpdateIntervalUnitSystem());
        this.spectrogramCaptureInterval.setValidator(rangeValidator3);
        this.spectrogramFrameSkip.setUnits("frames");
        this.spectrogramFrameSkip.setValidator(rangeValidator3);
        this.globalDisplaySettings.getChanStd().addValueListener(new SpectrumValueListener("channelStandard"){

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumMeasurementSettings.this.setSemLimits(SpectrumMeasurementSettings.this.spectrumEmissionMask.booleanValue());
            }
        });
        this.spectrumEmissionMask.addValueListener(new SpectrumValueListener("spectrumEmissionMask"){

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.booleanValue()) {
                    if (!SpectrumMeasurementSettings.this.bSemState) {
                        SpectrumMeasurementSettings.this.storeLimits();
                    }
                    SpectrumMeasurementSettings.this.bSemState = true;
                    SpectrumMeasurementSettings.this.setSemLimits(true);
                } else if (SpectrumMeasurementSettings.this.bSemState) {
                    SpectrumMeasurementSettings.this.restoreLimits();
                    SpectrumMeasurementSettings.this.bSemState = false;
                }
            }
        });
        this.centerFrequency.addValueListener(new SpectrumValueListener("centerFrequency"){

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumMeasurementSettings.this.upperLimits.syncCenterFrequency();
                SpectrumMeasurementSettings.this.lowerLimits.syncCenterFrequency();
            }
        });
        this.refresh();
    }

    public void setSemRefPwr(long l, boolean bl) {
        if (bl) {
            Band band = Band.getCurrentBand(BandSelector.getGlobalBandSelector());
            if (band.equals(Bands.BAND_US_PCS) || band.equals(Bands.BAND_US_CELLULAR_CDMA) || band.equals(Bands.BAND_JAPAN_CDMA) || band.equals(Bands.BAND_KOREAN_PCS) || band.equals(Bands.BAND_NMT_450) || band.equals(Bands.BAND_IMT_2000) || band.equals(Bands.BAND_SECONDARY_800)) {
                this.upperLimits.getMaskLevel().setValue(l);
            } else if ((band.equals(Bands.BAND_UMTS) || band.equals(Bands.BAND_UMTS_B) || band.equals(Bands.BAND_UMTS_DISCRETE)) && this.currentSemMask != null) {
                this.currentSemMask.referenceLevel = l;
            }
            this.setSemLimits(bl);
        }
    }

    public void setSemLimits(boolean bl) {
        if (bl) {
            Band band = Band.getCurrentBand(BandSelector.getGlobalBandSelector());
            if (band.equals(Bands.BAND_US_PCS) || band.equals(Bands.BAND_KOREAN_PCS) || band.equals(Bands.BAND_IMT_2000)) {
                this.bSemChanStdSupported = true;
                this.currentSemMask = null;
                this.upperLimits.getGroupThreeOnOff().setValue(1);
                this.upperLimits.getGroupTwoOnOff().setValue(1);
                this.upperLimits.getGroupOneOnOff().setValue(1);
                this.lowerLimits.getGroupOneOnOff().setValue(0);
                this.lowerLimits.getGroupTwoOnOff().setValue(0);
                this.lowerLimits.getGroupThreeOnOff().setValue(0);
                this.upperLimits.getMaskCenterFrequency().setValue(this.getCenterFrequency().intValue());
                this.upperLimits.getMaskSpan().setValue(1770000);
                this.upperLimits.getMaskSpanGroupTwoLower().setValue(1095000);
                this.upperLimits.getMaskSpanGroupTwoUpper().setValue(1095000);
                this.upperLimits.getMaskLevelGroupTwoLower().setValue(-45000L);
                this.upperLimits.getMaskLevelGroupTwoUpper().setValue(-45000L);
                this.upperLimits.getMaskLevelGroupThreeLower().setValue(-55000L);
                this.upperLimits.getMaskLevelGroupThreeUpper().setValue(-55000L);
            } else if (band.equals(Bands.BAND_US_CELLULAR_CDMA) || band.equals(Bands.BAND_JAPAN_CDMA) || band.equals(Bands.BAND_NMT_450) || band.equals(Bands.BAND_SECONDARY_800)) {
                this.bSemChanStdSupported = true;
                this.currentSemMask = null;
                this.upperLimits.getGroupThreeOnOff().setValue(1);
                this.upperLimits.getGroupTwoOnOff().setValue(1);
                this.upperLimits.getGroupOneOnOff().setValue(1);
                this.lowerLimits.getGroupOneOnOff().setValue(0);
                this.lowerLimits.getGroupTwoOnOff().setValue(0);
                this.lowerLimits.getGroupThreeOnOff().setValue(0);
                this.upperLimits.getMaskCenterFrequency().setValue(this.getCenterFrequency().intValue());
                this.upperLimits.getMaskSpan().setValue(1500000);
                this.upperLimits.getMaskSpanGroupTwoLower().setValue(1230000);
                this.upperLimits.getMaskSpanGroupTwoUpper().setValue(1230000);
                this.upperLimits.getMaskLevelGroupTwoLower().setValue(-45000L);
                this.upperLimits.getMaskLevelGroupTwoUpper().setValue(-45000L);
                this.upperLimits.getMaskLevelGroupThreeLower().setValue(-60000L);
                this.upperLimits.getMaskLevelGroupThreeUpper().setValue(-60000L);
            } else if (band.equals(Bands.BAND_UMTS) || band.equals(Bands.BAND_UMTS_B) || band.equals(Bands.BAND_UMTS_DISCRETE)) {
                this.bSemChanStdSupported = true;
                this.currentSemMask = new SemMaskWCDMA();
                this.span.setValue(this.currentSemMask.totalSpan * 1000L);
                this.upperLimits.getGroupThreeOnOff().setValue(0);
                this.upperLimits.getGroupThreeOnOff().send();
                this.upperLimits.getGroupTwoOnOff().setValue(0);
                this.upperLimits.getGroupTwoOnOff().send();
                this.upperLimits.getGroupOneOnOff().setValue(0);
                this.upperLimits.getGroupOneOnOff().send();
            } else {
                this.bSemChanStdSupported = false;
                this.currentSemMask = null;
                this.upperLimits.getGroupThreeOnOff().setValue(0);
                this.upperLimits.getGroupThreeOnOff().send();
                this.upperLimits.getGroupTwoOnOff().setValue(0);
                this.upperLimits.getGroupTwoOnOff().send();
                this.upperLimits.getGroupOneOnOff().setValue(0);
                this.upperLimits.getGroupOneOnOff().send();
            }
        }
    }

    public void restoreLimits() {
        this.upperLimits.copyLimits(this.copyUpperLimits);
        this.lowerLimits.copyLimits(this.copyLowerLimits);
    }

    public void storeLimits() {
        this.copyUpperLimits.copyLimits(this.upperLimits);
        this.copyLowerLimits.copyLimits(this.lowerLimits);
    }

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.upperLimits.getMaskSpan(), this.upperLimits.getMaskSpanGroupTwoLower(), this.upperLimits.getMaskSpanGroupTwoUpper(), this.upperLimits.getMaskCenterFrequency(), this.upperLimits.getMaskLevel(), this.upperLimits.getMaskLevelGroupTwoUpper(), this.upperLimits.getMaskLevelGroupTwoLower(), this.upperLimits.getMaskLevelGroupThreeUpper(), this.upperLimits.getMaskLevelGroupThreeLower()};
    }

    private void addFreqAutoStepValueListener() {
        ListActuator listActuator = DisplayGlobalMeasurementSettings.instance().getFrequencyAutoStepEnabled();
        SpectrumValueListener spectrumValueListener = new SpectrumValueListener("freqAutoStep"){

            public void valueChanged(ValueInterface valueInterface) {
                SpectrumMeasurementSettings.this.updateFreqIncrement();
            }
        };
        ListActuator listActuator2 = DisplayGlobalMeasurementSettings.instance().getChanFreqUnits();
        listActuator2.addValueListener(spectrumValueListener);
        listActuator.addValueListener(spectrumValueListener);
        this.span.addValueListener(spectrumValueListener);
        DisplayGlobalMeasurementSettings.instance().getFrequencyStep().addValueListener(spectrumValueListener);
        DisplayGlobalMeasurementSettings.instance().getChannelStep().addValueListener(spectrumValueListener);
    }

    private static ListActuator createDetectorType(String string) {
        return new ListActuator(string, KEY_SPECTRUM_DETECTOR_TYPE, Text.Detector, new Value[]{Value.createValue(Text.Peak, 0), Value.createValue(Text.Sample, 1), Value.createValue(Text.Negative_n_Peak, 2), Value.createValue(Text.Average, 3)});
    }

    private void updateFreqIncrement() {
        DisplayGlobalMeasurementSettings displayGlobalMeasurementSettings = DisplayGlobalMeasurementSettings.instance();
        if (!displayGlobalMeasurementSettings.isChannelSelected()) {
            if (displayGlobalMeasurementSettings.getFrequencyAutoStepEnabled().booleanValue()) {
                this.setFreqIncrement((int)(this.span.longValue() / 10L));
            } else {
                this.setFreqIncrement(displayGlobalMeasurementSettings.getFrequencyStep().intValue());
            }
        }
    }

    private void setFreqIncrement(int n) {
        this.calculatedAutoFrequencyStep.setValue(n);
        this.centerFrequency.setIncrement(n);
        this.startFreq.setIncrement(n);
        this.stopFreq.setIncrement(n);
        this.upperLimits.setIncrement(n);
        this.lowerLimits.setIncrement(n);
    }

    public ListActuator getUpperLowerToggle() {
        return this.upperLowerToggle;
    }

    public FrequencyActuator getCenterFrequency() {
        return this.centerFrequency;
    }

    public SpectrumLimits getLowerLimits() {
        return this.lowerLimits;
    }

    public SpectrumLimits getUpperLimits() {
        return this.upperLimits;
    }

    public FrequencyActuator getStopFreq() {
        return this.stopFreq;
    }

    public FrequencyActuator getStartFreq() {
        return this.startFreq;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public FrequencyActuator getSpan() {
        return this.span;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRfInLoss() {
        return this.rfInLoss;
    }

    public LongActuator getResBandWidth() {
        return this.resBandWidth;
    }

    public ListActuator getAutoResBandWidth() {
        return this.autoResBandWidth;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public ListActuator getSensitivity() {
        return this.sensitivity;
    }

    public ListActuator getRangeHold() {
        return this.rangeHold;
    }

    public LongActuator getRangeUpDown() {
        return this.rangeUpDown;
    }

    public ListActuator getSpectrogramEnabled() {
        return this.spectrogramEnabled;
    }

    public ListActuator getSpectrogramPalette() {
        return this.spectrogramPalette;
    }

    public LongActuator getSpectrogramCaptureInterval() {
        return this.spectrogramCaptureInterval;
    }

    public LongActuator getSpectrogramFrameSkip() {
        return this.spectrogramFrameSkip;
    }

    public ListActuator getOccupiedBw() {
        return this.occupiedBw;
    }

    public LongActuator getObwPower() {
        return this.obwPower;
    }

    public ListActuator getIntfAn() {
        return this.intfAn;
    }

    public FrequencyActuator getIaCf() {
        return this.iaCf;
    }

    public ListActuator getIaAutoThres() {
        return this.iaAutoThres;
    }

    public LongActuator getIaThreshold() {
        return this.iaThreshold;
    }

    public ListActuator getDetectorType() {
        return this.detectorType;
    }

    public ListActuator getSpectrumEmissionMask() {
        return this.spectrumEmissionMask;
    }

    public ListActuator getSemNoiseCorrection() {
        return this.semNoiseCorrection;
    }

    public ValueInterface getCalculatedAutoFrequencyStep() {
        return this.calculatedAutoFrequencyStep;
    }

    public DisplayGlobalMeasurementSettings getDisplayGlobalMeasurementSettings() {
        return this.displayGlobalSettings;
    }

    public long getBottomPowerLevel() {
        return this.getRefLevel().longValue() - 10L * this.getScaleDiv().longValue();
    }

    protected abstract class SpectrumValueListener
    implements ValueListener {
        private final String listenerName;

        public SpectrumValueListener(String string) {
            this.listenerName = "SA." + string + ".listener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public abstract /* synthetic */ void valueChanged(ValueInterface var1);
    }

    private class StopFrequencyActuator
    extends ComputedFrequencyActuator {
        public StopFrequencyActuator() {
            super(SpectrumMeasurementSettings.TOPIC_DISPLAY, "stop", Text.Stop_Freq);
        }

        public void setValue(long l) {
            super.setValue(l);
            l = super.longValue();
            long l2 = l - SpectrumMeasurementSettings.this.startFreq.longValue();
            SpectrumMeasurementSettings.this.span.send(l2);
            SpectrumMeasurementSettings.this.centerFrequency.send(l - this.halfSpan());
        }

        public long longValue() {
            return SpectrumMeasurementSettings.this.centerFrequency.longValue() + this.halfSpan();
        }
    }

    private class StartFrequencyActuator
    extends ComputedFrequencyActuator {
        public StartFrequencyActuator() {
            super(SpectrumMeasurementSettings.TOPIC_DISPLAY, "start", Text.Start_Freq);
        }

        public void setValue(long l) {
            super.setValue(l);
            l = super.longValue();
            long l2 = SpectrumMeasurementSettings.this.stopFreq.longValue() - l;
            SpectrumMeasurementSettings.this.span.send(l2);
            SpectrumMeasurementSettings.this.centerFrequency.send(l + this.halfSpan());
        }

        public long longValue() {
            return SpectrumMeasurementSettings.this.centerFrequency.longValue() - this.halfSpan();
        }
    }

    private abstract class ComputedFrequencyActuator
    extends FrequencyActuator {
        public ComputedFrequencyActuator(String string, String string2, String string3) {
            super(string, string2, string3);
            this.setWebPlugConversion(WebplugConversions.createNull());
        }

        protected long halfSpan() {
            return SpectrumMeasurementSettings.this.span.longValue() / 2L;
        }
    }
}

