/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.gui.MainWindow;
import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.actuators.TrimodeActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.marker.MarkerButtonFactory;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.RangeControlMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.peakSearch.PeakFinder;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.spectrum.SpectrumAnalyzer;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class SpectrumMenuMgr
extends MeasurementMenuMgr {
    protected static final Logger logger = LogManager.getLogger(class$elgato$measurement$spectrum$SpectrumMenuMgr == null ? (class$elgato$measurement$spectrum$SpectrumMenuMgr = SpectrumMenuMgr.class$("elgato.measurement.spectrum.SpectrumMenuMgr")) : class$elgato$measurement$spectrum$SpectrumMenuMgr);
    protected SpectrumAnalyzer analyzer;
    SpectrumMeasurementSettings settings;
    protected MarkerButtonFactory markerButtonFactory;
    protected Menu freqChanMenu;
    boolean pointerToPeakButtonOn = false;
    ActuatorEditor signalPointerButton;
    TrimodeActuatorButton rbwButton;
    protected Menu leftMenu = null;
    PeakButtonData maxPeakData = new PeakButtonData();
    protected ActuatorEditor startFreqButton;
    protected ActuatorEditor stopFreqButton;
    Menu spectrogramMenu;
    Menu menu;
    Menu iaMenu;
    MultiStateActuatorButton upperLowerToggle;
    final ActionButton[] upperButtons = new ActionButton[15];
    final ActionButton[] lowerButtons = new ActionButton[15];
    ActionButton[] limitButtons = this.upperButtons;
    private static final int GROUP_1_ON_OFF = 0;
    private static final int LEVEL_GROUP_TWO_LOWER = 1;
    private static final int LEVEL_GROUP_TWO_UPPER = 2;
    private static final int LEVEL_GROUP_THREE_LOWER = 3;
    private static final int LEVEL_GROUP_THREE_UPPER = 4;
    private static final int SPAN_GROUP_TWO_LOWER = 5;
    private static final int SPAN_GROUP_TWO_UPPER = 6;
    private static final int LEVEL_TWO_SELECT = 7;
    private static final int LEVEL_THREE_SELECT = 8;
    private static final int GROUP_BUTTON = 9;
    private static final int CENTER_FREQ = 10;
    private static final int SPAN = 11;
    private static final int LEVEL = 12;
    private static final int GROUP_TWO_ON_OFF = 13;
    private static final int GROUP_THREE_ON_OFF = 14;
    private ValueListener spectrogramEnabledValueListener = new ValueListener(){
        private final String listenerName = "SpectrumScreen.spectrogramEnabledValueListener";

        public String getListenerName() {
            return "SpectrumScreen.spectrogramEnabledValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = SpectrumMenuMgr.this.spectrogramMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
        }
    };
    private ValueListener iaEnabledValueListener = new ValueListener(){
        private final String listenerName = "SpectrumScreen.iaEnabledValueListener";

        public String getListenerName() {
            return "SpectrumScreen.iaEnabledValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            boolean bl = valueInterface.booleanValue();
            MenuItem[] menuItemArray = SpectrumMenuMgr.this.iaMenu.getItems();
            for (int i = 1; i < menuItemArray.length && i != 6; ++i) {
                if (menuItemArray[i] == null) continue;
                menuItemArray[i].setEnabled(bl);
            }
            if (!SpectrumMenuMgr.this.pointerToPeakButtonOn) {
                SpectrumMenuMgr.this.maxPeakData.nextPeakButton.setEnabled(false);
            }
            if (bl) {
                SpectrumMenuMgr.this.iaMenu.setDefaultItem(1);
                try {
                    SpectrumMenuMgr.this.signalPointerButton.press();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    };
    static /* synthetic */ Class class$elgato$measurement$spectrum$SpectrumMenuMgr;

    public void cleanup() {
        super.cleanup();
        this.markerButtonFactory = null;
        this.settings = null;
        this.analyzer = null;
    }

    public SpectrumMenuMgr(MeasurementScreen measurementScreen, SpectrumMeasurementSettings spectrumMeasurementSettings, SpectrumAnalyzer spectrumAnalyzer) {
        super(measurementScreen);
        this.settings = spectrumMeasurementSettings;
        this.analyzer = spectrumAnalyzer;
        this.upperLowerToggle = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLowerToggle(), "", this.getListenerBaseName() + ".upperLowerToggle");
        this.startFreqButton = this.createStartFreqButton();
        this.stopFreqButton = this.createStopFreqButton();
        this.markerButtonFactory = this.createMarkerButtonFactory();
        this.upperButtons[0] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getGroupOneOnOff(), "", this.getListenerBaseName() + ".ul.g1.OnOff");
        this.upperButtons[1] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskLevelGroupTwoLower(), this.getContextString("mask.level.GroupTwo.lower"), this.getListenerBaseName() + ".ul.g2.lLim");
        this.upperButtons[2] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskLevelGroupTwoUpper(), this.getContextString("mask.level.GroupTwo.upper"), this.getListenerBaseName() + ".ul.g2.uLim");
        this.upperButtons[3] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskLevelGroupThreeLower(), this.getContextString("mask.span.GroupThree.lower"), this.getListenerBaseName() + ".ul.g3.lLim");
        this.upperButtons[4] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskLevelGroupThreeUpper(), this.getContextString("mask.span.GroupThree.upper"), this.getListenerBaseName() + ".ul.g3.uLim");
        this.upperButtons[5] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskSpanGroupTwoLower(), this.getContextString("mask.span.GroupTwo.lower"), this.getListenerBaseName() + ".ul.g2span.lLim");
        this.upperButtons[6] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskSpanGroupTwoUpper(), this.getContextString("mask.span.GroupTwo.upper"), this.getListenerBaseName() + ".ul.g2span.uLim");
        this.upperButtons[7] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getMaskLevelTwoSelect(), "mask.group.two.select", this.getListenerBaseName() + ".ul.g2.select");
        this.upperButtons[8] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getMaskLevelThreeSelect(), "mask.group.three.select", this.getListenerBaseName() + ".ul.g3.select");
        this.upperButtons[9] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getLimitsMaskGroups(), "", this.getListenerBaseName() + ".ul.limMaskGrps");
        this.upperButtons[10] = null;
        this.upperButtons[11] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskSpan(), this.getContextString("mask.span"), this.getListenerBaseName() + ".ul.maskSpan");
        this.upperButtons[12] = new ActuatorEditor(spectrumMeasurementSettings.getUpperLimits().getMaskLevel(), this.getContextString("mask.level"), this.getListenerBaseName() + ".ul.maskLevel");
        this.upperButtons[13] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getGroupTwoOnOff(), "", this.getListenerBaseName() + ".ul.g2.onOff");
        this.upperButtons[14] = new MultiStateActuatorButton(spectrumMeasurementSettings.getUpperLimits().getGroupThreeOnOff(), "", this.getListenerBaseName() + ".ul.g3.onOff");
        this.lowerButtons[0] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getGroupOneOnOff(), "", this.getListenerBaseName() + ".ll.g1.OnOff");
        this.lowerButtons[1] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskLevelGroupTwoLower(), this.getContextString("mask.level.GroupTwo.lower"), this.getListenerBaseName() + ".ll.g2.lLim");
        this.lowerButtons[2] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskLevelGroupTwoUpper(), this.getContextString("mask.level.GroupTwo.upper"), this.getListenerBaseName() + ".ll.g2.uLim");
        this.lowerButtons[3] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskLevelGroupThreeLower(), this.getContextString("mask.span.GroupThree.lower"), this.getListenerBaseName() + ".ll.g3.lLim");
        this.lowerButtons[4] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskLevelGroupThreeUpper(), this.getContextString("mask.span.GroupThree.upper"), this.getListenerBaseName() + ".ll.g3.uLim");
        this.lowerButtons[5] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskSpanGroupTwoLower(), this.getContextString("mask.span.GroupTwo.lower"), this.getListenerBaseName() + ".ll.g2span.lLim");
        this.lowerButtons[6] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskSpanGroupTwoUpper(), this.getContextString("mask.span.GroupTwo.upper"), this.getListenerBaseName() + ".ll.g2span.uLim");
        this.lowerButtons[7] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getMaskLevelTwoSelect(), "mask.group.two.select", this.getListenerBaseName() + ".ll.g2.select");
        this.lowerButtons[8] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getMaskLevelThreeSelect(), "mask.group.three.select", this.getListenerBaseName() + ".ll.g3.select");
        this.lowerButtons[9] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getLimitsMaskGroups(), "", this.getListenerBaseName() + ".ll.limMaskGrps");
        this.lowerButtons[10] = null;
        this.lowerButtons[11] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskSpan(), this.getContextString("mask.span"), this.getListenerBaseName() + ".ll.maskSpan");
        this.lowerButtons[12] = new ActuatorEditor(spectrumMeasurementSettings.getLowerLimits().getMaskLevel(), this.getContextString("mask.level"), this.getListenerBaseName() + ".ll.maskLevel");
        this.lowerButtons[13] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getGroupTwoOnOff(), "", this.getListenerBaseName() + ".ll.g2.OnOff");
        this.lowerButtons[14] = new MultiStateActuatorButton(spectrumMeasurementSettings.getLowerLimits().getGroupThreeOnOff(), "", this.getListenerBaseName() + ".ll.g3.OnOff");
    }

    protected abstract MenuButton createFreqChanButton();

    protected abstract MenuItem createMeasurementsButton();

    protected abstract MenuButton createSetupMenuButton();

    public Menu buildLeftMenu() {
        if (this.leftMenu != null) {
            return this.leftMenu;
        }
        Menu menu = new Menu(Text.Spectrum, new MenuItem[]{this.createFreqChanButton(), this.createLevelMenuButton(), this.createMeasurementsButton(), null, this.createAvgSweepButton(), this.createSetupMenuButton(), this.createMarkerButton()});
        return menu;
    }

    public void prolog() {
        this.setupFreqChanUnitsListener();
        this.addValueListeners();
    }

    protected ActuatorEditor createStartFreqButton() {
        return new ActuatorEditor(this.settings.getStartFreq(), this.scn.getContextString("frequencyChannel.startFrequency"), "SpectrumScreen.startFreqButton");
    }

    protected ActuatorEditor createStopFreqButton() {
        return new ActuatorEditor(this.settings.getStopFreq(), this.scn.getContextString("frequencyChannel.stopFrequency"), "SpectrumScreen.stopFreqButton");
    }

    protected ActuatorEditor createCenterFreqButton() {
        return (ActuatorEditor)this.createCenterFrequencyButton();
    }

    protected MenuButton createAvgSweepButton() {
        return this.createAverageSweepButton(this.settings.getNumAverages(), this.settings.getAveraging());
    }

    protected MenuButton createMarkerButton() {
        return this.markerButtonFactory.getMenuButton();
    }

    protected SubMenuButton createInterferenceIDButton() {
        this.makeSignalPointerToMaxPeakButtons();
        this.iaMenu = new Menu(Text.Interference, new MenuItem[]{this.createInterferenceIdButton(), this.createSignalPointerButton(), this.createThresholdButton(), this.maxPeakData.peakButton, this.maxPeakData.nextPeakButton, this.createIaZoomButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Interference_n_ID, this.getContextId(), this.iaMenu, true);
        boolean bl = MeasurementFactory.instance().optionAvailable("interferenceAn");
        if (!bl) {
            this.settings.getIntfAn().send(0);
        }
        subMenuButton.setEnabled(bl);
        this.iaEnabledValueListener.valueChanged(this.settings.getIntfAn());
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ActuatorEditor createSignalPointerButton() {
        this.signalPointerButton = new ActuatorEditor(this.settings.getIaCf(), this.getContextId(), this.getListenerBaseName() + ".signalPointerButton");
        return this.signalPointerButton;
    }

    protected MultiStateActuatorButton createInterferenceIdButton() {
        return new MultiStateActuatorButton(this.settings.getIntfAn(), this.getContextId(), this.getListenerBaseName() + ".iaMenuButton");
    }

    private SubMenuButton createIaZoomButton() {
        Menu menu = new Menu(Text.IA_Zoom, new MenuItem[]{this.createZoomToSignalButton(), this.createZoomOutButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Zoom, this.getContextId(), menu);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected ZoomInOutButton createZoomToSignalButton() {
        return new ZoomInOutButton(Text.Zoom_To_n_Signal, this.getContextString("Zoom to Signal"), 1);
    }

    protected ZoomInOutButton createZoomOutButton() {
        return new ZoomInOutButton(Text.Zoom_Out, this.getContextString("Zoom out"), -1);
    }

    protected SubMenuButton createOccupiedBWButton() {
        Menu menu = new Menu(Text.Occu_BW, new MenuItem[]{this.createObwOnOffButton(), this.createObwPowerButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Occupied_n_BW, this.getContextId(), menu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected MultiStateActuatorButton createObwOnOffButton() {
        return new MultiStateActuatorButton(this.settings.getOccupiedBw(), this.getContextId(), this.getListenerBaseName() + ".obwEnabledButton");
    }

    protected ActuatorEditor createObwPowerButton() {
        return new ActuatorEditor(this.settings.getObwPower(), this.getContextId(), this.getListenerBaseName() + ".obwPwrPct");
    }

    protected SubMenuButton createSpectrogramButton() {
        this.spectrogramMenu = new Menu(Text.Spectrogram, new MenuItem[]{this.createSpectrumOnOffButton(), this.createResetSpectrogramButton(this.getContextId()), this.createSpectrogramCaptureIntervalButton(), this.createSpectrogramFrameSkipButton(), this.createSpectrogramPaletteButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.Spectrogram, this.getContextId(), this.spectrogramMenu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        boolean bl = MeasurementFactory.instance().optionAvailable("spectrogram");
        if (!bl) {
            this.settings.getSpectrogramEnabled().send(0);
        }
        subMenuButton.setEnabled(bl);
        this.spectrogramEnabledValueListener.valueChanged(this.settings.getSpectrogramEnabled());
        return subMenuButton;
    }

    protected MultiStateActuatorButton createSpectrumOnOffButton() {
        return new MultiStateActuatorButton(this.settings.getSpectrogramEnabled(), this.getContextId(), this.getListenerBaseName() + ".spectrogramEnabledButton");
    }

    private MenuItem createResetSpectrogramButton(String string) {
        return new PushButton(Text.Reset_n_Spectrogram, string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.analyzer.clearSpectrogramHistory();
            }
        });
    }

    private MenuItem createSpectrogramCaptureIntervalButton() {
        return new ActuatorEditor(this.settings.getSpectrogramCaptureInterval(), "spectrogramCaptureInterval", this.getListenerBaseName() + ".spectogramCapIntervalButton");
    }

    private MenuItem createSpectrogramFrameSkipButton() {
        return new ActuatorEditor(this.settings.getSpectrogramFrameSkip(), "spectrogramFrameSkip", this.getListenerBaseName() + ".spectogramFrameSkipButton");
    }

    private MenuItem createSpectrogramPaletteButton() {
        return new ActuatorSubMenuButton(this.settings.getSpectrogramPalette(), "spectrogramPalette", true, this.getListenerBaseName() + ".spectogramPaletteButton");
    }

    protected SubMenuButton createSemButton() {
        Menu menu = new Menu(Text.SEM, new MenuItem[]{this.createSemOnOffButton(), this.createSemNoiseCorrButton()});
        SubMenuButton subMenuButton = new SubMenuButton(Text.SEM, this.getContextId(), menu, true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    protected MultiStateActuatorButton createSemOnOffButton() {
        return new MultiStateActuatorButton(this.settings.getSpectrumEmissionMask(), this.getContextId(), this.getListenerBaseName() + ".semEnabledButton");
    }

    protected MultiStateActuatorButton createSemNoiseCorrButton() {
        return new MultiStateActuatorButton(this.settings.getSemNoiseCorrection(), this.getContextId(), this.getListenerBaseName() + ".semNoiseCorrButton");
    }

    public void addValueListeners() {
        this.settings.getSpan().addValueListener(this.startFreqButton);
        this.settings.getCenterFrequency().addValueListener(this.startFreqButton);
        this.settings.getSpan().addValueListener(this.startFreqButton.getField());
        this.settings.getCenterFrequency().addValueListener(this.startFreqButton.getField());
        this.settings.getSpan().addValueListener(this.stopFreqButton);
        this.settings.getCenterFrequency().addValueListener(this.stopFreqButton);
        this.settings.getSpan().addValueListener(this.stopFreqButton.getField());
        this.settings.getCenterFrequency().addValueListener(this.stopFreqButton.getField());
        this.settings.getSpectrogramEnabled().addValueListener(this.spectrogramEnabledValueListener);
        this.settings.getIntfAn().addValueListener(this.iaEnabledValueListener);
    }

    public void removeValueListeners() {
        this.settings.getSpan().removeValueListener(this.startFreqButton);
        this.settings.getCenterFrequency().removeValueListener(this.startFreqButton);
        this.settings.getSpan().removeValueListener(this.startFreqButton.getField());
        this.settings.getCenterFrequency().removeValueListener(this.startFreqButton.getField());
        this.settings.getSpan().removeValueListener(this.stopFreqButton);
        this.settings.getCenterFrequency().removeValueListener(this.stopFreqButton);
        this.settings.getSpan().removeValueListener(this.stopFreqButton.getField());
        this.settings.getCenterFrequency().removeValueListener(this.stopFreqButton.getField());
        this.settings.getSpectrogramEnabled().removeValueListener(this.spectrogramEnabledValueListener);
        this.spectrogramEnabledValueListener = null;
        this.settings.getIntfAn().removeValueListener(this.iaEnabledValueListener);
        this.iaEnabledValueListener = null;
    }

    public MenuItem createCenterFrequencyButton() {
        return new ActuatorEditor(this.settings.getCenterFrequency(), this.getContextString("frequencyChannel.cf"), this.getListenerBaseName() + ".cfButton");
    }

    public MenuItem createSpanButton() {
        return new ActuatorEditor(this.settings.getSpan(), this.getContextString("frequencyChannel.span"), this.getListenerBaseName() + ".spanButton");
    }

    protected MenuButton createLevelMenuButton() {
        LevelButtonFactory levelButtonFactory = new LevelButtonFactory(this.scn, this.analyzer, this.settings.getRefLevel(), this.settings.getScaleDiv(), true);
        MenuButton menuButton = levelButtonFactory.createMinimalLevelMenu();
        menuButton.addMenuItem(6, MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), this.settings.getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), this.getListenerBaseName() + ".RfInLossButton"));
        return menuButton;
    }

    protected String getMeasurementName() {
        return "spectrum";
    }

    protected RangeControlMenuButton createRangeControlMenuButton() {
        return new RangeControlMenuButton(this.scn, this.settings.getRangeHold(), this.settings.getRangeUpDown());
    }

    protected ActuatorSubMenuButton createDetectorTypeButton() {
        return new ActuatorSubMenuButton(this.settings.getDetectorType(), this.getContextString("detector"), true, this.getListenerBaseName() + ".detectorType");
    }

    protected MenuItem createLimitsButton() {
        this.limitButtons = this.settings.getUpperLowerToggle().longValue() == 2L ? this.lowerButtons : this.upperButtons;
        this.menu = new Menu("", new MenuItem[]{this.upperLowerToggle, this.limitButtons[9], this.limitButtons[0], this.limitButtons[10], this.limitButtons[12], this.limitButtons[11]});
        SubMenuButton subMenuButton = new SubMenuButton("Limits", "", this.menu);
        this.setInitialEnableStatesForLimitButtons();
        ((MultiStateActuatorButton)this.limitButtons[9]).setCurrentState(1);
        subMenuButton.setCancelButtonTitle(Text.Back);
        subMenuButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMeasurementSettings.instance().getLowerLimits().setMaskDefaults();
                SpectrumMeasurementSettings.instance().getUpperLimits().setMaskDefaults();
                SpectrumMenuMgr.this.setInitialEnableStatesForLimitButtons();
                SpectrumMenuMgr.this.configureMenuItems();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.setInitialEnableStatesForLimitButtons();
            }
        };
        this.upperButtons[0].addActionListener(actionListener);
        this.lowerButtons[0].addActionListener(actionListener);
        this.upperLowerToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.swapUpperLowerLimitButtons();
            }
        });
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.configureMenuItems();
                MainWindow.getRootPanel().repaint();
            }
        };
        this.lowerButtons[9].addActionListener(actionListener2);
        this.upperButtons[9].addActionListener(actionListener2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.enableOrDisableButtonsBelowGroupOnOffForLimitsMenu((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[13]);
                if (((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[13]).getActuator().getSelectedValue().intValue() == 0) {
                    ((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[14]).setCurrentState(0);
                    SpectrumMenuMgr.this.limitButtons[14].setEnabled(false);
                    SpectrumMenuMgr.this.setGroupThreeSelectAndLevelButtonsEnabled(false);
                } else {
                    SpectrumMenuMgr.this.limitButtons[5].setEnabled(((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L);
                    SpectrumMenuMgr.this.limitButtons[6].setEnabled(((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L);
                    SpectrumMenuMgr.this.limitButtons[14].setEnabled(true);
                }
            }
        };
        this.upperButtons[13].addActionListener(actionListener3);
        this.lowerButtons[13].addActionListener(actionListener3);
        ActionListener actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.setGroupThreeSelectAndLevelButtonsEnabled(((MultiStateActuatorButton)SpectrumMenuMgr.this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L);
            }
        };
        this.upperButtons[14].addActionListener(actionListener4);
        this.lowerButtons[14].addActionListener(actionListener4);
        actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.swapGroupTwoLevelAndSpanButtons();
            }
        };
        this.upperButtons[7].addActionListener(actionListener4);
        this.lowerButtons[7].addActionListener(actionListener4);
        actionListener4 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpectrumMenuMgr.this.swapGroupThreeLevelButtons();
            }
        };
        this.upperButtons[8].addActionListener(actionListener4);
        this.lowerButtons[8].addActionListener(actionListener4);
        return subMenuButton;
    }

    private void configureMenuItems() {
        boolean bl;
        long l = ((MultiStateActuatorButton)this.limitButtons[9]).getActuator().getSelectedValue().longValue();
        boolean bl2 = bl = ((MultiStateActuatorButton)this.limitButtons[0]).getActuator().getSelectedValue().longValue() == 1L;
        if (l == 1L) {
            this.menu.setMenuItem(this.limitButtons[0], 2);
            this.menu.setMenuItem(this.limitButtons[10], 3);
            this.menu.setMenuItem(this.limitButtons[12], 4);
            this.menu.setMenuItem(this.limitButtons[11], 5);
            this.enableOrDisableButtonsForLimitsMenu(true, 1, 5);
            this.limitButtons[11].setEnabled(((MultiStateActuatorButton)this.limitButtons[13]).getActuator().getSelectedValue().longValue() == 1L);
        } else if (l == 2L) {
            this.menu.setMenuItem((MultiStateActuatorButton)this.limitButtons[13], 2);
            this.menu.setMenuItem(this.limitButtons[7], 3);
            this.swapGroupTwoLevelAndSpanButtons();
            this.enableOrDisableButtonsForLimitsMenu(bl, 2, 2);
            this.enableOrDisableButtonsBelowGroupOnOffForLimitsMenu((MultiStateActuatorButton)this.limitButtons[13]);
            this.limitButtons[5].setEnabled(((MultiStateActuatorButton)this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L);
            this.limitButtons[6].setEnabled(((MultiStateActuatorButton)this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L);
            if (!bl) {
                this.enableOrDisableButtonsForLimitsMenu(false, 2, 5);
            }
        } else {
            this.menu.setMenuItem((MultiStateActuatorButton)this.limitButtons[14], 2);
            this.menu.setMenuItem(this.limitButtons[8], 3);
            this.swapGroupThreeLevelButtons();
            this.menu.setMenuItem(null, 5);
            this.enableOrDisableButtonsForLimitsMenu(bl, 2, 2);
            this.limitButtons[14].setEnabled(((MultiStateActuatorButton)this.limitButtons[13]).getActuator().getSelectedValue().longValue() == 1L);
            boolean bl3 = ((MultiStateActuatorButton)this.limitButtons[14]).getActuator().getSelectedValue().longValue() == 1L;
            this.limitButtons[8].setEnabled(bl3);
            this.limitButtons[3].setEnabled(bl3);
            this.limitButtons[4].setEnabled(bl3);
            if (!bl) {
                this.enableOrDisableButtonsForLimitsMenu(false, 2, 5);
            }
        }
    }

    void setInitialEnableStatesForLimitButtons() {
        long l = ((MultiStateActuatorButton)this.limitButtons[9]).getActuator().getSelectedValue().longValue();
        long l2 = ((MultiStateActuatorButton)this.limitButtons[13]).getActuator().getSelectedValue().longValue();
        if (l == 1L) {
            this.enableOrDisableButtonsForLimitsMenu(true, 1, 5);
            this.limitButtons[11].setEnabled(l2 == 1L);
        } else if (l == 2L) {
            this.enableOrDisableButtonsForLimitsMenu(true, 1, 2);
            this.enableOrDisableButtonsBelowGroupOnOffForLimitsMenu((MultiStateActuatorButton)this.limitButtons[13]);
        } else if (l == 3L) {
            this.enableOrDisableButtonsForLimitsMenu(true, 1, 1);
            this.enableOrDisableButtonsForLimitsMenu(l2 == 1L, 2, 2);
            this.enableOrDisableButtonsBelowGroupOnOffForLimitsMenu((MultiStateActuatorButton)this.limitButtons[14]);
        }
    }

    void setGroupThreeSelectAndLevelButtonsEnabled(boolean bl) {
        this.limitButtons[3].setEnabled(bl);
        this.limitButtons[4].setEnabled(bl);
        this.limitButtons[8].setEnabled(bl);
    }

    void swapGroupTwoLevelAndSpanButtons() {
        if (((MultiStateActuatorButton)this.limitButtons[7]).getActuator().getSelectedValueIndex() == 0) {
            this.menu.setMenuItem(this.limitButtons[1], 4);
            this.menu.setMenuItem(this.limitButtons[5], 5);
        } else {
            this.menu.setMenuItem(this.limitButtons[2], 4);
            this.menu.setMenuItem(this.limitButtons[6], 5);
        }
    }

    void swapGroupThreeLevelButtons() {
        if (((MultiStateActuatorButton)this.limitButtons[8]).getActuator().getSelectedValueIndex() == 0) {
            this.menu.setMenuItem(this.limitButtons[3], 4);
        } else {
            this.menu.setMenuItem(this.limitButtons[4], 4);
        }
    }

    void swapUpperLowerLimitButtons() {
        this.limitButtons = this.settings.getUpperLowerToggle().longValue() == 2L ? this.lowerButtons : this.upperButtons;
        ((MultiStateActuatorButton)this.limitButtons[9]).setCurrentState(1);
        this.menu.setMenuItem(this.limitButtons[9], 1);
        this.menu.setMenuItem(this.limitButtons[0], 2);
        this.menu.setMenuItem(this.limitButtons[10], 3);
        this.menu.setMenuItem(this.limitButtons[12], 4);
        this.menu.setMenuItem(this.limitButtons[11], 5);
        this.configureMenuItems();
    }

    void enableOrDisableButtonsBelowGroupOnOffForLimitsMenu(MultiStateActuatorButton multiStateActuatorButton) {
        long l = multiStateActuatorButton.getActuator().getSelectedValue().longValue();
        if (l == 0L) {
            this.enableOrDisableButtonsForLimitsMenu(false, 3, 5);
        } else {
            this.enableOrDisableButtonsForLimitsMenu(true, 3, 5);
        }
    }

    void disableKeysForSEMMeasurement(Band band) {
    }

    void enableKeysForSEMMeasurement() {
    }

    void enableOrDisableButtonsForLimitsMenu(boolean bl, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            MenuItem menuItem = this.menu.getItems()[i];
            if (menuItem == null) continue;
            menuItem.setEnabled(bl);
        }
    }

    public MultiStateActuatorButton createSensitivityButton() {
        return new MultiStateActuatorButton(this.settings.getSensitivity(), this.getContextString("sensitivity"), this.getListenerBaseName() + ".sensitivityButton");
    }

    public MultiStateActuatorButton createResBwButton() {
        this.rbwButton = new TrimodeActuatorButton((ValueListInterface)this.settings.getAutoResBandWidth(), this.getContextString("setup.resolution.bandwidth"), this.settings.getResBandWidth(), this.getListenerBaseName() + ".rbwButton");
        this.rbwButton.setReadOnlyValueIndex(0);
        return this.rbwButton;
    }

    MultiStateActuatorButton createThresholdButton() {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)this.settings.getIaAutoThres(), this.getContextId(), this.settings.getIaThreshold(), this.getListenerBaseName() + ".iaThresholdButton");
        trimodeActuatorButton.setReadOnlyValueIndex(0);
        return trimodeActuatorButton;
    }

    protected MenuItem createFrequencyStepButton() {
        TrimodeActuatorButton trimodeActuatorButton = new TrimodeActuatorButton((ValueListInterface)DisplayGlobalMeasurementSettings.instance().getFrequencyAutoStepEnabled(), this.getContextString("frequencyChannel.cfStep"), new ValueInterface[]{SpectrumMeasurementSettings.instance().getCalculatedAutoFrequencyStep(), DisplayGlobalMeasurementSettings.instance().getFrequencyStep()}, this.getListenerBaseName() + ".cfStepButton");
        trimodeActuatorButton.setReadOnlyValueIndex(0);
        return trimodeActuatorButton;
    }

    private MarkerButtonFactory createMarkerButtonFactory() {
        LongActuator longActuator = new LongActuator("", "", "");
        FrequencyActuator frequencyActuator = this.settings.getStartFreq();
        longActuator.setPalette(frequencyActuator.getPalette());
        longActuator.setUnitsFactory(frequencyActuator.getUnitsFactory());
        if (this.markerButtonFactory == null) {
            return new MarkerButtonFactory((MeasurementScreen)this.scn, this.settings.getCenterFrequency(), this.settings.getRefLevel(), longActuator, true);
        }
        return this.markerButtonFactory;
    }

    public MarkerButtonFactory getMarkerButtonFactory() {
        return this.markerButtonFactory;
    }

    public void setupFreqChanUnitsListener() {
        this.setupFreqChanUnitsListener(this.freqChanMenu, 4);
    }

    protected void makeSignalPointerToMaxPeakButtons() {
        this.maxPeakData.peakIndex = -1;
        this.maxPeakData.nextPeakButton = new PushButton(Text.Pointer_To_n_Next_Peak, "Spectrum.signalPointer.toNextPeak");
        this.maxPeakData.nextPeakAction = new SignalPointerToNextPeakAction(this.maxPeakData);
        this.maxPeakData.nextPeakButton.addActionListener(this.maxPeakData.nextPeakAction);
        this.maxPeakData.nextPeakButton.setEnabled(false);
        this.maxPeakData.peakButton = new PushButton(Text.Pointer_To_n_Peak, "Spectrum.signalPointer.toPeak", new SignalPointerToPeakAction(this.maxPeakData, false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ZoomInOutButton
    extends PushButton
    implements ActionListener {
        private int zoomInOut = 0;

        public ZoomInOutButton(String string, String string2, int n) {
            super(string, string2);
            this.zoomInOut = n;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeasurementFactory.instance().getCommandProcessor().set(SpectrumMenuMgr.this.getMeasurementName(), "zoomToSig", this.zoomInOut);
        }
    }

    private class SignalPointerToNextPeakAction
    implements ActionListener {
        private final PeakButtonData data;

        public SignalPointerToNextPeakAction(PeakButtonData peakButtonData) {
            this.data = peakButtonData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.data.peakFinder.getNumPeaks();
            String string = this.data.peakIndex >= 0 && this.data.peakIndex <= n ? this.data.peakIndex + 1 + "/" + n : "";
            this.data.peakButton.setBodyText(string);
            if (this.data.peakIndex < n) {
                long l = this.data.peakFinder.getPeakXValue(this.data.peakIndex);
                if (SpectrumMeasurementSettings.instance().getIaCf().longValue() != l) {
                    SpectrumMeasurementSettings.instance().getIaCf().setValue(l);
                    SpectrumMeasurementSettings.instance().getIaCf().send();
                }
                ++this.data.peakIndex;
            }
            this.data.peakButton.repaint();
            this.updateEnabledState();
        }

        void updateEnabledState() {
            boolean bl = this.data.peakIndex >= 0 && this.data.peakIndex < this.data.peakFinder.getNumPeaks();
            this.data.nextPeakButton.setEnabled(bl);
        }
    }

    private class SignalPointerToPeakAction
    implements ActionListener {
        private final PeakButtonData data;
        private final boolean shouldFindMinPeaks;

        SignalPointerToPeakAction(PeakButtonData peakButtonData, boolean bl) {
            this.data = peakButtonData;
            this.shouldFindMinPeaks = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TraceMeasurement traceMeasurement = SpectrumMenuMgr.this.analyzer.getTraceMeasurement();
            if (this.data.peakFinder == null) {
                this.data.peakFinder = traceMeasurement.createPeakFinder();
            }
            boolean bl = traceMeasurement.isTraceInverted();
            boolean bl2 = bl ^ this.shouldFindMinPeaks;
            int[] nArray = traceMeasurement.getTrace();
            if (bl2) {
                nArray = TraceMeasurement.inverted(nArray);
            }
            int n = traceMeasurement.getIndexForXValue(SpectrumMenuMgr.this.analyzer.getViewStartValue());
            int n2 = traceMeasurement.getIndexForXValue(SpectrumMenuMgr.this.analyzer.getViewStopValue());
            this.data.peakFinder.processTrace(nArray, n, n2 - n, traceMeasurement);
            this.data.peakIndex = 0;
            this.data.nextPeakButton.setEnabled(true);
            SpectrumMenuMgr.this.pointerToPeakButtonOn = true;
            this.data.nextPeakAction.actionPerformed(actionEvent);
        }
    }

    protected static class PeakButtonData {
        PeakFinder peakFinder;
        int peakIndex;
        ActionButton peakButton;
        ActionButton nextPeakButton;
        SignalPointerToNextPeakAction nextPeakAction;

        protected PeakButtonData() {
        }
    }
}

