/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.spectrum;

import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.SaveDataUnsupportedException;
import elgato.infrastructure.mainScreens.Saveable;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.util.Text;
import elgato.measurement.spectrum.SpectrumAnalyzer;
import elgato.measurement.spectrum.SpectrumLimits;
import elgato.measurement.spectrum.SpectrumLineChart;
import elgato.measurement.spectrum.SpectrumMeasurement;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;
import elgato.measurement.spectrum.SpectrumMenuMgr;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.PrintWriter;

public class SpectrumScreen
extends MeasurementScreen {
    SpectrumAnalyzer analyzer;
    protected SpectrumMenuMgr menuMgr;
    boolean lowerLeft;
    boolean left;
    boolean middle;
    boolean right;
    boolean upperRight;
    private SpectrumMeasurementSettings settings;
    static /* synthetic */ Class class$elgato$measurement$spectrum$SpectrumMeasurement;

    public void installScreen(ScreenManager screenManager) {
        this.settings = SpectrumMeasurementSettings.instance();
        super.installScreen(screenManager);
        this.menuMgr.prolog();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        if (this.menuMgr != null) {
            this.menuMgr.removeValueListeners();
            this.menuMgr.cleanup();
        }
        super.uninstallScreen(screenManager);
        this.menuMgr = null;
        this.analyzer = null;
        this.settings = null;
    }

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    protected void setupAnalyzer() {
        this.analyzer = new SpectrumAnalyzer();
        if (this.settings == null) {
            this.settings = SpectrumMeasurementSettings.instance();
        }
        this.menuMgr = this.createMenuMgr();
        this.analyzer.setMarkerButtonFactory(this.menuMgr.getMarkerButtonFactory());
    }

    protected SpectrumMenuMgr createMenuMgr() {
        return ProductFactory.getInstance().createSpectrumMenuMgr(this, this.settings, this.analyzer);
    }

    protected Command[] getInitialGetCommands() {
        return new Command[0];
    }

    protected String getMeasurementName() {
        return "spectrum";
    }

    protected Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$spectrum$SpectrumMeasurement == null ? (class$elgato$measurement$spectrum$SpectrumMeasurement = SpectrumScreen.class$("elgato.measurement.spectrum.SpectrumMeasurement")) : class$elgato$measurement$spectrum$SpectrumMeasurement;
    }

    public String getTopic() {
        return "spectrum";
    }

    public void saveData(PrintWriter printWriter) throws SaveDataUnsupportedException {
        if (!(this.getAnalyzer() instanceof Saveable)) {
            throw new SaveDataUnsupportedException();
        }
        ((Saveable)((Object)this.getAnalyzer())).saveData(printWriter);
    }

    protected void refreshMeasurementSettings() {
        this.settings.refresh();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        return MeasurementScreen.formatResultLine(string, "", "", "", this.getPassOrFail((SpectrumMeasurement)this.analyzer.getMeasurement()));
    }

    String getPassOrFail(SpectrumMeasurement spectrumMeasurement) {
        SpectrumLimits spectrumLimits = this.settings.getUpperLimits();
        SpectrumLineChart.PassFailResults passFailResults = SpectrumLineChart.PassFailResults.createPassFailResults(spectrumMeasurement, spectrumLimits);
        this.lowerLeft = passFailResults.groupThreeLowerImage == TraceChart.passImage;
        this.left = passFailResults.groupTwoLowerImage == TraceChart.passImage;
        this.middle = passFailResults.groupOneImage == TraceChart.passImage;
        this.right = passFailResults.groupTwoUpperImage == TraceChart.passImage;
        boolean bl = this.upperRight = passFailResults.groupThreeUpperImage == TraceChart.passImage;
        if (this.lowerLeft && this.left && this.middle && this.right && this.upperRight) {
            return Text.PASS;
        }
        return Text.FAIL;
    }

    protected String limitValues() {
        return null;
    }

    public SpectrumMenuMgr getMenuMgr() {
        return this.menuMgr;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

