/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.timeFreqRef;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.util.Queue;
import java.io.DataInput;
import java.io.IOException;

public class TimeFreqRefMeasurement
implements Measurement {
    static final long serialVersionUID = 6374846694139390504L;
    public static final int VALUE_PPS_NOT_PRESENT = 0;
    public static final int VALUE_PPS_PRESENT_AND_LOCKED = 1;
    public static final int VALUE_PPS_ACQUIRING = 2;
    private static final Queue pool = new Queue(3);
    private int gpsDataValid;
    private int currentTime;
    private int currentLatitude;
    private int currentLongitude;
    private int currentAltitude;
    private int numSatellite;
    private int ppsPresent;
    private boolean externalFrequencyLocked;
    private int timeReference;
    private int frequencyReference;

    public static TimeFreqRefMeasurement unpack(DataInput dataInput) throws IOException {
        TimeFreqRefMeasurement timeFreqRefMeasurement = TimeFreqRefMeasurement.create();
        timeFreqRefMeasurement.gpsDataValid = dataInput.readInt();
        timeFreqRefMeasurement.currentTime = dataInput.readInt();
        timeFreqRefMeasurement.currentLatitude = dataInput.readInt();
        timeFreqRefMeasurement.currentLongitude = dataInput.readInt();
        timeFreqRefMeasurement.currentAltitude = dataInput.readInt();
        timeFreqRefMeasurement.numSatellite = dataInput.readInt();
        timeFreqRefMeasurement.ppsPresent = dataInput.readInt();
        timeFreqRefMeasurement.externalFrequencyLocked = dataInput.readInt() != 0;
        timeFreqRefMeasurement.timeReference = dataInput.readInt();
        timeFreqRefMeasurement.frequencyReference = dataInput.readInt();
        return timeFreqRefMeasurement;
    }

    public static TimeFreqRefMeasurement create() {
        TimeFreqRefMeasurement timeFreqRefMeasurement = (TimeFreqRefMeasurement)pool.dequeue();
        if (timeFreqRefMeasurement == null) {
            return new TimeFreqRefMeasurement();
        }
        return timeFreqRefMeasurement;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int getGpsDataValid() {
        return this.gpsDataValid;
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public int getCurrentLatitude() {
        return this.currentLatitude;
    }

    public int getCurrentLongitude() {
        return this.currentLongitude;
    }

    public int getCurrentAltitude() {
        return this.currentAltitude;
    }

    public int getNumSatellite() {
        return this.numSatellite;
    }

    public int getTimeReference() {
        return this.timeReference;
    }

    public int getFrequencyReference() {
        return this.frequencyReference;
    }

    public int getPpsPresent() {
        return this.ppsPresent;
    }

    public boolean isExternalFrequencyLocked() {
        return this.externalFrequencyLocked;
    }

    public int getIntegerReadingValue(int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("Method not implemented yet");
    }

    public double getDoubleReadingValue(int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public String getMeasurementTitle() {
        return "TimeFreqRef";
    }

    public boolean hasCurrentSettings() {
        return true;
    }
}

