/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.timeFreqRef;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.timeFreqRef.TimeFreqRefMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TimeFreqRefMeasurementGenerator
extends MeasurementGenerator {
    private boolean randomMode;
    private int numberOfSatellites = 0;

    protected void writePayload(DataOutput dataOutput) throws IOException {
        int n = this.numberOfSatellites > 2 ? 1 : 0;
        dataOutput.writeInt(this.randomMode ? n : 1);
        dataOutput.writeInt(200003);
        dataOutput.writeInt(367);
        dataOutput.writeInt(49999);
        dataOutput.writeInt(51324);
        dataOutput.writeInt(this.randomMode ? this.numberOfSatellites : 6);
        dataOutput.writeInt(this.randomMode ? this.genRandomNumber(0, 2) : 0);
        dataOutput.writeInt(this.randomMode ? this.genRandomNumber(0, 1) : 1);
        dataOutput.writeInt(this.randomMode ? this.genRandomNumber(0, 1) : 0);
        dataOutput.writeInt(this.randomMode ? this.genRandomNumber(0, 3) : 1);
        if (this.numberOfSatellites++ == 4) {
            this.numberOfSatellites = 0;
        }
    }

    private int genRandomNumber(int n, int n2) {
        return (int)(Math.random() * (double)(n2 + 1) + (double)n);
    }

    public void setRandomMode(boolean bl) {
        this.randomMode = bl;
    }

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return TimeFreqRefMeasurement.unpack(dataInput);
    }
}

