/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.timeFreqRef;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.util.Vector;

public class TimeFreqRefMeasurementSettings
extends MeasurementSettings {
    static final String TOPIC = "timeFreqRef";
    private final String DISPLAY_TOPIC = "display.timeFreqRef";
    private static Logger logger = LogManager.getLogger(class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurementSettings == null ? (class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurementSettings = TimeFreqRefMeasurementSettings.class$("elgato.measurement.timeFreqRef.TimeFreqRefMeasurementSettings")) : class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurementSettings);
    private static TimeFreqRefMeasurementSettings instance;
    private final ListActuator timeFreqRef = new ListActuator("display.timeFreqRef", "timeFreqRefKeyForDisplay", Text.Fr_slash_Time_Ref, this.getValidValues(false));
    private final LongActuator freqRef = new LongActuator(this.getTopic(), "freqRef", Text.Fr_slash_Time_Ref, 0L);
    private LongActuator timeRef = new LongActuator(this.getTopic(), "timeRef", Text.Fr_slash_Time_Ref);
    private final ListActuator ppsState = new ListActuator("display.timeFreqRef", "ppsState", "", this.getPpsValues());
    private static final int VALUE_FREQ_REF_INT_REF = 0;
    private static final int VALUE_FREQ_REF_EXT_10_MHZ = 1;
    private static final int VALUE_FREQ_REF_EXT_1966_MHZ = 2;
    private static final int VALUE_FREQ_REF_USE_TIME_REF = 3;
    private static final int VALUE_FREQ_REF_EXT_1_MHZ = 4;
    private static final int VALUE_FREQ_REF_EXT_495_MHZ = 5;
    private static final int VALUE_FREQ_REF_EXT_13_MHZ = 6;
    private static final int VALUE_FREQ_REF_EXT_15_MHZ = 7;
    private static final int VALUE_FREQ_REF_EXT_2048_MHZ = 8;
    public static final int VALUE_FREQ_REF_3_TIME_REF_0 = 30;
    public static final int VALUE_FREQ_REF_3_TIME_REF_1 = 31;
    private int VALUE_TIME_REF_GPS = 0;
    private int VALUE_TIME_REF_EVEN_SEC = 1;
    static /* synthetic */ Class class$elgato$measurement$timeFreqRef$TimeFreqRefMeasurementSettings;

    private ValueInterface[] getPpsValues() {
        Vector<Value> vector = new Vector<Value>();
        vector.addElement(Value.createValue("ppsNot", 0));
        vector.addElement(Value.createValue("ppsPresLocked", 1));
        vector.addElement(Value.createValue("ppsAcquiring", 2));
        Object[] objectArray = new Value[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ValueInterface[] getValidValues(boolean bl) {
        Vector<Value> vector = new Vector<Value>();
        vector.addElement(Value.createValue(Text.GPS, 30));
        vector.addElement(Value.createValue(Text.Even_Sec, Text.External_Even_Second, 31));
        vector.addElement(Value.createValue(Text.Int_Ref, Text.Internal_Reference, 0));
        MeasurementFactory measurementFactory = MeasurementFactory.instance();
        if (bl && measurementFactory.isHardwareFeatureAvailable("1MHz")) {
            vector.addElement(Value.createValue(Text.Ext_1_point_0MHz, Text.External_1_point_0_MHz, 4));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("2048MHz")) {
            vector.addElement(Value.createValue(Text.Ext_2_point_048_MHz, Text.External_2_point_048_MHz, 8));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("495MHz")) {
            vector.addElement(Value.createValue(Text.Ext_4_point_95MHz, Text.External_4_point_95_MHz, 5));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("10MHz")) {
            vector.addElement(Value.createValue(Text.Ext_10MHz, Text.External_10_MHz, 1));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("13MHz")) {
            vector.addElement(Value.createValue(Text.Ext_13MHz, Text.External_13_MHz, 6));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("15MHz")) {
            vector.addElement(Value.createValue(Text.Ext_15MHz, Text.External_15_MHz, 7));
        }
        if (bl && measurementFactory.isHardwareFeatureAvailable("1966MHz")) {
            vector.addElement(Value.createValue(Text.Ext_1966_MHz, Text.External_1966_MHz, 2));
        }
        Object[] objectArray = new Value[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] getValidValueStrings(boolean bl) {
        ValueInterface[] valueInterfaceArray = this.getValidValues(bl);
        String[] stringArray = new String[valueInterfaceArray.length];
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            ValueInterface valueInterface = valueInterfaceArray[i];
            stringArray[i] = valueInterface.getLongLabel();
        }
        return stringArray;
    }

    public void setFreqTimeRefByString(String string) {
        ValueInterface[] valueInterfaceArray = this.timeFreqRef.getValueList();
        for (int i = 0; i < valueInterfaceArray.length; ++i) {
            ValueInterface valueInterface = valueInterfaceArray[i];
            if (!valueInterface.getLongLabel().equals(string)) continue;
            this.timeFreqRef.setValue(((Object)valueInterface).toString());
        }
    }

    private TimeFreqRefMeasurementSettings() {
        super(TOPIC);
        this.add(this.timeRef);
        this.add(this.freqRef);
        this.add(this.timeFreqRef);
        this.add(this.ppsState);
        this.timeFreqRef.addValueListener(new ValueListener(){
            private final String listenerName = "TimeFreqRef.listener";

            public String getListenerName() {
                return "TimeFreqRef.listener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (valueInterface.intValue() == 30 || valueInterface.intValue() == 31) {
                    TimeFreqRefMeasurementSettings.this.freqRef.send(3L);
                    if (valueInterface.intValue() == 30) {
                        TimeFreqRefMeasurementSettings.this.timeRef.setValue(TimeFreqRefMeasurementSettings.this.VALUE_TIME_REF_GPS);
                        TimeFreqRefMeasurementSettings.this.timeRef.send();
                    } else if (valueInterface.intValue() == 31) {
                        TimeFreqRefMeasurementSettings.this.timeRef.setValue(TimeFreqRefMeasurementSettings.this.VALUE_TIME_REF_EVEN_SEC);
                        TimeFreqRefMeasurementSettings.this.timeRef.send();
                    }
                } else {
                    TimeFreqRefMeasurementSettings.this.freqRef.send(valueInterface.intValue());
                }
            }
        });
        this.refresh();
    }

    public static TimeFreqRefMeasurementSettings instance() {
        if (instance == null) {
            instance = new TimeFreqRefMeasurementSettings();
            logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public int getInt(String string) {
        try {
            Actuator actuator = this.get(string);
            if (actuator == null) {
                return 0;
            }
            if (actuator instanceof LongActuator) {
                return actuator.intValue();
            }
            if (actuator instanceof ListActuator) {
                return actuator.intValue();
            }
        }
        catch (Exception exception) {
            logger.error("Unable to find actuator for key " + string);
        }
        return 0;
    }

    public String getString(String string) {
        try {
            Actuator actuator = this.get(string);
            if (actuator == null) {
                return "";
            }
            return actuator.toString();
        }
        catch (Exception exception) {
            logger.error("Unable to get actuator for key " + string);
            return "";
        }
    }

    public void set(String string, int n) {
        this.set(string, String.valueOf(n));
    }

    public void set(String string, long l) {
        this.set(string, String.valueOf(l));
    }

    public void set(String string, boolean bl) {
        this.set(string, bl ? "1" : "0");
    }

    public void set(String string, String string2) {
        Actuator actuator = this.get(string);
        if (actuator == null) {
            logger.warn("set: No actuator");
            return;
        }
        if (actuator instanceof LongActuator) {
            actuator.setValue(string2);
        }
        if (actuator instanceof ListActuator) {
            actuator.setValue(string2);
        }
        if (actuator instanceof StringActuator) {
            actuator.setValue(string2);
        }
    }

    public LongActuator getTimeRef() {
        return this.timeRef;
    }

    protected LongActuator getFreqRef() {
        return this.freqRef;
    }

    public ListActuator getTimeFreqRef() {
        return this.timeFreqRef;
    }

    public ListActuator getPpsState() {
        return this.ppsState;
    }

    public void setValidHardwareFeatures() {
        this.timeFreqRef.setValueList(this.getValidValues(true));
    }

    public boolean isInternalGps() {
        return this.timeFreqRef.intValue() == 30;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

