/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.readings.BooleanReading;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Logger;
import elgato.measurement.twoPortInsertionLoss.InsertionLossMeasurementSettings;

public abstract class InsertionLossMeasurement
extends TraceMeasurement {
    protected IntegerArrayReading trace = new IntegerArrayReading(256);
    protected IntegerReading averageInsertionLoss = new IntegerReading();
    protected BooleanReading validCalibration = new BooleanReading();
    protected IntegerReading calMeasurementMode = new IntegerReading();
    protected IntegerReading startFrequency = new IntegerReading();
    protected IntegerReading stopFrequency = new IntegerReading();
    protected IntegerReading averageType = new IntegerReading();
    protected IntegerReading numAverages = new IntegerReading();
    protected IntegerReading interferenceMode = new IntegerReading();
    protected IntegerReading averageCount = new IntegerReading();
    public Reading[] readings;

    public Reading[] getReadings() {
        return this.readings;
    }

    public int[] getTrace() {
        return this.trace.getTrace();
    }

    public long getTraceStartValue() {
        return this.getStartFrequency() * 1000L;
    }

    public long getTraceStopValue() {
        return this.getStopFrequency() * 1000L;
    }

    public int getAverageType() {
        return this.averageType.intValue();
    }

    public int getCalMeasurementMode() {
        return this.calMeasurementMode.intValue();
    }

    public int getNumAverages() {
        return this.numAverages.intValue();
    }

    public int getAverageCount() {
        return this.averageCount.intValue();
    }

    public long getStartFrequency() {
        return this.startFrequency.intValue();
    }

    public long getStopFrequency() {
        return this.stopFrequency.intValue();
    }

    public boolean isValidCalibration() {
        return this.validCalibration.booleanValue();
    }

    public int getAverageInsertionLoss() {
        return this.averageInsertionLoss.intValue();
    }

    public int getInterferenceMode() {
        return this.interferenceMode.intValue();
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    protected abstract Logger getLogger();

    protected abstract int getReadCount();

    protected abstract int getMismatchCount();

    protected abstract void setMismatchCount(int var1);

    public abstract InsertionLossMeasurementSettings getSettings();

    public long getLongReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public float getFloatReadingValue(int n) {
        throw new RuntimeException("method not implemented yet");
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("method not implemented yet");
    }

    public abstract String getMeasurementTitle();

    public void setAverageInsertionLoss(int n) {
        this.averageInsertionLoss.setValue(n);
    }

    protected boolean actuatorsMatchCurrentSettings() {
        InsertionLossMeasurementSettings insertionLossMeasurementSettings = this.getProperSettings();
        boolean bl = true;
        if (this.getReadCount() == 0) {
            return true;
        }
        if (!this.resultEqualsSetting(this.getLogger(), insertionLossMeasurementSettings.getStartFrequency(), this.startFrequency.longValue() * 1000L)) {
            bl = false;
        } else if (!this.resultEqualsSetting(this.getLogger(), insertionLossMeasurementSettings.getStopFrequency(), this.stopFrequency.longValue() * 1000L)) {
            bl = false;
        }
        if (bl) {
            this.setMismatchCount(0);
        } else {
            this.setMismatchCount(this.getMismatchCount() + 1);
        }
        if (this.getMismatchCount() > 3) {
            this.getLogger().warn("Result/Setting mismatch #" + this.getMismatchCount() + ", resetting and continuing as if matched");
            this.setMismatchCount(0);
            bl = true;
            insertionLossMeasurementSettings.invalidate();
            insertionLossMeasurementSettings.refresh();
        }
        return bl;
    }

    protected abstract InsertionLossMeasurementSettings getProperSettings();
}

