/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.twoPortInsertionLoss;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandChannelEmulator;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.twoPortInsertionLoss.TwoPortInsertionLossMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;

public class InsertionLossMeasurementGenerator
extends MeasurementGenerator {
    private Random rand = new Random();
    private int calibratedState = 1;

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return TwoPortInsertionLossMeasurement.unpack(dataInput);
    }

    protected void writePayload(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < 256; ++i) {
            if (i > 150 && i < 175) {
                dataOutput.writeInt(5000 + (i - 150) * 2000 + this.nextInt(2000));
                continue;
            }
            if (i >= 175 && i < 200) {
                dataOutput.writeInt(5000 + (200 - i) * 2000 + this.nextInt(2000));
                continue;
            }
            dataOutput.writeInt(5000 + i * 10 + this.nextInt(1000));
        }
        dataOutput.writeInt(9000);
        if (this.calibratedState == -1) {
            dataOutput.writeInt(this.rand.nextInt() & 1);
        } else {
            dataOutput.writeInt(this.calibratedState);
        }
        dataOutput.writeInt(1);
        dataOutput.writeInt(2);
        dataOutput.writeInt(3);
        dataOutput.writeInt(4);
        dataOutput.writeInt(5);
        dataOutput.writeInt(6);
        dataOutput.writeInt(7);
        dataOutput.writeInt(8);
        dataOutput.writeInt(9);
        dataOutput.writeInt(10);
    }

    private int nextInt(int n) {
        return Math.abs(this.rand.nextInt()) % n;
    }

    public void setCalibrated() {
        this.calibratedState = 1;
    }

    public void setUncalibrated() {
        this.calibratedState = 0;
    }

    public void setCommandChannelEmulator(CommandChannelEmulator commandChannelEmulator) {
        Command command = Command.makeSetCommand("antInsLoss");
        command.addProperty("mode", 1L);
        commandChannelEmulator.addListener(command, (CommandChannelEmulator.EmulatorCommandListener)new UncalibratedListener());
    }

    private class UncalibratedListener
    implements CommandChannelEmulator.EmulatorCommandListener {
        private UncalibratedListener() {
        }

        public Command processCommand(Command command) {
            InsertionLossMeasurementGenerator.this.setUncalibrated();
            return null;
        }
    }
}

